"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
class MetricFilterIntegStack extends cdk_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const logGroup = new lib_1.LogGroup(this, 'LogGroup', {
            removalPolicy: cdk_1.RemovalPolicy.Destroy
        });
        /// !show
        new lib_1.MetricFilter(this, 'MetricFilter', {
            logGroup,
            metricNamespace: 'MyApp',
            metricName: 'Latency',
            filterPattern: lib_1.FilterPattern.exists('$.latency'),
            metricValue: '$.latency'
        });
        /// !hide
    }
}
const app = new cdk_1.App();
new MetricFilterIntegStack(app, 'aws-cdk-metricfilter-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubWV0cmljZmlsdGVyLmxpdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLm1ldHJpY2ZpbHRlci5saXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxzQ0FBcUU7QUFDckUsZ0NBQStEO0FBRS9ELE1BQU0sc0JBQXVCLFNBQVEsV0FBSztJQUN4QyxZQUFZLEtBQVUsRUFBRSxFQUFVLEVBQUUsS0FBa0I7UUFDcEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsTUFBTSxRQUFRLEdBQUcsSUFBSSxjQUFRLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM5QyxhQUFhLEVBQUUsbUJBQWEsQ0FBQyxPQUFPO1NBQ3JDLENBQUMsQ0FBQztRQUVILFNBQVM7UUFDVCxJQUFJLGtCQUFZLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRTtZQUNyQyxRQUFRO1lBQ1IsZUFBZSxFQUFFLE9BQU87WUFDeEIsVUFBVSxFQUFFLFNBQVM7WUFDckIsYUFBYSxFQUFFLG1CQUFhLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQztZQUNoRCxXQUFXLEVBQUUsV0FBVztTQUN6QixDQUFDLENBQUM7UUFDSCxTQUFTO0lBQ1gsQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFHLEVBQUUsQ0FBQztBQUN0QixJQUFJLHNCQUFzQixDQUFDLEdBQUcsRUFBRSw0QkFBNEIsQ0FBQyxDQUFDO0FBQzlELEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgUmVtb3ZhbFBvbGljeSwgU3RhY2ssIFN0YWNrUHJvcHMgfSBmcm9tICdAYXdzLWNkay9jZGsnO1xuaW1wb3J0IHsgRmlsdGVyUGF0dGVybiwgTG9nR3JvdXAsIE1ldHJpY0ZpbHRlciB9IGZyb20gJy4uL2xpYic7XG5cbmNsYXNzIE1ldHJpY0ZpbHRlckludGVnU3RhY2sgZXh0ZW5kcyBTdGFjayB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBBcHAsIGlkOiBzdHJpbmcsIHByb3BzPzogU3RhY2tQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgY29uc3QgbG9nR3JvdXAgPSBuZXcgTG9nR3JvdXAodGhpcywgJ0xvZ0dyb3VwJywge1xuICAgICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5EZXN0cm95XG4gICAgfSk7XG5cbiAgICAvLy8gIXNob3dcbiAgICBuZXcgTWV0cmljRmlsdGVyKHRoaXMsICdNZXRyaWNGaWx0ZXInLCB7XG4gICAgICBsb2dHcm91cCxcbiAgICAgIG1ldHJpY05hbWVzcGFjZTogJ015QXBwJyxcbiAgICAgIG1ldHJpY05hbWU6ICdMYXRlbmN5JyxcbiAgICAgIGZpbHRlclBhdHRlcm46IEZpbHRlclBhdHRlcm4uZXhpc3RzKCckLmxhdGVuY3knKSxcbiAgICAgIG1ldHJpY1ZhbHVlOiAnJC5sYXRlbmN5J1xuICAgIH0pO1xuICAgIC8vLyAhaGlkZVxuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbm5ldyBNZXRyaWNGaWx0ZXJJbnRlZ1N0YWNrKGFwcCwgJ2F3cy1jZGstbWV0cmljZmlsdGVyLWludGVnJyk7XG5hcHAuc3ludGgoKTtcbiJdfQ==