"use strict";
const assert_1 = require("@aws-cdk/assert");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'simple destination'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const role = new iam.Role(stack, 'Role', {
            assumedBy: new iam.ServicePrincipal('logs.us-east-2.amazonaws.com')
        });
        // WHEN
        new lib_1.CrossAccountDestination(stack, 'Dest', {
            destinationName: 'MyDestination',
            role,
            targetArn: 'arn:bogus'
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::Destination', {
            DestinationName: 'MyDestination',
            RoleArn: { "Fn::GetAtt": ["Role1ABCC5F0", "Arn"] },
            TargetArn: 'arn:bogus',
        }));
        test.done();
    },
    'add policy to destination'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const role = new iam.Role(stack, 'Role', {
            assumedBy: new iam.ServicePrincipal('logs.us-east-2.amazonaws.com')
        });
        const dest = new lib_1.CrossAccountDestination(stack, 'Dest', {
            destinationName: 'MyDestination',
            role,
            targetArn: 'arn:bogus'
        });
        // WHEN
        dest.addToPolicy(new iam.PolicyStatement({
            actions: ['logs:TalkToMe']
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::Destination', (props) => {
            const pol = JSON.parse(props.DestinationPolicy);
            return pol.Statement[0].Action === 'logs:TalkToMe';
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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