"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'trivial instantiation'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        const logGroup = new lib_1.LogGroup(stack, 'LogGroup');
        // WHEN
        new lib_1.MetricFilter(stack, 'Subscription', {
            logGroup,
            metricNamespace: 'AWS/Test',
            metricName: 'Latency',
            metricValue: '$.latency',
            filterPattern: lib_1.FilterPattern.exists('$.latency')
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::MetricFilter', {
            MetricTransformations: [{
                    MetricNamespace: 'AWS/Test',
                    MetricName: 'Latency',
                    MetricValue: '$.latency',
                }],
            FilterPattern: '{ $.latency = "*" }',
            LogGroupName: { Ref: "LogGroupF5B46931" }
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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