"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
class FakeDestination {
    bind(_scope, _sourceLogGroup) {
        return {
            arn: 'arn:bogus',
        };
    }
}
module.exports = {
    'trivial instantiation'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        const logGroup = new lib_1.LogGroup(stack, 'LogGroup');
        // WHEN
        new lib_1.SubscriptionFilter(stack, 'Subscription', {
            logGroup,
            destination: new FakeDestination(),
            filterPattern: lib_1.FilterPattern.literal("some pattern")
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::SubscriptionFilter', {
            DestinationArn: "arn:bogus",
            FilterPattern: "some pattern",
            LogGroupName: { Ref: "LogGroupF5B46931" }
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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