"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Merge the `src` event pattern into the `dest` event pattern by adding all
 * values from `src` into the fields in `dest`.
 *
 * See `rule.addEventPattern` for details.
 */
function mergeEventPattern(dest, src) {
    dest = dest || {};
    mergeObject(dest, src);
    return dest;
    function mergeObject(destObj, srcObj) {
        if (typeof (srcObj) !== 'object') {
            throw new Error(`Invalid event pattern '${JSON.stringify(srcObj)}', expecting an object or an array`);
        }
        for (const field of Object.keys(srcObj)) {
            const srcValue = srcObj[field];
            const destValue = destObj[field];
            if (srcValue === undefined) {
                continue;
            }
            if (typeof (srcValue) !== 'object') {
                throw new Error(`Invalid event pattern field { ${field}: ${JSON.stringify(srcValue)} }. All fields must be arrays`);
            }
            // dest doesn't have this field
            if (destObj[field] === undefined) {
                destObj[field] = srcValue;
                continue;
            }
            if (Array.isArray(srcValue) !== Array.isArray(destValue)) {
                throw new Error(`Invalid event pattern field ${field}. ` +
                    `Type mismatch between existing pattern ${JSON.stringify(destValue)} and added pattern ${JSON.stringify(srcValue)}`);
            }
            // if this is an array, concat the values
            if (Array.isArray(srcValue)) {
                destObj[field] = destValue.concat(srcValue);
                continue;
            }
            // otherwise, it's an object, so recurse
            mergeObject(destObj[field], srcValue);
        }
    }
}
exports.mergeEventPattern = mergeEventPattern;
//# sourceMappingURL=data:application/json;base64,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