# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['thumbor_aws']

package_data = \
{'': ['*']}

install_requires = \
['aiobotocore>=2.0.0,<3.0.0',
 'deprecated>=1.2.13,<2.0.0',
 'pycurl>=7.44.1,<8.0.0',
 'thumbor>=7.0.0,<8.0.0']

setup_kwargs = {
    'name': 'thumbor-aws',
    'version': '0.4.3',
    'description': 'thumbor_aws provides extensions for thumbor using AWS',
    'long_description': '<p align="center">\n<img src="https://raw.github.com/thumbor/thumbor/master/logo-thumbor.png" />\n</p>\n\n<h3 align="center">thumbor-aws</h3>\n\n<p align="center">\nThis is a project to provide modern thumbor>7.0.0 AWS Extensions.\n</p>\n\n<p align="center">\n  <img src=\'https://github.com/thumbor/thumbor-aws/workflows/build/badge.svg\' />\n  <a href=\'https://coveralls.io/github/thumbor/thumbor-aws?branch=main\'><img src=\'https://coveralls.io/repos/github/thumbor/thumbor-aws/badge.svg?branch=main\' alt=\'Coverage Status\' /></a>\n\n  <a href=\'https://codeclimate.com/github/thumbor/thumbor-aws\' target=\'_blank\'>\n    <img src=\'https://codeclimate.com/github/thumbor/thumbor-aws/badges/gpa.svg\'/>\n  </a>\n</p>\n<p align="center">\n  <a href=\'https://github.com/thumbor/thumbor-aws/pulls\' target=\'_blank\'>\n    <img src=\'https://img.shields.io/github/issues-pr-raw/thumbor/thumbor-aws.svg\'/>\n  </a>\n  <a href=\'https://github.com/thumbor/thumbor-aws/issues\' target=\'_blank\'>\n    <img src=\'https://img.shields.io/github/issues-raw/thumbor/thumbor-aws.svg\'/>\n  </a>\n  <a href=\'https://pypi.python.org/pypi/thumbor-aws\' target=\'_blank\'>\n    <img src=\'https://img.shields.io/pypi/v/thumbor-aws.svg\'/>\n  </a>\n  <a href=\'https://pypi.python.org/pypi/thumbor-aws\' target=\'_blank\'>\n    <img src=\'https://img.shields.io/pypi/dm/thumbor-aws.svg\'/>\n  </a>\n</p>\n\n## ⚙️ Installation\n\n```bash\npip install thumbor-aws\n```\n## 🎯 Features\n\n- Asynchronous non-blocking AWS S3 support\n- Conforms with thumbor 7 new storage and results storage specs\n- Python 3 compliant\n- S3 Image Loader - Load source images from S3\n- S3 Storage - Retrieve and store source images, detector data and security keys\n- S3 Result Storage - Retrieve and store resulting images\n- Compatibility mode for users of tc_aws: currently supported loader, storage and result storage\n\n## Usage\n\n### Configuring thumbor\n\nConfigure your `thumbor.conf` file to point to `thumbor_aws`:\n\n```\n## The loader thumbor should use to find source images.\n## This must be the full name of a python module (python must be able to import it)\nLOADER = "thumbor.loaders.http_loader"\n\n## The file storage thumbor should use to store original images.\n## This must be the full name of a python module (python must be able to import it)\nSTORAGE = \'thumbor_aws.storage\'\n\n## The result storage thumbor should use to store generated images.\n## This must be the full name of a python module (python must be able to import it)\nRESULT_STORAGE = \'thumbor_aws.result_storage\'\n```\n\nYou should use only the extensions required by your use case.\nThere\'s no dependency between them.\n\n### Configuration\n\nthumbor-aws allows you to configure each extension independently:\n\n#### General\n\nSome S3 providers fail to return a valid location header when uploading a new object. For that scenario, `thumbor-aws` allows users to set the location template to be used.\n\n```\n## Default location to use if S3 does not return location header.\n## Can use {bucket_name} var.\n## Defaults to: \'https://{bucket_name}.s3.amazonaws.com\'\nAWS_DEFAULT_LOCATION = "https://{bucket_name}.s3.amazonaws.com"\n```\n\n#### Loader\n\nthumbor-aws loader offer several configuration options:\n\n```python\n################################## AWS Loader ##################################\n\n## Region where thumbor\'s objects are going to be loaded from.\n## Defaults to: \'us-east-1\'\n#AWS_LOADER_REGION_NAME = \'us-east-1\'\n\n## S3 Bucket where thumbor\'s objects are loaded from.\n## Defaults to: \'thumbor\'\n#AWS_LOADER_BUCKET_NAME = \'thumbor\'\n\n## Secret access key for S3 Loader.\n## Defaults to: None\n#AWS_LOADER_S3_SECRET_ACCESS_KEY = None\n\n## Access key ID for S3 Loader.\n## Defaults to: None\n#AWS_LOADER_S3_ACCESS_KEY_ID = None\n\n## Endpoint URL for S3 API. Very useful for testing.\n## Defaults to: None\n#AWS_LOADER_S3_ENDPOINT_URL = None\n\n## Loader prefix path.\n## Defaults to: \'/st\'\n#AWS_LOADER_ROOT_PATH = \'/st\'\n\n################################################################################\n```\n\n#### Storage\n\nBelow you can see the result of running thumbor\'s config generation after importing thumbor-aws:\n\n```\n################################# AWS Storage ##################################\n\n## Region where thumbor\'s objects are going to be stored.\n## Defaults to: \'us-east-1\'\n#AWS_STORAGE_REGION_NAME = \'us-east-1\'\n\n## S3 Bucket where thumbor\'s objects are going to be stored.\n## Defaults to: \'thumbor\'\n#AWS_STORAGE_BUCKET_NAME = \'thumbor\'\n\n## Secret access key for S3 to allow thumbor to store objects there.\n## Defaults to: None\n#AWS_STORAGE_S3_SECRET_ACCESS_KEY = None\n\n## Access key ID for S3 to allow thumbor to store objects there.\n## Defaults to: None\n#AWS_STORAGE_S3_ACCESS_KEY_ID = None\n\n## Endpoint URL for S3 API. Very useful for testing.\n## Defaults to: None\n#AWS_STORAGE_S3_ENDPOINT_URL = None\n\n## Storage prefix path.\n## Defaults to: \'/st\'\n#AWS_STORAGE_ROOT_PATH = \'/st\'\n\n## Storage ACL for files written in bucket\n## Defaults to: \'public-read\'\n#AWS_STORAGE_S3_ACL = \'public-read\'\n\n## Default location to use if S3 does not return location header. Can use\n## {bucket_name} var.\n## Defaults to: \'https://{bucket_name}.s3.amazonaws.com\'\n#AWS_DEFAULT_LOCATION = \'https://{bucket_name}.s3.amazonaws.com\'\n\n################################################################################\n\n```\n\n#### Result Storage\n\nBelow you can see the result of running thumbor\'s config generation after importing thumbor-aws:\n\n```\n############################## AWS Result Storage ##############################\n\n## Region where thumbor\'s objects are going to be stored.\n## Defaults to: \'us-east-1\'\n#AWS_RESULT_STORAGE_REGION_NAME = \'us-east-1\'\n\n## S3 Bucket where thumbor\'s objects are going to be stored.\n## Defaults to: \'thumbor\'\n#AWS_RESULT_STORAGE_BUCKET_NAME = \'thumbor\'\n\n## Secret access key for S3 to allow thumbor to store objects there.\n## Defaults to: None\n#AWS_RESULT_STORAGE_S3_SECRET_ACCESS_KEY = None\n\n## Access key ID for S3 to allow thumbor to store objects there.\n## Defaults to: None\n#AWS_RESULT_STORAGE_S3_ACCESS_KEY_ID = None\n\n## Endpoint URL for S3 API. Very useful for testing.\n## Defaults to: None\n#AWS_RESULT_STORAGE_S3_ENDPOINT_URL = None\n\n## Result Storage prefix path.\n## Defaults to: \'/rs\'\n#AWS_RESULT_STORAGE_ROOT_PATH = \'/rs\'\n\n## ACL to use for storing items in S3.\n## Defaults to: None\n#AWS_RESULT_STORAGE_S3_ACL = None\n\n################################################################################\n```\n\n### Configuring thumbor in compatibility mode with tc_aws\n\nIf you are a [tc_aws](https://github.com/thumbor-community/aws) user, thumbor-aws has a compatibility mode where you can use the same configuration you are already used to:\n\n```python\n############################# tc_aws Compatibility #############################\n\n## Runs in compatibility mode using the configurations for tc_aws.\n## Defaults to: False\nTHUMBOR_AWS_RUN_IN_COMPATIBILITY_MODE = True\n\n## AWS Region the bucket is located in.\n## Defaults to: \'us-east-1\'\nTC_AWS_REGION = \'us-east-1\'\n\n## Max retries for get image from S3 Bucket. Default is 0\n## Defaults to: 0\nTC_AWS_MAX_RETRY = 0  # This is not yet supported\n\n## S3 bucket for Loader. If given, source urls are interpreted as keys within\n## this bucket. If not given, source urls are expected to containthe bucket\n## name, such as \'s3-bucket/keypath\'.\n## Defaults to: \'\'\nTC_AWS_LOADER_BUCKET = \'my-bucket\'\n\n## S3 path prefix for Loader bucket. If given, this is prefixed to all S3 keys.\n## Defaults to: \'\'\nTC_AWS_LOADER_ROOT_PATH = \'source-files\'\n\n## S3 bucket for Storage\n## Defaults to: \'\'\nTC_AWS_STORAGE_BUCKET = \'my-bucket\'\n\n## S3 path prefix for Storage bucket\n## Defaults to: \'\'\nTC_AWS_STORAGE_ROOT_PATH = \'source-files\'\n\n## put data into S3 using the Server Side Encryption functionality to encrypt\n## data at rest in S3 https://aws.amazon.com/about-aws/whats-\n## new/2011/10/04/amazon-s3-announces-server-side-encryption-support/\n## Defaults to: False\nTC_AWS_STORAGE_SSE = False  # This is not yet supported\n\n## put data into S3 with Reduced Redundancy https://aws.amazon.com/about-\n## aws/whats-new/2010/05/19/announcing-amazon-s3-reduced-redundancy-storage/\n## Defaults to: False\nTC_AWS_STORAGE_RRS = False  # This is not yet supported\n\n## S3 bucket for result Storage\n## Defaults to: \'\'\nTC_AWS_RESULT_STORAGE_BUCKET = \'my-bucket\'\n\n## S3 path prefix for Result storage bucket\n## Defaults to: \'\'\nTC_AWS_RESULT_STORAGE_ROOT_PATH = \'result-storage\'\n\n## Store result with metadata (for instance content-type)\n## Defaults to: False\n# This configuration won\'t matter as thumbor-aws stores metadata anyway\nTC_AWS_STORE_METADATA = False\n\n################################################################################\n```\n\nPlease notice the addition of `THUMBOR_AWS_RUN_IN_COMPATIBILITY_MODE = True` to tell `thumbor_aws` you want compatibility with `tc_aws`.\n\nIf you have any issues with this\n\n#### Caveats\n\n1. thumbor-aws does not create buckets for you. If they don\'t exist you are getting errors.\n\nYou can easily create a bucket using [aws-cli](https://aws.amazon.com/cli/?nc1=h_ls) with:\n\n```\n$ aws s3api create-bucket --bucket <bucket name> --region <your region>\n```\n\nOr through your [AWS Console UI](https://console.aws.amazon.com/s3/home?region=us-east-1).\n\n### Troubles?\n\nIf you experience any troubles, try running:\n\n```bash\nthumbor-doctor\n```\n\nIf you still need help, please [raise an issue](https://github.com/thumbor/thumbor-aws/issues).\n\n## 👀 Thumbor\n\n[thumbor-aws](https://github.com/thumbor/thumbor-aws) stands on the shoulders of [thumbor](https://github.com/thumbor/thumbor)! If you are not familiar with [thumbor](https://github.com/thumbor/thumbor), please check the [docs](https://thumbor.readthedocs.io/en/latest/) or you can see a demo at http://thumborize.me/\n\n## 👍 Contribute\n\nthumbor-aws is an open-source project with many contributors. Join them\n[contributing code](https://github.com/thumbor/thumbor-aws/blob/master/CONTRIBUTING.md) or\n[contributing documentation](https://github.com/thumbor/thumbor-aws/blob/master/CONTRIBUTING.md).\n\nJoin the chat at https://gitter.im/thumbor/thumbor\n\n## License\n\nMIT License\n\nCopyright (c) 2021 thumbor-aws (by @heynemann)\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n',
    'author': 'Bernardo Heynemann',
    'author_email': 'heynemann@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
