# mypy-boto3-comprehend

[![PyPI - mypy-boto3-comprehend](https://img.shields.io/pypi/v/mypy-boto3-comprehend.svg?color=blue)](https://pypi.org/project/mypy-boto3-comprehend)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-comprehend.svg?color=blue)](https://pypi.org/project/mypy-boto3-comprehend)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Comprehend 1.12.44](https://boto3.amazonaws.com/v1/documentation/api/1.12.44/reference/services/comprehend.html#Comprehend) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.7](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-comprehend](#mypy-boto3-comprehend)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Comprehend` service.

```bash
python -m pip install boto3-stubs[comprehend]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import comprehend
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_comprehend as comprehend

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("comprehend")
client: comprehend.ComprehendClient = boto3.client("comprehend")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: comprehend.ComprehendClient = session.client("comprehend")


# Paginators need type annotation on creation
list_document_classification_jobs_paginator: comprehend.ListDocumentClassificationJobsPaginator = client.get_paginator("list_document_classification_jobs")
list_document_classifiers_paginator: comprehend.ListDocumentClassifiersPaginator = client.get_paginator("list_document_classifiers")
list_dominant_language_detection_jobs_paginator: comprehend.ListDominantLanguageDetectionJobsPaginator = client.get_paginator("list_dominant_language_detection_jobs")
list_entities_detection_jobs_paginator: comprehend.ListEntitiesDetectionJobsPaginator = client.get_paginator("list_entities_detection_jobs")
list_entity_recognizers_paginator: comprehend.ListEntityRecognizersPaginator = client.get_paginator("list_entity_recognizers")
list_key_phrases_detection_jobs_paginator: comprehend.ListKeyPhrasesDetectionJobsPaginator = client.get_paginator("list_key_phrases_detection_jobs")
list_sentiment_detection_jobs_paginator: comprehend.ListSentimentDetectionJobsPaginator = client.get_paginator("list_sentiment_detection_jobs")
list_topics_detection_jobs_paginator: comprehend.ListTopicsDetectionJobsPaginator = client.get_paginator("list_topics_detection_jobs")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.