# Copyright (c) 2016, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

from mixbox import fields

import stix
from stix.common import StructuredText
import stix.bindings.exploit_target as exploit_target_binding


class Configuration(stix.Entity):
    """Implementation of STIX ``Configuration``.

    Args:
        cce_id(optional): Common Configuration Enumeration value as a string
        description (optional): A string description.
        short_description (optional): A string short description.

    """
    _binding = exploit_target_binding
    _binding_class = _binding.ConfigurationType
    _namespace = "http://stix.mitre.org/ExploitTarget-1"

    description = fields.TypedField("Description", type_="stix.common.StructuredText")
    short_description = fields.TypedField("Short_Description", type_="stix.common.StructuredText")
    cce_id = fields.TypedField("CCE_ID")

    def __init__(self, description=None, short_description=None, cce_id=None):
        super(Configuration, self).__init__()

        self.description = description
        self.short_description = short_description
        self.cce_id = cce_id
