# Copyright (c) 2016, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

from mixbox import fields

import stix
import stix.bindings.exploit_target as exploit_target_binding
from stix.common import StructuredText


class Weakness(stix.Entity):
    """Implementation of STIX ``Weakness``.

    Args:
        cwe_id(optional): Common Weakness Enumeration value as a string
        description (optional): A string description.

    """
    _binding = exploit_target_binding
    _binding_class = _binding.WeaknessType
    _namespace = "http://stix.mitre.org/ExploitTarget-1"

    description = fields.TypedField("Description", type_="stix.common.StructuredText")
    cwe_id = fields.TypedField("CWE_ID")

    def __init__(self, description=None, cwe_id=None):
        super(Weakness, self).__init__()

        self.description = description
        self.cwe_id = cwe_id


class _Weaknesses(stix.TypedList):
    _contained_type = Weakness
