/// Files: net/bluetooth/a2mp.c
/// Fix: eddb7732119d53400f48a02536a84c509692faa8
/// Fixes: 6b44d9b8d96b37f72ccd7335b32f386a67b7f1f4

virtual detect

@err_a2mp_discover_rsp exists@
identifier req;
position p;
@@

a2mp_discover_rsp(...)
{
	...
	struct a2mp_info_req req;
	... when != memset(&req, 0, sizeof(req));
*	a2mp_send(..., A2MP_GETINFO_REQ, ..., sizeof(req), &req)@p;
	...
}

@err_a2mp_getinfo_req exists@
identifier rsp;
position p;
@@

a2mp_getinfo_req(...)
{
	...
	struct a2mp_info_rsp rsp;
	... when != memset(&rsp, 0, sizeof(rsp));
*	a2mp_send(..., A2MP_GETINFO_RSP, ..., sizeof(rsp), &rsp)@p;
	...
}

@err_a2mp_getinfo_rsp exists@
identifier req;
position p;
@@

a2mp_getinfo_rsp(...)
{
	...
	struct a2mp_amp_assoc_req req;
	... when != memset(&req, 0, sizeof(req));
*	a2mp_send(..., A2MP_GETAMPASSOC_REQ, ..., sizeof(req), &req);@p
	...
}

@err_a2mp_getampassoc_req exists@
identifier rsp;
position p;
@@

a2mp_getampassoc_req(...)
{
	...
	struct a2mp_amp_assoc_rsp rsp;
	... when != memset(&rsp, 0, sizeof(rsp));
*	a2mp_send(..., A2MP_GETAMPASSOC_RSP, ..., sizeof(rsp), &rsp);@p
	...
}

@err_a2mp_createphyslink_req exists@
identifier rsp;
position p;
@@

a2mp_createphyslink_req(...)
{
	...
	struct a2mp_physlink_rsp rsp;
	... when != memset(&rsp, 0, sizeof(rsp));
*	a2mp_send(..., A2MP_CREATEPHYSLINK_RSP, ..., sizeof(rsp), &rsp);@p
	...
}

@err_a2mp_discphyslink_req exists@
identifier rsp;
position p;
@@

a2mp_discphyslink_req(...)
{
	...
	struct a2mp_physlink_rsp rsp;
	... when != memset(&rsp, 0, sizeof(rsp));
*	a2mp_send(..., A2MP_DISCONNPHYSLINK_RSP, ..., sizeof(rsp), &rsp);@p
	...
}

@err_a2mp_chan_recv_cb exists@
identifier rej;
position p;
@@

a2mp_chan_recv_cb(...)
{
	...
	struct a2mp_cmd_rej rej;
	... when != memset(&rej, 0, sizeof(rej));
*	a2mp_send(..., A2MP_COMMAND_REJ, ..., sizeof(rej), &rej);@p
	...
}

@err_a2mp_send_getinfo_rsp exists@
identifier rsp;
position p;
@@

a2mp_send_getinfo_rsp(...)
{
	...
	struct a2mp_info_rsp rsp;
	... when != memset(&rsp, 0, sizeof(rsp));
*	a2mp_send(..., A2MP_GETINFO_RSP, ..., sizeof(rsp), &rsp);@p
	...
}

@err_a2mp_send_create_phy_link_rsp exists@
identifier rsp;
position p;
@@

a2mp_send_create_phy_link_rsp(...)
{
	...
	struct a2mp_physlink_rsp rsp;
	... when != memset(&rsp, 0, sizeof(rsp));
*	a2mp_send(..., A2MP_CREATEPHYSLINK_RSP, ..., sizeof(rsp), &rsp);@p
	...
}

@err_a2mp_discover_amp exists@
identifier req;
position p;
@@

a2mp_discover_amp(...)
{
	...
	struct a2mp_discov_req req;
	... when != memset(&req, 0, sizeof(req));
*	a2mp_send(..., A2MP_DISCOVER_REQ, ..., sizeof(req), &req);@p
	...
}

@script:python depends on detect@
p << err_a2mp_discover_rsp.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_getinfo_req.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_getinfo_rsp.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_getampassoc_req.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_createphyslink_req.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_discphyslink_req.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_chan_recv_cb.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_send_getinfo_rsp.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_send_create_phy_link_rsp.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')

@script:python depends on detect@
p << err_a2mp_discover_amp.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-12352')
