/// Files: kernel/futex.c
/// Fix: 12bb3f7f1b03d5913b3f9d4236a488aa7774dfe9
/// Fixes: c1e2f0eaf015fb7076d51a339011f2383e6dd389
/// Version: 1.0.7

virtual detect

@err_fixup_pi_state_owner exists@
identifier ret;
symbol current;
position p;
@@

\(__fixup_pi_state_owner\|fixup_pi_state_owner\)(...)
{
	...
	if (__rt_mutex_futex_trylock(&pi_state->pi_mutex)) {
*		ret =@p 0;
		...
	}
	...
	if (oldowner != current) {
*		ret = 0;
		...
	}
	...
*	return 0;
	...
}

@err_fixup_owner exists@
identifier ret, locked, out;
symbol current;
position p;
@@

static int fixup_owner(...)
{
	...
	if (locked) {
		if (...)
*			ret =@p fixup_pi_state_owner(..., current);
(
		return ret ? ret : locked;
|
		goto out;
)
	}
	...
(
	return ret;
|
	return ret ? ret : locked;
)
}

@err_futex_wait_requeue_pi exists@
symbol current;
position p;
@@

futex_wait_requeue_pi(...)
{
	...
	if (...) {
		spin_lock(...);
		ret = fixup_pi_state_owner(..., current);
*		if (ret &&@p rt_mutex_owner(&q.pi_state->pi_mutex) == current) {
			pi_state = ...;
			get_pi_state(pi_state);
		}
		put_pi_state(...);
		spin_unlock(...);
	}
	...
}

@script:python depends on detect@
p << err_fixup_pi_state_owner.p;
q << err_fixup_owner.p;
r << err_futex_wait_requeue_pi.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-3347')
coccilib.report.print_report(q[0], 'ERROR: CVE-2021-3347')
coccilib.report.print_report(r[0], 'ERROR: CVE-2021-3347')
