/// Files: kernel/bpf/ringbuf.c
/// Fix: 4b81ccebaeee885ab1aa1438133f2991e3a2b6ea
/// Fixes: 457f44363a8894135c85b7a9afd2bd8196db24ab

virtual detect

@err exists@
identifier rb, size, len;
position p;
@@

__bpf_ringbuf_reserve(struct bpf_ringbuf *rb, u64 size)
{
	...
*	len =@p round_up(size + BPF_RINGBUF_HDR_SZ, ...);
	... when != if (len > rb->mask + 1) return NULL;
	smp_load_acquire(&rb->consumer_pos)
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-3489')
