# Generated by Django 4.1 on 2022-10-06 00:05
# flake8: noqa

from django.db import migrations, models
import django.db.models.manager
import pghistory.models


class Migration(migrations.Migration):

    dependencies = [
        ("pghistory", "0004_auto_20220906_1625"),
    ]

    operations = [
        migrations.CreateModel(
            name="Events",
            fields=[
                (
                    "pgh_slug",
                    models.TextField(
                        help_text="The unique identifier across all event tables.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("pgh_model", models.CharField(help_text="The event model.", max_length=64)),
                ("pgh_id", models.BigIntegerField(help_text="The primary key of the event.")),
                (
                    "pgh_created_at",
                    models.DateTimeField(
                        auto_now_add=True, help_text="When the event was created."
                    ),
                ),
                ("pgh_label", models.TextField(help_text="The event label.")),
                (
                    "pgh_data",
                    pghistory.models.PGHistoryJSONField(help_text="The raw data of the event."),
                ),
                (
                    "pgh_diff",
                    pghistory.models.PGHistoryJSONField(
                        help_text="The diff between the previous event of the same label."
                    ),
                ),
                ("pgh_context_id", models.UUIDField(help_text="The context UUID.", null=True)),
                (
                    "pgh_context",
                    pghistory.models.PGHistoryJSONField(
                        help_text="The context associated with the event.", null=True
                    ),
                ),
                ("pgh_obj_model", models.CharField(help_text="The object model.", max_length=64)),
                (
                    "pgh_obj_id",
                    models.TextField(help_text="The primary key of the object.", null=True),
                ),
            ],
            options={
                "verbose_name_plural": "events",
                "managed": False,
                "default_manager_name": "no_objects",
            },
            managers=[
                ("no_objects", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="MiddlewareEvents",
            fields=[],
            options={
                "verbose_name_plural": "middleware events",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("pghistory.events",),
            managers=[
                ("no_objects", django.db.models.manager.Manager()),
            ],
        ),
    ]
