"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const emr_generated_1 = require("./emr.generated");
Object.defineProperty(exports, "ClusterProperty", { enumerable: true, get: function () { return emr_generated_1.RosCluster; } });
/**
 * A ROS resource type:  `ALIYUN::EMR::Cluster`
 */
class Cluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::EMR::Cluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCluster = new emr_generated_1.RosCluster(this, id, {
            bootstrapAction: props.bootstrapAction,
            securityGroupName: props.securityGroupName,
            config: props.config,
            clickHouseConf: props.clickHouseConf,
            autoRenew: props.autoRenew,
            hostGroup: props.hostGroup,
            userInfo: props.userInfo,
            name: props.name,
            highAvailabilityEnable: props.highAvailabilityEnable,
            optionSoftWareList: props.optionSoftWareList,
            masterPwd: props.masterPwd,
            sshEnable: props.sshEnable,
            useCustomHiveMetaDb: props.useCustomHiveMetaDb,
            isOpenPublicIp: props.isOpenPublicIp,
            configurations: props.configurations,
            authorizeContent: props.authorizeContent,
            userDefinedEmrEcsRole: props.userDefinedEmrEcsRole,
            netType: props.netType,
            useLocalMetaDb: props.useLocalMetaDb,
            keyPairName: props.keyPairName,
            ioOptimized: props.ioOptimized === undefined || props.ioOptimized === null ? true : props.ioOptimized,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            machineType: props.machineType,
            depositType: props.depositType,
            period: props.period,
            metaStoreType: props.metaStoreType,
            emrVer: props.emrVer,
            clusterType: props.clusterType,
            easEnable: props.easEnable,
            relatedClusterId: props.relatedClusterId,
            vpcId: props.vpcId,
            chargeType: props.chargeType,
            whiteListType: props.whiteListType,
            metaStoreConf: props.metaStoreConf,
            instanceGeneration: props.instanceGeneration,
            logPath: props.logPath,
            initCustomHiveMetaDb: props.initCustomHiveMetaDb,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCluster;
        this.attrClusterId = rosCluster.attrClusterId;
        this.attrHostGroups = rosCluster.attrHostGroups;
        this.attrMasterNodeInnerIps = rosCluster.attrMasterNodeInnerIps;
        this.attrMasterNodePubIps = rosCluster.attrMasterNodePubIps;
    }
}
exports.Cluster = Cluster;
//# sourceMappingURL=data:application/json;base64,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