"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingAppInstanceAdmin = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const messagingCustomResources_1 = require("./messagingCustomResources");
class MessagingAppInstanceAdmin extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { appInstanceArn, appInstanceAdminArn } = props;
        const appInstanceRequest = new messagingCustomResources_1.MessagingResources(this, 'MessagingAppInstance', {
            resourceType: 'AppInstanceAdmin',
            uid: uid,
            properties: {
                appInstanceArn: appInstanceArn,
                appInstanceAdminArn: appInstanceAdminArn,
            },
        });
        this.appInstanceAdminArn =
            appInstanceRequest.messagingCustomResource.getAttString('AppInstanceAdminArn');
        this.appInstanceAdminName =
            appInstanceRequest.messagingCustomResource.getAttString('AppInstanceAdminName');
    }
}
exports.MessagingAppInstanceAdmin = MessagingAppInstanceAdmin;
_a = JSII_RTTI_SYMBOL_1;
MessagingAppInstanceAdmin[_a] = { fqn: "cdk-amazon-chime-resources.MessagingAppInstanceAdmin", version: "0.1.190" };
//# sourceMappingURL=data:application/json;base64,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