"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRecordSetGroup = exports.CfnRecordSet = exports.CfnKeySigningKey = exports.CfnHostedZone = exports.CfnHealthCheck = exports.CfnDNSSEC = exports.CfnCidrCollection = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-09-21T21:45:45.827Z","fingerprint":"TsvLcjh76b8LmaMItIuHmDvF06zUsMVg/YwazMlSUg8="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnCidrCollectionProps`
 *
 * @param properties - the TypeScript properties of a `CfnCidrCollectionProps`
 *
 * @returns the result of the validation.
 */
function CfnCidrCollectionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('locations', cdk.listValidator(CfnCidrCollection_LocationPropertyValidator))(properties.locations));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "CfnCidrCollectionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::CidrCollection` resource
 *
 * @param properties - the TypeScript properties of a `CfnCidrCollectionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::CidrCollection` resource.
 */
// @ts-ignore TS6133
function cfnCidrCollectionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCidrCollectionPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Locations: cdk.listMapper(cfnCidrCollectionLocationPropertyToCloudFormation)(properties.locations),
    };
}
// @ts-ignore TS6133
function CfnCidrCollectionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('locations', 'Locations', properties.Locations != null ? cfn_parse.FromCloudFormation.getArray(CfnCidrCollectionLocationPropertyFromCloudFormation)(properties.Locations) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::CidrCollection`
 *
 *
 *
 * @cloudformationResource AWS::Route53::CidrCollection
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-cidrcollection.html
 */
class CfnCidrCollection extends cdk.CfnResource {
    /**
     * Create a new `AWS::Route53::CidrCollection`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCidrCollection.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CfnCidrCollectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnCidrCollection);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.name = props.name;
        this.locations = props.locations;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnCidrCollectionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnCidrCollection(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCidrCollection.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            locations: this.locations,
        };
    }
    renderProperties(props) {
        return cfnCidrCollectionPropsToCloudFormation(props);
    }
}
exports.CfnCidrCollection = CfnCidrCollection;
_a = JSII_RTTI_SYMBOL_1;
CfnCidrCollection[_a] = { fqn: "@aws-cdk/aws-route53.CfnCidrCollection", version: "1.174.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnCidrCollection.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::CidrCollection";
/**
 * Determine whether the given properties match those of a `LocationProperty`
 *
 * @param properties - the TypeScript properties of a `LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnCidrCollection_LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cidrList', cdk.requiredValidator)(properties.cidrList));
    errors.collect(cdk.propertyValidator('cidrList', cdk.listValidator(cdk.validateString))(properties.cidrList));
    errors.collect(cdk.propertyValidator('locationName', cdk.requiredValidator)(properties.locationName));
    errors.collect(cdk.propertyValidator('locationName', cdk.validateString)(properties.locationName));
    return errors.wrap('supplied properties not correct for "LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::CidrCollection.Location` resource
 *
 * @param properties - the TypeScript properties of a `LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::CidrCollection.Location` resource.
 */
// @ts-ignore TS6133
function cfnCidrCollectionLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCidrCollection_LocationPropertyValidator(properties).assertSuccess();
    return {
        CidrList: cdk.listMapper(cdk.stringToCloudFormation)(properties.cidrList),
        LocationName: cdk.stringToCloudFormation(properties.locationName),
    };
}
// @ts-ignore TS6133
function CfnCidrCollectionLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cidrList', 'CidrList', cfn_parse.FromCloudFormation.getStringArray(properties.CidrList));
    ret.addPropertyResult('locationName', 'LocationName', cfn_parse.FromCloudFormation.getString(properties.LocationName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDNSSECProps`
 *
 * @param properties - the TypeScript properties of a `CfnDNSSECProps`
 *
 * @returns the result of the validation.
 */
function CfnDNSSECPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.requiredValidator)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    return errors.wrap('supplied properties not correct for "CfnDNSSECProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::DNSSEC` resource
 *
 * @param properties - the TypeScript properties of a `CfnDNSSECProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::DNSSEC` resource.
 */
// @ts-ignore TS6133
function cfnDNSSECPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDNSSECPropsValidator(properties).assertSuccess();
    return {
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
    };
}
// @ts-ignore TS6133
function CfnDNSSECPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', cfn_parse.FromCloudFormation.getString(properties.HostedZoneId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::DNSSEC`
 *
 * The `AWS::Route53::DNSSEC` resource is used to enable DNSSEC signing in a hosted zone.
 *
 * @cloudformationResource AWS::Route53::DNSSEC
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-dnssec.html
 */
class CfnDNSSEC extends cdk.CfnResource {
    /**
     * Create a new `AWS::Route53::DNSSEC`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDNSSEC.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CfnDNSSECProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDNSSEC);
            }
            throw error;
        }
        cdk.requireProperty(props, 'hostedZoneId', this);
        this.hostedZoneId = props.hostedZoneId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDNSSECPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDNSSEC(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDNSSEC.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            hostedZoneId: this.hostedZoneId,
        };
    }
    renderProperties(props) {
        return cfnDNSSECPropsToCloudFormation(props);
    }
}
exports.CfnDNSSEC = CfnDNSSEC;
_b = JSII_RTTI_SYMBOL_1;
CfnDNSSEC[_b] = { fqn: "@aws-cdk/aws-route53.CfnDNSSEC", version: "1.174.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDNSSEC.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::DNSSEC";
/**
 * Determine whether the given properties match those of a `CfnHealthCheckProps`
 *
 * @param properties - the TypeScript properties of a `CfnHealthCheckProps`
 *
 * @returns the result of the validation.
 */
function CfnHealthCheckPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('healthCheckConfig', cdk.requiredValidator)(properties.healthCheckConfig));
    errors.collect(cdk.propertyValidator('healthCheckConfig', CfnHealthCheck_HealthCheckConfigPropertyValidator)(properties.healthCheckConfig));
    errors.collect(cdk.propertyValidator('healthCheckTags', cdk.listValidator(CfnHealthCheck_HealthCheckTagPropertyValidator))(properties.healthCheckTags));
    return errors.wrap('supplied properties not correct for "CfnHealthCheckProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HealthCheck` resource
 *
 * @param properties - the TypeScript properties of a `CfnHealthCheckProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HealthCheck` resource.
 */
// @ts-ignore TS6133
function cfnHealthCheckPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHealthCheckPropsValidator(properties).assertSuccess();
    return {
        HealthCheckConfig: cfnHealthCheckHealthCheckConfigPropertyToCloudFormation(properties.healthCheckConfig),
        HealthCheckTags: cdk.listMapper(cfnHealthCheckHealthCheckTagPropertyToCloudFormation)(properties.healthCheckTags),
    };
}
// @ts-ignore TS6133
function CfnHealthCheckPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('healthCheckConfig', 'HealthCheckConfig', CfnHealthCheckHealthCheckConfigPropertyFromCloudFormation(properties.HealthCheckConfig));
    ret.addPropertyResult('healthCheckTags', 'HealthCheckTags', properties.HealthCheckTags != null ? cfn_parse.FromCloudFormation.getArray(CfnHealthCheckHealthCheckTagPropertyFromCloudFormation)(properties.HealthCheckTags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`
 *
 * The `AWS::Route53::HealthCheck` resource is a Route 53 resource type that contains settings for a Route 53 health check.
 *
 * For information about associating health checks with records, see [HealthCheckId](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId) in [ChangeResourceRecordSets](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html) .
 *
 * > You can't create a health check with simple routing.
 *
 * *ELB Load Balancers*
 *
 * If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you configure settings for an ELB health check, which performs a similar function to a Route 53 health check.
 *
 * *Private Hosted Zones*
 *
 * You can associate health checks with failover records in a private hosted zone. Note the following:
 *
 * - Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you must assign a public IP address to the instance in the VPC.
 * - You can configure a health checker to check the health of an external resource that the instance relies on, such as a database server.
 * - You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the Amazon EC2 `StatusCheckFailed` metric, add an alarm to the metric, and then create a health check that is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the CloudWatch console, see the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html) .
 *
 * @cloudformationResource AWS::Route53::HealthCheck
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
class CfnHealthCheck extends cdk.CfnResource {
    /**
     * Create a new `AWS::Route53::HealthCheck`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnHealthCheck.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CfnHealthCheckProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnHealthCheck);
            }
            throw error;
        }
        cdk.requireProperty(props, 'healthCheckConfig', this);
        this.attrHealthCheckId = cdk.Token.asString(this.getAtt('HealthCheckId'));
        this.healthCheckConfig = props.healthCheckConfig;
        this.healthCheckTags = props.healthCheckTags;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnHealthCheckPropsFromCloudFormation(resourceProperties);
        const ret = new CfnHealthCheck(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnHealthCheck.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            healthCheckConfig: this.healthCheckConfig,
            healthCheckTags: this.healthCheckTags,
        };
    }
    renderProperties(props) {
        return cfnHealthCheckPropsToCloudFormation(props);
    }
}
exports.CfnHealthCheck = CfnHealthCheck;
_c = JSII_RTTI_SYMBOL_1;
CfnHealthCheck[_c] = { fqn: "@aws-cdk/aws-route53.CfnHealthCheck", version: "1.174.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnHealthCheck.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HealthCheck";
/**
 * Determine whether the given properties match those of a `AlarmIdentifierProperty`
 *
 * @param properties - the TypeScript properties of a `AlarmIdentifierProperty`
 *
 * @returns the result of the validation.
 */
function CfnHealthCheck_AlarmIdentifierPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('region', cdk.requiredValidator)(properties.region));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    return errors.wrap('supplied properties not correct for "AlarmIdentifierProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.AlarmIdentifier` resource
 *
 * @param properties - the TypeScript properties of a `AlarmIdentifierProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.AlarmIdentifier` resource.
 */
// @ts-ignore TS6133
function cfnHealthCheckAlarmIdentifierPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHealthCheck_AlarmIdentifierPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Region: cdk.stringToCloudFormation(properties.region),
    };
}
// @ts-ignore TS6133
function CfnHealthCheckAlarmIdentifierPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('region', 'Region', cfn_parse.FromCloudFormation.getString(properties.Region));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HealthCheckConfigProperty`
 *
 * @param properties - the TypeScript properties of a `HealthCheckConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnHealthCheck_HealthCheckConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('alarmIdentifier', CfnHealthCheck_AlarmIdentifierPropertyValidator)(properties.alarmIdentifier));
    errors.collect(cdk.propertyValidator('childHealthChecks', cdk.listValidator(cdk.validateString))(properties.childHealthChecks));
    errors.collect(cdk.propertyValidator('enableSni', cdk.validateBoolean)(properties.enableSni));
    errors.collect(cdk.propertyValidator('failureThreshold', cdk.validateNumber)(properties.failureThreshold));
    errors.collect(cdk.propertyValidator('fullyQualifiedDomainName', cdk.validateString)(properties.fullyQualifiedDomainName));
    errors.collect(cdk.propertyValidator('healthThreshold', cdk.validateNumber)(properties.healthThreshold));
    errors.collect(cdk.propertyValidator('ipAddress', cdk.validateString)(properties.ipAddress));
    errors.collect(cdk.propertyValidator('insufficientDataHealthStatus', cdk.validateString)(properties.insufficientDataHealthStatus));
    errors.collect(cdk.propertyValidator('inverted', cdk.validateBoolean)(properties.inverted));
    errors.collect(cdk.propertyValidator('measureLatency', cdk.validateBoolean)(properties.measureLatency));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('regions', cdk.listValidator(cdk.validateString))(properties.regions));
    errors.collect(cdk.propertyValidator('requestInterval', cdk.validateNumber)(properties.requestInterval));
    errors.collect(cdk.propertyValidator('resourcePath', cdk.validateString)(properties.resourcePath));
    errors.collect(cdk.propertyValidator('routingControlArn', cdk.validateString)(properties.routingControlArn));
    errors.collect(cdk.propertyValidator('searchString', cdk.validateString)(properties.searchString));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "HealthCheckConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.HealthCheckConfig` resource
 *
 * @param properties - the TypeScript properties of a `HealthCheckConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.HealthCheckConfig` resource.
 */
// @ts-ignore TS6133
function cfnHealthCheckHealthCheckConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHealthCheck_HealthCheckConfigPropertyValidator(properties).assertSuccess();
    return {
        AlarmIdentifier: cfnHealthCheckAlarmIdentifierPropertyToCloudFormation(properties.alarmIdentifier),
        ChildHealthChecks: cdk.listMapper(cdk.stringToCloudFormation)(properties.childHealthChecks),
        EnableSNI: cdk.booleanToCloudFormation(properties.enableSni),
        FailureThreshold: cdk.numberToCloudFormation(properties.failureThreshold),
        FullyQualifiedDomainName: cdk.stringToCloudFormation(properties.fullyQualifiedDomainName),
        HealthThreshold: cdk.numberToCloudFormation(properties.healthThreshold),
        IPAddress: cdk.stringToCloudFormation(properties.ipAddress),
        InsufficientDataHealthStatus: cdk.stringToCloudFormation(properties.insufficientDataHealthStatus),
        Inverted: cdk.booleanToCloudFormation(properties.inverted),
        MeasureLatency: cdk.booleanToCloudFormation(properties.measureLatency),
        Port: cdk.numberToCloudFormation(properties.port),
        Regions: cdk.listMapper(cdk.stringToCloudFormation)(properties.regions),
        RequestInterval: cdk.numberToCloudFormation(properties.requestInterval),
        ResourcePath: cdk.stringToCloudFormation(properties.resourcePath),
        RoutingControlArn: cdk.stringToCloudFormation(properties.routingControlArn),
        SearchString: cdk.stringToCloudFormation(properties.searchString),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnHealthCheckHealthCheckConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('alarmIdentifier', 'AlarmIdentifier', properties.AlarmIdentifier != null ? CfnHealthCheckAlarmIdentifierPropertyFromCloudFormation(properties.AlarmIdentifier) : undefined);
    ret.addPropertyResult('childHealthChecks', 'ChildHealthChecks', properties.ChildHealthChecks != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ChildHealthChecks) : undefined);
    ret.addPropertyResult('enableSni', 'EnableSNI', properties.EnableSNI != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableSNI) : undefined);
    ret.addPropertyResult('failureThreshold', 'FailureThreshold', properties.FailureThreshold != null ? cfn_parse.FromCloudFormation.getNumber(properties.FailureThreshold) : undefined);
    ret.addPropertyResult('fullyQualifiedDomainName', 'FullyQualifiedDomainName', properties.FullyQualifiedDomainName != null ? cfn_parse.FromCloudFormation.getString(properties.FullyQualifiedDomainName) : undefined);
    ret.addPropertyResult('healthThreshold', 'HealthThreshold', properties.HealthThreshold != null ? cfn_parse.FromCloudFormation.getNumber(properties.HealthThreshold) : undefined);
    ret.addPropertyResult('ipAddress', 'IPAddress', properties.IPAddress != null ? cfn_parse.FromCloudFormation.getString(properties.IPAddress) : undefined);
    ret.addPropertyResult('insufficientDataHealthStatus', 'InsufficientDataHealthStatus', properties.InsufficientDataHealthStatus != null ? cfn_parse.FromCloudFormation.getString(properties.InsufficientDataHealthStatus) : undefined);
    ret.addPropertyResult('inverted', 'Inverted', properties.Inverted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Inverted) : undefined);
    ret.addPropertyResult('measureLatency', 'MeasureLatency', properties.MeasureLatency != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MeasureLatency) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('regions', 'Regions', properties.Regions != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Regions) : undefined);
    ret.addPropertyResult('requestInterval', 'RequestInterval', properties.RequestInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.RequestInterval) : undefined);
    ret.addPropertyResult('resourcePath', 'ResourcePath', properties.ResourcePath != null ? cfn_parse.FromCloudFormation.getString(properties.ResourcePath) : undefined);
    ret.addPropertyResult('routingControlArn', 'RoutingControlArn', properties.RoutingControlArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoutingControlArn) : undefined);
    ret.addPropertyResult('searchString', 'SearchString', properties.SearchString != null ? cfn_parse.FromCloudFormation.getString(properties.SearchString) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HealthCheckTagProperty`
 *
 * @param properties - the TypeScript properties of a `HealthCheckTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnHealthCheck_HealthCheckTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "HealthCheckTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.HealthCheckTag` resource
 *
 * @param properties - the TypeScript properties of a `HealthCheckTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HealthCheck.HealthCheckTag` resource.
 */
// @ts-ignore TS6133
function cfnHealthCheckHealthCheckTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHealthCheck_HealthCheckTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnHealthCheckHealthCheckTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnHostedZoneProps`
 *
 * @param properties - the TypeScript properties of a `CfnHostedZoneProps`
 *
 * @returns the result of the validation.
 */
function CfnHostedZonePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostedZoneConfig', CfnHostedZone_HostedZoneConfigPropertyValidator)(properties.hostedZoneConfig));
    errors.collect(cdk.propertyValidator('hostedZoneTags', cdk.listValidator(CfnHostedZone_HostedZoneTagPropertyValidator))(properties.hostedZoneTags));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('queryLoggingConfig', CfnHostedZone_QueryLoggingConfigPropertyValidator)(properties.queryLoggingConfig));
    errors.collect(cdk.propertyValidator('vpcs', cdk.listValidator(CfnHostedZone_VPCPropertyValidator))(properties.vpcs));
    return errors.wrap('supplied properties not correct for "CfnHostedZoneProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone` resource
 *
 * @param properties - the TypeScript properties of a `CfnHostedZoneProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone` resource.
 */
// @ts-ignore TS6133
function cfnHostedZonePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZonePropsValidator(properties).assertSuccess();
    return {
        HostedZoneConfig: cfnHostedZoneHostedZoneConfigPropertyToCloudFormation(properties.hostedZoneConfig),
        HostedZoneTags: cdk.listMapper(cfnHostedZoneHostedZoneTagPropertyToCloudFormation)(properties.hostedZoneTags),
        Name: cdk.stringToCloudFormation(properties.name),
        QueryLoggingConfig: cfnHostedZoneQueryLoggingConfigPropertyToCloudFormation(properties.queryLoggingConfig),
        VPCs: cdk.listMapper(cfnHostedZoneVPCPropertyToCloudFormation)(properties.vpcs),
    };
}
// @ts-ignore TS6133
function CfnHostedZonePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostedZoneConfig', 'HostedZoneConfig', properties.HostedZoneConfig != null ? CfnHostedZoneHostedZoneConfigPropertyFromCloudFormation(properties.HostedZoneConfig) : undefined);
    ret.addPropertyResult('hostedZoneTags', 'HostedZoneTags', properties.HostedZoneTags != null ? cfn_parse.FromCloudFormation.getArray(CfnHostedZoneHostedZoneTagPropertyFromCloudFormation)(properties.HostedZoneTags) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('queryLoggingConfig', 'QueryLoggingConfig', properties.QueryLoggingConfig != null ? CfnHostedZoneQueryLoggingConfigPropertyFromCloudFormation(properties.QueryLoggingConfig) : undefined);
    ret.addPropertyResult('vpcs', 'VPCs', properties.VPCs != null ? cfn_parse.FromCloudFormation.getArray(CfnHostedZoneVPCPropertyFromCloudFormation)(properties.VPCs) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`
 *
 * Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
 *
 * > You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the same name and create new resource record sets.
 *
 * For more information about charges for hosted zones, see [Amazon Route 53 Pricing](https://docs.aws.amazon.com/route53/pricing/) .
 *
 * Note the following:
 *
 * - You can't create a hosted zone for a top-level domain (TLD) such as .com.
 * - For public hosted zones, Route 53 automatically creates a default SOA record and four NS records for the zone. For more information about SOA and NS records, see [NS and SOA Records that Route 53 Creates for a Hosted Zone](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html) in the *Amazon Route 53 Developer Guide* .
 *
 * If you want to use the same name servers for multiple public hosted zones, you can optionally associate a reusable delegation set with the hosted zone. See the `DelegationSetId` element.
 * - If your domain is registered with a registrar other than Route 53, you must update the name servers with your registrar to make Route 53 the DNS service for the domain. For more information, see [Migrating DNS Service for an Existing Domain to Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html) in the *Amazon Route 53 Developer Guide* .
 *
 * When you submit a `CreateHostedZone` request, the initial status of the hosted zone is `PENDING` . For public hosted zones, this means that the NS and SOA records are not yet available on all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to `INSYNC` .
 *
 * The `CreateHostedZone` request requires the caller to have an `ec2:DescribeVpcs` permission.
 *
 * > When creating private hosted zones, the Amazon VPC must belong to the same partition where the hosted zone is created. A partition is a group of AWS Regions . Each AWS account is scoped to one partition.
 * >
 * > The following are the supported partitions:
 * >
 * > - `aws` - AWS Regions
 * > - `aws-cn` - China Regions
 * > - `aws-us-gov` - AWS GovCloud (US) Region
 * >
 * > For more information, see [Access Management](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference* .
 *
 * @cloudformationResource AWS::Route53::HostedZone
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
class CfnHostedZone extends cdk.CfnResource {
    /**
     * Create a new `AWS::Route53::HostedZone`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnHostedZone.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CfnHostedZoneProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnHostedZone);
            }
            throw error;
        }
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrNameServers = cdk.Token.asList(this.getAtt('NameServers'));
        this.hostedZoneConfig = props.hostedZoneConfig;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Route53::HostedZone", props.hostedZoneTags, { tagPropertyName: 'hostedZoneTags' });
        this.name = props.name;
        this.queryLoggingConfig = props.queryLoggingConfig;
        this.vpcs = props.vpcs;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnHostedZonePropsFromCloudFormation(resourceProperties);
        const ret = new CfnHostedZone(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnHostedZone.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            hostedZoneConfig: this.hostedZoneConfig,
            hostedZoneTags: this.tags.renderTags(),
            name: this.name,
            queryLoggingConfig: this.queryLoggingConfig,
            vpcs: this.vpcs,
        };
    }
    renderProperties(props) {
        return cfnHostedZonePropsToCloudFormation(props);
    }
}
exports.CfnHostedZone = CfnHostedZone;
_d = JSII_RTTI_SYMBOL_1;
CfnHostedZone[_d] = { fqn: "@aws-cdk/aws-route53.CfnHostedZone", version: "1.174.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnHostedZone.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HostedZone";
/**
 * Determine whether the given properties match those of a `HostedZoneConfigProperty`
 *
 * @param properties - the TypeScript properties of a `HostedZoneConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnHostedZone_HostedZoneConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comment', cdk.validateString)(properties.comment));
    return errors.wrap('supplied properties not correct for "HostedZoneConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone.HostedZoneConfig` resource
 *
 * @param properties - the TypeScript properties of a `HostedZoneConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone.HostedZoneConfig` resource.
 */
// @ts-ignore TS6133
function cfnHostedZoneHostedZoneConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZone_HostedZoneConfigPropertyValidator(properties).assertSuccess();
    return {
        Comment: cdk.stringToCloudFormation(properties.comment),
    };
}
// @ts-ignore TS6133
function CfnHostedZoneHostedZoneConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comment', 'Comment', properties.Comment != null ? cfn_parse.FromCloudFormation.getString(properties.Comment) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HostedZoneTagProperty`
 *
 * @param properties - the TypeScript properties of a `HostedZoneTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnHostedZone_HostedZoneTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "HostedZoneTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone.HostedZoneTag` resource
 *
 * @param properties - the TypeScript properties of a `HostedZoneTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone.HostedZoneTag` resource.
 */
// @ts-ignore TS6133
function cfnHostedZoneHostedZoneTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZone_HostedZoneTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnHostedZoneHostedZoneTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `QueryLoggingConfigProperty`
 *
 * @param properties - the TypeScript properties of a `QueryLoggingConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnHostedZone_QueryLoggingConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogsLogGroupArn', cdk.requiredValidator)(properties.cloudWatchLogsLogGroupArn));
    errors.collect(cdk.propertyValidator('cloudWatchLogsLogGroupArn', cdk.validateString)(properties.cloudWatchLogsLogGroupArn));
    return errors.wrap('supplied properties not correct for "QueryLoggingConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone.QueryLoggingConfig` resource
 *
 * @param properties - the TypeScript properties of a `QueryLoggingConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone.QueryLoggingConfig` resource.
 */
// @ts-ignore TS6133
function cfnHostedZoneQueryLoggingConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZone_QueryLoggingConfigPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchLogsLogGroupArn: cdk.stringToCloudFormation(properties.cloudWatchLogsLogGroupArn),
    };
}
// @ts-ignore TS6133
function CfnHostedZoneQueryLoggingConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cloudWatchLogsLogGroupArn', 'CloudWatchLogsLogGroupArn', cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogsLogGroupArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VPCProperty`
 *
 * @param properties - the TypeScript properties of a `VPCProperty`
 *
 * @returns the result of the validation.
 */
function CfnHostedZone_VPCPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('vpcId', cdk.requiredValidator)(properties.vpcId));
    errors.collect(cdk.propertyValidator('vpcId', cdk.validateString)(properties.vpcId));
    errors.collect(cdk.propertyValidator('vpcRegion', cdk.requiredValidator)(properties.vpcRegion));
    errors.collect(cdk.propertyValidator('vpcRegion', cdk.validateString)(properties.vpcRegion));
    return errors.wrap('supplied properties not correct for "VPCProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::HostedZone.VPC` resource
 *
 * @param properties - the TypeScript properties of a `VPCProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::HostedZone.VPC` resource.
 */
// @ts-ignore TS6133
function cfnHostedZoneVPCPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnHostedZone_VPCPropertyValidator(properties).assertSuccess();
    return {
        VPCId: cdk.stringToCloudFormation(properties.vpcId),
        VPCRegion: cdk.stringToCloudFormation(properties.vpcRegion),
    };
}
// @ts-ignore TS6133
function CfnHostedZoneVPCPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('vpcId', 'VPCId', cfn_parse.FromCloudFormation.getString(properties.VPCId));
    ret.addPropertyResult('vpcRegion', 'VPCRegion', cfn_parse.FromCloudFormation.getString(properties.VPCRegion));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnKeySigningKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnKeySigningKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnKeySigningKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.requiredValidator)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('keyManagementServiceArn', cdk.requiredValidator)(properties.keyManagementServiceArn));
    errors.collect(cdk.propertyValidator('keyManagementServiceArn', cdk.validateString)(properties.keyManagementServiceArn));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('status', cdk.requiredValidator)(properties.status));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    return errors.wrap('supplied properties not correct for "CfnKeySigningKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::KeySigningKey` resource
 *
 * @param properties - the TypeScript properties of a `CfnKeySigningKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::KeySigningKey` resource.
 */
// @ts-ignore TS6133
function cfnKeySigningKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnKeySigningKeyPropsValidator(properties).assertSuccess();
    return {
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        KeyManagementServiceArn: cdk.stringToCloudFormation(properties.keyManagementServiceArn),
        Name: cdk.stringToCloudFormation(properties.name),
        Status: cdk.stringToCloudFormation(properties.status),
    };
}
// @ts-ignore TS6133
function CfnKeySigningKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', cfn_parse.FromCloudFormation.getString(properties.HostedZoneId));
    ret.addPropertyResult('keyManagementServiceArn', 'KeyManagementServiceArn', cfn_parse.FromCloudFormation.getString(properties.KeyManagementServiceArn));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('status', 'Status', cfn_parse.FromCloudFormation.getString(properties.Status));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::KeySigningKey`
 *
 * The `AWS::Route53::KeySigningKey` resource creates a new key-signing key (KSK) in a hosted zone. The hosted zone ID is passed as a parameter in the KSK properties. You can specify the properties of this KSK using the `Name` , `Status` , and `KeyManagementServiceArn` properties of the resource.
 *
 * @cloudformationResource AWS::Route53::KeySigningKey
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html
 */
class CfnKeySigningKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::Route53::KeySigningKey`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnKeySigningKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CfnKeySigningKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnKeySigningKey);
            }
            throw error;
        }
        cdk.requireProperty(props, 'hostedZoneId', this);
        cdk.requireProperty(props, 'keyManagementServiceArn', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'status', this);
        this.hostedZoneId = props.hostedZoneId;
        this.keyManagementServiceArn = props.keyManagementServiceArn;
        this.name = props.name;
        this.status = props.status;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnKeySigningKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnKeySigningKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnKeySigningKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            hostedZoneId: this.hostedZoneId,
            keyManagementServiceArn: this.keyManagementServiceArn,
            name: this.name,
            status: this.status,
        };
    }
    renderProperties(props) {
        return cfnKeySigningKeyPropsToCloudFormation(props);
    }
}
exports.CfnKeySigningKey = CfnKeySigningKey;
_e = JSII_RTTI_SYMBOL_1;
CfnKeySigningKey[_e] = { fqn: "@aws-cdk/aws-route53.CfnKeySigningKey", version: "1.174.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnKeySigningKey.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::KeySigningKey";
/**
 * Determine whether the given properties match those of a `CfnRecordSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnRecordSetProps`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasTarget', CfnRecordSet_AliasTargetPropertyValidator)(properties.aliasTarget));
    errors.collect(cdk.propertyValidator('cidrRoutingConfig', CfnRecordSet_CidrRoutingConfigPropertyValidator)(properties.cidrRoutingConfig));
    errors.collect(cdk.propertyValidator('comment', cdk.validateString)(properties.comment));
    errors.collect(cdk.propertyValidator('failover', cdk.validateString)(properties.failover));
    errors.collect(cdk.propertyValidator('geoLocation', CfnRecordSet_GeoLocationPropertyValidator)(properties.geoLocation));
    errors.collect(cdk.propertyValidator('healthCheckId', cdk.validateString)(properties.healthCheckId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneName', cdk.validateString)(properties.hostedZoneName));
    errors.collect(cdk.propertyValidator('multiValueAnswer', cdk.validateBoolean)(properties.multiValueAnswer));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    errors.collect(cdk.propertyValidator('resourceRecords', cdk.listValidator(cdk.validateString))(properties.resourceRecords));
    errors.collect(cdk.propertyValidator('setIdentifier', cdk.validateString)(properties.setIdentifier));
    errors.collect(cdk.propertyValidator('ttl', cdk.validateString)(properties.ttl));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('weight', cdk.validateNumber)(properties.weight));
    return errors.wrap('supplied properties not correct for "CfnRecordSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnRecordSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSet` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Type: cdk.stringToCloudFormation(properties.type),
        AliasTarget: cfnRecordSetAliasTargetPropertyToCloudFormation(properties.aliasTarget),
        CidrRoutingConfig: cfnRecordSetCidrRoutingConfigPropertyToCloudFormation(properties.cidrRoutingConfig),
        Comment: cdk.stringToCloudFormation(properties.comment),
        Failover: cdk.stringToCloudFormation(properties.failover),
        GeoLocation: cfnRecordSetGeoLocationPropertyToCloudFormation(properties.geoLocation),
        HealthCheckId: cdk.stringToCloudFormation(properties.healthCheckId),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        HostedZoneName: cdk.stringToCloudFormation(properties.hostedZoneName),
        MultiValueAnswer: cdk.booleanToCloudFormation(properties.multiValueAnswer),
        Region: cdk.stringToCloudFormation(properties.region),
        ResourceRecords: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceRecords),
        SetIdentifier: cdk.stringToCloudFormation(properties.setIdentifier),
        TTL: cdk.stringToCloudFormation(properties.ttl),
        Weight: cdk.numberToCloudFormation(properties.weight),
    };
}
// @ts-ignore TS6133
function CfnRecordSetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('aliasTarget', 'AliasTarget', properties.AliasTarget != null ? CfnRecordSetAliasTargetPropertyFromCloudFormation(properties.AliasTarget) : undefined);
    ret.addPropertyResult('cidrRoutingConfig', 'CidrRoutingConfig', properties.CidrRoutingConfig != null ? CfnRecordSetCidrRoutingConfigPropertyFromCloudFormation(properties.CidrRoutingConfig) : undefined);
    ret.addPropertyResult('comment', 'Comment', properties.Comment != null ? cfn_parse.FromCloudFormation.getString(properties.Comment) : undefined);
    ret.addPropertyResult('failover', 'Failover', properties.Failover != null ? cfn_parse.FromCloudFormation.getString(properties.Failover) : undefined);
    ret.addPropertyResult('geoLocation', 'GeoLocation', properties.GeoLocation != null ? CfnRecordSetGeoLocationPropertyFromCloudFormation(properties.GeoLocation) : undefined);
    ret.addPropertyResult('healthCheckId', 'HealthCheckId', properties.HealthCheckId != null ? cfn_parse.FromCloudFormation.getString(properties.HealthCheckId) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', properties.HostedZoneId != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneId) : undefined);
    ret.addPropertyResult('hostedZoneName', 'HostedZoneName', properties.HostedZoneName != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneName) : undefined);
    ret.addPropertyResult('multiValueAnswer', 'MultiValueAnswer', properties.MultiValueAnswer != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiValueAnswer) : undefined);
    ret.addPropertyResult('region', 'Region', properties.Region != null ? cfn_parse.FromCloudFormation.getString(properties.Region) : undefined);
    ret.addPropertyResult('resourceRecords', 'ResourceRecords', properties.ResourceRecords != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceRecords) : undefined);
    ret.addPropertyResult('setIdentifier', 'SetIdentifier', properties.SetIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SetIdentifier) : undefined);
    ret.addPropertyResult('ttl', 'TTL', properties.TTL != null ? cfn_parse.FromCloudFormation.getString(properties.TTL) : undefined);
    ret.addPropertyResult('weight', 'Weight', properties.Weight != null ? cfn_parse.FromCloudFormation.getNumber(properties.Weight) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`
 *
 * Information about the record that you want to create.
 *
 * The `AWS::Route53::RecordSet` type can be used as a standalone resource or as an embedded property in the `AWS::Route53::RecordSetGroup` type. Note that some `AWS::Route53::RecordSet` properties are valid only when used within `AWS::Route53::RecordSetGroup` .
 *
 * For more information, see [ChangeResourceRecordSets](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html) in the *Amazon Route 53 API Reference* .
 *
 * @cloudformationResource AWS::Route53::RecordSet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
class CfnRecordSet extends cdk.CfnResource {
    /**
     * Create a new `AWS::Route53::RecordSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRecordSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CfnRecordSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnRecordSet);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'type', this);
        this.name = props.name;
        this.type = props.type;
        this.aliasTarget = props.aliasTarget;
        this.cidrRoutingConfig = props.cidrRoutingConfig;
        this.comment = props.comment;
        this.failover = props.failover;
        this.geoLocation = props.geoLocation;
        this.healthCheckId = props.healthCheckId;
        this.hostedZoneId = props.hostedZoneId;
        this.hostedZoneName = props.hostedZoneName;
        this.multiValueAnswer = props.multiValueAnswer;
        this.region = props.region;
        this.resourceRecords = props.resourceRecords;
        this.setIdentifier = props.setIdentifier;
        this.ttl = props.ttl;
        this.weight = props.weight;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnRecordSetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnRecordSet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnRecordSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            type: this.type,
            aliasTarget: this.aliasTarget,
            cidrRoutingConfig: this.cidrRoutingConfig,
            comment: this.comment,
            failover: this.failover,
            geoLocation: this.geoLocation,
            healthCheckId: this.healthCheckId,
            hostedZoneId: this.hostedZoneId,
            hostedZoneName: this.hostedZoneName,
            multiValueAnswer: this.multiValueAnswer,
            region: this.region,
            resourceRecords: this.resourceRecords,
            setIdentifier: this.setIdentifier,
            ttl: this.ttl,
            weight: this.weight,
        };
    }
    renderProperties(props) {
        return cfnRecordSetPropsToCloudFormation(props);
    }
}
exports.CfnRecordSet = CfnRecordSet;
_f = JSII_RTTI_SYMBOL_1;
CfnRecordSet[_f] = { fqn: "@aws-cdk/aws-route53.CfnRecordSet", version: "1.174.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRecordSet.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSet";
/**
 * Determine whether the given properties match those of a `AliasTargetProperty`
 *
 * @param properties - the TypeScript properties of a `AliasTargetProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSet_AliasTargetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dnsName', cdk.requiredValidator)(properties.dnsName));
    errors.collect(cdk.propertyValidator('dnsName', cdk.validateString)(properties.dnsName));
    errors.collect(cdk.propertyValidator('evaluateTargetHealth', cdk.validateBoolean)(properties.evaluateTargetHealth));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.requiredValidator)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    return errors.wrap('supplied properties not correct for "AliasTargetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSet.AliasTarget` resource
 *
 * @param properties - the TypeScript properties of a `AliasTargetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSet.AliasTarget` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetAliasTargetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSet_AliasTargetPropertyValidator(properties).assertSuccess();
    return {
        DNSName: cdk.stringToCloudFormation(properties.dnsName),
        EvaluateTargetHealth: cdk.booleanToCloudFormation(properties.evaluateTargetHealth),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
    };
}
// @ts-ignore TS6133
function CfnRecordSetAliasTargetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dnsName', 'DNSName', cfn_parse.FromCloudFormation.getString(properties.DNSName));
    ret.addPropertyResult('evaluateTargetHealth', 'EvaluateTargetHealth', properties.EvaluateTargetHealth != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EvaluateTargetHealth) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', cfn_parse.FromCloudFormation.getString(properties.HostedZoneId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CidrRoutingConfigProperty`
 *
 * @param properties - the TypeScript properties of a `CidrRoutingConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSet_CidrRoutingConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('collectionId', cdk.requiredValidator)(properties.collectionId));
    errors.collect(cdk.propertyValidator('collectionId', cdk.validateString)(properties.collectionId));
    errors.collect(cdk.propertyValidator('locationName', cdk.requiredValidator)(properties.locationName));
    errors.collect(cdk.propertyValidator('locationName', cdk.validateString)(properties.locationName));
    return errors.wrap('supplied properties not correct for "CidrRoutingConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSet.CidrRoutingConfig` resource
 *
 * @param properties - the TypeScript properties of a `CidrRoutingConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSet.CidrRoutingConfig` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetCidrRoutingConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSet_CidrRoutingConfigPropertyValidator(properties).assertSuccess();
    return {
        CollectionId: cdk.stringToCloudFormation(properties.collectionId),
        LocationName: cdk.stringToCloudFormation(properties.locationName),
    };
}
// @ts-ignore TS6133
function CfnRecordSetCidrRoutingConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('collectionId', 'CollectionId', cfn_parse.FromCloudFormation.getString(properties.CollectionId));
    ret.addPropertyResult('locationName', 'LocationName', cfn_parse.FromCloudFormation.getString(properties.LocationName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeoLocationProperty`
 *
 * @param properties - the TypeScript properties of a `GeoLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSet_GeoLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('continentCode', cdk.validateString)(properties.continentCode));
    errors.collect(cdk.propertyValidator('countryCode', cdk.validateString)(properties.countryCode));
    errors.collect(cdk.propertyValidator('subdivisionCode', cdk.validateString)(properties.subdivisionCode));
    return errors.wrap('supplied properties not correct for "GeoLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSet.GeoLocation` resource
 *
 * @param properties - the TypeScript properties of a `GeoLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSet.GeoLocation` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGeoLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSet_GeoLocationPropertyValidator(properties).assertSuccess();
    return {
        ContinentCode: cdk.stringToCloudFormation(properties.continentCode),
        CountryCode: cdk.stringToCloudFormation(properties.countryCode),
        SubdivisionCode: cdk.stringToCloudFormation(properties.subdivisionCode),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGeoLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('continentCode', 'ContinentCode', properties.ContinentCode != null ? cfn_parse.FromCloudFormation.getString(properties.ContinentCode) : undefined);
    ret.addPropertyResult('countryCode', 'CountryCode', properties.CountryCode != null ? cfn_parse.FromCloudFormation.getString(properties.CountryCode) : undefined);
    ret.addPropertyResult('subdivisionCode', 'SubdivisionCode', properties.SubdivisionCode != null ? cfn_parse.FromCloudFormation.getString(properties.SubdivisionCode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnRecordSetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnRecordSetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comment', cdk.validateString)(properties.comment));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneName', cdk.validateString)(properties.hostedZoneName));
    errors.collect(cdk.propertyValidator('recordSets', cdk.listValidator(CfnRecordSetGroup_RecordSetPropertyValidator))(properties.recordSets));
    return errors.wrap('supplied properties not correct for "CfnRecordSetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnRecordSetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroupPropsValidator(properties).assertSuccess();
    return {
        Comment: cdk.stringToCloudFormation(properties.comment),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        HostedZoneName: cdk.stringToCloudFormation(properties.hostedZoneName),
        RecordSets: cdk.listMapper(cfnRecordSetGroupRecordSetPropertyToCloudFormation)(properties.recordSets),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comment', 'Comment', properties.Comment != null ? cfn_parse.FromCloudFormation.getString(properties.Comment) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', properties.HostedZoneId != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneId) : undefined);
    ret.addPropertyResult('hostedZoneName', 'HostedZoneName', properties.HostedZoneName != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneName) : undefined);
    ret.addPropertyResult('recordSets', 'RecordSets', properties.RecordSets != null ? cfn_parse.FromCloudFormation.getArray(CfnRecordSetGroupRecordSetPropertyFromCloudFormation)(properties.RecordSets) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`
 *
 * A complex type that contains an optional comment, the name and ID of the hosted zone that you want to make changes in, and values for the records that you want to create.
 *
 * @cloudformationResource AWS::Route53::RecordSetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
class CfnRecordSetGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::Route53::RecordSetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnRecordSetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53_CfnRecordSetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnRecordSetGroup);
            }
            throw error;
        }
        this.comment = props.comment;
        this.hostedZoneId = props.hostedZoneId;
        this.hostedZoneName = props.hostedZoneName;
        this.recordSets = props.recordSets;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnRecordSetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnRecordSetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnRecordSetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            comment: this.comment,
            hostedZoneId: this.hostedZoneId,
            hostedZoneName: this.hostedZoneName,
            recordSets: this.recordSets,
        };
    }
    renderProperties(props) {
        return cfnRecordSetGroupPropsToCloudFormation(props);
    }
}
exports.CfnRecordSetGroup = CfnRecordSetGroup;
_g = JSII_RTTI_SYMBOL_1;
CfnRecordSetGroup[_g] = { fqn: "@aws-cdk/aws-route53.CfnRecordSetGroup", version: "1.174.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRecordSetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSetGroup";
/**
 * Determine whether the given properties match those of a `AliasTargetProperty`
 *
 * @param properties - the TypeScript properties of a `AliasTargetProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroup_AliasTargetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dnsName', cdk.requiredValidator)(properties.dnsName));
    errors.collect(cdk.propertyValidator('dnsName', cdk.validateString)(properties.dnsName));
    errors.collect(cdk.propertyValidator('evaluateTargetHealth', cdk.validateBoolean)(properties.evaluateTargetHealth));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.requiredValidator)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    return errors.wrap('supplied properties not correct for "AliasTargetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.AliasTarget` resource
 *
 * @param properties - the TypeScript properties of a `AliasTargetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.AliasTarget` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupAliasTargetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroup_AliasTargetPropertyValidator(properties).assertSuccess();
    return {
        DNSName: cdk.stringToCloudFormation(properties.dnsName),
        EvaluateTargetHealth: cdk.booleanToCloudFormation(properties.evaluateTargetHealth),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupAliasTargetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dnsName', 'DNSName', cfn_parse.FromCloudFormation.getString(properties.DNSName));
    ret.addPropertyResult('evaluateTargetHealth', 'EvaluateTargetHealth', properties.EvaluateTargetHealth != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EvaluateTargetHealth) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', cfn_parse.FromCloudFormation.getString(properties.HostedZoneId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CidrRoutingConfigProperty`
 *
 * @param properties - the TypeScript properties of a `CidrRoutingConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroup_CidrRoutingConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('collectionId', cdk.requiredValidator)(properties.collectionId));
    errors.collect(cdk.propertyValidator('collectionId', cdk.validateString)(properties.collectionId));
    errors.collect(cdk.propertyValidator('locationName', cdk.requiredValidator)(properties.locationName));
    errors.collect(cdk.propertyValidator('locationName', cdk.validateString)(properties.locationName));
    return errors.wrap('supplied properties not correct for "CidrRoutingConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.CidrRoutingConfig` resource
 *
 * @param properties - the TypeScript properties of a `CidrRoutingConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.CidrRoutingConfig` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupCidrRoutingConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroup_CidrRoutingConfigPropertyValidator(properties).assertSuccess();
    return {
        CollectionId: cdk.stringToCloudFormation(properties.collectionId),
        LocationName: cdk.stringToCloudFormation(properties.locationName),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupCidrRoutingConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('collectionId', 'CollectionId', cfn_parse.FromCloudFormation.getString(properties.CollectionId));
    ret.addPropertyResult('locationName', 'LocationName', cfn_parse.FromCloudFormation.getString(properties.LocationName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GeoLocationProperty`
 *
 * @param properties - the TypeScript properties of a `GeoLocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroup_GeoLocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('continentCode', cdk.validateString)(properties.continentCode));
    errors.collect(cdk.propertyValidator('countryCode', cdk.validateString)(properties.countryCode));
    errors.collect(cdk.propertyValidator('subdivisionCode', cdk.validateString)(properties.subdivisionCode));
    return errors.wrap('supplied properties not correct for "GeoLocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.GeoLocation` resource
 *
 * @param properties - the TypeScript properties of a `GeoLocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.GeoLocation` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupGeoLocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroup_GeoLocationPropertyValidator(properties).assertSuccess();
    return {
        ContinentCode: cdk.stringToCloudFormation(properties.continentCode),
        CountryCode: cdk.stringToCloudFormation(properties.countryCode),
        SubdivisionCode: cdk.stringToCloudFormation(properties.subdivisionCode),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupGeoLocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('continentCode', 'ContinentCode', properties.ContinentCode != null ? cfn_parse.FromCloudFormation.getString(properties.ContinentCode) : undefined);
    ret.addPropertyResult('countryCode', 'CountryCode', properties.CountryCode != null ? cfn_parse.FromCloudFormation.getString(properties.CountryCode) : undefined);
    ret.addPropertyResult('subdivisionCode', 'SubdivisionCode', properties.SubdivisionCode != null ? cfn_parse.FromCloudFormation.getString(properties.SubdivisionCode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RecordSetProperty`
 *
 * @param properties - the TypeScript properties of a `RecordSetProperty`
 *
 * @returns the result of the validation.
 */
function CfnRecordSetGroup_RecordSetPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasTarget', CfnRecordSetGroup_AliasTargetPropertyValidator)(properties.aliasTarget));
    errors.collect(cdk.propertyValidator('cidrRoutingConfig', CfnRecordSetGroup_CidrRoutingConfigPropertyValidator)(properties.cidrRoutingConfig));
    errors.collect(cdk.propertyValidator('failover', cdk.validateString)(properties.failover));
    errors.collect(cdk.propertyValidator('geoLocation', CfnRecordSetGroup_GeoLocationPropertyValidator)(properties.geoLocation));
    errors.collect(cdk.propertyValidator('healthCheckId', cdk.validateString)(properties.healthCheckId));
    errors.collect(cdk.propertyValidator('hostedZoneId', cdk.validateString)(properties.hostedZoneId));
    errors.collect(cdk.propertyValidator('hostedZoneName', cdk.validateString)(properties.hostedZoneName));
    errors.collect(cdk.propertyValidator('multiValueAnswer', cdk.validateBoolean)(properties.multiValueAnswer));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    errors.collect(cdk.propertyValidator('resourceRecords', cdk.listValidator(cdk.validateString))(properties.resourceRecords));
    errors.collect(cdk.propertyValidator('setIdentifier', cdk.validateString)(properties.setIdentifier));
    errors.collect(cdk.propertyValidator('ttl', cdk.validateString)(properties.ttl));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('weight', cdk.validateNumber)(properties.weight));
    return errors.wrap('supplied properties not correct for "RecordSetProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.RecordSet` resource
 *
 * @param properties - the TypeScript properties of a `RecordSetProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Route53::RecordSetGroup.RecordSet` resource.
 */
// @ts-ignore TS6133
function cfnRecordSetGroupRecordSetPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRecordSetGroup_RecordSetPropertyValidator(properties).assertSuccess();
    return {
        AliasTarget: cfnRecordSetGroupAliasTargetPropertyToCloudFormation(properties.aliasTarget),
        CidrRoutingConfig: cfnRecordSetGroupCidrRoutingConfigPropertyToCloudFormation(properties.cidrRoutingConfig),
        Failover: cdk.stringToCloudFormation(properties.failover),
        GeoLocation: cfnRecordSetGroupGeoLocationPropertyToCloudFormation(properties.geoLocation),
        HealthCheckId: cdk.stringToCloudFormation(properties.healthCheckId),
        HostedZoneId: cdk.stringToCloudFormation(properties.hostedZoneId),
        HostedZoneName: cdk.stringToCloudFormation(properties.hostedZoneName),
        MultiValueAnswer: cdk.booleanToCloudFormation(properties.multiValueAnswer),
        Name: cdk.stringToCloudFormation(properties.name),
        Region: cdk.stringToCloudFormation(properties.region),
        ResourceRecords: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceRecords),
        SetIdentifier: cdk.stringToCloudFormation(properties.setIdentifier),
        TTL: cdk.stringToCloudFormation(properties.ttl),
        Type: cdk.stringToCloudFormation(properties.type),
        Weight: cdk.numberToCloudFormation(properties.weight),
    };
}
// @ts-ignore TS6133
function CfnRecordSetGroupRecordSetPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aliasTarget', 'AliasTarget', properties.AliasTarget != null ? CfnRecordSetGroupAliasTargetPropertyFromCloudFormation(properties.AliasTarget) : undefined);
    ret.addPropertyResult('cidrRoutingConfig', 'CidrRoutingConfig', properties.CidrRoutingConfig != null ? CfnRecordSetGroupCidrRoutingConfigPropertyFromCloudFormation(properties.CidrRoutingConfig) : undefined);
    ret.addPropertyResult('failover', 'Failover', properties.Failover != null ? cfn_parse.FromCloudFormation.getString(properties.Failover) : undefined);
    ret.addPropertyResult('geoLocation', 'GeoLocation', properties.GeoLocation != null ? CfnRecordSetGroupGeoLocationPropertyFromCloudFormation(properties.GeoLocation) : undefined);
    ret.addPropertyResult('healthCheckId', 'HealthCheckId', properties.HealthCheckId != null ? cfn_parse.FromCloudFormation.getString(properties.HealthCheckId) : undefined);
    ret.addPropertyResult('hostedZoneId', 'HostedZoneId', properties.HostedZoneId != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneId) : undefined);
    ret.addPropertyResult('hostedZoneName', 'HostedZoneName', properties.HostedZoneName != null ? cfn_parse.FromCloudFormation.getString(properties.HostedZoneName) : undefined);
    ret.addPropertyResult('multiValueAnswer', 'MultiValueAnswer', properties.MultiValueAnswer != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiValueAnswer) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('region', 'Region', properties.Region != null ? cfn_parse.FromCloudFormation.getString(properties.Region) : undefined);
    ret.addPropertyResult('resourceRecords', 'ResourceRecords', properties.ResourceRecords != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceRecords) : undefined);
    ret.addPropertyResult('setIdentifier', 'SetIdentifier', properties.SetIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SetIdentifier) : undefined);
    ret.addPropertyResult('ttl', 'TTL', properties.TTL != null ? cfn_parse.FromCloudFormation.getString(properties.TTL) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('weight', 'Weight', properties.Weight != null ? cfn_parse.FromCloudFormation.getNumber(properties.Weight) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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