from typing import (
    Any,
    TypeVar,
)

_OpsMixinT = TypeVar("_OpsMixinT", bound=OpsMixin)

class OpsMixin:
    def __eq__(self: _OpsMixinT, other: object) -> _OpsMixinT: ...  # type: ignore[override]
    def __ne__(self: _OpsMixinT, other: object) -> _OpsMixinT: ...  # type: ignore[override]
    def __lt__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __le__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __gt__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __ge__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    # -------------------------------------------------------------
    # Logical Methods
    def __and__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __rand__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __or__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __ror__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __xor__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __rxor__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    # -------------------------------------------------------------
    # Arithmetic Methods
    def __add__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __radd__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __sub__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __rsub__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __mul__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __rmul__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __truediv__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __rtruediv__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __floordiv__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __rfloordiv__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __mod__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __rmod__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __divmod__(self: _OpsMixinT, other: Any) -> tuple[_OpsMixinT, _OpsMixinT]: ...
    def __rdivmod__(self: _OpsMixinT, other: Any) -> tuple[_OpsMixinT, _OpsMixinT]: ...
    def __pow__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
    def __rpow__(self: _OpsMixinT, other: Any) -> _OpsMixinT: ...
