import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IpblockConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#location Ipblock#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#name Ipblock#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#size Ipblock#size}
    */
    readonly size: number;
    /**
    * ip_consumers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#ip_consumers Ipblock#ip_consumers}
    */
    readonly ipConsumers?: IpblockIpConsumers[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#timeouts Ipblock#timeouts}
    */
    readonly timeouts?: IpblockTimeouts;
}
export interface IpblockIpConsumers {
}
export declare function ipblockIpConsumersToTerraform(struct?: IpblockIpConsumers | cdktf.IResolvable): any;
export interface IpblockTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#create Ipblock#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#default Ipblock#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#delete Ipblock#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock#update Ipblock#update}
    */
    readonly update?: string;
}
export declare function ipblockTimeoutsToTerraform(struct?: IpblockTimeoutsOutputReference | IpblockTimeouts | cdktf.IResolvable): any;
export declare class IpblockTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IpblockTimeouts | undefined;
    set internalValue(value: IpblockTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock ionoscloud_ipblock}
*/
export declare class Ipblock extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_ipblock";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/ipblock ionoscloud_ipblock} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IpblockConfig
    */
    constructor(scope: Construct, id: string, config: IpblockConfig);
    get id(): string;
    get ips(): string[];
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _ipConsumers?;
    get ipConsumers(): IpblockIpConsumers[] | cdktf.IResolvable;
    set ipConsumers(value: IpblockIpConsumers[] | cdktf.IResolvable);
    resetIpConsumers(): void;
    get ipConsumersInput(): cdktf.IResolvable | IpblockIpConsumers[] | undefined;
    private _timeouts;
    get timeouts(): IpblockTimeoutsOutputReference;
    putTimeouts(value: IpblockTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IpblockTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
