import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as kms from '@aws-cdk/aws-kms';
import * as s3 from '@aws-cdk/aws-s3';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import { Duration, IResource, RemovalPolicy, Resource, SecretValue } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { Endpoint } from './endpoint';
import { IClusterParameterGroup } from './parameter-group';
import { IClusterSubnetGroup } from './subnet-group';
/**
 * (experimental) Possible Node Types to use in the cluster used for defining {@link ClusterProps.nodeType}.
 *
 * @experimental
 */
export declare enum NodeType {
    /**
     * (experimental) ds2.xlarge.
     *
     * @experimental
     */
    DS2_XLARGE = "ds2.xlarge",
    /**
     * (experimental) ds2.8xlarge.
     *
     * @experimental
     */
    DS2_8XLARGE = "ds2.8xlarge",
    /**
     * (experimental) dc1.large.
     *
     * @experimental
     */
    DC1_LARGE = "dc1.large",
    /**
     * (experimental) dc1.8xlarge.
     *
     * @experimental
     */
    DC1_8XLARGE = "dc1.8xlarge",
    /**
     * (experimental) dc2.large.
     *
     * @experimental
     */
    DC2_LARGE = "dc2.large",
    /**
     * (experimental) dc2.8xlarge.
     *
     * @experimental
     */
    DC2_8XLARGE = "dc2.8xlarge",
    /**
     * (experimental) ra3.16xlarge.
     *
     * @experimental
     */
    RA3_16XLARGE = "ra3.16xlarge"
}
/**
 * (experimental) What cluster type to use.
 *
 * Used by {@link ClusterProps.clusterType}
 *
 * @experimental
 */
export declare enum ClusterType {
    /**
     * (experimental) single-node cluster, the {@link ClusterProps.numberOfNodes} parameter is not required.
     *
     * @experimental
     */
    SINGLE_NODE = "single-node",
    /**
     * (experimental) multi-node cluster, set the amount of nodes using {@link ClusterProps.numberOfNodes} parameter.
     *
     * @experimental
     */
    MULTI_NODE = "multi-node"
}
/**
 * (experimental) Username and password combination.
 *
 * @experimental
 */
export interface Login {
    /**
     * (experimental) Username.
     *
     * @experimental
     */
    readonly masterUsername: string;
    /**
     * (experimental) Password.
     *
     * Do not put passwords in your CDK code directly.
     *
     * @default a Secrets Manager generated password
     * @experimental
     */
    readonly masterPassword?: SecretValue;
    /**
     * (experimental) KMS encryption key to encrypt the generated secret.
     *
     * @default default master key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * (experimental) Options to add the multi user rotation.
 *
 * @experimental
 */
export interface RotationMultiUserOptions {
    /**
     * (experimental) The secret to rotate.
     *
     * It must be a JSON string with the following format:
     * ```
     * {
     *    "engine": <required: database engine>,
     *    "host": <required: instance host name>,
     *    "username": <required: username>,
     *    "password": <required: password>,
     *    "dbname": <optional: database name>,
     *    "port": <optional: if not specified, default port will be used>,
     *    "masterarn": <required: the arn of the master secret which will be used to create users/change passwords>
     * }
     * ```
     *
     * @experimental
     */
    readonly secret: secretsmanager.ISecret;
    /**
     * (experimental) Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     *
     * @default Duration.days(30)
     * @experimental
     */
    readonly automaticallyAfter?: Duration;
}
/**
 * (experimental) Create a Redshift Cluster with a given number of nodes.
 *
 * Implemented by {@link Cluster} via {@link ClusterBase}.
 *
 * @experimental
 */
export interface ICluster extends IResource, ec2.IConnectable, secretsmanager.ISecretAttachmentTarget {
    /**
     * (experimental) Name of the cluster.
     *
     * @experimental
     * @attribute ClusterName
     */
    readonly clusterName: string;
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     * @attribute EndpointAddress,EndpointPort
     */
    readonly clusterEndpoint: Endpoint;
}
/**
 * (experimental) Properties that describe an existing cluster instance.
 *
 * @experimental
 */
export interface ClusterAttributes {
    /**
     * (experimental) The security groups of the redshift cluster.
     *
     * @default no security groups will be attached to the import
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) Identifier for the cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) Cluster endpoint address.
     *
     * @experimental
     */
    readonly clusterEndpointAddress: string;
    /**
     * (experimental) Cluster endpoint port.
     *
     * @experimental
     */
    readonly clusterEndpointPort: number;
}
/**
 * (experimental) Properties for a new database cluster.
 *
 * @experimental
 */
export interface ClusterProps {
    /**
     * (experimental) An optional identifier for the cluster.
     *
     * @default - A name is automatically generated.
     * @experimental
     */
    readonly clusterName?: string;
    /**
     * (experimental) Additional parameters to pass to the database engine https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html.
     *
     * @default - No parameter group.
     * @experimental
     */
    readonly parameterGroup?: IClusterParameterGroup;
    /**
     * (experimental) Number of compute nodes in the cluster. Only specify this property for multi-node clusters.
     *
     * Value must be at least 2 and no more than 100.
     *
     * @default - 2 if `clusterType` is ClusterType.MULTI_NODE, undefined otherwise
     * @experimental
     */
    readonly numberOfNodes?: number;
    /**
     * (experimental) The node type to be provisioned for the cluster.
     *
     * @default {@link NodeType.DC2_LARGE}
     * @experimental
     */
    readonly nodeType?: NodeType;
    /**
     * (experimental) Settings for the individual instances that are launched.
     *
     * @default {@link ClusterType.MULTI_NODE}
     * @experimental
     */
    readonly clusterType?: ClusterType;
    /**
     * (experimental) What port to listen on.
     *
     * @default - The default for the engine is used.
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) Whether to enable encryption of data at rest in the cluster.
     *
     * @default true
     * @experimental
     */
    readonly encrypted?: boolean;
    /**
     * (experimental) The KMS key to use for encryption of data at rest.
     *
     * @default - AWS-managed key, if encryption at rest is enabled
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
     *
     * Example: 'Sun:23:45-Mon:00:15'
     *
     * @default - 30-minute window selected at random from an 8-hour block of time for
     * each AWS Region, occurring on a random day of the week.
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance
     * @experimental
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * (experimental) The VPC to place the cluster in.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Where to place the instances within the VPC.
     *
     * @default - private subnets
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) Security group.
     *
     * @default - a new security group is created.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) A cluster subnet group to use with this cluster.
     *
     * @default - a new subnet group will be created.
     * @experimental
     */
    readonly subnetGroup?: IClusterSubnetGroup;
    /**
     * (experimental) Username and password for the administrative user.
     *
     * @experimental
     */
    readonly masterUser: Login;
    /**
     * (experimental) A list of AWS Identity and Access Management (IAM) role that can be used by the cluster to access other AWS services.
     *
     * Specify a maximum of 10 roles.
     *
     * @default - No role is attached to the cluster.
     * @experimental
     */
    readonly roles?: iam.IRole[];
    /**
     * (experimental) Name of a database which is automatically created inside the cluster.
     *
     * @default - default_db
     * @experimental
     */
    readonly defaultDatabaseName?: string;
    /**
     * (experimental) Bucket to send logs to.
     *
     * Logging information includes queries and connection attempts, for the specified Amazon Redshift cluster.
     *
     * @default - No Logs
     * @experimental
     */
    readonly loggingBucket?: s3.IBucket;
    /**
     * (experimental) Prefix used for logging.
     *
     * @default - no prefix
     * @experimental
     */
    readonly loggingKeyPrefix?: string;
    /**
     * (experimental) The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
     *
     * @default RemovalPolicy.RETAIN
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * A new or imported clustered database.
 */
declare abstract class ClusterBase extends Resource implements ICluster {
    /**
     * Name of the cluster
     */
    abstract readonly clusterName: string;
    /**
     * The endpoint to use for read/write operations
     */
    abstract readonly clusterEndpoint: Endpoint;
    /**
     * Access to the network connections
     */
    abstract readonly connections: ec2.Connections;
    /**
     * (experimental) Renders the secret attachment target specifications.
     *
     * @experimental
     */
    asSecretAttachmentTarget(): secretsmanager.SecretAttachmentTargetProps;
}
/**
 * (experimental) Create a Redshift cluster a given number of nodes.
 *
 * @experimental
 * @resource AWS::Redshift::Cluster
 */
export declare class Cluster extends ClusterBase {
    /**
     * (experimental) Import an existing DatabaseCluster from properties.
     *
     * @experimental
     */
    static fromClusterAttributes(scope: Construct, id: string, attrs: ClusterAttributes): ICluster;
    /**
     * (experimental) Identifier of the cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     */
    readonly clusterEndpoint: Endpoint;
    /**
     * (experimental) Access to the network connections.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The secret attached to this cluster.
     *
     * @experimental
     */
    readonly secret?: secretsmanager.ISecret;
    private readonly singleUserRotationApplication;
    private readonly multiUserRotationApplication;
    /**
     * The VPC where the DB subnet group is created.
     */
    private readonly vpc;
    /**
     * The subnets used by the DB subnet group.
     */
    private readonly vpcSubnets?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClusterProps);
    /**
     * (experimental) Adds the single user rotation of the master password to this cluster.
     *
     * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     * @experimental
     */
    addRotationSingleUser(automaticallyAfter?: Duration): secretsmanager.SecretRotation;
    /**
     * (experimental) Adds the multi user rotation to this cluster.
     *
     * @experimental
     */
    addRotationMultiUser(id: string, options: RotationMultiUserOptions): secretsmanager.SecretRotation;
    private validateNodeCount;
}
export {};
