#  SPDX-License-Identifier: Apache-2.0
"""
Constants for users of this package.

For more details about this api, please refer to the documentation at
https://github.com/G-Two/subarulink
"""
from typing import Dict, Final, List

COUNTRY_USA = "USA"
COUNTRY_CAN = "CAN"

# Fields for users of this package (must stay consistent despite Subaru's changes)
# Home Assistant uses these names to establish unique_ids for entities
AVG_FUEL_CONSUMPTION = "AVG_FUEL_CONSUMPTION"
DIST_TO_EMPTY = "DISTANCE_TO_EMPTY_FUEL"
DOOR_BOOT_POSITION = "DOOR_BOOT_POSITION"
DOOR_ENGINE_HOOD_POSITION = "DOOR_ENGINE_HOOD_POSITION"
DOOR_FRONT_LEFT_POSITION = "DOOR_FRONT_LEFT_POSITION"
DOOR_FRONT_RIGHT_POSITION = "DOOR_FRONT_RIGHT_POSITION"
DOOR_REAR_LEFT_POSITION = "DOOR_REAR_LEFT_POSITION"
DOOR_REAR_RIGHT_POSITION = "DOOR_REAR_RIGHT_POSITION"
EV_CHARGER_STATE_TYPE = "EV_CHARGER_STATE_TYPE"
EV_DISTANCE_TO_EMPTY = "EV_DISTANCE_TO_EMPTY"
EV_IS_PLUGGED_IN = "EV_IS_PLUGGED_IN"
EV_STATE_OF_CHARGE_MODE = "EV_STATE_OF_CHARGE_MODE"
EV_STATE_OF_CHARGE_PERCENT = "EV_STATE_OF_CHARGE_PERCENT"
EV_TIME_TO_FULLY_CHARGED = "EV_TIME_TO_FULLY_CHARGED"
EV_TIME_TO_FULLY_CHARGED_UTC = "EV_TIME_TO_FULLY_CHARGED_UTC"
HEADING = "HEADING"
LAST_UPDATED_DATE = "LAST_UPDATED_DATE"
LATITUDE = "LATITUDE"
LONGITUDE = "LONGITUDE"
ODOMETER = "ODOMETER"
REMAINING_FUEL_PERCENT = "REMAINING_FUEL_PERCENT"
TIMESTAMP = "TIMESTAMP"
TIRE_PRESSURE_FL = "TYRE_PRESSURE_FRONT_LEFT"
TIRE_PRESSURE_FR = "TYRE_PRESSURE_FRONT_RIGHT"
TIRE_PRESSURE_RL = "TYRE_PRESSURE_REAR_LEFT"
TIRE_PRESSURE_RR = "TYRE_PRESSURE_REAR_RIGHT"
VEHICLE_STATE = "VEHICLE_STATE_TYPE"
WINDOW_FRONT_LEFT_STATUS = "WINDOW_FRONT_LEFT_STATUS"
WINDOW_FRONT_RIGHT_STATUS = "WINDOW_FRONT_RIGHT_STATUS"
WINDOW_REAR_LEFT_STATUS = "WINDOW_REAR_LEFT_STATUS"
WINDOW_REAR_RIGHT_STATUS = "WINDOW_REAR_RIGHT_STATUS"
WINDOW_SUNROOF_STATUS = "WINDOW_SUNROOF_STATUS"

# VEHICLE HEALTH STATUS
HEALTH_FEATURES = "FEATURES"
HEALTH_MIL_NAME = "MIL"
HEALTH_TROUBLE = "ISTROUBLE"
HEALTH_ONDATE = "ONDATE"
HEALTH_RECOMMENDED_TIRE_PRESSURE = "RECOMMENDED_TIRE_PRESSURE"
HEALTH_RECOMMENDED_TIRE_PRESSURE_FRONT = "FRONT_TIRES"
HEALTH_RECOMMENDED_TIRE_PRESSURE_REAR = "REAR_TIRES"

# EV_IS_PLUGGED_IN Values
CHARGING = "CHARGING"
LOCKED_CONNECTED = "LOCKED_CONNECTED"
UNLOCKED_CONNECTED = "UNLOCKED_CONNECTED"

# Door Values
DOOR_OPEN = "OPEN"
DOOR_CLOSED = "CLOSED"

# Window Values
WINDOW_OPEN = "OPEN"
WINDOW_VENTED = "VENTED"
WINDOW_CLOSED = "CLOSE"

# Moonroof Values
SUNROOF_OPEN = "OPEN"
SUNROOF_SLIDE_PARTLY_OPEN = "SLIDE_PARTLY_OPEN"
SUNROOF_TILT = "TILT"
SUNROOF_TILT_PARTLY_OPEN = "TILT_PARTLY_OPEN"
SUNROOF_CLOSED = "CLOSE"

# VEHICLE_STATE Values
IGNITION_ON = "IGNITION_ON"
IGNITION_OFF = "IGNITION_OFF"

NOT_EQUIPPED = "NOT_EQUIPPED"

# Remote start constants
TEMP_F = "climateZoneFrontTemp"
TEMP_F_MAX = 85
TEMP_F_MIN = 60

TEMP_C = "climateZoneFrontTempCelsius"
TEMP_C_MAX = 30
TEMP_C_MIN = 15

RUNTIME = "runTimeMinutes"
RUNTIME_10_MIN = "10"
RUNTIME_5_MIN = "5"

MODE = "climateZoneFrontAirMode"
MODE_DEFROST = "WINDOW"
MODE_FEET_DEFROST = "FEET_WINDOW"
MODE_FACE = "FACE"
MODE_FEET = "FEET"
MODE_SPLIT = "FEET_FACE_BALANCED"
MODE_AUTO = "AUTO"

HEAT_SEAT_LEFT = "heatedSeatFrontLeft"
HEAT_SEAT_RIGHT = "heatedSeatFrontRight"
HEAT_SEAT_HI = "HIGH_HEAT"
HEAT_SEAT_MED = "MEDIUM_HEAT"
HEAT_SEAT_LOW = "LOW_HEAT"
HEAT_SEAT_OFF = "OFF"

REAR_DEFROST = "heatedRearWindowActive"
REAR_DEFROST_ON = "true"
REAR_DEFROST_OFF = "false"

FAN_SPEED = "climateZoneFrontAirVolume"
FAN_SPEED_LOW = "2"
FAN_SPEED_MED = "4"
FAN_SPEED_HI = "7"
FAN_SPEED_AUTO = "AUTO"

RECIRCULATE = "outerAirCirculation"
RECIRCULATE_OFF = "outsideAir"
RECIRCULATE_ON = "recirculation"

REAR_AC = "airConditionOn"
REAR_AC_ON = "true"
REAR_AC_OFF = "false"

PRESET_NAME = "name"
PRESET_INDEX = "index"

CAN_EDIT = "canEdit"
CAN_EDIT_VALUE = "true"
DISABLED = "disabled"
DISABLED_VALUE = "false"
PRESET_TYPE = "presetType"
PRESET_TYPE_USER = "userPreset"
START_CONFIGURATION = "startConfiguration"
START_CONFIGURATION_EV = "START_CLIMATE_CONTROL_ONLY_ALLOW_KEY_IN_IGNITION"
START_CONFIGURATION_RES = "START_ENGINE_ALLOW_KEY_IN_IGNITION"

START_CONFIG_CONSTS_EV = {
    CAN_EDIT: CAN_EDIT_VALUE,
    DISABLED: DISABLED_VALUE,
    PRESET_TYPE: PRESET_TYPE_USER,
    START_CONFIGURATION: START_CONFIGURATION_EV,
}
START_CONFIG_CONSTS_RES = {
    CAN_EDIT: CAN_EDIT_VALUE,
    DISABLED: DISABLED_VALUE,
    PRESET_TYPE: PRESET_TYPE_USER,
    START_CONFIGURATION: START_CONFIGURATION_RES,
}

VALID_CLIMATE_OPTIONS: Dict[str, List] = {
    TEMP_C: [str(_) for _ in range(TEMP_C_MIN, TEMP_C_MAX + 1)],
    TEMP_F: [str(_) for _ in range(TEMP_F_MIN, TEMP_F_MAX + 1)],
    FAN_SPEED: [FAN_SPEED_AUTO, FAN_SPEED_LOW, FAN_SPEED_MED, FAN_SPEED_HI],
    HEAT_SEAT_LEFT: [HEAT_SEAT_OFF, HEAT_SEAT_LOW, HEAT_SEAT_MED, HEAT_SEAT_HI],
    HEAT_SEAT_RIGHT: [HEAT_SEAT_OFF, HEAT_SEAT_LOW, HEAT_SEAT_MED, HEAT_SEAT_HI],
    MODE: [
        MODE_DEFROST,
        MODE_FEET_DEFROST,
        MODE_FACE,
        MODE_FEET,
        MODE_SPLIT,
        MODE_AUTO,
    ],
    RECIRCULATE: [RECIRCULATE_OFF, RECIRCULATE_ON],
    REAR_AC: [REAR_AC_OFF, REAR_AC_ON],
    REAR_DEFROST: [REAR_DEFROST_OFF, REAR_DEFROST_ON],
    RUNTIME: [RUNTIME_10_MIN, RUNTIME_5_MIN],
    PRESET_NAME: [None],
    CAN_EDIT: [CAN_EDIT_VALUE],
    DISABLED: [DISABLED_VALUE],
    PRESET_TYPE: [PRESET_TYPE_USER],
    START_CONFIGURATION: [START_CONFIGURATION_EV, START_CONFIGURATION_RES],
    PRESET_INDEX: [0, 1, 2, 3],
}

# Unlock doors constants
WHICH_DOOR = "unlockDoorType"
ALL_DOORS = "ALL_DOORS_CMD"
DRIVERS_DOOR = "FRONT_LEFT_DOOR_CMD"
TAILGATE_DOOR = "TAILGATE_DOOR_CMD"
VALID_DOORS = [ALL_DOORS, DRIVERS_DOOR, TAILGATE_DOOR]


# Erroneous Values
BAD_AVG_FUEL_CONSUMPTION = "16383"
BAD_DISTANCE_TO_EMPTY_FUEL = "16383"
BAD_EV_TIME_TO_FULLY_CHARGED = "65535"
BAD_TIRE_PRESSURE = "32767"
BAD_LONGITUDE = 180
BAD_LATITUDE = 90
BAD_ODOMETER = None
BAD_SENSOR_VALUES = [
    BAD_AVG_FUEL_CONSUMPTION,
    BAD_DISTANCE_TO_EMPTY_FUEL,
    BAD_EV_TIME_TO_FULLY_CHARGED,
    BAD_TIRE_PRESSURE,
    BAD_ODOMETER,
]
UNKNOWN = "UNKNOWN"
BAD_BINARY_SENSOR_VALUES = [UNKNOWN, NOT_EQUIPPED]

LOCATION_VALID = "LOCATION_VALID"

FEATURE_G1_TELEMATICS = "g1"
FEATURE_G2_TELEMATICS = "g2"
FEATURE_G3_TELEMATICS = "g3"

POLL_INTERVAL = 7200
FETCH_INTERVAL = 300

VEHICLE_INFO: Final = "vehicle_info"
VEHICLE_STATUS: Final = "vehicle_status"
VEHICLE_HEALTH: Final = "vehicle_health"
VEHICLE_MODEL_YEAR: Final = "model_year"
VEHICLE_MODEL_NAME: Final = "model_name"
VEHICLE_NAME: Final = "vehicle_name"
VEHICLE_FEATURES: Final = "vehicle_features"
VEHICLE_SUBSCRIPTION_FEATURES: Final = "subscription_features"
VEHICLE_SUBSCRIPTION_STATUS: Final = "subscription_status"
VEHICLE_CLIMATE: Final = "climate"
VEHICLE_LAST_FETCH: Final = "last_fetch"
VEHICLE_LAST_UPDATE: Final = "last_update"


# List of potentially sensitive or identifying data fields to redact from raw API data when using HA diagnostic feature
RAW_API_FIELDS_TO_REDACT = [
    "cachedStateCode",
    "customer",
    "email",
    "firstName",
    "lastName",
    "latitude",
    "licensePlate",
    "licensePlateState",
    "longitude",
    "nickname",
    "odometer",
    "odometerValue",
    "odometerValueKilometers",
    "oemCustId",
    "phone",
    "preferredDealer",
    "sessionCustomer",
    "timeZone",
    "userOemCustId",
    "vehicleGeoPosition",
    "vehicleKey",
    "vehicleMileage",
    "vehicleName",
    "vhsId",
    "vin",
    "zip",
]
