"""
This file is automatically generated by Flask-Batteries. 

Modifying the contents of this file may result in Flask-Batteries producing unexpected results.
"""
from flask import Flask
from .config import ProductionConfig
from .routes import register_routes
from .helpers import webpack_init
import subprocess
import requests
from .helpers import static_url_for

# --flask_batteries_mark import_packages--

# --flask_batteries_mark init_extensions--

# Create app
def create_app(config=ProductionConfig):
    app = Flask(__name__)

    with app.app_context():
        # Load app config
        app.config.from_object(config)

        # Register routes
        register_routes(app)

        # --flask_batteries_mark attach_extensions--

        # Initialize webpack helpers
        if app.config["ENV"] == "development":
            webpack_init(app)

        @app.shell_context_processor
        def inject_variables_into_shell_context():
            return {}

        @app.context_processor
        def inject_global_template_variables():
            return {
                "application_name": "{{name}}",
                "app": app,
                "static_url_for": static_url_for,
            }

    return app
