# -*- coding: utf-8 -*-


class StdoutColors(object):

    """格式：\033[显示方式;前景色;背景色m
    说明：
    前景色            背景色           颜色
    ---------------------------------------
    30                40              黑色
    31                41              红色
    32                42              绿色
    33                43              黃色
    34                44              蓝色
    35                45              紫红色
    36                46              青蓝色
    37                47              白色

    显示方式           意义
    -------------------------
    0                终端默认设置
    1                高亮显示
    4                使用下划线
    5                闪烁
    7                反白显示
    8                不可见

    例子：
    \033[1;31;40m    <!--1-高亮显示 31-前景色红色  40-背景色黑色-->
    \033[0m          <!--采用终端默认设置，即取消颜色设置-->
    """

    HEADER = '\033[95m'   # 浅淡紫红
    OKBLUE = '\033[94m'   # 浅淡蓝
    OKGREEN = '\033[92m'  # 浅淡绿
    WARNING = '\033[93m'  # 浅淡黄
    FAIL = '\033[91m'  # 浅淡红
    ENDC = '\033[0m'
