# Generated by Django 2.2.16 on 2020-09-30 12:56

import django.db.models.deletion
from django.db import migrations, models

import django_video_encoder.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Thumbnail",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveIntegerField()),
                ("time", models.PositiveIntegerField(verbose_name="Time (s)")),
                ("width", models.PositiveIntegerField(null=True, verbose_name="Width")),
                (
                    "height",
                    models.PositiveIntegerField(null=True, verbose_name="Height"),
                ),
                (
                    "image",
                    models.ImageField(
                        blank=True,
                        max_length=512,
                        null=True,
                        upload_to=django_video_encoder.models.thumbnail_upload_to,
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.ContentType",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Format",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveIntegerField()),
                ("field_name", models.CharField(max_length=255)),
                (
                    "format",
                    models.CharField(choices=[("H.264", "H.264")], max_length=255),
                ),
                (
                    "file",
                    models.FileField(
                        max_length=2048,
                        upload_to=django_video_encoder.models.format_upload_to,
                    ),
                ),
                ("width", models.PositiveIntegerField(null=True, verbose_name="Width")),
                (
                    "height",
                    models.PositiveIntegerField(null=True, verbose_name="Height"),
                ),
                (
                    "duration",
                    models.PositiveIntegerField(
                        null=True, verbose_name="Duration (ms)"
                    ),
                ),
                (
                    "extra_info",
                    models.TextField(
                        blank=True, verbose_name="Encoder information (JSON)"
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.ContentType",
                    ),
                ),
            ],
        ),
    ]
