# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class GetServerResult:
    """
    A collection of values returned by getServer.
    """
    def __init__(__self__, audiences=None, credentials_last_rotated=None, credentials_next_rotation=None, credentials_rotation_mode=None, description=None, id=None, kid=None, name=None, status=None):
        if audiences and not isinstance(audiences, list):
            raise TypeError("Expected argument 'audiences' to be a list")
        __self__.audiences = audiences
        """
        array of audiences,
        """
        if credentials_last_rotated and not isinstance(credentials_last_rotated, str):
            raise TypeError("Expected argument 'credentials_last_rotated' to be a str")
        __self__.credentials_last_rotated = credentials_last_rotated
        """
        last time credentials were rotated.
        """
        if credentials_next_rotation and not isinstance(credentials_next_rotation, str):
            raise TypeError("Expected argument 'credentials_next_rotation' to be a str")
        __self__.credentials_next_rotation = credentials_next_rotation
        """
        next time credentials will be rotated
        """
        if credentials_rotation_mode and not isinstance(credentials_rotation_mode, str):
            raise TypeError("Expected argument 'credentials_rotation_mode' to be a str")
        __self__.credentials_rotation_mode = credentials_rotation_mode
        """
        mode of credential rotation, auto or manual.
        """
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        __self__.description = description
        """
        description of Authorization server.
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if kid and not isinstance(kid, str):
            raise TypeError("Expected argument 'kid' to be a str")
        __self__.kid = kid
        """
        auth server key id.
        """
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        """
        The name of the auth server.
        """
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        __self__.status = status
        """
        the activation status of the authorization server.
        """
class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            audiences=self.audiences,
            credentials_last_rotated=self.credentials_last_rotated,
            credentials_next_rotation=self.credentials_next_rotation,
            credentials_rotation_mode=self.credentials_rotation_mode,
            description=self.description,
            id=self.id,
            kid=self.kid,
            name=self.name,
            status=self.status)

def get_server(name=None,opts=None):
    """
    Use this data source to retrieve an auth server from Okta.

    ## Example Usage



    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.auth.get_server(name="Example Auth")
    ```



    :param str name: The name of the auth server to retrieve.
    """
    __args__ = dict()


    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:auth/getServer:getServer', __args__, opts=opts).value

    return AwaitableGetServerResult(
        audiences=__ret__.get('audiences'),
        credentials_last_rotated=__ret__.get('credentialsLastRotated'),
        credentials_next_rotation=__ret__.get('credentialsNextRotation'),
        credentials_rotation_mode=__ret__.get('credentialsRotationMode'),
        description=__ret__.get('description'),
        id=__ret__.get('id'),
        kid=__ret__.get('kid'),
        name=__ret__.get('name'),
        status=__ret__.get('status'))
