/*
 Copyright (c) 2019-2020 by Marek Wydmuch

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
 */

#pragma once

#include "model.h"


class OnlineModel : virtual public Model {
public:
    void train(SRMatrix& labels, SRMatrix& features, Args& args, std::string output) final;

    virtual void init(Args& args) = 0;
    virtual void init(SRMatrix& labels, SRMatrix& features, Args& args) = 0;
    virtual void update(const int epoch, const int row, SparseVector& labels, SparseVector& features, Args& args) = 0;
    virtual void save(Args& args, std::string output) = 0;

private:
    static void onlineTrainThread(int threadId, OnlineModel* model, SRMatrix& labels,
                                  SRMatrix& features, Args& args, const int startRow, const int stopRow);
};
