"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IamRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * IAM Role.
 *
 * Defines an IAM role for pre-production and production AWS accounts.
 *
 * @stability stable
 */
class IamRole extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, name, props) {
        var _b;
        super(scope, name);
        if (props.environment !== 'preproduction' && props.environment !== 'production') {
            throw new Error('The value of `environment` should be either \'production\' or \'preproduction\'');
        }
        const role = new iam.Role(this, `${props.environment}IamRole`, {
            assumedBy: new iam.AccountPrincipal(props.accountID),
            roleName: (_b = props.roleName) !== null && _b !== void 0 ? _b : `${props.environment}-Databrew-Cicd-Role`,
            description: `The IAM role for DataBrew CICD in the ${props.environment} account.`,
        });
        role.addToPolicy(new iam.PolicyStatement({
            sid: 'DataBrewPermissions',
            effect: iam.Effect.ALLOW,
            actions: [
                'databrew:ListRecipes',
                'databrew:CreateRecipe',
                'databrew:PublishRecipe',
                'databrew:UpdateRecipe',
            ],
            resources: ['*'],
        }));
        this.roleArn = role.roleArn;
    }
}
exports.IamRole = IamRole;
_a = JSII_RTTI_SYMBOL_1;
IamRole[_a] = { fqn: "cdk-databrew-cicd.IamRole", version: "0.1.30" };
//# sourceMappingURL=data:application/json;base64,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