# coding: utf-8

"""
    ARLAS Exploration API

    Explore the content of ARLAS collections  # noqa: E501

    OpenAPI spec version: 14.0.1
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from arlas_api_python.api_client import ApiClient


class CollectionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete(self, collection, **kwargs):  # noqa: E501
        """Delete a collection reference  # noqa: E501

        Delete a collection reference in ARLAS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete(collection, async=True)
        >>> result = thread.get()

        :param async bool
        :param str collection: collection (required)
        :param bool pretty: Pretty print
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_with_http_info(collection, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_with_http_info(collection, **kwargs)  # noqa: E501
            return data

    def delete_with_http_info(self, collection, **kwargs):  # noqa: E501
        """Delete a collection reference  # noqa: E501

        Delete a collection reference in ARLAS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_with_http_info(collection, async=True)
        >>> result = thread.get()

        :param async bool
        :param str collection: collection (required)
        :param bool pretty: Pretty print
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'pretty']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params or
                params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/collections/{collection}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_collections(self, **kwargs):  # noqa: E501
        """Get all collection references as a json file  # noqa: E501

        Get all collection references in ARLAS as json file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.export_collections(async=True)
        >>> result = thread.get()

        :param async bool
        :return: list[CollectionReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.export_collections_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.export_collections_with_http_info(**kwargs)  # noqa: E501
            return data

    def export_collections_with_http_info(self, **kwargs):  # noqa: E501
        """Get all collection references as a json file  # noqa: E501

        Get all collection references in ARLAS as json file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.export_collections_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: list[CollectionReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_collections" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/collections/_export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CollectionReference]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get(self, collection, **kwargs):  # noqa: E501
        """Get a collection reference  # noqa: E501

        Get a collection reference in ARLAS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get(collection, async=True)
        >>> result = thread.get()

        :param async bool
        :param str collection: collection (required)
        :param bool pretty: Pretty print
        :return: CollectionReference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_with_http_info(collection, **kwargs)  # noqa: E501
        else:
            (data) = self.get_with_http_info(collection, **kwargs)  # noqa: E501
            return data

    def get_with_http_info(self, collection, **kwargs):  # noqa: E501
        """Get a collection reference  # noqa: E501

        Get a collection reference in ARLAS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_with_http_info(collection, async=True)
        >>> result = thread.get()

        :param async bool
        :param str collection: collection (required)
        :param bool pretty: Pretty print
        :return: CollectionReference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'pretty']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params or
                params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/collections/{collection}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionReference',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all(self, **kwargs):  # noqa: E501
        """Get all collection references  # noqa: E501

        Get all collection references in ARLAS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool pretty: Pretty print
        :return: list[CollectionReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_all_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_with_http_info(self, **kwargs):  # noqa: E501
        """Get all collection references  # noqa: E501

        Get all collection references in ARLAS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param bool pretty: Pretty print
        :return: list[CollectionReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CollectionReference]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_collections(self, **kwargs):  # noqa: E501
        """Add collection references from a json file  # noqa: E501

        Add collection references in ARLAS from a json file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.import_collections(async=True)
        >>> result = thread.get()

        :param async bool
        :param file file:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.import_collections_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.import_collections_with_http_info(**kwargs)  # noqa: E501
            return data

    def import_collections_with_http_info(self, **kwargs):  # noqa: E501
        """Add collection references from a json file  # noqa: E501

        Add collection references in ARLAS from a json file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.import_collections_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param file file:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_collections" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/collections/_import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put(self, collection, collection_params, **kwargs):  # noqa: E501
        """Add a collection reference  # noqa: E501

        Add a collection reference in ARLAS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.put(collection, collection_params, async=True)
        >>> result = thread.get()

        :param async bool
        :param str collection: collection (required)
        :param CollectionReferenceParameters collection_params: collectionParams (required)
        :param bool pretty: Pretty print
        :return: CollectionReference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.put_with_http_info(collection, collection_params, **kwargs)  # noqa: E501
        else:
            (data) = self.put_with_http_info(collection, collection_params, **kwargs)  # noqa: E501
            return data

    def put_with_http_info(self, collection, collection_params, **kwargs):  # noqa: E501
        """Add a collection reference  # noqa: E501

        Add a collection reference in ARLAS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.put_with_http_info(collection, collection_params, async=True)
        >>> result = thread.get()

        :param async bool
        :param str collection: collection (required)
        :param CollectionReferenceParameters collection_params: collectionParams (required)
        :param bool pretty: Pretty print
        :return: CollectionReference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection', 'collection_params', 'pretty']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection' is set
        if ('collection' not in params or
                params['collection'] is None):
            raise ValueError("Missing the required parameter `collection` when calling `put`")  # noqa: E501
        # verify the required parameter 'collection_params' is set
        if ('collection_params' not in params or
                params['collection_params'] is None):
            raise ValueError("Missing the required parameter `collection_params` when calling `put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection' in params:
            path_params['collection'] = params['collection']  # noqa: E501

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'collection_params' in params:
            body_params = params['collection_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/collections/{collection}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionReference',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
