import abc

class Rule(abc.ABC):
    @classmethod
    def __subclasshook__(cls, C): ...

class BaseMarshal:
    def __init__(self) -> None: ...
    def register(self, proto_type: type, rule: Rule = ...): ...
    def reset(self) -> None: ...
    def to_python(self, proto_type, value, *, absent: bool = ...): ...
    def to_proto(self, proto_type, value, *, strict: bool = ...): ...

class Marshal(BaseMarshal):
    def __new__(cls, name: str): ...
    def __init__(self, name: str) -> None: ...

class NoopRule:
    def to_python(self, pb_value, *, absent: bool = ...): ...
    def to_proto(self, value): ...
