import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
 *
 * @experimental
 */
export declare class Ec2messages extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Acknowledges a message, ensuring it will not be delivered again.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toAcknowledgeMessage(): this;
    /**
     * (experimental) Deletes a message.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteMessage(): this;
    /**
     * (experimental) Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toFailMessage(): this;
    /**
     * (experimental) Routes traffic to the correct endpoint based on the given destination for the messages.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetEndpoint(): this;
    /**
     * (experimental) Delivers messages to clients/instances using long polling.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMessages(): this;
    /**
     * (experimental) Sends replies from clients/instances to upstream service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toSendReply(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
