import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [quicksight](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonquicksight.html).
 *
 * @experimental
 */
export declare class Quicksight extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [quicksight](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonquicksight.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to cancel a SPICE ingestions on a dataset.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CancelIngestion.html
     *
     * @experimental
     */
    toCancelIngestion(): this;
    /**
     * (experimental) Grants permission to create an account customization for QuickSight account or namespace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateAccountCustomization.html
     *
     * @experimental
     */
    toCreateAccountCustomization(): this;
    /**
     * (experimental) CreateAdmin enables the user to provision Amazon QuickSight administrators, authors, and readers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toCreateAdmin(): this;
    /**
     * (experimental) Creates an analysis from a template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateAnalysis.html
     *
     * @experimental
     */
    toCreateAnalysis(): this;
    /**
     * (experimental) Grants permission to create a custom permissions resource for restricting user access.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toCreateCustomPermissions(): this;
    /**
     * (experimental) Creates a dashboard from a template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDashboard.html
     *
     * @experimental
     */
    toCreateDashboard(): this;
    /**
     * (experimental) Grants permission to create a dataset.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSet.html
     *
     * @experimental
     */
    toCreateDataSet(): this;
    /**
     * (experimental) Grants permission to create a data source.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSource.html
     *
     * @experimental
     */
    toCreateDataSource(): this;
    /**
     * (experimental) Create a QuickSight group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateGroup.html
     *
     * @experimental
     */
    toCreateGroup(): this;
    /**
     * (experimental) Add a QuickSight user to a QuickSight group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateGroupMembership.html
     *
     * @experimental
     */
    toCreateGroupMembership(): this;
    /**
     * (experimental) Creates an assignment with one specified IAM Policy ARN that will be assigned to specified groups or users of QuickSight.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateIAMPolicyAssignment.html
     *
     * @experimental
     */
    toCreateIAMPolicyAssignment(): this;
    /**
     * (experimental) Grants permission to start a SPICE ingestion on a dataset.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateIngestion.html
     *
     * @experimental
     */
    toCreateIngestion(): this;
    /**
     * (experimental) Grants permission to create an QuickSight namespace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateNamespace.html
     *
     * @experimental
     */
    toCreateNamespace(): this;
    /**
     * (experimental) CreateReader enables the user to provision Amazon QuickSight readers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toCreateReader(): this;
    /**
     * (experimental) Creates a template from an existing QuickSight analysis or template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html
     *
     * @experimental
     */
    toCreateTemplate(): this;
    /**
     * (experimental) Creates a template alias for a template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplateAlias.html
     *
     * @experimental
     */
    toCreateTemplateAlias(): this;
    /**
     * (experimental) Creates a QuickSight theme.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTheme.html
     *
     * @experimental
     */
    toCreateTheme(): this;
    /**
     * (experimental) Creates a theme alias for a theme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateThemeAlias.html
     *
     * @experimental
     */
    toCreateThemeAlias(): this;
    /**
     * (experimental) CreateUser enables the user to provision Amazon QuickSight authors and readers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toCreateUser(): this;
    /**
     * (experimental) Grants permission to delete an account customization for QuickSight account or namespace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteAccountCustomization.html
     *
     * @experimental
     */
    toDeleteAccountCustomization(): this;
    /**
     * (experimental) Deletes an analysis.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteAnalysis.html
     *
     * @experimental
     */
    toDeleteAnalysis(): this;
    /**
     * (experimental) Deletes a dashboard.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDashboard.html
     *
     * @experimental
     */
    toDeleteDashboard(): this;
    /**
     * (experimental) Grants permission to delete a dataset.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDataSet.html
     *
     * @experimental
     */
    toDeleteDataSet(): this;
    /**
     * (experimental) Grants permission to delete a data source.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteDataSource.html
     *
     * @experimental
     */
    toDeleteDataSource(): this;
    /**
     * (experimental) Remove a user group from QuickSight.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteGroup.html
     *
     * @experimental
     */
    toDeleteGroup(): this;
    /**
     * (experimental) Remove a user from a group so that he/she is no longer a member of the group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteGroupMembership.html
     *
     * @experimental
     */
    toDeleteGroupMembership(): this;
    /**
     * (experimental) Update an existing assignment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteIAMPolicyAssignment.html
     *
     * @experimental
     */
    toDeleteIAMPolicyAssignment(): this;
    /**
     * (experimental) Grants permission to delete a QuickSight namespace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteNamespace.html
     *
     * @experimental
     */
    toDeleteNamespace(): this;
    /**
     * (experimental) Deletes a template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTemplate.html
     *
     * @experimental
     */
    toDeleteTemplate(): this;
    /**
     * (experimental) Deletes the item that the specified template alias points to.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTemplateAlias.html
     *
     * @experimental
     */
    toDeleteTemplateAlias(): this;
    /**
     * (experimental) Deletes a theme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteTheme.html
     *
     * @experimental
     */
    toDeleteTheme(): this;
    /**
     * (experimental) Deletes the item that the specified theme alias points to.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteThemeAlias.html
     *
     * @experimental
     */
    toDeleteThemeAlias(): this;
    /**
     * (experimental) Delete the QuickSight user that is associated with the identity of the IAM user/role making the call.
     *
     * The IAM user is not deleted as a result of this call.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteUser.html
     *
     * @experimental
     */
    toDeleteUser(): this;
    /**
     * (experimental) Deletes a user identified by its principal ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DeleteUserByPrincipalId.html
     *
     * @experimental
     */
    toDeleteUserByPrincipalId(): this;
    /**
     * (experimental) Grants permission to describe an account customization for QuickSight account or namespace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAccountCustomization.html
     *
     * @experimental
     */
    toDescribeAccountCustomization(): this;
    /**
     * (experimental) Grants permission to describe the administrative account settings for QuickSight account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAccountSettings.html
     *
     * @experimental
     */
    toDescribeAccountSettings(): this;
    /**
     * (experimental) Provides a summary for an analysis.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html
     *
     * @experimental
     */
    toDescribeAnalysis(): this;
    /**
     * (experimental) Describes read and write permissions for an analysis.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysisPermissions.html
     *
     * @experimental
     */
    toDescribeAnalysisPermissions(): this;
    /**
     * (experimental) Grants permission to describe a custom permissions resource in a QuickSight account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toDescribeCustomPermissions(): this;
    /**
     * (experimental) Provides a summary for a dashboard.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html
     *
     * @experimental
     */
    toDescribeDashboard(): this;
    /**
     * (experimental) Describes read and write permissions for a dashboard.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboardPermissions.html
     *
     * @experimental
     */
    toDescribeDashboardPermissions(): this;
    /**
     * (experimental) Grants permission to describe a dataset.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSet.html
     *
     * @experimental
     */
    toDescribeDataSet(): this;
    /**
     * (experimental) Grants permission to describe the resource policy of a dataset.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSetPermissions.html
     *
     * @experimental
     */
    toDescribeDataSetPermissions(): this;
    /**
     * (experimental) Grants permission to describe a data source.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSource.html
     *
     * @experimental
     */
    toDescribeDataSource(): this;
    /**
     * (experimental) Grants permission to describe the resource policy of a data source.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDataSourcePermissions.html
     *
     * @experimental
     */
    toDescribeDataSourcePermissions(): this;
    /**
     * (experimental) Return a QuickSight group’s description and ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeGroup.html
     *
     * @experimental
     */
    toDescribeGroup(): this;
    /**
     * (experimental) Describe an existing assignment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeIAMPolicyAssignment.html
     *
     * @experimental
     */
    toDescribeIAMPolicyAssignment(): this;
    /**
     * (experimental) Grants permission to describe a SPICE ingestion on a dataset.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeIngestion.html
     *
     * @experimental
     */
    toDescribeIngestion(): this;
    /**
     * (experimental) Grants permission to describe a QuickSight namespace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeNamespace.html
     *
     * @experimental
     */
    toDescribeNamespace(): this;
    /**
     * (experimental) Describes a template's metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html
     *
     * @experimental
     */
    toDescribeTemplate(): this;
    /**
     * (experimental) Describes the template alias for a template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplateAlias.html
     *
     * @experimental
     */
    toDescribeTemplateAlias(): this;
    /**
     * (experimental) Describes read and write permissions on a template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplatePermissions.html
     *
     * @experimental
     */
    toDescribeTemplatePermissions(): this;
    /**
     * (experimental) Describes a theme's metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTheme.html
     *
     * @experimental
     */
    toDescribeTheme(): this;
    /**
     * (experimental) Describes the theme alias for a theme.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemeAlias.html
     *
     * @experimental
     */
    toDescribeThemeAlias(): this;
    /**
     * (experimental) Describes read and write permissions on a theme.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html
     *
     * @experimental
     */
    toDescribeThemePermissions(): this;
    /**
     * (experimental) Return information about a user, given the user name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html
     *
     * @experimental
     */
    toDescribeUser(): this;
    /**
     * (experimental) Return an auth code representing a QuickSight user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toGetAuthCode(): this;
    /**
     * (experimental) Return a QuickSight dashboard embedding URL.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html
     *
     * @experimental
     */
    toGetDashboardEmbedUrl(): this;
    /**
     * (experimental) GetGroupMapping is used only in Amazon QuickSight Enterprise edition accounts.
     *
     * It enables the user to use Amazon QuickSight to identify and display the Microsoft Active Directory (Microsoft Active Directory) directory groups that are mapped to roles in Amazon QuickSight.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toGetGroupMapping(): this;
    /**
     * (experimental) Grants permission to get a URL to embed QuickSight console experience.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetSessionEmbedUrl.html
     *
     * @experimental
     */
    toGetSessionEmbedUrl(): this;
    /**
     * (experimental) Lists analyses in an AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListAnalyses.html
     *
     * @experimental
     */
    toListAnalyses(): this;
    /**
     * (experimental) Grants permission to list custom permissions resources in QuickSight account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toListCustomPermissions(): this;
    /**
     * (experimental) Lists all the versions of the dashboards in the QuickSight subscription.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDashboardVersions.html
     *
     * @experimental
     */
    toListDashboardVersions(): this;
    /**
     * (experimental) Lists dashboards in an AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDashboards.html
     *
     * @experimental
     */
    toListDashboards(): this;
    /**
     * (experimental) Grants permission to list all datasets.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDataSets.html
     *
     * @experimental
     */
    toListDataSets(): this;
    /**
     * (experimental) Grants permission to list all data sources.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListDataSources.html
     *
     * @experimental
     */
    toListDataSources(): this;
    /**
     * (experimental) Return a list of member users in a group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListGroupMemberships.html
     *
     * @experimental
     */
    toListGroupMemberships(): this;
    /**
     * (experimental) Get a list of all user groups in QuickSight.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListGroups.html
     *
     * @experimental
     */
    toListGroups(): this;
    /**
     * (experimental) List all assignments in the current Amazon QuickSight account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIAMPolicyAssignments.html
     *
     * @experimental
     */
    toListIAMPolicyAssignments(): this;
    /**
     * (experimental) List all assignments assigned to a user and the groups it belongs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIAMPolicyAssignmentsForUser.html
     *
     * @experimental
     */
    toListIAMPolicyAssignmentsForUser(): this;
    /**
     * (experimental) Grants permission to list all SPICE ingestions on a dataset.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListIngestions.html
     *
     * @experimental
     */
    toListIngestions(): this;
    /**
     * (experimental) Grants permission to lists all namespaces in a QuickSight account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListNamespaces.html
     *
     * @experimental
     */
    toListNamespaces(): this;
    /**
     * (experimental) List tags of a QuickSight resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Lists all the aliases of a template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplateAliases.html
     *
     * @experimental
     */
    toListTemplateAliases(): this;
    /**
     * (experimental) Lists all the versions of the templates in the current Amazon QuickSight account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplateVersions.html
     *
     * @experimental
     */
    toListTemplateVersions(): this;
    /**
     * (experimental) Lists all the templates in the current Amazon QuickSight account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListTemplates.html
     *
     * @experimental
     */
    toListTemplates(): this;
    /**
     * (experimental) Lists all the aliases of a theme.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemeAliases.html
     *
     * @experimental
     */
    toListThemeAliases(): this;
    /**
     * (experimental) Lists all the versions of a theme.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemeVersions.html
     *
     * @experimental
     */
    toListThemeVersions(): this;
    /**
     * (experimental) Lists all the themes in the current Amazon QuickSight account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListThemes.html
     *
     * @experimental
     */
    toListThemes(): this;
    /**
     * (experimental) Return a list of groups that a given user is a member of.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListUserGroups.html
     *
     * @experimental
     */
    toListUserGroups(): this;
    /**
     * (experimental) Return a list of all of the QuickSight users belonging to this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ListUsers.html
     *
     * @experimental
     */
    toListUsers(): this;
    /**
     * (experimental) Grants permission to use a dataset for a template.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-api-overview.html
     *
     * @experimental
     */
    toPassDataSet(): this;
    /**
     * (experimental) Grants permission to use a data source for a data set.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-api-overview.html
     *
     * @experimental
     */
    toPassDataSource(): this;
    /**
     * (experimental) Create a QuickSight user, whose identity is associated with the IAM identity/role specified in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html
     *
     * @experimental
     */
    toRegisterUser(): this;
    /**
     * (experimental) Restores a deleted analysis.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RestoreAnalysis.html
     *
     * @experimental
     */
    toRestoreAnalysis(): this;
    /**
     * (experimental) Searches for analyses that belong to the user specified in the filter.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchAnalyses.html
     *
     * @experimental
     */
    toSearchAnalyses(): this;
    /**
     * (experimental) Searches for dashboards that belong to a user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_SearchDashboards.html
     *
     * @experimental
     */
    toSearchDashboards(): this;
    /**
     * (experimental) SearchDirectoryGroups is used only in Amazon QuickSight Enterprise edition accounts.
     *
     * It enables the user to use Amazon QuickSight to display your Microsoft Active Directory directory groups so that you can choose which ones to map to roles in Amazon QuickSight.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toSearchDirectoryGroups(): this;
    /**
     * (experimental) SearchDirectoryGroups is used only in Amazon QuickSight Enterprise edition accounts.
     *
     * It enables the user to use Amazon QuickSight to display your Microsoft Active Directory directory groups so that you can choose which ones to map to roles in Amazon QuickSight.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toSetGroupMapping(): this;
    /**
     * (experimental) Subscribe enables the user to subscribe to Amazon QuickSight.
     *
     * Enabling this action also allows the user to upgrade the subscription to Enterprise edition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toSubscribe(): this;
    /**
     * (experimental) Add tags to a QuickSight resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Unsubscribe enables the user to unsubscribe from Amazon QuickSight, which permanently deletes all users and their resources from Amazon QuickSight.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toUnsubscribe(): this;
    /**
     * (experimental) Remove tags from a QuickSight resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an account customization for QuickSight account or namespace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAccountCustomization.html
     *
     * @experimental
     */
    toUpdateAccountCustomization(): this;
    /**
     * (experimental) Grants permission to update the administrative account settings for QuickSight account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAccountSettings.html
     *
     * @experimental
     */
    toUpdateAccountSettings(): this;
    /**
     * (experimental) Updates an analysis in an AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAnalysis.html
     *
     * @experimental
     */
    toUpdateAnalysis(): this;
    /**
     * (experimental) Updates read and write permissions on an analysis.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateAnalysisPermissions.html
     *
     * @experimental
     */
    toUpdateAnalysisPermissions(): this;
    /**
     * (experimental) Grants permission to update a custom permissions resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * @experimental
     */
    toUpdateCustomPermissions(): this;
    /**
     * (experimental) Updates a dashboard in an AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboard.html
     *
     * @experimental
     */
    toUpdateDashboard(): this;
    /**
     * (experimental) Updates read and write permissions on a dashboard.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPermissions.html
     *
     * @experimental
     */
    toUpdateDashboardPermissions(): this;
    /**
     * (experimental) Updates the published version of a dashboard.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html
     *
     * @experimental
     */
    toUpdateDashboardPublishedVersion(): this;
    /**
     * (experimental) Grants permission to update a dataset.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSet.html
     *
     * @experimental
     */
    toUpdateDataSet(): this;
    /**
     * (experimental) Grants permission to update the resource policy of a dataset.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSetPermissions.html
     *
     * @experimental
     */
    toUpdateDataSetPermissions(): this;
    /**
     * (experimental) Grants permission to update a data source.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSource.html
     *
     * @experimental
     */
    toUpdateDataSource(): this;
    /**
     * (experimental) Grants permission to update the resource policy of a data source.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDataSourcePermissions.html
     *
     * @experimental
     */
    toUpdateDataSourcePermissions(): this;
    /**
     * (experimental) Change group description.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateGroup.html
     *
     * @experimental
     */
    toUpdateGroup(): this;
    /**
     * (experimental) Update an existing assignment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateIAMPolicyAssignment.html
     *
     * @experimental
     */
    toUpdateIAMPolicyAssignment(): this;
    /**
     * (experimental) Updates a template from an existing Amazon QuickSight analysis or another template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplate.html
     *
     * @experimental
     */
    toUpdateTemplate(): this;
    /**
     * (experimental) Updates the template alias of a template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplateAlias.html
     *
     * @experimental
     */
    toUpdateTemplateAlias(): this;
    /**
     * (experimental) Updates the resource permissions for a template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTemplatePermissions.html
     *
     * @experimental
     */
    toUpdateTemplatePermissions(): this;
    /**
     * (experimental) Updates a theme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateTheme.html
     *
     * @experimental
     */
    toUpdateTheme(): this;
    /**
     * (experimental) Updates the theme alias of a theme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemeAlias.html
     *
     * @experimental
     */
    toUpdateThemeAlias(): this;
    /**
     * (experimental) Updates the resource permissions for a theme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html
     *
     * @experimental
     */
    toUpdateThemePermissions(): this;
    /**
     * (experimental) Updates an Amazon QuickSight user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html
     *
     * @experimental
     */
    toUpdateUser(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type user to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_User.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onUser(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type group to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Group.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onGroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type analysis to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Analysis.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAnalysis(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dashboard to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Dashboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDashboard(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type template to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Template.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTemplate(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type datasource to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSource.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDatasource(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dataset to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DataSet.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDataset(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ingestion to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Ingestion.html
     *
     * @param datasetId - Identifier for the datasetId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onIngestion(datasetId: string, resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type theme to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Theme.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTheme(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type assignment to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IAMPolicyAssignment.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssignment(resourceId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type customization to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_AccountCustomization.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCustomization(resourceId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type namespace to the statement.
     *
     * https://docs.aws.amazon.com/quicksight/latest/APIReference/API_Namespace.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onNamespace(resourceId: string, account?: string, partition?: string): this;
    /**
     * (experimental) IAM user ARN or role ARN.
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * Applies to actions:
     * - .toRegisterUser()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifIamArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The session name.
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * Applies to actions:
     * - .toRegisterUser()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifSessionName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The user name.
     *
     * https://docs.aws.amazon.com/quicksight/latest/user/iam-actions.html
     *
     * Applies to actions:
     * - .toCreateGroupMembership()
     * - .toDeleteGroupMembership()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifUserName(value: string | string[], operator?: Operator | string): this;
}
