import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [sso](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssso.html).
 *
 * @experimental
 */
export declare class Sso extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [sso](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssso.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Connect a directory to be used by AWS Single Sign-On.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toAssociateDirectory(): this;
    /**
     * (experimental) Create an association between a directory user or group and a profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toAssociateProfile(): this;
    /**
     * (experimental) Attaches an AWS managed policy to a permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toAttachManagedPolicyToPermissionSet(): this;
    /**
     * (experimental) Assigns access to a Principal for a specified AWS account using a specified permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateAccountAssignment(): this;
    /**
     * (experimental) Add an application instance to AWS Single Sign-On.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateApplicationInstance(): this;
    /**
     * (experimental) Add a new certificate for an application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateApplicationInstanceCertificate(): this;
    /**
     * (experimental) Grants permission to enable the instance for ABAC and specify the attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateInstanceAccessControlAttributeConfiguration.html
     *
     * @experimental
     */
    toCreateInstanceAccessControlAttributeConfiguration(): this;
    /**
     * (experimental) Add a managed application instance to AWS Single Sign-On.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateManagedApplicationInstance(): this;
    /**
     * (experimental) Create a permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreatePermissionSet(): this;
    /**
     * (experimental) Create a profile for an application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateProfile(): this;
    /**
     * (experimental) Create a federation trust in a target account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateTrust(): this;
    /**
     * (experimental) Deletes a Principal's access from a specified AWS account using a specified permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteAccountAssignment(): this;
    /**
     * (experimental) Delete the application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteApplicationInstance(): this;
    /**
     * (experimental) Delete an inactive or expired certificate from the application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteApplicationInstanceCertificate(): this;
    /**
     * (experimental) Deletes the inline policy from a specified permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteInlinePolicyFromPermissionSet(): this;
    /**
     * (experimental) Grants permission to disable ABAC and remove the attributes list for the instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_DeleteInstanceAccessControlAttributeConfiguration.html
     *
     * @experimental
     */
    toDeleteInstanceAccessControlAttributeConfiguration(): this;
    /**
     * (experimental) Delete the managed application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteManagedApplicationInstance(): this;
    /**
     * (experimental) Delete a permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeletePermissionSet(): this;
    /**
     * (experimental) Delete the permission policy associated with a permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeletePermissionsPolicy(): this;
    /**
     * (experimental) Delete the profile for an application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteProfile(): this;
    /**
     * (experimental) Describes the status of the assignment creation request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeAccountAssignmentCreationStatus(): this;
    /**
     * (experimental) Describes the status of an assignment deletion request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeAccountAssignmentDeletionStatus(): this;
    /**
     * (experimental) Grants permission to get the list of attributes used by the instance for ABAC.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_DescribeInstanceAccessControlAttributeConfiguration.html
     *
     * @experimental
     */
    toDescribeInstanceAccessControlAttributeConfiguration(): this;
    /**
     * (experimental) Describes a permission set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribePermissionSet(): this;
    /**
     * (experimental) Describes the status for the given Permission Set Provisioning request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribePermissionSetProvisioningStatus(): this;
    /**
     * (experimental) Retrieve all the permissions policies associated with a permission set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribePermissionsPolicies(): this;
    /**
     * (experimental) Obtains the regions where your organization has enabled AWS Single Sign-on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeRegisteredRegions(): this;
    /**
     * (experimental) Detaches the attached AWS managed policy from the specified permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDetachManagedPolicyFromPermissionSet(): this;
    /**
     * (experimental) Disassociate a directory to be used by AWS Single Sign-On.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDisassociateDirectory(): this;
    /**
     * (experimental) Disassociate a directory user or group from a profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDisassociateProfile(): this;
    /**
     * (experimental) Retrieve details for an application instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetApplicationInstance(): this;
    /**
     * (experimental) Retrieve application template details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetApplicationTemplate(): this;
    /**
     * (experimental) Obtains the inline policy assigned to the permission set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetInlinePolicyForPermissionSet(): this;
    /**
     * (experimental) Retrieve details for an application instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetManagedApplicationInstance(): this;
    /**
     * (experimental) Retrieve Mfa Device Management settings for the directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetMfaDeviceManagementForDirectory(): this;
    /**
     * (experimental) Retrieve details of a permission set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetPermissionSet(): this;
    /**
     * (experimental) Retrieve all permission policies associated with a permission set.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - sso:DescribePermissionsPolicies
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetPermissionsPolicy(): this;
    /**
     * (experimental) Retrieve a profile for an application instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetProfile(): this;
    /**
     * (experimental) Check if AWS Single Sign-On is enabled.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetSSOStatus(): this;
    /**
     * (experimental) Retrieve shared configuration for the current SSO instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetSharedSsoConfiguration(): this;
    /**
     * (experimental) Retrieve configuration for the current SSO instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetSsoConfiguration(): this;
    /**
     * (experimental) Retrieve the federation trust in a target account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetTrust(): this;
    /**
     * (experimental) Update the application instance by uploading an application SAML metadata file provided by the service provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toImportApplicationInstanceServiceProviderMetadata(): this;
    /**
     * (experimental) Lists the status of the AWS account assignment creation requests for a specified SSO instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListAccountAssignmentCreationStatus(): this;
    /**
     * (experimental) Lists the status of the AWS account assignment deletion requests for a specified SSO instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListAccountAssignmentDeletionStatus(): this;
    /**
     * (experimental) Lists the assignee of the specified AWS account with the specified permission set.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListAccountAssignments(): this;
    /**
     * (experimental) Lists all the AWS accounts where the specified permission set is provisioned.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListAccountsForProvisionedPermissionSet(): this;
    /**
     * (experimental) Retrieve all of the certificates for a given application instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListApplicationInstanceCertificates(): this;
    /**
     * (experimental) Retrieve all application instances.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - sso:GetApplicationInstance
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListApplicationInstances(): this;
    /**
     * (experimental) Retrieve all supported application templates.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - sso:GetApplicationTemplate
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListApplicationTemplates(): this;
    /**
     * (experimental) Retrieve all supported applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListApplications(): this;
    /**
     * (experimental) Retrieve details about the directory connected to AWS Single Sign-On.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListDirectoryAssociations(): this;
    /**
     * (experimental) Lists the SSO Instances that the caller has access to.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListInstances(): this;
    /**
     * (experimental) Lists the AWS managed policies that are attached to a specified permission set.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListManagedPoliciesInPermissionSet(): this;
    /**
     * (experimental) Lists the status of the Permission Set Provisioning requests for a specified SSO instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListPermissionSetProvisioningStatus(): this;
    /**
     * (experimental) Retrieve all permission sets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListPermissionSets(): this;
    /**
     * (experimental) Lists all the permission sets that are provisioned to a specified AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListPermissionSetsProvisionedToAccount(): this;
    /**
     * (experimental) Retrieve the directory user or group associated with the profile.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListProfileAssociations(): this;
    /**
     * (experimental) Retrieve all profiles for an application instance.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - sso:GetProfile
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListProfiles(): this;
    /**
     * (experimental) Lists the tags that are attached to a specified resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) The process by which a specified permission set is provisioned to the specified target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toProvisionPermissionSet(): this;
    /**
     * (experimental) Attaches an IAM inline policy to a permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toPutInlinePolicyToPermissionSet(): this;
    /**
     * (experimental) Put Mfa Device Management settings for the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toPutMfaDeviceManagementForDirectory(): this;
    /**
     * (experimental) Add a policy to a permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toPutPermissionsPolicy(): this;
    /**
     * (experimental) Search for groups within the associated directory.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toSearchGroups(): this;
    /**
     * (experimental) Search for users within the associated directory.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toSearchUsers(): this;
    /**
     * (experimental) Initialize AWS Single Sign-On.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organization:DescribeOrganization
     * - organizations:EnableAWSServiceAccess
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toStartSSO(): this;
    /**
     * (experimental) Associates a set of tags with a specified resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Disassociates a set of tags from a specified resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Set a certificate as the active one for this application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateApplicationInstanceActiveCertificate(): this;
    /**
     * (experimental) Update display data of an application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateApplicationInstanceDisplayData(): this;
    /**
     * (experimental) Update federation response configuration for the application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateApplicationInstanceResponseConfiguration(): this;
    /**
     * (experimental) Update federation response schema configuration for the application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateApplicationInstanceResponseSchemaConfiguration(): this;
    /**
     * (experimental) Update security details for the application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateApplicationInstanceSecurityConfiguration(): this;
    /**
     * (experimental) Update service provider related configuration for the application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateApplicationInstanceServiceProviderConfiguration(): this;
    /**
     * (experimental) Update the status of an application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateApplicationInstanceStatus(): this;
    /**
     * (experimental) Update the user attribute mappings for your connected directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateDirectoryAssociation(): this;
    /**
     * (experimental) Grants permission to update the attributes to use with the instance for ABAC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_UpdateInstanceAccessControlAttributeConfiguration.html
     *
     * @experimental
     */
    toUpdateInstanceAccessControlAttributeConfiguration(): this;
    /**
     * (experimental) Update the status of a managed application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateManagedApplicationInstanceStatus(): this;
    /**
     * (experimental) Update the permission set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdatePermissionSet(): this;
    /**
     * (experimental) Update the profile for an application instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateProfile(): this;
    /**
     * (experimental) Update the configuration for the current SSO instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateSSOConfiguration(): this;
    /**
     * (experimental) Update the federation trust in a target account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateTrust(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type PermissionSet to the statement.
     *
     * @param instanceId - Identifier for the instanceId.
     * @param permissionSetId - Identifier for the permissionSetId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPermissionSet(instanceId: string, permissionSetId: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Account to the statement.
     *
     * @param accountId - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAccount(accountId?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Instance to the statement.
     *
     * @param instanceId - Identifier for the instanceId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onInstance(instanceId: string, partition?: string): this;
}
