"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithEffect = exports.Effect = void 0;
const _4_resources_1 = require("./4-resources");
/**
 * (experimental) Policy effects.
 *
 * @experimental
 */
var Effect;
(function (Effect) {
    Effect["ALLOW"] = "Allow";
    Effect["DENY"] = "Deny";
})(Effect = exports.Effect || (exports.Effect = {}));
/**
 * (experimental) Adds "effect" functionality to the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementWithEffect extends _4_resources_1.PolicyStatementWithResources {
    constructor() {
        super(...arguments);
        /**
         * @experimental
         */
        this.effect = Effect.ALLOW;
    }
    /**
     * (experimental) Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     *
     * @experimental
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            return super.toJSON();
        }
        const statement = super.toJSON();
        statement.Effect = this.effect;
        return statement;
    }
    /**
     * (experimental) Allow the actions in this statement.
     *
     * @experimental
     */
    allow() {
        this.effect = Effect.ALLOW;
        return this;
    }
    /**
     * (experimental) Deny the actions in this statement.
     *
     * @experimental
     */
    deny() {
        this.effect = Effect.DENY;
        return this;
    }
}
exports.PolicyStatementWithEffect = PolicyStatementWithEffect;
//# sourceMappingURL=data:application/json;base64,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