import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [backup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackup.html).
 *
 * @experimental
 */
export declare class Backup extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [backup](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackup.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to copy from a backup vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCopyTargets()
     * - .ifCopyTargetOrgPaths()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartCopyJob.html
     *
     * @experimental
     */
    toCopyFromBackupVault(): this;
    /**
     * (experimental) Grants permission to copy into a backup vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartCopyJob.html
     *
     * @experimental
     */
    toCopyIntoBackupVault(): this;
    /**
     * (experimental) Grants permission to create a new backup plan.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupPlan.html
     *
     * @experimental
     */
    toCreateBackupPlan(): this;
    /**
     * (experimental) Grants permission to create a new resource assignment in a backup plan.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupSelection.html
     *
     * @experimental
     */
    toCreateBackupSelection(): this;
    /**
     * (experimental) Grants permission to create a new backup vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupVault.html
     *
     * @experimental
     */
    toCreateBackupVault(): this;
    /**
     * (experimental) Grants permission to create a new framework.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateFramework.html
     *
     * @experimental
     */
    toCreateFramework(): this;
    /**
     * (experimental) Grants permission to create a new report plan.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifFrameworkArns()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateReportPlan.html
     *
     * @experimental
     */
    toCreateReportPlan(): this;
    /**
     * (experimental) Grants permission to delete a backup plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupPlan.html
     *
     * @experimental
     */
    toDeleteBackupPlan(): this;
    /**
     * (experimental) Grants permission to delete a resource assignment from a backup plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupSelection.html
     *
     * @experimental
     */
    toDeleteBackupSelection(): this;
    /**
     * (experimental) Grants permission to delete a backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVault.html
     *
     * @experimental
     */
    toDeleteBackupVault(): this;
    /**
     * (experimental) Grants permission to delete backup vault access policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVaultAccessPolicy.html
     *
     * @experimental
     */
    toDeleteBackupVaultAccessPolicy(): this;
    /**
     * (experimental) Grants permission to remove the lock configuration from a backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVaultLockConfiguration.html
     *
     * @experimental
     */
    toDeleteBackupVaultLockConfiguration(): this;
    /**
     * (experimental) Grants permission to remove the notifications from a backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteBackupVaultNotifications.html
     *
     * @experimental
     */
    toDeleteBackupVaultNotifications(): this;
    /**
     * (experimental) Grants permission to delete a framework.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteFramework.html
     *
     * @experimental
     */
    toDeleteFramework(): this;
    /**
     * (experimental) Grants permission to delete a recovery point from a backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteRecoveryPoint.html
     *
     * @experimental
     */
    toDeleteRecoveryPoint(): this;
    /**
     * (experimental) Grants permission to delete a report plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteReportPlan.html
     *
     * @experimental
     */
    toDeleteReportPlan(): this;
    /**
     * (experimental) Grants permission to describe a backup job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeBackupJob.html
     *
     * @experimental
     */
    toDescribeBackupJob(): this;
    /**
     * (experimental) Grants permission to describe a new backup vault with the specified name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeBackupVault.html
     *
     * @experimental
     */
    toDescribeBackupVault(): this;
    /**
     * (experimental) Grants permission to describe a copy job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeCopyJob.html
     *
     * @experimental
     */
    toDescribeCopyJob(): this;
    /**
     * (experimental) Grants permission to describe a framework with the specified name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeFramework.html
     *
     * @experimental
     */
    toDescribeFramework(): this;
    /**
     * (experimental) Grants permission to describe global settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeGlobalSettings.html
     *
     * @experimental
     */
    toDescribeGlobalSettings(): this;
    /**
     * (experimental) Grants permission to describe a protected resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeProtectedResource.html
     *
     * @experimental
     */
    toDescribeProtectedResource(): this;
    /**
     * (experimental) Grants permission to describe a recovery point.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRecoveryPoint.html
     *
     * @experimental
     */
    toDescribeRecoveryPoint(): this;
    /**
     * (experimental) Grants permission to describe region settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRegionSettings.html
     *
     * @experimental
     */
    toDescribeRegionSettings(): this;
    /**
     * (experimental) Grants permission to describe a report job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeReportJob.html
     *
     * @experimental
     */
    toDescribeReportJob(): this;
    /**
     * (experimental) Grants permission to describe a report plan with the specified name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeReportPlan.html
     *
     * @experimental
     */
    toDescribeReportPlan(): this;
    /**
     * (experimental) Grants permission to describe a restore job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeRestoreJob.html
     *
     * @experimental
     */
    toDescribeRestoreJob(): this;
    /**
     * (experimental) Grants permission to disassociate a recovery point from a backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DisassociateRecoveryPoint.html
     *
     * @experimental
     */
    toDisassociateRecoveryPoint(): this;
    /**
     * (experimental) Grants permission to export a backup plan as a JSON.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ExportBackupPlanTemplate.html
     *
     * @experimental
     */
    toExportBackupPlanTemplate(): this;
    /**
     * (experimental) Grants permission to get a backup plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlan.html
     *
     * @experimental
     */
    toGetBackupPlan(): this;
    /**
     * (experimental) Grants permission to transform a JSON to a backup plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlanFromJSON.html
     *
     * @experimental
     */
    toGetBackupPlanFromJSON(): this;
    /**
     * (experimental) Grants permission to transform a template to a backup plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupPlanFromTemplate.html
     *
     * @experimental
     */
    toGetBackupPlanFromTemplate(): this;
    /**
     * (experimental) Grants permission to get a backup plan resource assignment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupSelection.html
     *
     * @experimental
     */
    toGetBackupSelection(): this;
    /**
     * (experimental) Grants permission to get backup vault access policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupVaultAccessPolicy.html
     *
     * @experimental
     */
    toGetBackupVaultAccessPolicy(): this;
    /**
     * (experimental) Grants permission to get backup vault notifications.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetBackupVaultNotifications.html
     *
     * @experimental
     */
    toGetBackupVaultNotifications(): this;
    /**
     * (experimental) Grants permission to get recovery point restore metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetRecoveryPointRestoreMetadata.html
     *
     * @experimental
     */
    toGetRecoveryPointRestoreMetadata(): this;
    /**
     * (experimental) Grants permission to get supported resource types.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_GetSupportedResourceTypes.html
     *
     * @experimental
     */
    toGetSupportedResourceTypes(): this;
    /**
     * (experimental) Grants permission to list backup jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupJobs.html
     *
     * @experimental
     */
    toListBackupJobs(): this;
    /**
     * (experimental) Grants permission to list backup plan templates provided by AWS Backup.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlanTemplates.html
     *
     * @experimental
     */
    toListBackupPlanTemplates(): this;
    /**
     * (experimental) Grants permission to list backup plan versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlanVersions.html
     *
     * @experimental
     */
    toListBackupPlanVersions(): this;
    /**
     * (experimental) Grants permission to list backup plans.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupPlans.html
     *
     * @experimental
     */
    toListBackupPlans(): this;
    /**
     * (experimental) Grants permission to list resource assignments for a specific backup plan.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupSelections.html
     *
     * @experimental
     */
    toListBackupSelections(): this;
    /**
     * (experimental) Grants permission to list backup vaults.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupVaults.html
     *
     * @experimental
     */
    toListBackupVaults(): this;
    /**
     * (experimental) Grants permission to list copy jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListCopyJobs.html
     *
     * @experimental
     */
    toListCopyJobs(): this;
    /**
     * (experimental) Grants permission to list frameworks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListFrameworks.html
     *
     * @experimental
     */
    toListFrameworks(): this;
    /**
     * (experimental) Grants permission to list protected resources by AWS Backup.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListProtectedResources.html
     *
     * @experimental
     */
    toListProtectedResources(): this;
    /**
     * (experimental) Grants permission to list recovery points inside a backup vault.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRecoveryPointsByBackupVault.html
     *
     * @experimental
     */
    toListRecoveryPointsByBackupVault(): this;
    /**
     * (experimental) Grants permission to list recovery points for a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRecoveryPointsByResource.html
     *
     * @experimental
     */
    toListRecoveryPointsByResource(): this;
    /**
     * (experimental) Grants permission to list report jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListReportJobs.html
     *
     * @experimental
     */
    toListReportJobs(): this;
    /**
     * (experimental) Grants permission to list report plans.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListReportPlans.html
     *
     * @experimental
     */
    toListReportPlans(): this;
    /**
     * (experimental) Grants permission to lists restore jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListRestoreJobs.html
     *
     * @experimental
     */
    toListRestoreJobs(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListTags.html
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Grants permission to add an access policy to the backup vault.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultAccessPolicy.html
     *
     * @experimental
     */
    toPutBackupVaultAccessPolicy(): this;
    /**
     * (experimental) Grants permission to add a lock configuration to the backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultLockConfiguration.html
     *
     * @experimental
     */
    toPutBackupVaultLockConfiguration(): this;
    /**
     * (experimental) Grants permission to add an SNS topic to the backup vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html
     *
     * @experimental
     */
    toPutBackupVaultNotifications(): this;
    /**
     * (experimental) Grants permission to start a new backup job.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartBackupJob.html
     *
     * @experimental
     */
    toStartBackupJob(): this;
    /**
     * (experimental) Grants permission to copy a backup from a source backup vault to a destination backup vault.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartCopyJob.html
     *
     * @experimental
     */
    toStartCopyJob(): this;
    /**
     * (experimental) Grants permission to start a new report job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartReportJob.html
     *
     * @experimental
     */
    toStartReportJob(): this;
    /**
     * (experimental) Grants permission to start a new restore job.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartRestoreJob.html
     *
     * @experimental
     */
    toStartRestoreJob(): this;
    /**
     * (experimental) Grants permission to stop a backup job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StopBackupJob.html
     *
     * @experimental
     */
    toStopBackupJob(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a backup plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html
     *
     * @experimental
     */
    toUpdateBackupPlan(): this;
    /**
     * (experimental) Grants permission to update a framework.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateFramework.html
     *
     * @experimental
     */
    toUpdateFramework(): this;
    /**
     * (experimental) Grants permission to update the current global settings for the AWS Account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateGlobalSettings.html
     *
     * @experimental
     */
    toUpdateGlobalSettings(): this;
    /**
     * (experimental) Grants permission to update the lifecycle of the recovery point.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRecoveryPointLifecycle.html
     *
     * @experimental
     */
    toUpdateRecoveryPointLifecycle(): this;
    /**
     * (experimental) Grants permission to update the current service opt-in settings for the Region.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateRegionSettings.html
     *
     * @experimental
     */
    toUpdateRegionSettings(): this;
    /**
     * (experimental) Grants permission to update a report plan.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFrameworkArns()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateReportPlan.html
     *
     * @experimental
     */
    toUpdateReportPlan(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type backupVault to the statement.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/vaults.html
     *
     * @param backupVaultName - Identifier for the backupVaultName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBackupVault(backupVaultName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type backupPlan to the statement.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/about-backup-plans.html
     *
     * @param backupPlanId - Identifier for the backupPlanId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBackupPlan(backupPlanId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type recoveryPoint to the statement.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/recovery-points.html
     *
     * @param recoveryPointId - Identifier for the recoveryPointId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRecoveryPoint(recoveryPointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type framework to the statement.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/frameworks.html
     *
     * @param frameworkName - Identifier for the frameworkName.
     * @param frameworkId - Identifier for the frameworkId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFramework(frameworkName: string, frameworkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type reportPlan to the statement.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/report-plans.html
     *
     * @param reportPlanName - Identifier for the reportPlanName.
     * @param reportPlanId - Identifier for the reportPlanId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onReportPlan(reportPlanName: string, reportPlanId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the organization unit.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toCopyFromBackupVault()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCopyTargetOrgPaths(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of an backup vault.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toCopyFromBackupVault()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCopyTargets(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the Framework ARNs.
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#amazon-backup-keys
     *
     * Applies to actions:
     * - .toCreateReportPlan()
     * - .toUpdateReportPlan()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifFrameworkArns(value: string | string[], operator?: Operator | string): this;
}
