import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [wisdom](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectwisdom.html).
 *
 * @experimental
 */
export declare class Wisdom extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [wisdom](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectwisdom.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an assistant.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAssistant.html
     *
     * @experimental
     */
    toCreateAssistant(): this;
    /**
     * (experimental) Grants permission to create an association between an assistant and another resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAssistantAssociation.html
     *
     * @experimental
     */
    toCreateAssistantAssociation(): this;
    /**
     * (experimental) Grants permission to create content.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html
     *
     * @experimental
     */
    toCreateContent(): this;
    /**
     * (experimental) Grants permission to create a knowledge base.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateKnowledgeBase.html
     *
     * @experimental
     */
    toCreateKnowledgeBase(): this;
    /**
     * (experimental) Grants permission to create a session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateSession.html
     *
     * @experimental
     */
    toCreateSession(): this;
    /**
     * (experimental) Grants permission to delete an assistant.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAssistant.html
     *
     * @experimental
     */
    toDeleteAssistant(): this;
    /**
     * (experimental) Grants permission to delete an assistant association.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAssistantAssociation.html
     *
     * @experimental
     */
    toDeleteAssistantAssociation(): this;
    /**
     * (experimental) Grants permission to delete content.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteContent.html
     *
     * @experimental
     */
    toDeleteContent(): this;
    /**
     * (experimental) Grants permission to delete a knowledge base.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html
     *
     * @experimental
     */
    toDeleteKnowledgeBase(): this;
    /**
     * (experimental) Grants permission to retrieve information about an assistant.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAssistant.html
     *
     * @experimental
     */
    toGetAssistant(): this;
    /**
     * (experimental) Grants permission to retrieve information about an assistant association.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAssistantAssociation.html
     *
     * @experimental
     */
    toGetAssistantAssociation(): this;
    /**
     * (experimental) Grants permission to retrieve content, including a pre-signed URL to download the content.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html
     *
     * @experimental
     */
    toGetContent(): this;
    /**
     * (experimental) Grants permission to retrieve summary information about the content.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContentSummary.html
     *
     * @experimental
     */
    toGetContentSummary(): this;
    /**
     * (experimental) Grants permission to retrieve information about the knowledge base.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetKnowledgeBase.html
     *
     * @experimental
     */
    toGetKnowledgeBase(): this;
    /**
     * (experimental) Grants permission to retrieve recommendations for the specified session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html
     *
     * @experimental
     */
    toGetRecommendations(): this;
    /**
     * (experimental) Grants permission to retrieve information for a specified session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetSession.html
     *
     * @experimental
     */
    toGetSession(): this;
    /**
     * (experimental) Grants permission to list information about assistant associations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAssistantAssociations.html
     *
     * @experimental
     */
    toListAssistantAssociations(): this;
    /**
     * (experimental) Grants permission to list information about assistants.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAssistants.html
     *
     * @experimental
     */
    toListAssistants(): this;
    /**
     * (experimental) Grants permission to list the content with a knowledge base.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListContents.html
     *
     * @experimental
     */
    toListContents(): this;
    /**
     * (experimental) Grants permission to list information about knowledge bases.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListKnowledgeBases.html
     *
     * @experimental
     */
    toListKnowledgeBases(): this;
    /**
     * (experimental) Grants permission to list the tags for the specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to remove the specified recommendations from the specified assistant's queue of newly available recommendations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html
     *
     * @experimental
     */
    toNotifyRecommendationsReceived(): this;
    /**
     * (experimental) Grants permission to perform a manual search against the specified assistant.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html
     *
     * @experimental
     */
    toQueryAssistant(): this;
    /**
     * (experimental) Grants permission to remove a URI template from a knowledge base.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_RemoveKnowledgeBaseTemplateUri.html
     *
     * @experimental
     */
    toRemoveKnowledgeBaseTemplateUri(): this;
    /**
     * (experimental) Grants permission to search for content referencing a specified knowledge base.
     *
     * Can be used to get a specific content resource by its name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html
     *
     * @experimental
     */
    toSearchContent(): this;
    /**
     * (experimental) Grants permission to search for sessions referencing a specified assistant.
     *
     * Can be used to et a specific session resource by its name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchSessions.html
     *
     * @experimental
     */
    toSearchSessions(): this;
    /**
     * (experimental) Grants permission to get a URL to upload content to a knowledge base.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html
     *
     * @experimental
     */
    toStartContentUpload(): this;
    /**
     * (experimental) Grants permission to add the specified tags to the specified resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the specified resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update information about the content.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html
     *
     * @experimental
     */
    toUpdateContent(): this;
    /**
     * (experimental) Grants permission to update the template URI of a knowledge base.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateKnowledgeBaseTemplateUri.html
     *
     * @experimental
     */
    toUpdateKnowledgeBaseTemplateUri(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Assistant to the statement.
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AssistantData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAssistant(assistantId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type AssistantAssociation to the statement.
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AssistantAssociationData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param assistantAssociationId - Identifier for the assistantAssociationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAssistantAssociation(assistantId: string, assistantAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Content to the statement.
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ContentData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param contentId - Identifier for the contentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onContent(knowledgeBaseId: string, contentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type KnowledgeBase to the statement.
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_KnowledgeBaseData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onKnowledgeBase(knowledgeBaseId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Session to the statement.
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SessionData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSession(assistantId: string, sessionId: string, account?: string, region?: string, partition?: string): this;
}
