# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.5.1, generator: @autorest/python@5.9.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, Callable, Dict, Generic, IO, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest

from ... import models as _models
from ...operations._affinda_api_operations import build_create_redacted_resume_request, build_create_reformatted_resume_request, build_create_resume_request, build_delete_redacted_resume_request, build_delete_reformatted_resume_request, build_delete_resume_request, build_get_all_redacted_resumes_request, build_get_all_reformatted_resumes_request, build_get_all_resume_formats_request, build_get_all_resumes_request, build_get_redacted_resume_request, build_get_reformatted_resume_request, build_get_resume_request

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class AffindaAPIOperationsMixin:

    async def get_all_resumes(
        self,
        **kwargs: Any
    ) -> Union["_models.GetAllDocumentsResults", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema"]:
        """Gets summary information for all resumes of a user.

        Returns all the resume summaries for that user, limited to 300 per page.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or
         ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.GetAllDocumentsResults", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_all_resumes_request(
            limit=self._config.limit,
            offset=self._config.offset,
            template_url=self.get_all_resumes.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('GetAllDocumentsResults', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resumes.metadata = {'url': '/resumes'}  # type: ignore


    async def create_resume(
        self,
        file: Optional[IO] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        url: Optional[str] = None,
        wait: Optional[bool] = None,
        resume_language: Optional[str] = None,
        expiry_time: Optional[str] = None,
        **kwargs: Any
    ) -> Union["_models.Resume", "_models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Uploads a resume for parsing.

        Uploads a resume for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/resumes/{identifier} <#operation/getResume>`_ endpoint to check processing status and
        retrieve results.

        :param file:
        :type file: IO
        :param identifier:
        :type identifier: str
        :param file_name:
        :type file_name: str
        :param url:
        :type url: str
        :param wait:
        :type wait: bool
        :param resume_language:
        :type resume_language: str
        :param expiry_time:
        :type expiry_time: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or Components8Sxs33Responses400ErrorContentApplicationJsonSchema or
         ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.Resume or
         ~affinda.models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.Resume", "_models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', None)  # type: Optional[str]

        files = None
        data = None
        # Construct form data
        files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "wait": wait,
            "resumeLanguage": resume_language,
            "expiryTime": expiry_time,
        }

        request = build_create_resume_request(
            content_type=content_type,
            files=files,
            data=data,
            template_url=self.create_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('Resume', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('Resume', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('Components8Sxs33Responses400ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume.metadata = {'url': '/resumes'}  # type: ignore


    async def get_resume(
        self,
        identifier: str,
        **kwargs: Any
    ) -> Union["_models.Resume", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Gets parse results for a specific resume.

        Returns all the parse results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#operation/createResume>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.Resume or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.Resume", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_resume_request(
            identifier=identifier,
            template_url=self.get_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('Resume', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume.metadata = {'url': '/resumes/{identifier}'}  # type: ignore


    async def delete_resume(
        self,
        identifier: str,
        **kwargs: Any
    ) -> Optional[Union["_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]:
        """Deletes a resume.

        Deletes the specified resume from the database.

        :param identifier: Resume identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[Union["_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_resume_request(
            identifier=identifier,
            template_url=self.delete_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_resume.metadata = {'url': '/resumes/{identifier}'}  # type: ignore


    async def get_all_redacted_resumes(
        self,
        **kwargs: Any
    ) -> Union["_models.GetAllDocumentsResults", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Gets summary information for all redacted resumes of a user.

        Returns all the redacted resume information for that resume.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or
         ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.GetAllDocumentsResults", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_all_redacted_resumes_request(
            limit=self._config.limit,
            offset=self._config.offset,
            template_url=self.get_all_redacted_resumes.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('GetAllDocumentsResults', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_redacted_resumes.metadata = {'url': '/redacted_resumes'}  # type: ignore


    async def create_redacted_resume(
        self,
        file: Optional[IO] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        url: Optional[str] = None,
        resume_language: Optional[str] = None,
        wait: Optional[bool] = None,
        redact_headshot: Optional[bool] = True,
        redact_personal_details: Optional[bool] = True,
        redact_work_details: Optional[bool] = True,
        redact_education_details: Optional[bool] = True,
        redact_referees: Optional[bool] = True,
        redact_locations: Optional[bool] = True,
        redact_dates: Optional[bool] = True,
        expiry_time: Optional[str] = None,
        **kwargs: Any
    ) -> Union["_models.RedactedResume", "_models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Uploads a resume for redacting.

        Uploads a resume for redacting.

        :param file:
        :type file: IO
        :param identifier:
        :type identifier: str
        :param file_name:
        :type file_name: str
        :param url:
        :type url: str
        :param resume_language:
        :type resume_language: str
        :param wait:
        :type wait: bool
        :param redact_headshot: Whether to redact headshot.
        :type redact_headshot: bool
        :param redact_personal_details: Whether to redact personal details (e.g. name, address).
        :type redact_personal_details: bool
        :param redact_work_details: Whether to redact work details (e.g. company names).
        :type redact_work_details: bool
        :param redact_education_details: Whether to redact education details (e.g. university names).
        :type redact_education_details: bool
        :param redact_referees: Whether to redact referee details.
        :type redact_referees: bool
        :param redact_locations: Whether to redact location names.
        :type redact_locations: bool
        :param redact_dates: Whether to redact dates.
        :type redact_dates: bool
        :param expiry_time:
        :type expiry_time: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume or Components8Sxs33Responses400ErrorContentApplicationJsonSchema or
         ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume or
         ~affinda.models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.RedactedResume", "_models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', None)  # type: Optional[str]

        files = None
        data = None
        # Construct form data
        files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "resumeLanguage": resume_language,
            "wait": wait,
            "redactHeadshot": redact_headshot,
            "redactPersonalDetails": redact_personal_details,
            "redactWorkDetails": redact_work_details,
            "redactEducationDetails": redact_education_details,
            "redactReferees": redact_referees,
            "redactLocations": redact_locations,
            "redactDates": redact_dates,
            "expiryTime": expiry_time,
        }

        request = build_create_redacted_resume_request(
            content_type=content_type,
            files=files,
            data=data,
            template_url=self.create_redacted_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('RedactedResume', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('RedactedResume', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('Components8Sxs33Responses400ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_redacted_resume.metadata = {'url': '/redacted_resumes'}  # type: ignore


    async def get_redacted_resume(
        self,
        identifier: str,
        **kwargs: Any
    ) -> Union["_models.RedactedResume", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Gets redaction results for a specific resume.

        Returns all the redaction results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/redacted_resumes <#operation/createRedactedResume>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume or ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.RedactedResume", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_redacted_resume_request(
            identifier=identifier,
            template_url=self.get_redacted_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('RedactedResume', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_redacted_resume.metadata = {'url': '/redacted_resumes/{identifier}'}  # type: ignore


    async def delete_redacted_resume(
        self,
        identifier: str,
        **kwargs: Any
    ) -> Optional[Union["_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]:
        """Deletes a redacted resume.

        Deletes the specified resume from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[Union["_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_redacted_resume_request(
            identifier=identifier,
            template_url=self.delete_redacted_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_redacted_resume.metadata = {'url': '/redacted_resumes/{identifier}'}  # type: ignore


    async def get_all_resume_formats(
        self,
        **kwargs: Any
    ) -> Union["_models.Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Gets summary information for all resume formats of a user.

        Returns all the resume formats.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema or
         ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_all_resume_formats_request(
            limit=self._config.limit,
            offset=self._config.offset,
            template_url=self.get_all_resume_formats.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resume_formats.metadata = {'url': '/resume_formats'}  # type: ignore


    async def get_all_reformatted_resumes(
        self,
        **kwargs: Any
    ) -> Union["_models.GetAllDocumentsResults", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Gets summary information for all reformatted resumes of a user.

        Returns all the reformatted resume information for that resume.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or
         ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.GetAllDocumentsResults", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_all_reformatted_resumes_request(
            limit=self._config.limit,
            offset=self._config.offset,
            template_url=self.get_all_reformatted_resumes.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('GetAllDocumentsResults', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_reformatted_resumes.metadata = {'url': '/reformatted_resumes'}  # type: ignore


    async def create_reformatted_resume(
        self,
        resume_format: str,
        file: Optional[IO] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        url: Optional[str] = None,
        resume_language: Optional[str] = None,
        wait: Optional[bool] = None,
        **kwargs: Any
    ) -> Union["_models.ReformattedResume", "_models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Uploads a resume for reformatting.

        Uploads a resume for reformatting.

        :param resume_format:
        :type resume_format: str
        :param file:
        :type file: IO
        :param identifier:
        :type identifier: str
        :param file_name:
        :type file_name: str
        :param url:
        :type url: str
        :param resume_language:
        :type resume_language: str
        :param wait:
        :type wait: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReformattedResume or Components8Sxs33Responses400ErrorContentApplicationJsonSchema or
         ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.ReformattedResume or
         ~affinda.models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.ReformattedResume", "_models.Components8Sxs33Responses400ErrorContentApplicationJsonSchema", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', None)  # type: Optional[str]

        files = None
        data = None
        # Construct form data
        files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "resumeLanguage": resume_language,
            "resumeFormat": resume_format,
            "wait": wait,
        }

        request = build_create_reformatted_resume_request(
            content_type=content_type,
            files=files,
            data=data,
            template_url=self.create_reformatted_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('ReformattedResume', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('ReformattedResume', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('Components8Sxs33Responses400ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_reformatted_resume.metadata = {'url': '/reformatted_resumes'}  # type: ignore


    async def get_reformatted_resume(
        self,
        identifier: str,
        **kwargs: Any
    ) -> Union["_models.ReformattedResume", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]:
        """Gets reformatting results for a specific resume.

        Returns all the reformatting results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/reformatted_resumes <#operation/createReformattedResume>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReformattedResume or ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.ReformattedResume or
         ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.ReformattedResume", "_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_reformatted_resume_request(
            identifier=identifier,
            template_url=self.get_reformatted_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('ReformattedResume', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_reformatted_resume.metadata = {'url': '/reformatted_resumes/{identifier}'}  # type: ignore


    async def delete_reformatted_resume(
        self,
        identifier: str,
        **kwargs: Any
    ) -> Optional[Union["_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]:
        """Deletes a reformatted resume.

        Deletes the specified resume from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema, or the result of cls(response)
        :rtype: ~affinda.models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema or
         ~affinda.models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[Union["_models.ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema", "_models.ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema"]]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_reformatted_resume_request(
            identifier=identifier,
            template_url=self.delete_reformatted_resume.metadata['url'],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ComponentsMzfa75Responses401ErrorContentApplicationJsonSchema', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ComponentsP4H6CrResponses404ErrorContentApplicationJsonSchema', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_reformatted_resume.metadata = {'url': '/reformatted_resumes/{identifier}'}  # type: ignore

