# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.4, generator: @autorest/python@5.16.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._affinda_api_operations import (
    build_create_collection_request,
    build_create_data_point_request,
    build_create_document_request,
    build_create_extractor_request,
    build_create_index_document_request,
    build_create_index_request,
    build_create_invitation_request,
    build_create_invoice_request,
    build_create_job_description_request,
    build_create_job_description_search_embed_url_request,
    build_create_job_description_search_request,
    build_create_organization_request,
    build_create_redacted_resume_request,
    build_create_resume_request,
    build_create_resume_search_embed_url_request,
    build_create_resume_search_request,
    build_create_tag_request,
    build_create_user_request,
    build_create_workspace_membership_request,
    build_create_workspace_request,
    build_delete_collection_request,
    build_delete_data_point_request,
    build_delete_document_request,
    build_delete_extractor_request,
    build_delete_index_document_request,
    build_delete_index_request,
    build_delete_invitation_request,
    build_delete_invoice_request,
    build_delete_job_description_request,
    build_delete_organization_membership_request,
    build_delete_organization_request,
    build_delete_redacted_resume_request,
    build_delete_resume_request,
    build_delete_tag_request,
    build_delete_workspace_membership_request,
    build_delete_workspace_request,
    build_get_all_collections_request,
    build_get_all_data_points_request,
    build_get_all_documents_request,
    build_get_all_extractors_request,
    build_get_all_index_documents_request,
    build_get_all_indexes_request,
    build_get_all_invitations_request,
    build_get_all_invoices_request,
    build_get_all_job_descriptions_request,
    build_get_all_organization_memberships_request,
    build_get_all_organizations_request,
    build_get_all_redacted_resumes_request,
    build_get_all_resumes_request,
    build_get_all_tags_request,
    build_get_all_users_request,
    build_get_all_workspace_memberships_request,
    build_get_all_workspaces_request,
    build_get_collection_request,
    build_get_data_point_request,
    build_get_document_request,
    build_get_extractor_request,
    build_get_invitation_by_token_request,
    build_get_invitation_request,
    build_get_invoice_request,
    build_get_job_description_request,
    build_get_job_description_search_config_request,
    build_get_job_description_search_detail_request,
    build_get_organization_membership_request,
    build_get_organization_request,
    build_get_redacted_resume_request,
    build_get_resume_request,
    build_get_resume_search_config_request,
    build_get_resume_search_detail_request,
    build_get_resume_search_match_request,
    build_get_resume_search_suggestion_job_title_request,
    build_get_resume_search_suggestion_skill_request,
    build_get_tag_request,
    build_get_workspace_membership_request,
    build_get_workspace_request,
    build_list_occupation_groups_request,
    build_respond_to_invitation_request,
    build_update_collection_data_request,
    build_update_data_point_data_request,
    build_update_document_data_request,
    build_update_extractor_data_request,
    build_update_invitation_request,
    build_update_job_description_search_config_request,
    build_update_organization_membership_request,
    build_update_organization_request,
    build_update_resume_data_request,
    build_update_resume_search_config_request,
    build_update_tag_data_request,
    build_update_workspace_request,
)

T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]
]


class AffindaAPIOperationsMixin:  # pylint: disable=too-many-public-methods
    async def get_all_resumes(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> _models.GetAllDocumentsResults:
        """Get list of all resumes.

        Returns all the resume summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.GetAllDocumentsResults]

        request = build_get_all_resumes_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_resumes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resumes.metadata = {"url": "/resumes"}  # type: ignore

    async def create_resume(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        data: Optional[_models.ResumeData] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> _models.Resume:
        """Upload a resume for parsing.

        Uploads a resume for parsing. When successful, returns an ``identifier`` in the response for
        subsequent use with the `/resumes/{identifier} <#get-/resumes/-identifier->`_ endpoint to check
        processing status and retrieve results.:code:`<br/>`
        Resumes can be uploaded as a file or a URL. In addition, data can be added directly if users
        want to upload directly without parsing any resume file. For uploading resume data, the
        ``data`` argument provided must be a JSON-encoded string. Data uploads will not impact upon
        parsing credits.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param data:  Default value is None.
        :type data: ~affinda.models.ResumeData
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is False.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume, or the result of cls(response)
        :rtype: ~affinda.models.Resume
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Resume]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "data": data,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_resume_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Resume", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume.metadata = {"url": "/resumes"}  # type: ignore

    async def get_resume(
        self, identifier: str, format: Optional[str] = None, **kwargs: Any
    ) -> Union[_models.Resume, _models.RequestError]:
        """Get parse results for a specific resume.

        Returns all the parse results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#post-/resumes>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :param format: Set this to "hr-xml" to get the response in HR-XML format. Currently the only
         supported value for this parameter is "hr-xml". Default value is None.
        :type format: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Resume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Union[_models.Resume, _models.RequestError]]

        request = build_get_resume_request(
            identifier=identifier,
            format=format,
            template_url=self.get_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 200, 400, 400, 401, 401, 404, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    async def update_resume_data(
        self, identifier: str, body: _models.ResumeData, **kwargs: Any
    ) -> Optional[_models.ResumeData]:
        """Update a resume's data.

        Update data of a parsed resume.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#post-/resumes>`_ endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Resume data to update.
        :type body: ~affinda.models.ResumeData
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeData or None, or the result of cls(response)
        :rtype: ~affinda.models.ResumeData or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.ResumeData]]

        _json = self._serialize.body(body, "ResumeData")

        request = build_update_resume_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeData", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_data.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    async def delete_resume(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a resume.

        Deletes the specified resume from the database.

        :param identifier: Resume identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_resume_request(
            identifier=identifier,
            template_url=self.delete_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_resume.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    async def get_all_redacted_resumes(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> _models.GetAllDocumentsResults:
        """Get list of all redacted resumes.

        Returns all the redacted resume information for that resume.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.GetAllDocumentsResults]

        request = build_get_all_redacted_resumes_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_redacted_resumes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_redacted_resumes.metadata = {"url": "/redacted_resumes"}  # type: ignore

    async def create_redacted_resume(
        self,
        file: Optional[IO] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        url: Optional[str] = None,
        language: Optional[str] = None,
        wait: Optional[bool] = True,
        redact_headshot: Optional[bool] = True,
        redact_personal_details: Optional[bool] = True,
        redact_work_details: Optional[bool] = True,
        redact_education_details: Optional[bool] = True,
        redact_referees: Optional[bool] = True,
        redact_locations: Optional[bool] = True,
        redact_dates: Optional[bool] = True,
        redact_gender: Optional[str] = "true",
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> _models.RedactedResume:
        """Upload a resume for redacting.

        Uploads a resume for redacting.

        :param file:  Default value is None.
        :type file: IO
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param url:  Default value is None.
        :type url: str
        :param language:  Default value is None.
        :type language: str
        :param wait:  Default value is True.
        :type wait: bool
        :param redact_headshot: Whether to redact headshot. Default value is True.
        :type redact_headshot: bool
        :param redact_personal_details: Whether to redact personal details (e.g. name, address).
         Default value is True.
        :type redact_personal_details: bool
        :param redact_work_details: Whether to redact work details (e.g. company names). Default value
         is True.
        :type redact_work_details: bool
        :param redact_education_details: Whether to redact education details (e.g. university names).
         Default value is True.
        :type redact_education_details: bool
        :param redact_referees: Whether to redact referee details. Default value is True.
        :type redact_referees: bool
        :param redact_locations: Whether to redact location names. Default value is True.
        :type redact_locations: bool
        :param redact_dates: Whether to redact dates. Default value is True.
        :type redact_dates: bool
        :param redact_gender: Whether to redact gender. Default value is "true".
        :type redact_gender: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.RedactedResume]

        # Construct form data
        _files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "language": language,
            "wait": wait,
            "redactHeadshot": redact_headshot,
            "redactPersonalDetails": redact_personal_details,
            "redactWorkDetails": redact_work_details,
            "redactEducationDetails": redact_education_details,
            "redactReferees": redact_referees,
            "redactLocations": redact_locations,
            "redactDates": redact_dates,
            "redactGender": redact_gender,
            "expiryTime": expiry_time,
        }

        request = build_create_redacted_resume_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_redacted_resume.metadata = {"url": "/redacted_resumes"}  # type: ignore

    async def get_redacted_resume(self, identifier: str, **kwargs: Any) -> _models.RedactedResume:
        """Get redaction results for a specific resume.

        Returns all the redaction results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/redacted_resumes <#post-/redacted_resumes>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.RedactedResume]

        request = build_get_redacted_resume_request(
            identifier=identifier,
            template_url=self.get_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RedactedResume", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_redacted_resume.metadata = {"url": "/redacted_resumes/{identifier}"}  # type: ignore

    async def delete_redacted_resume(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a redacted resume.

        Deletes the specified resume from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_redacted_resume_request(
            identifier=identifier,
            template_url=self.delete_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_redacted_resume.metadata = {"url": "/redacted_resumes/{identifier}"}  # type: ignore

    async def create_resume_search(
        self,
        body: _models.ResumeSearchParameters,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        **kwargs: Any,
    ) -> _models.ResumeSearch:
        """Search through parsed resumes.

        Searches through parsed resumes. Users have 3 options to create a search::code:`<br
        />`:code:`<br />` 1.    Match to a job description - a parsed job description is used to find
        candidates that suit it:code:`<br />` 2.  Match to a resume - a parsed resume is used to find
        other candidates that have similar attributes:code:`<br />` 3.  Search using custom
        criteria:code:`<br />`:code:`<br />` Users should only populate 1 of jobDescription, resume or
        the custom criteria.

        :param body: Search parameters.
        :type body: ~affinda.models.ResumeSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearch, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearch]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_create_resume_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_resume_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search.metadata = {"url": "/resume_search"}  # type: ignore

    async def get_resume_search_detail(
        self, identifier: str, body: _models.ResumeSearchParameters, **kwargs: Any
    ) -> _models.ResumeSearchDetail:
        """Get search result of specific resume.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this resume.
        The ``identifier`` is the unique ID returned via the `/resume_search <#post-/resume_search>`_
        endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda.models.ResumeSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchDetail, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchDetail
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchDetail]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_get_resume_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_resume_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchDetail", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_detail.metadata = {"url": "/resume_search/details/{identifier}"}  # type: ignore

    async def get_resume_search_match(
        self,
        resume: str,
        job_description: str,
        index: Optional[str] = None,
        search_expression: Optional[str] = None,
        job_titles_weight: Optional[float] = None,
        years_experience_weight: Optional[float] = None,
        locations_weight: Optional[float] = None,
        languages_weight: Optional[float] = None,
        skills_weight: Optional[float] = None,
        education_weight: Optional[float] = None,
        search_expression_weight: Optional[float] = None,
        soc_codes_weight: Optional[float] = None,
        management_level_weight: Optional[float] = None,
        **kwargs: Any,
    ) -> _models.ResumeSearchMatch:
        """Match a single resume and job description.

        Get the matching score between a resume and a job description. The score ranges between 0 and
        1, with 0 being not a match at all, and 1 being perfect match.:code:`<br/>` Note, this score
        will not directly match the score returned from POST `/resume_search/details/{identifier}
        <#post-/resume_search/details/-identifier->`_.

        :param resume: Identify the resume to match.
        :type resume: str
        :param job_description: Identify the job description to match.
        :type job_description: str
        :param index: Optionally, specify an index to search in. If not specified, will search in all
         indexes. Default value is None.
        :type index: str
        :param search_expression: Add keywords to the search criteria. Default value is None.
        :type search_expression: str
        :param job_titles_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type job_titles_weight: float
        :param years_experience_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type years_experience_weight: float
        :param locations_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type locations_weight: float
        :param languages_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type languages_weight: float
        :param skills_weight: How important is this criteria to the matching score, range from 0 to 1.
         Default value is None.
        :type skills_weight: float
        :param education_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type education_weight: float
        :param search_expression_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type search_expression_weight: float
        :param soc_codes_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type soc_codes_weight: float
        :param management_level_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type management_level_weight: float
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchMatch, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchMatch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchMatch]

        request = build_get_resume_search_match_request(
            resume=resume,
            job_description=job_description,
            index=index,
            search_expression=search_expression,
            job_titles_weight=job_titles_weight,
            years_experience_weight=years_experience_weight,
            locations_weight=locations_weight,
            languages_weight=languages_weight,
            skills_weight=skills_weight,
            education_weight=education_weight,
            search_expression_weight=search_expression_weight,
            soc_codes_weight=soc_codes_weight,
            management_level_weight=management_level_weight,
            template_url=self.get_resume_search_match.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchMatch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_match.metadata = {"url": "/resume_search/match"}  # type: ignore

    async def get_resume_search_config(self, **kwargs: Any) -> _models.ResumeSearchConfig:
        """Get the config for the logged in user's embeddable resume search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchConfig]

        request = build_get_resume_search_config_request(
            template_url=self.get_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_config.metadata = {"url": "/resume_search/config"}  # type: ignore

    async def update_resume_search_config(
        self, body: _models.ResumeSearchConfig, **kwargs: Any
    ) -> _models.ResumeSearchConfig:
        """Update the config for the logged in user's embeddable resume search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :param body:
        :type body: ~affinda.models.ResumeSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchConfig]

        _json = self._serialize.body(body, "ResumeSearchConfig")

        request = build_update_resume_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_search_config.metadata = {"url": "/resume_search/config"}  # type: ignore

    async def create_resume_search_embed_url(
        self,
        body: Optional[
            _models.Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        ] = None,
        **kwargs: Any,
    ) -> _models.ResumeSearchEmbed:
        """Create a signed URL for the embeddable resume search tool.

        Create and return a signed URL of the resume search tool which then can be embedded on a web
        page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable resume search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda.models.Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchEmbed, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchEmbed
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchEmbed]

        if body is not None:
            _json = self._serialize.body(
                body, "Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema"
            )
        else:
            _json = None

        request = build_create_resume_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_resume_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchEmbed", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search_embed_url.metadata = {"url": "/resume_search/embed"}  # type: ignore

    async def get_resume_search_suggestion_job_title(
        self, job_titles: List[str], **kwargs: Any
    ) -> List[str]:
        """Get job title suggestions based on provided job title(s).

        Provided one or more job titles, get related suggestions for your search.

        :param job_titles: Job title to query suggestions for.
        :type job_titles: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of str, or the result of cls(response)
        :rtype: list[str]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[str]]

        request = build_get_resume_search_suggestion_job_title_request(
            job_titles=job_titles,
            template_url=self.get_resume_search_suggestion_job_title.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[str]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_suggestion_job_title.metadata = {"url": "/resume_search/suggestion_job_title"}  # type: ignore

    async def get_resume_search_suggestion_skill(
        self, skills: List[str], **kwargs: Any
    ) -> List[str]:
        """Get skill suggestions based on provided skill(s).

        Provided one or more skills, get related suggestions for your search.

        :param skills: Skill to query suggestions for.
        :type skills: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of str, or the result of cls(response)
        :rtype: list[str]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[str]]

        request = build_get_resume_search_suggestion_skill_request(
            skills=skills,
            template_url=self.get_resume_search_suggestion_skill.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[str]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_suggestion_skill.metadata = {"url": "/resume_search/suggestion_skill"}  # type: ignore

    async def get_all_job_descriptions(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> _models.GetAllJobDescriptionsResults:
        """Get list of all job descriptions.

        Returns all the job descriptions for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllJobDescriptionsResults, or the result of cls(response)
        :rtype: ~affinda.models.GetAllJobDescriptionsResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.GetAllJobDescriptionsResults]

        request = build_get_all_job_descriptions_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_job_descriptions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("GetAllJobDescriptionsResults", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_job_descriptions.metadata = {"url": "/job_descriptions"}  # type: ignore

    async def create_job_description(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> _models.JobDescription:
        """Upload a job description for parsing.

        Uploads a job description for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/job_descriptions/{identifier} <#get-/job_descriptions/-identifier->`_ endpoint to check
        processing status and retrieve results.
        Job Descriptions can be uploaded as a file or a URL.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is False.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescription, or the result of cls(response)
        :rtype: ~affinda.models.JobDescription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescription]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_job_description_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description.metadata = {"url": "/job_descriptions"}  # type: ignore

    async def get_job_description(self, identifier: str, **kwargs: Any) -> _models.JobDescription:
        """Get job description results for a specific job description file.

        Returns all the results for that job description if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/job_descriptions <#post-/job_descriptions>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescription, or the result of cls(response)
        :rtype: ~affinda.models.JobDescription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescription]

        request = build_get_job_description_request(
            identifier=identifier,
            template_url=self.get_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description.metadata = {"url": "/job_descriptions/{identifier}"}  # type: ignore

    async def delete_job_description(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a job description.

        Deletes the specified job description from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_job_description_request(
            identifier=identifier,
            template_url=self.delete_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_job_description.metadata = {"url": "/job_descriptions/{identifier}"}  # type: ignore

    async def create_job_description_search(
        self,
        body: _models.JobDescriptionSearchParameters,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        **kwargs: Any,
    ) -> _models.JobDescriptionSearch:
        """Search through parsed job descriptions.

        Searches through parsed job descriptions. You can search with custom criterias or a resume.

        :param body: Search parameters.
        :type body: ~affinda.models.JobDescriptionSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearch, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearch]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_create_job_description_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_job_description_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search.metadata = {"url": "/job_description_search"}  # type: ignore

    async def get_job_description_search_detail(
        self, identifier: str, body: _models.JobDescriptionSearchParameters, **kwargs: Any
    ) -> _models.JobDescriptionSearchDetail:
        """Get search result of specific job description.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this job description.
        The ``identifier`` is the unique ID returned via the `/job_description_search
        <#post-/job_description_search>`_ endpoint.

        :param identifier: Job Description identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda.models.JobDescriptionSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchDetail, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchDetail
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchDetail]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_get_job_description_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_job_description_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchDetail", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_detail.metadata = {"url": "/job_description_search/details/{identifier}"}  # type: ignore

    async def get_job_description_search_config(
        self, **kwargs: Any
    ) -> _models.JobDescriptionSearchConfig:
        """Get the config for the logged in user's embeddable job description search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchConfig]

        request = build_get_job_description_search_config_request(
            template_url=self.get_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_config.metadata = {"url": "/job_description_search/config"}  # type: ignore

    async def update_job_description_search_config(
        self, body: _models.JobDescriptionSearchConfig, **kwargs: Any
    ) -> _models.JobDescriptionSearchConfig:
        """Update the config for the logged in user's embeddable job description search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :param body:
        :type body: ~affinda.models.JobDescriptionSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchConfig]

        _json = self._serialize.body(body, "JobDescriptionSearchConfig")

        request = build_update_job_description_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_job_description_search_config.metadata = {"url": "/job_description_search/config"}  # type: ignore

    async def create_job_description_search_embed_url(
        self,
        body: Optional[
            _models.PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        ] = None,
        **kwargs: Any,
    ) -> _models.JobDescriptionSearchEmbed:
        """Create a signed URL for the embeddable job description search tool.

        Create and return a signed URL of the job description search tool which then can be embedded on
        a web page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda.models.PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchEmbed, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchEmbed
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchEmbed]

        if body is not None:
            _json = self._serialize.body(
                body,
                "PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema",
            )
        else:
            _json = None

        request = build_create_job_description_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_job_description_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchEmbed", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search_embed_url.metadata = {"url": "/job_description_search/embed"}  # type: ignore

    async def get_all_indexes(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        document_type: Optional[Union[str, "_models.Enum2"]] = None,
        **kwargs: Any,
    ) -> _models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema:
        """Get list of all indexes.

        Returns all the indexes.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param document_type: Filter indices by a document type. Default value is None.
        :type document_type: str or ~affinda.models.Enum2
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[_models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_indexes_request(
            offset=offset,
            limit=limit,
            document_type=document_type,
            template_url=self.get_all_indexes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_indexes.metadata = {"url": "/index"}  # type: ignore

    async def create_index(
        self,
        name: Optional[str] = None,
        document_type: Optional[Union[str, "_models.PostContentSchemaDocumentType"]] = None,
        **kwargs: Any,
    ) -> _models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema:
        """Create a new index.

        Create an index for the search tool.

        :param name:  Default value is None.
        :type name: str
        :param document_type:  Default value is None.
        :type document_type: str or ~affinda.models.PostContentSchemaDocumentType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[_models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema]

        # Construct form data
        _files = {
            "name": name,
            "documentType": document_type,
        }

        request = build_create_index_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index.metadata = {"url": "/index"}  # type: ignore

    async def delete_index(  # pylint: disable=inconsistent-return-statements
        self, name: str, **kwargs: Any
    ) -> None:
        """Delete an index.

        Deletes the specified index from the database.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_index_request(
            name=name,
            template_url=self.delete_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_index.metadata = {"url": "/index/{name}"}  # type: ignore

    async def get_all_index_documents(
        self, name: str, **kwargs: Any
    ) -> _models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema:
        """Get indexed documents for a specific index.

        Returns all the indexed documents for that index.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[_models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_index_documents_request(
            name=name,
            template_url=self.get_all_index_documents.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_index_documents.metadata = {"url": "/index/{name}/documents"}  # type: ignore

    async def create_index_document(
        self,
        name: str,
        body: _models.PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema,
        **kwargs: Any,
    ) -> _models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema:
        """Index a new document.

        Create an indexed document for the search tool.

        :param name: Index name.
        :type name: str
        :param body: Document to index.
        :type body:
         ~affinda.models.PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[_models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema]

        _json = self._serialize.body(
            body, "PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema"
        )

        request = build_create_index_document_request(
            name=name,
            content_type=content_type,
            json=_json,
            template_url=self.create_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index_document.metadata = {"url": "/index/{name}/documents"}  # type: ignore

    async def delete_index_document(  # pylint: disable=inconsistent-return-statements
        self, name: str, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an indexed document.

        Delete the specified indexed document from the database.

        :param name: Index name.
        :type name: str
        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_index_document_request(
            name=name,
            identifier=identifier,
            template_url=self.delete_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_index_document.metadata = {"url": "/index/{name}/documents/{identifier}"}  # type: ignore

    async def get_all_invoices(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> _models.GetAllInvoicesResults:
        """Get list of all invoices.

        Returns all the invoice summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllInvoicesResults, or the result of cls(response)
        :rtype: ~affinda.models.GetAllInvoicesResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.GetAllInvoicesResults]

        request = build_get_all_invoices_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_invoices.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("GetAllInvoicesResults", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_invoices.metadata = {"url": "/invoices"}  # type: ignore

    async def create_invoice(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> _models.Invoice:
        """Upload an invoice for parsing.

        Uploads an invoice for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/invoices/{identifier} <#get-/invoices/-identifier->`_ endpoint to check processing status and
        retrieve results.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is False.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invoice, or the result of cls(response)
        :rtype: ~affinda.models.Invoice
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invoice]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_invoice_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_invoice.metadata = {"url": "/invoices"}  # type: ignore

    async def get_invoice(self, identifier: str, **kwargs: Any) -> _models.Invoice:
        """Get parse results for a specific invoice.

        Returns all the parse results for that invoice if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the invoice via the `/invoices
        <#post-/invoices>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invoice, or the result of cls(response)
        :rtype: ~affinda.models.Invoice
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invoice]

        request = build_get_invoice_request(
            identifier=identifier,
            template_url=self.get_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invoice", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_invoice.metadata = {"url": "/invoices/{identifier}"}  # type: ignore

    async def delete_invoice(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an invoice.

        Delete the specified invoice from the database. Note, any invoices deleted from the database
        will no longer be used in any tailored customer models.

        :param identifier: Invoice identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_invoice_request(
            identifier=identifier,
            template_url=self.delete_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_invoice.metadata = {"url": "/invoices/{identifier}"}  # type: ignore

    async def list_occupation_groups(self, **kwargs: Any) -> List[_models.OccupationGroup]:
        """List occupation groups.

        Returns the list of searchable occupation groups.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of OccupationGroup, or the result of cls(response)
        :rtype: list[~affinda.models.OccupationGroup]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.OccupationGroup]]

        request = build_list_occupation_groups_request(
            template_url=self.list_occupation_groups.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[OccupationGroup]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_occupation_groups.metadata = {"url": "/occupation_groups"}  # type: ignore

    async def get_all_users(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> _models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema:
        """Get list of all users.

        Returns all the users.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[_models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_users_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_users.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_users.metadata = {"url": "/users"}  # type: ignore

    async def create_user(
        self,
        username: str,
        email: str,
        name: Optional[str] = None,
        avatar: Optional[IO] = None,
        **kwargs: Any,
    ) -> _models.UserCreateResponse:
        """Create a new user.

        Create an user as part of your account.

        :param username:
        :type username: str
        :param email:
        :type email: str
        :param name:  Default value is None.
        :type name: str
        :param avatar: Upload avatar for the user. Default value is None.
        :type avatar: IO
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: UserCreateResponse, or the result of cls(response)
        :rtype: ~affinda.models.UserCreateResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.UserCreateResponse]

        # Construct form data
        _files = {
            "name": name,
            "username": username,
            "email": email,
            "avatar": avatar,
        }

        request = build_create_user_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("UserCreateResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_user.metadata = {"url": "/users"}  # type: ignore

    async def get_all_organizations(self, **kwargs: Any) -> List[_models.Organization]:
        """Get list of all organizations.

        Returns all the organizations.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Organization, or the result of cls(response)
        :rtype: list[~affinda.models.Organization]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Organization]]

        request = build_get_all_organizations_request(
            template_url=self.get_all_organizations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Organization]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_organizations.metadata = {"url": "/organizations"}  # type: ignore

    async def create_organization(
        self,
        name: str,
        avatar: Optional[IO] = None,
        resthook_signature_key: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.Organization:
        """Create a new organization.

        Create a new organization.

        :param name:
        :type name: str
        :param avatar: Upload avatar for the organization. Default value is None.
        :type avatar: IO
        :param resthook_signature_key:  Default value is None.
        :type resthook_signature_key: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Organization, or the result of cls(response)
        :rtype: ~affinda.models.Organization
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Organization]

        # Construct form data
        _files = {
            "name": name,
            "avatar": avatar,
            "resthookSignatureKey": resthook_signature_key,
        }

        request = build_create_organization_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_organization.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Organization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_organization.metadata = {"url": "/organizations"}  # type: ignore

    async def get_organization(self, identifier: str, **kwargs: Any) -> _models.Organization:
        """Get detail of an organization.

        Get detail of an organization.

        :param identifier: Organization identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Organization, or the result of cls(response)
        :rtype: ~affinda.models.Organization
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Organization]

        request = build_get_organization_request(
            identifier=identifier,
            template_url=self.get_organization.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Organization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_organization.metadata = {"url": "/organizations/{identifier}"}  # type: ignore

    async def update_organization(
        self,
        identifier: str,
        name: Optional[str] = None,
        avatar: Optional[IO] = None,
        resthook_signature_key: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.Organization:
        """Update an organization.

        Update the detail of an organization.

        :param identifier: Organization identifier.
        :type identifier: str
        :param name:  Default value is None.
        :type name: str
        :param avatar:  Default value is None.
        :type avatar: IO
        :param resthook_signature_key:  Default value is None.
        :type resthook_signature_key: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Organization, or the result of cls(response)
        :rtype: ~affinda.models.Organization
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Organization]

        # Construct form data
        _files = {
            "name": name,
            "avatar": avatar,
            "resthookSignatureKey": resthook_signature_key,
        }

        request = build_update_organization_request(
            identifier=identifier,
            content_type=content_type,
            files=_files,
            template_url=self.update_organization.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Organization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_organization.metadata = {"url": "/organizations/{identifier}"}  # type: ignore

    async def delete_organization(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an organization.

        Delete the specified organization from the database.

        :param identifier: Organization identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_organization_request(
            identifier=identifier,
            template_url=self.delete_organization.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_organization.metadata = {"url": "/organizations/{identifier}"}  # type: ignore

    async def get_all_organization_memberships(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        organization: Optional[str] = None,
        role: Optional[Union[str, "_models.OrganizationRole"]] = None,
        **kwargs: Any,
    ) -> _models.PathsCkdzu3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema:
        """Get list of all organization memberships.

        Returns all the organization memberships.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :param role: Filter by role. Default value is None.
        :type role: str or ~affinda.models.OrganizationRole
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsCkdzu3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.PathsCkdzu3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[_models.PathsCkdzu3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_organization_memberships_request(
            offset=offset,
            limit=limit,
            organization=organization,
            role=role,
            template_url=self.get_all_organization_memberships.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsCkdzu3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_organization_memberships.metadata = {"url": "/organization_memberships"}  # type: ignore

    async def get_organization_membership(
        self, identifier: str, **kwargs: Any
    ) -> _models.OrganizationMembership:
        """Get detail of an organization membership.

        Get detail of an organization membership.

        :param identifier: Membership identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OrganizationMembership, or the result of cls(response)
        :rtype: ~affinda.models.OrganizationMembership
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.OrganizationMembership]

        request = build_get_organization_membership_request(
            identifier=identifier,
            template_url=self.get_organization_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("OrganizationMembership", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_organization_membership.metadata = {"url": "/organization_memberships/{identifier}"}  # type: ignore

    async def update_organization_membership(
        self, identifier: str, body: _models.OrganizationMembershipUpdate, **kwargs: Any
    ) -> _models.OrganizationMembership:
        """Update an organization membership.

        The admin users can use this endpoint to update the role of the members within their
        organization.

        :param identifier: Membership identifier.
        :type identifier: str
        :param body:
        :type body: ~affinda.models.OrganizationMembershipUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OrganizationMembership, or the result of cls(response)
        :rtype: ~affinda.models.OrganizationMembership
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.OrganizationMembership]

        _json = self._serialize.body(body, "OrganizationMembershipUpdate")

        request = build_update_organization_membership_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_organization_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("OrganizationMembership", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_organization_membership.metadata = {"url": "/organization_memberships/{identifier}"}  # type: ignore

    async def delete_organization_membership(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an organization membership.

        The admin users can use this endpoint to remove member from their organization. Other users can
        also use this to leave their organization.

        :param identifier: Membership identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_organization_membership_request(
            identifier=identifier,
            template_url=self.delete_organization_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_organization_membership.metadata = {"url": "/organization_memberships/{identifier}"}  # type: ignore

    async def get_all_invitations(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        organization: Optional[str] = None,
        status: Optional[Union[str, "_models.InvitationStatus"]] = None,
        role: Optional[Union[str, "_models.OrganizationRole"]] = None,
        **kwargs: Any,
    ) -> _models.PathsZt2JhiInvitationsGetResponses200ContentApplicationJsonSchema:
        """Get list of all invitations.

        Get list of all invitations you created or sent to you.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :param status: Filter by status. Default value is None.
        :type status: str or ~affinda.models.InvitationStatus
        :param role: Filter by role. Default value is None.
        :type role: str or ~affinda.models.OrganizationRole
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsZt2JhiInvitationsGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda.models.PathsZt2JhiInvitationsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[_models.PathsZt2JhiInvitationsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_invitations_request(
            offset=offset,
            limit=limit,
            organization=organization,
            status=status,
            role=role,
            template_url=self.get_all_invitations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsZt2JhiInvitationsGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_invitations.metadata = {"url": "/invitations"}  # type: ignore

    async def create_invitation(
        self, body: _models.InvitationCreate, **kwargs: Any
    ) -> _models.Invitation:
        """Create a new invitation.

        Create a new invitation.

        :param body: Invitation to create.
        :type body: ~affinda.models.InvitationCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        _json = self._serialize.body(body, "InvitationCreate")

        request = build_create_invitation_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_invitation.metadata = {"url": "/invitations"}  # type: ignore

    async def get_invitation(self, identifier: str, **kwargs: Any) -> _models.Invitation:
        """Get detail of an invitation.

        Get detail of an invitation.

        :param identifier: Invitation identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        request = build_get_invitation_request(
            identifier=identifier,
            template_url=self.get_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_invitation.metadata = {"url": "/invitations/{identifier}"}  # type: ignore

    async def update_invitation(
        self, identifier: str, body: _models.InvitationUpdate, **kwargs: Any
    ) -> _models.Invitation:
        """Update an invitation.

        Update the detail of an invitation.

        :param identifier: Invitation identifier.
        :type identifier: str
        :param body:
        :type body: ~affinda.models.InvitationUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        _json = self._serialize.body(body, "InvitationUpdate")

        request = build_update_invitation_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_invitation.metadata = {"url": "/invitations/{identifier}"}  # type: ignore

    async def delete_invitation(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an invitation.

        Delete the specified invitation from the database.

        :param identifier: Invitation identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_invitation_request(
            identifier=identifier,
            template_url=self.delete_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_invitation.metadata = {"url": "/invitations/{identifier}"}  # type: ignore

    async def get_invitation_by_token(self, token: str, **kwargs: Any) -> _models.Invitation:
        """Get detail of an invitation by token.

        Get detail of an invitation using a secret token. This allows users who have not
        registered/logged in to view the invitation.

        :param token: Invitation token.
        :type token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        request = build_get_invitation_by_token_request(
            token=token,
            template_url=self.get_invitation_by_token.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_invitation_by_token.metadata = {"url": "/invitations/token/{token}"}  # type: ignore

    async def respond_to_invitation(
        self,
        token: str,
        body: _models.PathsW51LnrInvitationsTokenPatchRequestbodyContentApplicationJsonSchema,
        **kwargs: Any,
    ) -> _models.Invitation:
        """Respond to an invitation.

        Choose to accept or decline an invitation.

        :param token: Invitation token.
        :type token: str
        :param body:
        :type body:
         ~affinda.models.PathsW51LnrInvitationsTokenPatchRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invitation, or the result of cls(response)
        :rtype: ~affinda.models.Invitation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invitation]

        _json = self._serialize.body(
            body, "PathsW51LnrInvitationsTokenPatchRequestbodyContentApplicationJsonSchema"
        )

        request = build_respond_to_invitation_request(
            token=token,
            content_type=content_type,
            json=_json,
            template_url=self.respond_to_invitation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invitation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    respond_to_invitation.metadata = {"url": "/invitations/token/{token}"}  # type: ignore

    async def get_all_extractors(
        self,
        organization: str,
        include_public_extractors: Optional[bool] = None,
        name: Optional[str] = None,
        validatable: Optional[bool] = None,
        **kwargs: Any,
    ) -> List[_models.Extractor]:
        """Get list of all extractors.

        Returns your custom extractors as well as Affinda's off-the-shelf extractors.

        :param organization: Filter by organization.
        :type organization: str
        :param include_public_extractors: Whether to include Affinda's off-the-shelf extractors.
         Default value is None.
        :type include_public_extractors: bool
        :param name: Filter by name. Default value is None.
        :type name: str
        :param validatable: Filter by validatable. Default value is None.
        :type validatable: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Extractor, or the result of cls(response)
        :rtype: list[~affinda.models.Extractor]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Extractor]]

        request = build_get_all_extractors_request(
            organization=organization,
            include_public_extractors=include_public_extractors,
            name=name,
            validatable=validatable,
            template_url=self.get_all_extractors.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Extractor]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_extractors.metadata = {"url": "/extractors"}  # type: ignore

    async def create_extractor(
        self, body: Optional[_models.ExtractorCreate] = None, **kwargs: Any
    ) -> _models.Extractor:
        """Create an extractor.

        Create a custom extractor.

        :param body:  Default value is None.
        :type body: ~affinda.models.ExtractorCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Extractor, or the result of cls(response)
        :rtype: ~affinda.models.Extractor
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Extractor]

        if body is not None:
            _json = self._serialize.body(body, "ExtractorCreate")
        else:
            _json = None

        request = build_create_extractor_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_extractor.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Extractor", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_extractor.metadata = {"url": "/extractors"}  # type: ignore

    async def get_extractor(self, id: int, **kwargs: Any) -> _models.Extractor:
        """Get specific extractor.

        Return a specific extractor.

        :param id: Extractor's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Extractor, or the result of cls(response)
        :rtype: ~affinda.models.Extractor
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Extractor]

        request = build_get_extractor_request(
            id=id,
            template_url=self.get_extractor.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Extractor", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_extractor.metadata = {"url": "/extractors/{id}"}  # type: ignore

    async def update_extractor_data(
        self, id: int, body: _models.ExtractorUpdate, **kwargs: Any
    ) -> _models.Extractor:
        """Update an extractor's data.

        Update data of an extractor.

        :param id: Extractor's ID.
        :type id: int
        :param body: Extractor data to update.
        :type body: ~affinda.models.ExtractorUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Extractor, or the result of cls(response)
        :rtype: ~affinda.models.Extractor
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Extractor]

        _json = self._serialize.body(body, "ExtractorUpdate")

        request = build_update_extractor_data_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_extractor_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Extractor", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_extractor_data.metadata = {"url": "/extractors/{id}"}  # type: ignore

    async def delete_extractor(  # pylint: disable=inconsistent-return-statements
        self, id: int, **kwargs: Any
    ) -> None:
        """Delete an extractor.

        Deletes the specified extractor from the database.

        :param id: Extractor's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_extractor_request(
            id=id,
            template_url=self.delete_extractor.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_extractor.metadata = {"url": "/extractors/{id}"}  # type: ignore

    async def get_all_data_points(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        organization: Optional[str] = None,
        extractor: Optional[int] = None,
        slug: Optional[str] = None,
        description: Optional[str] = None,
        annotation_content_type: Optional[str] = None,
        **kwargs: Any,
    ) -> List[_models.DataPoint]:
        """Get list of all data points.

        Returns your custom data points as well as Affinda's off-the-shelf data points.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param organization: Filter by organization. Default value is None.
        :type organization: str
        :param extractor: Filter by extractor. Default value is None.
        :type extractor: int
        :param slug: Filter by slug. Default value is None.
        :type slug: str
        :param description: Filter by description. Default value is None.
        :type description: str
        :param annotation_content_type: Filter by annotation content type, e.g. text, integer, float,
         date, etc. Default value is None.
        :type annotation_content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of DataPoint, or the result of cls(response)
        :rtype: list[~affinda.models.DataPoint]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.DataPoint]]

        request = build_get_all_data_points_request(
            offset=offset,
            limit=limit,
            organization=organization,
            extractor=extractor,
            slug=slug,
            description=description,
            annotation_content_type=annotation_content_type,
            template_url=self.get_all_data_points.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[DataPoint]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_data_points.metadata = {"url": "/data_points"}  # type: ignore

    async def create_data_point(
        self, body: Optional[_models.DataPointCreate] = None, **kwargs: Any
    ) -> _models.DataPoint:
        """Create a data point.

        Create a custom data point.

        :param body:  Default value is None.
        :type body: ~affinda.models.DataPointCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPoint, or the result of cls(response)
        :rtype: ~affinda.models.DataPoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPoint]

        if body is not None:
            _json = self._serialize.body(body, "DataPointCreate")
        else:
            _json = None

        request = build_create_data_point_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_data_point.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPoint", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_data_point.metadata = {"url": "/data_points"}  # type: ignore

    async def get_data_point(self, identifier: str, **kwargs: Any) -> _models.DataPoint:
        """Get specific data point.

        Return a specific data point.

        :param identifier: Data point's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPoint, or the result of cls(response)
        :rtype: ~affinda.models.DataPoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPoint]

        request = build_get_data_point_request(
            identifier=identifier,
            template_url=self.get_data_point.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPoint", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_data_point.metadata = {"url": "/data_points/{identifier}"}  # type: ignore

    async def update_data_point_data(
        self, identifier: str, body: _models.DataPointUpdate, **kwargs: Any
    ) -> _models.DataPoint:
        """Update a data point's data.

        Update data of a data point.

        :param identifier: DataPoint's identifier.
        :type identifier: str
        :param body: Data point to update.
        :type body: ~affinda.models.DataPointUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DataPoint, or the result of cls(response)
        :rtype: ~affinda.models.DataPoint
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DataPoint]

        _json = self._serialize.body(body, "DataPointUpdate")

        request = build_update_data_point_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_data_point_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DataPoint", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_data_point_data.metadata = {"url": "/data_points/{identifier}"}  # type: ignore

    async def delete_data_point(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a data point.

        Deletes the specified data point from the database.

        :param identifier: DataPoint's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_data_point_request(
            identifier=identifier,
            template_url=self.delete_data_point.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_data_point.metadata = {"url": "/data_points/{identifier}"}  # type: ignore

    async def get_all_workspaces(
        self, organization: str, name: Optional[str] = None, **kwargs: Any
    ) -> List[_models.Workspace]:
        """Get list of all workspaces.

        Returns your workspaces.

        :param organization: Filter by organization.
        :type organization: str
        :param name: Filter by name. Default value is None.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Workspace, or the result of cls(response)
        :rtype: list[~affinda.models.Workspace]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Workspace]]

        request = build_get_all_workspaces_request(
            organization=organization,
            name=name,
            template_url=self.get_all_workspaces.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Workspace]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_workspaces.metadata = {"url": "/workspaces"}  # type: ignore

    async def create_workspace(
        self, body: _models.WorkspaceCreate, **kwargs: Any
    ) -> _models.Workspace:
        """Create a workspace.

        Create a workspace.

        :param body: Workspace to create.
        :type body: ~affinda.models.WorkspaceCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Workspace, or the result of cls(response)
        :rtype: ~affinda.models.Workspace
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Workspace]

        _json = self._serialize.body(body, "WorkspaceCreate")

        request = build_create_workspace_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Workspace", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_workspace.metadata = {"url": "/workspaces"}  # type: ignore

    async def get_workspace(self, identifier: str, **kwargs: Any) -> _models.Workspace:
        """Get specific workspace.

        Return a specific workspace.

        :param identifier: Workspace's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Workspace, or the result of cls(response)
        :rtype: ~affinda.models.Workspace
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Workspace]

        request = build_get_workspace_request(
            identifier=identifier,
            template_url=self.get_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Workspace", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_workspace.metadata = {"url": "/workspaces/{identifier}"}  # type: ignore

    async def update_workspace(
        self, identifier: str, body: _models.WorkspaceUpdate, **kwargs: Any
    ) -> _models.Workspace:
        """Update a workspace.

        Update a workspace.

        :param identifier: Workspace's identifier.
        :type identifier: str
        :param body: Workspace data to update.
        :type body: ~affinda.models.WorkspaceUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Workspace, or the result of cls(response)
        :rtype: ~affinda.models.Workspace
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Workspace]

        _json = self._serialize.body(body, "WorkspaceUpdate")

        request = build_update_workspace_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Workspace", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_workspace.metadata = {"url": "/workspaces/{identifier}"}  # type: ignore

    async def delete_workspace(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a workspace.

        Deletes the specified workspace from the database.

        :param identifier: Workspace's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_workspace_request(
            identifier=identifier,
            template_url=self.delete_workspace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_workspace.metadata = {"url": "/workspaces/{identifier}"}  # type: ignore

    async def get_all_workspace_memberships(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        workspace: Optional[str] = None,
        user: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.PathsAdr1YhWorkspaceMembershipsGetResponses200ContentApplicationJsonSchema:
        """Get list of all workspace memberships.

        Returns the memberships of your workspaces.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param workspace: Filter by workspace. Default value is None.
        :type workspace: str
        :param user: Partial text match on user's email, case-insensitive. Default value is None.
        :type user: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsAdr1YhWorkspaceMembershipsGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda.models.PathsAdr1YhWorkspaceMembershipsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[_models.PathsAdr1YhWorkspaceMembershipsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_workspace_memberships_request(
            offset=offset,
            limit=limit,
            workspace=workspace,
            user=user,
            template_url=self.get_all_workspace_memberships.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsAdr1YhWorkspaceMembershipsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_workspace_memberships.metadata = {"url": "/workspace_memberships"}  # type: ignore

    async def create_workspace_membership(
        self, body: _models.WorkspaceMembershipCreate, **kwargs: Any
    ) -> _models.WorkspaceMembership:
        """Create a workspace membership.

        Create a workspace membership.

        :param body:
        :type body: ~affinda.models.WorkspaceMembershipCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkspaceMembership, or the result of cls(response)
        :rtype: ~affinda.models.WorkspaceMembership
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.WorkspaceMembership]

        _json = self._serialize.body(body, "WorkspaceMembershipCreate")

        request = build_create_workspace_membership_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_workspace_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("WorkspaceMembership", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_workspace_membership.metadata = {"url": "/workspace_memberships"}  # type: ignore

    async def get_workspace_membership(
        self, identifier: str, **kwargs: Any
    ) -> _models.WorkspaceMembership:
        """Get specific workspace membership.

        Return a specific workspace membership.

        :param identifier: Workspace membership's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WorkspaceMembership, or the result of cls(response)
        :rtype: ~affinda.models.WorkspaceMembership
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.WorkspaceMembership]

        request = build_get_workspace_membership_request(
            identifier=identifier,
            template_url=self.get_workspace_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("WorkspaceMembership", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_workspace_membership.metadata = {"url": "/workspace_memberships/{identifier}"}  # type: ignore

    async def delete_workspace_membership(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a workspace membership.

        Remove an user from a workspace.

        :param identifier: Workspace membership's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_workspace_membership_request(
            identifier=identifier,
            template_url=self.delete_workspace_membership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_workspace_membership.metadata = {"url": "/workspace_memberships/{identifier}"}  # type: ignore

    async def get_all_collections(self, workspace: str, **kwargs: Any) -> List[_models.Collection]:
        """Get list of all collections.

        Returns your collections.

        :param workspace: Filter by workspace.
        :type workspace: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Collection, or the result of cls(response)
        :rtype: list[~affinda.models.Collection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Collection]]

        request = build_get_all_collections_request(
            workspace=workspace,
            template_url=self.get_all_collections.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Collection]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_collections.metadata = {"url": "/collections"}  # type: ignore

    async def create_collection(
        self, body: _models.CollectionCreate, **kwargs: Any
    ) -> _models.Collection:
        """Create a collection.

        Create a collection.

        :param body:
        :type body: ~affinda.models.CollectionCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Collection, or the result of cls(response)
        :rtype: ~affinda.models.Collection
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Collection]

        _json = self._serialize.body(body, "CollectionCreate")

        request = build_create_collection_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Collection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_collection.metadata = {"url": "/collections"}  # type: ignore

    async def get_collection(self, identifier: str, **kwargs: Any) -> _models.Collection:
        """Get specific collection.

        Return a specific collection.

        :param identifier: Collection's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Collection, or the result of cls(response)
        :rtype: ~affinda.models.Collection
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Collection]

        request = build_get_collection_request(
            identifier=identifier,
            template_url=self.get_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Collection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_collection.metadata = {"url": "/collections/{identifier}"}  # type: ignore

    async def update_collection_data(
        self, identifier: str, body: _models.CollectionUpdate, **kwargs: Any
    ) -> _models.Collection:
        """Update a collection's data.

        Update data of a collection.

        :param identifier: Collection's identifier.
        :type identifier: str
        :param body: Collection data to update.
        :type body: ~affinda.models.CollectionUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Collection, or the result of cls(response)
        :rtype: ~affinda.models.Collection
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Collection]

        _json = self._serialize.body(body, "CollectionUpdate")

        request = build_update_collection_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_collection_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Collection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_collection_data.metadata = {"url": "/collections/{identifier}"}  # type: ignore

    async def delete_collection(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a collection.

        Deletes the specified collection from the database.

        :param identifier: Collection's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_collection_request(
            identifier=identifier,
            template_url=self.delete_collection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_collection.metadata = {"url": "/collections/{identifier}"}  # type: ignore

    async def get_all_documents(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        workspace: Optional[str] = None,
        collection: Optional[str] = None,
        state: Optional[Union[str, "_models.DocumentState"]] = None,
        tags: Optional[List[int]] = None,
        created_dt: Optional[Union[str, "_models.DateRange"]] = None,
        search: Optional[str] = None,
        ordering: Optional[List[Union[str, "_models.Get8ItemsItem"]]] = None,
        include_data: Optional[bool] = None,
        **kwargs: Any,
    ) -> _models.GetAllDocumentsResults:
        """Get list of all documents.

        Returns all the document summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param workspace: Filter by workspace. Default value is None.
        :type workspace: str
        :param collection: Filter by collection. Default value is None.
        :type collection: str
        :param state: Filter by the document's state. Default value is None.
        :type state: str or ~affinda.models.DocumentState
        :param tags: Filter by tags. Default value is None.
        :type tags: list[int]
        :param created_dt: Filter by created datetime. Default value is None.
        :type created_dt: str or ~affinda.models.DateRange
        :param search: Partial, case-insensitive match with file name or tag name. Default value is
         None.
        :type search: str
        :param ordering: Sort the result set. A "-" at the beginning denotes DESC sort, e.g.
         -created_dt. Sort by multiple fields is supported. Default value is None.
        :type ordering: list[str or ~affinda.models.Get8ItemsItem]
        :param include_data: By default, this endpoint returns only the meta data of the documents. Set
         this to ``true`` will return the detailed data that was parsed, at a performance cost. Default
         value is None.
        :type include_data: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.GetAllDocumentsResults]

        request = build_get_all_documents_request(
            offset=offset,
            limit=limit,
            workspace=workspace,
            collection=collection,
            state=state,
            tags=tags,
            created_dt=created_dt,
            search=search,
            ordering=ordering,
            include_data=include_data,
            template_url=self.get_all_documents.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_documents.metadata = {"url": "/documents"}  # type: ignore

    async def create_document(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        collection: Optional[str] = None,
        workspace: Optional[str] = None,
        wait: Optional[bool] = True,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.Document:
        """Upload a document for parsing.

        Uploads a document for parsing. When successful, returns an ``identifier`` in the response for
        subsequent use with the `/documents/{identifier} <#get-/documents/-identifier->`_ endpoint to
        check processing status and retrieve results.:code:`<br/>`.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param collection:  Default value is None.
        :type collection: str
        :param workspace:  Default value is None.
        :type workspace: str
        :param wait:  Default value is True.
        :type wait: bool
        :param identifier: Specify a custom identifier for the document. Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :param language:  Default value is None.
        :type language: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Document, or the result of cls(response)
        :rtype: ~affinda.models.Document
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Document]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "collection": collection,
            "workspace": workspace,
            "wait": wait,
            "identifier": identifier,
            "fileName": file_name,
            "expiryTime": expiry_time,
            "language": language,
        }

        request = build_create_document_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Document", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Document", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_document.metadata = {"url": "/documents"}  # type: ignore

    async def get_document(self, identifier: str, **kwargs: Any) -> _models.Document:
        """Get specific document.

        Return a specific document.

        :param identifier: Document's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Document, or the result of cls(response)
        :rtype: ~affinda.models.Document
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Document]

        request = build_get_document_request(
            identifier=identifier,
            template_url=self.get_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Document", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_document.metadata = {"url": "/documents/{identifier}"}  # type: ignore

    async def update_document_data(
        self, identifier: str, body: _models.DocumentUpdate, **kwargs: Any
    ) -> _models.Document:
        """Update a document's data.

        Update file name, expiry time, or move to another collection, etc.

        :param identifier: Document's identifier.
        :type identifier: str
        :param body: Document data to update.
        :type body: ~affinda.models.DocumentUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Document, or the result of cls(response)
        :rtype: ~affinda.models.Document
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Document]

        _json = self._serialize.body(body, "DocumentUpdate")

        request = build_update_document_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_document_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Document", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_document_data.metadata = {"url": "/documents/{identifier}"}  # type: ignore

    async def delete_document(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a document.

        Deletes the specified document from the database.

        :param identifier: Document's identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_document_request(
            identifier=identifier,
            template_url=self.delete_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_document.metadata = {"url": "/documents/{identifier}"}  # type: ignore

    async def get_all_tags(
        self,
        limit: Optional[int] = 300,
        offset: Optional[int] = None,
        workspace: Optional[str] = None,
        **kwargs: Any,
    ) -> List[_models.Tag]:
        """Get list of all tags.

        Returns your tags.

        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param workspace: Filter by workspace. Default value is None.
        :type workspace: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of Tag, or the result of cls(response)
        :rtype: list[~affinda.models.Tag]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.Tag]]

        request = build_get_all_tags_request(
            limit=limit,
            offset=offset,
            workspace=workspace,
            template_url=self.get_all_tags.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[Tag]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_tags.metadata = {"url": "/tags"}  # type: ignore

    async def create_tag(self, body: _models.TagCreate, **kwargs: Any) -> _models.Tag:
        """Create a tag.

        Create a tag.

        :param body:
        :type body: ~affinda.models.TagCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Tag, or the result of cls(response)
        :rtype: ~affinda.models.Tag
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Tag]

        _json = self._serialize.body(body, "TagCreate")

        request = build_create_tag_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Tag", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_tag.metadata = {"url": "/tags"}  # type: ignore

    async def get_tag(self, id: int, **kwargs: Any) -> _models.Tag:
        """Get specific tag.

        Return a specific tag.

        :param id: Tag's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Tag, or the result of cls(response)
        :rtype: ~affinda.models.Tag
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Tag]

        request = build_get_tag_request(
            id=id,
            template_url=self.get_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Tag", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_tag.metadata = {"url": "/tags/{id}"}  # type: ignore

    async def update_tag_data(
        self, id: int, body: _models.TagUpdate, **kwargs: Any
    ) -> _models.Tag:
        """Update an tag's data.

        Update data of an tag.

        :param id: Tag's ID.
        :type id: int
        :param body: Tag data to update.
        :type body: ~affinda.models.TagUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Tag, or the result of cls(response)
        :rtype: ~affinda.models.Tag
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Tag]

        _json = self._serialize.body(body, "TagUpdate")

        request = build_update_tag_data_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_tag_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Tag", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_tag_data.metadata = {"url": "/tags/{id}"}  # type: ignore

    async def delete_tag(  # pylint: disable=inconsistent-return-statements
        self, id: int, **kwargs: Any
    ) -> None:
        """Delete an tag.

        Deletes the specified tag from the database.

        :param id: Tag's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_tag_request(
            id=id,
            template_url=self.delete_tag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_tag.metadata = {"url": "/tags/{id}"}  # type: ignore
