# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.4, generator: @autorest/python@5.16.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, IO, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class Accreditation(msrest.serialization.Model):
    """Accreditation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar education:
    :vartype education: str
    :ivar input_str:
    :vartype input_str: str
    :ivar match_str:
    :vartype match_str: str
    :ivar education_level:
    :vartype education_level: str
    """

    _validation = {
        "input_str": {"readonly": True},
        "match_str": {"readonly": True},
        "education_level": {"readonly": True},
    }

    _attribute_map = {
        "education": {"key": "education", "type": "str"},
        "input_str": {"key": "inputStr", "type": "str"},
        "match_str": {"key": "matchStr", "type": "str"},
        "education_level": {"key": "educationLevel", "type": "str"},
    }

    def __init__(self, *, education: Optional[str] = None, **kwargs):
        """
        :keyword education:
        :paramtype education: str
        """
        super(Accreditation, self).__init__(**kwargs)
        self.education = education
        self.input_str = None
        self.match_str = None
        self.education_level = None


class Annotation(msrest.serialization.Model):
    """Annotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        """
        super(Annotation, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type


class BaseExtractor(msrest.serialization.Model):
    """BaseExtractor.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: int
    :ivar identifier: Required.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar name_plural: Required.
    :vartype name_plural: str
    :ivar validatable: Required.
    :vartype validatable: bool
    :ivar is_custom:
    :vartype is_custom: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "identifier": {"required": True},
        "name": {"required": True},
        "name_plural": {"required": True},
        "validatable": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "is_custom": {"key": "isCustom", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: int,
        identifier: str,
        name: str,
        name_plural: str,
        validatable: bool,
        is_custom: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword id: Required.
        :paramtype id: int
        :keyword identifier: Required.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural: Required.
        :paramtype name_plural: str
        :keyword validatable: Required.
        :paramtype validatable: bool
        :keyword is_custom:
        :paramtype is_custom: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(BaseExtractor, self).__init__(**kwargs)
        self.id = id
        self.identifier = identifier
        self.name = name
        self.name_plural = name_plural
        self.validatable = validatable
        self.is_custom = is_custom
        self.created_dt = created_dt


class Collection(msrest.serialization.Model):
    """Collection.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a collection.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    :ivar workspace:
    :vartype workspace: ~affinda.models.CollectionWorkspace
    :ivar extractor:
    :vartype extractor: ~affinda.models.Extractor
    :ivar auto_validation_threshold:
    :vartype auto_validation_threshold: float
    :ivar fields:
    :vartype fields: list[~affinda.models.FieldGroup]
    :ivar fields_configured:
    :vartype fields_configured: bool
    :ivar date_format_preference: Known values are: "DMY", "MDY", "YMD".
    :vartype date_format_preference: str or ~affinda.models.CollectionDateFormatPreference
    :ivar date_format_from_document: Predict the date format from any dates in the document that is
     not ambiguous.
    :vartype date_format_from_document: bool
    :ivar extractor_config: Extra configurations specific to an extractor.
    :vartype extractor_config: dict[str, any]
    :ivar unvalidated_docs_count: Number of unvalidated documents in the collection.
    :vartype unvalidated_docs_count: int
    :ivar confirmed_docs_count: Number of validated documents in the collection.
    :vartype confirmed_docs_count: int
    """

    _validation = {
        "identifier": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "CollectionWorkspace"},
        "extractor": {"key": "extractor", "type": "Extractor"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "fields": {"key": "fields", "type": "[FieldGroup]"},
        "fields_configured": {"key": "fieldsConfigured", "type": "bool"},
        "date_format_preference": {"key": "dateFormatPreference", "type": "str"},
        "date_format_from_document": {"key": "dateFormatFromDocument", "type": "bool"},
        "extractor_config": {"key": "extractorConfig", "type": "{object}"},
        "unvalidated_docs_count": {"key": "unvalidatedDocsCount", "type": "int"},
        "confirmed_docs_count": {"key": "confirmedDocsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: Optional[str] = None,
        workspace: Optional["_models.CollectionWorkspace"] = None,
        extractor: Optional["_models.Extractor"] = None,
        auto_validation_threshold: Optional[float] = None,
        fields: Optional[List["_models.FieldGroup"]] = None,
        fields_configured: Optional[bool] = None,
        date_format_preference: Optional[
            Union[str, "_models.CollectionDateFormatPreference"]
        ] = None,
        date_format_from_document: Optional[bool] = None,
        extractor_config: Optional[Dict[str, Any]] = None,
        unvalidated_docs_count: Optional[int] = None,
        confirmed_docs_count: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a collection.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        :keyword workspace:
        :paramtype workspace: ~affinda.models.CollectionWorkspace
        :keyword extractor:
        :paramtype extractor: ~affinda.models.Extractor
        :keyword auto_validation_threshold:
        :paramtype auto_validation_threshold: float
        :keyword fields:
        :paramtype fields: list[~affinda.models.FieldGroup]
        :keyword fields_configured:
        :paramtype fields_configured: bool
        :keyword date_format_preference: Known values are: "DMY", "MDY", "YMD".
        :paramtype date_format_preference: str or ~affinda.models.CollectionDateFormatPreference
        :keyword date_format_from_document: Predict the date format from any dates in the document that
         is not ambiguous.
        :paramtype date_format_from_document: bool
        :keyword extractor_config: Extra configurations specific to an extractor.
        :paramtype extractor_config: dict[str, any]
        :keyword unvalidated_docs_count: Number of unvalidated documents in the collection.
        :paramtype unvalidated_docs_count: int
        :keyword confirmed_docs_count: Number of validated documents in the collection.
        :paramtype confirmed_docs_count: int
        """
        super(Collection, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.workspace = workspace
        self.extractor = extractor
        self.auto_validation_threshold = auto_validation_threshold
        self.fields = fields
        self.fields_configured = fields_configured
        self.date_format_preference = date_format_preference
        self.date_format_from_document = date_format_from_document
        self.extractor_config = extractor_config
        self.unvalidated_docs_count = unvalidated_docs_count
        self.confirmed_docs_count = confirmed_docs_count


class CollectionCreate(msrest.serialization.Model):
    """CollectionCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar workspace: Required. Uniquely identify a workspace.
    :vartype workspace: str
    :ivar extractor: Required. Extractor's ID.
    :vartype extractor: int
    :ivar auto_validation_threshold:
    :vartype auto_validation_threshold: float
    :ivar fields:
    :vartype fields: list[~affinda.models.FieldGroup]
    :ivar date_format_preference: Known values are: "DMY", "MDY", "YMD".
    :vartype date_format_preference: str or ~affinda.models.DateFormatPreference
    :ivar date_format_from_document: Predict the date format from any dates in the document that is
     not ambiguous.
    :vartype date_format_from_document: bool
    :ivar extractor_config: Extra configurations specific to an extractor.
    :vartype extractor_config: dict[str, any]
    """

    _validation = {
        "name": {"required": True},
        "workspace": {"required": True},
        "extractor": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "extractor": {"key": "extractor", "type": "int"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "fields": {"key": "fields", "type": "[FieldGroup]"},
        "date_format_preference": {"key": "dateFormatPreference", "type": "str"},
        "date_format_from_document": {"key": "dateFormatFromDocument", "type": "bool"},
        "extractor_config": {"key": "extractorConfig", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        name: str,
        workspace: str,
        extractor: int,
        auto_validation_threshold: Optional[float] = None,
        fields: Optional[List["_models.FieldGroup"]] = None,
        date_format_preference: Optional[Union[str, "_models.DateFormatPreference"]] = None,
        date_format_from_document: Optional[bool] = None,
        extractor_config: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword workspace: Required. Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword extractor: Required. Extractor's ID.
        :paramtype extractor: int
        :keyword auto_validation_threshold:
        :paramtype auto_validation_threshold: float
        :keyword fields:
        :paramtype fields: list[~affinda.models.FieldGroup]
        :keyword date_format_preference: Known values are: "DMY", "MDY", "YMD".
        :paramtype date_format_preference: str or ~affinda.models.DateFormatPreference
        :keyword date_format_from_document: Predict the date format from any dates in the document that
         is not ambiguous.
        :paramtype date_format_from_document: bool
        :keyword extractor_config: Extra configurations specific to an extractor.
        :paramtype extractor_config: dict[str, any]
        """
        super(CollectionCreate, self).__init__(**kwargs)
        self.name = name
        self.workspace = workspace
        self.extractor = extractor
        self.auto_validation_threshold = auto_validation_threshold
        self.fields = fields
        self.date_format_preference = date_format_preference
        self.date_format_from_document = date_format_from_document
        self.extractor_config = extractor_config


class CollectionUpdate(msrest.serialization.Model):
    """CollectionUpdate.

    :ivar name:
    :vartype name: str
    :ivar auto_validation_threshold:
    :vartype auto_validation_threshold: float
    :ivar fields:
    :vartype fields: list[~affinda.models.FieldGroup]
    :ivar date_format_preference: Known values are: "DMY", "MDY", "YMD".
    :vartype date_format_preference: str or ~affinda.models.DateFormatPreference
    :ivar date_format_from_document: Predict the date format from any dates in the document that is
     not ambiguous.
    :vartype date_format_from_document: bool
    :ivar extractor_config: Extra configurations specific to an extractor.
    :vartype extractor_config: dict[str, any]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "fields": {"key": "fields", "type": "[FieldGroup]"},
        "date_format_preference": {"key": "dateFormatPreference", "type": "str"},
        "date_format_from_document": {"key": "dateFormatFromDocument", "type": "bool"},
        "extractor_config": {"key": "extractorConfig", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        auto_validation_threshold: Optional[float] = None,
        fields: Optional[List["_models.FieldGroup"]] = None,
        date_format_preference: Optional[Union[str, "_models.DateFormatPreference"]] = None,
        date_format_from_document: Optional[bool] = None,
        extractor_config: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword auto_validation_threshold:
        :paramtype auto_validation_threshold: float
        :keyword fields:
        :paramtype fields: list[~affinda.models.FieldGroup]
        :keyword date_format_preference: Known values are: "DMY", "MDY", "YMD".
        :paramtype date_format_preference: str or ~affinda.models.DateFormatPreference
        :keyword date_format_from_document: Predict the date format from any dates in the document that
         is not ambiguous.
        :paramtype date_format_from_document: bool
        :keyword extractor_config: Extra configurations specific to an extractor.
        :paramtype extractor_config: dict[str, any]
        """
        super(CollectionUpdate, self).__init__(**kwargs)
        self.name = name
        self.auto_validation_threshold = auto_validation_threshold
        self.fields = fields
        self.date_format_preference = date_format_preference
        self.date_format_from_document = date_format_from_document
        self.extractor_config = extractor_config


class CollectionWorkspace(msrest.serialization.Model):
    """CollectionWorkspace.

    :ivar identifier: Uniquely identify a workspace.
    :vartype identifier: str
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar name:
    :vartype name: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        organization: Optional["_models.Organization"] = None,
        name: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify a workspace.
        :paramtype identifier: str
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword name:
        :paramtype name: str
        """
        super(CollectionWorkspace, self).__init__(**kwargs)
        self.identifier = identifier
        self.organization = organization
        self.name = name


class Components105Abr3SchemasInvoicedataPropertiesCustomernumberAllof1(
    msrest.serialization.Model
):
    """Components105Abr3SchemasInvoicedataPropertiesCustomernumberAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components105Abr3SchemasInvoicedataPropertiesCustomernumberAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components10Thcs2SchemasInvoicedataPropertiesSupplieremailAllof1(msrest.serialization.Model):
    """Components10Thcs2SchemasInvoicedataPropertiesSupplieremailAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components10Thcs2SchemasInvoicedataPropertiesSupplieremailAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components1127QwqSchemasInvoicedataPropertiesBankibanAllof1(msrest.serialization.Model):
    """Components1127QwqSchemasInvoicedataPropertiesBankibanAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components1127QwqSchemasInvoicedataPropertiesBankibanAllof1, self).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class Components158Lya5SchemasInvoicedataPropertiesCustomerbusinessnumberAllof1(
    msrest.serialization.Model
):
    """Components158Lya5SchemasInvoicedataPropertiesCustomerbusinessnumberAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(
            Components158Lya5SchemasInvoicedataPropertiesCustomerbusinessnumberAllof1, self
        ).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class Components159Ji55SchemasResumesearchdetailPropertiesLanguagesPropertiesValueItemsAllof1(
    msrest.serialization.Model
):
    """Components159Ji55SchemasResumesearchdetailPropertiesLanguagesPropertiesValueItemsAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            Components159Ji55SchemasResumesearchdetailPropertiesLanguagesPropertiesValueItemsAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class Components17JmwpjSchemasInvoicedataPropertiesSupplierwebsiteAllof1(
    msrest.serialization.Model
):
    """Components17JmwpjSchemasInvoicedataPropertiesSupplierwebsiteAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components17JmwpjSchemasInvoicedataPropertiesSupplierwebsiteAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components1Bq3Q31SchemasJobdescriptionsearchdetailPropertiesOccupationgroupPropertiesValueItemsAllof1(
    msrest.serialization.Model
):
    """Components1Bq3Q31SchemasJobdescriptionsearchdetailPropertiesOccupationgroupPropertiesValueItemsAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            Components1Bq3Q31SchemasJobdescriptionsearchdetailPropertiesOccupationgroupPropertiesValueItemsAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class Components1Fe3VqtSchemasInvoicedataPropertiesSupplierfaxAllof1(msrest.serialization.Model):
    """Components1Fe3VqtSchemasInvoicedataPropertiesSupplierfaxAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components1Fe3VqtSchemasInvoicedataPropertiesSupplierfaxAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components1Hr2XldSchemasInvoicedataPropertiesSupplierphonenumberAllof1(
    msrest.serialization.Model
):
    """Components1Hr2XldSchemasInvoicedataPropertiesSupplierphonenumberAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(
            Components1Hr2XldSchemasInvoicedataPropertiesSupplierphonenumberAllof1, self
        ).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class Components1O8OpknSchemasInvoicedataPropertiesCustomercompanynameAllof1(
    msrest.serialization.Model
):
    """Components1O8OpknSchemasInvoicedataPropertiesCustomercompanynameAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(
            Components1O8OpknSchemasInvoicedataPropertiesCustomercompanynameAllof1, self
        ).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class Components1P4Fl61SchemasInvoicedataPropertiesSuppliercompanynameAllof1(
    msrest.serialization.Model
):
    """Components1P4Fl61SchemasInvoicedataPropertiesSuppliercompanynameAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(
            Components1P4Fl61SchemasInvoicedataPropertiesSuppliercompanynameAllof1, self
        ).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class Components1QdassaSchemasInvoicedataPropertiesBanksortcodeAllof1(msrest.serialization.Model):
    """Components1QdassaSchemasInvoicedataPropertiesBanksortcodeAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components1QdassaSchemasInvoicedataPropertiesBanksortcodeAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components1Roa72HSchemasInvoicedataPropertiesBankswiftAllof1(msrest.serialization.Model):
    """Components1Roa72HSchemasInvoicedataPropertiesBankswiftAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components1Roa72HSchemasInvoicedataPropertiesBankswiftAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components1RrxgkvSchemasInvoicedataPropertiesBankbsbAllof1(msrest.serialization.Model):
    """Components1RrxgkvSchemasInvoicedataPropertiesBankbsbAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components1RrxgkvSchemasInvoicedataPropertiesBankbsbAllof1, self).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class Components1TlnsonSchemasJobdescriptionsearchdetailPropertiesLocationPropertiesValueAllof1(
    msrest.serialization.Model
):
    """Components1TlnsonSchemasJobdescriptionsearchdetailPropertiesLocationPropertiesValueAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            Components1TlnsonSchemasJobdescriptionsearchdetailPropertiesLocationPropertiesValueAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification(
    msrest.serialization.Model
):
    """Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification.

    :ivar title: SOC2020 classification for this job title.
    :vartype title: str
    :ivar minor_group: SOC2020 minor group.
    :vartype minor_group: str
    :ivar sub_major_group: SOC2020 sub major group.
    :vartype sub_major_group: str
    :ivar major_group: SOC2020 major group.
    :vartype major_group: str
    :ivar soc_code: The 4 digit code representing the SOC2020 classification for this job title.
    :vartype soc_code: int
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "minor_group": {"key": "minorGroup", "type": "str"},
        "sub_major_group": {"key": "subMajorGroup", "type": "str"},
        "major_group": {"key": "majorGroup", "type": "str"},
        "soc_code": {"key": "socCode", "type": "int"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        minor_group: Optional[str] = None,
        sub_major_group: Optional[str] = None,
        major_group: Optional[str] = None,
        soc_code: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword title: SOC2020 classification for this job title.
        :paramtype title: str
        :keyword minor_group: SOC2020 minor group.
        :paramtype minor_group: str
        :keyword sub_major_group: SOC2020 sub major group.
        :paramtype sub_major_group: str
        :keyword major_group: SOC2020 major group.
        :paramtype major_group: str
        :keyword soc_code: The 4 digit code representing the SOC2020 classification for this job title.
        :paramtype soc_code: int
        """
        super(
            Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification,
            self,
        ).__init__(**kwargs)
        self.title = title
        self.minor_group = minor_group
        self.sub_major_group = sub_major_group
        self.major_group = major_group
        self.soc_code = soc_code


class Components1Vvtu5NSchemasInvoicedataPropertiesPaymentamountpaidAllof1(
    msrest.serialization.Model
):
    """Components1Vvtu5NSchemasInvoicedataPropertiesPaymentamountpaidAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components1Vvtu5NSchemasInvoicedataPropertiesPaymentamountpaidAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components1W3SqeuSchemasInvoicedataPropertiesPaymentamountbaseAllof1(
    msrest.serialization.Model
):
    """Components1W3SqeuSchemasInvoicedataPropertiesPaymentamountbaseAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components1W3SqeuSchemasInvoicedataPropertiesPaymentamountbaseAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components1Y7HcurSchemasInvoicedataPropertiesCustomeremailAllof1(msrest.serialization.Model):
    """Components1Y7HcurSchemasInvoicedataPropertiesCustomeremailAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components1Y7HcurSchemasInvoicedataPropertiesCustomeremailAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components1YsiqwnSchemasInvoicedataPropertiesCustomerphonenumberAllof1(
    msrest.serialization.Model
):
    """Components1YsiqwnSchemasInvoicedataPropertiesCustomerphonenumberAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(
            Components1YsiqwnSchemasInvoicedataPropertiesCustomerphonenumberAllof1, self
        ).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class Components2XnshtSchemasInvoicedataPropertiesPaymentreferenceAllof1(
    msrest.serialization.Model
):
    """Components2XnshtSchemasInvoicedataPropertiesPaymentreferenceAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components2XnshtSchemasInvoicedataPropertiesPaymentreferenceAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components4A2PzvSchemasInvoicedataPropertiesPaymentamounttotalAllof1(
    msrest.serialization.Model
):
    """Components4A2PzvSchemasInvoicedataPropertiesPaymentamounttotalAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components4A2PzvSchemasInvoicedataPropertiesPaymentamounttotalAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components5D6NjySchemasInvoicedataPropertiesSupplierbusinessnumberAllof1(
    msrest.serialization.Model
):
    """Components5D6NjySchemasInvoicedataPropertiesSupplierbusinessnumberAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(
            Components5D6NjySchemasInvoicedataPropertiesSupplierbusinessnumberAllof1, self
        ).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class Components5Rnu7ESchemasInvoicedataPropertiesInvoicenumberAllof1(msrest.serialization.Model):
    """Components5Rnu7ESchemasInvoicedataPropertiesInvoicenumberAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components5Rnu7ESchemasInvoicedataPropertiesInvoicenumberAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components6Zm20BSchemasInvoicedataPropertiesPaymentamounttaxAllof1(
    msrest.serialization.Model
):
    """Components6Zm20BSchemasInvoicedataPropertiesPaymentamounttaxAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components6Zm20BSchemasInvoicedataPropertiesPaymentamounttaxAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class Components74A7C1SchemasInvoicedataPropertiesBankaccountnumberAllof1(
    msrest.serialization.Model
):
    """Components74A7C1SchemasInvoicedataPropertiesBankaccountnumberAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(Components74A7C1SchemasInvoicedataPropertiesBankaccountnumberAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class ComponentsA69Bd0SchemasInvoicedataPropertiesBpaybillercodeAllof1(msrest.serialization.Model):
    """ComponentsA69Bd0SchemasInvoicedataPropertiesBpaybillercodeAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(ComponentsA69Bd0SchemasInvoicedataPropertiesBpaybillercodeAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class ComponentsAq75Z8SchemasInvoicedataPropertiesInvoicepurchaseordernumberAllof1(
    msrest.serialization.Model
):
    """ComponentsAq75Z8SchemasInvoicedataPropertiesInvoicepurchaseordernumberAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(
            ComponentsAq75Z8SchemasInvoicedataPropertiesInvoicepurchaseordernumberAllof1, self
        ).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class ComponentsB3U7OaSchemasInvoicedataPropertiesSuppliervatAllof1(msrest.serialization.Model):
    """ComponentsB3U7OaSchemasInvoicedataPropertiesSuppliervatAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(ComponentsB3U7OaSchemasInvoicedataPropertiesSuppliervatAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class ComponentsBeazccSchemasInvoicedataPropertiesCustomervatAllof1(msrest.serialization.Model):
    """ComponentsBeazccSchemasInvoicedataPropertiesCustomervatAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(ComponentsBeazccSchemasInvoicedataPropertiesCustomervatAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class ComponentsEtsq6MSchemasInvoicedataPropertiesPaymentamountdueAllof1(
    msrest.serialization.Model
):
    """ComponentsEtsq6MSchemasInvoicedataPropertiesPaymentamountdueAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(ComponentsEtsq6MSchemasInvoicedataPropertiesPaymentamountdueAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class ComponentsH65QjbSchemasResumesearchdetailPropertiesSkillsPropertiesValueItemsAllof1(
    msrest.serialization.Model
):
    """ComponentsH65QjbSchemasResumesearchdetailPropertiesSkillsPropertiesValueItemsAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            ComponentsH65QjbSchemasResumesearchdetailPropertiesSkillsPropertiesValueItemsAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class ComponentsK7P1F5SchemasResumesearchdetailPropertiesOccupationgroupPropertiesValueItemsAllof1(
    msrest.serialization.Model
):
    """ComponentsK7P1F5SchemasResumesearchdetailPropertiesOccupationgroupPropertiesValueItemsAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            ComponentsK7P1F5SchemasResumesearchdetailPropertiesOccupationgroupPropertiesValueItemsAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class ComponentsN9ShogSchemasResumesearchdetailPropertiesLocationPropertiesValueAllof1(
    msrest.serialization.Model
):
    """ComponentsN9ShogSchemasResumesearchdetailPropertiesLocationPropertiesValueAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            ComponentsN9ShogSchemasResumesearchdetailPropertiesLocationPropertiesValueAllof1, self
        ).__init__(**kwargs)
        self.match = match


class ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties(
    msrest.serialization.Model
):
    """ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(
            ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties, self
        ).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class ComponentsSxu0N3SchemasResumesearchdetailPropertiesEducationPropertiesValueItemsAllof1(
    msrest.serialization.Model
):
    """ComponentsSxu0N3SchemasResumesearchdetailPropertiesEducationPropertiesValueItemsAllof1.

    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        """
        super(
            ComponentsSxu0N3SchemasResumesearchdetailPropertiesEducationPropertiesValueItemsAllof1,
            self,
        ).__init__(**kwargs)
        self.match = match


class ComponentsW32SuaSchemasInvoicedataPropertiesBpayreferenceAllof1(msrest.serialization.Model):
    """ComponentsW32SuaSchemasInvoicedataPropertiesBpayreferenceAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(ComponentsW32SuaSchemasInvoicedataPropertiesBpayreferenceAllof1, self).__init__(
            **kwargs
        )
        self.raw = raw
        self.parsed = parsed


class ComponentsWv2QrxSchemasInvoicedataPropertiesCustomercontactnameAllof1(
    msrest.serialization.Model
):
    """ComponentsWv2QrxSchemasInvoicedataPropertiesCustomercontactnameAllof1.

    :ivar raw:
    :vartype raw: str
    :ivar parsed:
    :vartype parsed: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(self, *, raw: Optional[str] = None, parsed: Optional[str] = None, **kwargs):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(
            ComponentsWv2QrxSchemasInvoicedataPropertiesCustomercontactnameAllof1, self
        ).__init__(**kwargs)
        self.raw = raw
        self.parsed = parsed


class DataPoint(msrest.serialization.Model):
    """DataPoint.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a data point.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar slug:
    :vartype slug: str
    :ivar description:
    :vartype description: str
    :ivar annotation_content_type: Required. Known values are: "text", "integer", "float",
     "decimal", "date", "datetime", "boolean", "enum", "location", "json", "table".
    :vartype annotation_content_type: str or ~affinda.models.AnnotationContentType
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar extractor: Required. Extractor's ID.
    :vartype extractor: int
    :ivar multiple:
    :vartype multiple: bool
    :ivar no_rect:
    :vartype no_rect: bool
    :ivar similar_to: Required.
    :vartype similar_to: list[str]
    :ivar choices:
    :vartype choices: list[~affinda.models.DataPointChoicesItem]
    :ivar children:
    :vartype children: list[~affinda.models.DataPoint]
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "annotation_content_type": {"required": True},
        "extractor": {"required": True},
        "similar_to": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "annotation_content_type": {"key": "annotationContentType", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "extractor": {"key": "extractor", "type": "int"},
        "multiple": {"key": "multiple", "type": "bool"},
        "no_rect": {"key": "noRect", "type": "bool"},
        "similar_to": {"key": "similarTo", "type": "[str]"},
        "choices": {"key": "choices", "type": "[DataPointChoicesItem]"},
        "children": {"key": "children", "type": "[DataPoint]"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        annotation_content_type: Union[str, "_models.AnnotationContentType"],
        extractor: int,
        similar_to: List[str],
        slug: Optional[str] = None,
        description: Optional[str] = None,
        organization: Optional["_models.Organization"] = None,
        multiple: Optional[bool] = None,
        no_rect: Optional[bool] = None,
        choices: Optional[List["_models.DataPointChoicesItem"]] = None,
        children: Optional[List["_models.DataPoint"]] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a data point.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword slug:
        :paramtype slug: str
        :keyword description:
        :paramtype description: str
        :keyword annotation_content_type: Required. Known values are: "text", "integer", "float",
         "decimal", "date", "datetime", "boolean", "enum", "location", "json", "table".
        :paramtype annotation_content_type: str or ~affinda.models.AnnotationContentType
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword extractor: Required. Extractor's ID.
        :paramtype extractor: int
        :keyword multiple:
        :paramtype multiple: bool
        :keyword no_rect:
        :paramtype no_rect: bool
        :keyword similar_to: Required.
        :paramtype similar_to: list[str]
        :keyword choices:
        :paramtype choices: list[~affinda.models.DataPointChoicesItem]
        :keyword children:
        :paramtype children: list[~affinda.models.DataPoint]
        """
        super(DataPoint, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.slug = slug
        self.description = description
        self.annotation_content_type = annotation_content_type
        self.organization = organization
        self.extractor = extractor
        self.multiple = multiple
        self.no_rect = no_rect
        self.similar_to = similar_to
        self.choices = choices
        self.children = children


class DataPointChoicesItem(msrest.serialization.Model):
    """DataPointChoicesItem.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
    }

    def __init__(self, *, label: str, **kwargs):
        """
        :keyword label: Required.
        :paramtype label: str
        """
        super(DataPointChoicesItem, self).__init__(**kwargs)
        self.label = label


class DataPointCreate(msrest.serialization.Model):
    """DataPointCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name:
    :vartype name: str
    :ivar slug: Required.
    :vartype slug: str
    :ivar description:
    :vartype description: str
    :ivar annotation_content_type: Required. Known values are: "text", "integer", "float",
     "decimal", "date", "datetime", "boolean", "enum", "location", "json", "table".
    :vartype annotation_content_type: str or ~affinda.models.AnnotationContentType
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar extractor: Required. Extractor's ID.
    :vartype extractor: int
    :ivar multiple:
    :vartype multiple: bool
    :ivar no_rect:
    :vartype no_rect: bool
    """

    _validation = {
        "slug": {"required": True},
        "annotation_content_type": {"required": True},
        "organization": {"required": True},
        "extractor": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "annotation_content_type": {"key": "annotationContentType", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "extractor": {"key": "extractor", "type": "int"},
        "multiple": {"key": "multiple", "type": "bool"},
        "no_rect": {"key": "noRect", "type": "bool"},
    }

    def __init__(
        self,
        *,
        slug: str,
        annotation_content_type: Union[str, "_models.AnnotationContentType"],
        organization: str,
        extractor: int,
        name: Optional[str] = None,
        description: Optional[str] = None,
        multiple: Optional[bool] = None,
        no_rect: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword slug: Required.
        :paramtype slug: str
        :keyword description:
        :paramtype description: str
        :keyword annotation_content_type: Required. Known values are: "text", "integer", "float",
         "decimal", "date", "datetime", "boolean", "enum", "location", "json", "table".
        :paramtype annotation_content_type: str or ~affinda.models.AnnotationContentType
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword extractor: Required. Extractor's ID.
        :paramtype extractor: int
        :keyword multiple:
        :paramtype multiple: bool
        :keyword no_rect:
        :paramtype no_rect: bool
        """
        super(DataPointCreate, self).__init__(**kwargs)
        self.name = name
        self.slug = slug
        self.description = description
        self.annotation_content_type = annotation_content_type
        self.organization = organization
        self.extractor = extractor
        self.multiple = multiple
        self.no_rect = no_rect


class DataPointUpdate(msrest.serialization.Model):
    """DataPointUpdate.

    :ivar name:
    :vartype name: str
    :ivar slug:
    :vartype slug: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        slug: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword slug:
        :paramtype slug: str
        :keyword description:
        :paramtype description: str
        """
        super(DataPointUpdate, self).__init__(**kwargs)
        self.name = name
        self.slug = slug
        self.description = description


class DateAnnotation(Annotation):
    """DateAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: ~datetime.date
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "date"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[datetime.date] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: ~datetime.date
        """
        super(DateAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class DocumentMeta(msrest.serialization.Model):
    """DocumentMeta.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a document.
    :vartype identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar ready: If true, the document has finished processing. Particularly useful if an endpoint
     request specified wait=False, when polling use this variable to determine when to stop polling.
    :vartype ready: bool
    :ivar ready_dt: The datetime when the document was ready.
    :vartype ready_dt: ~datetime.datetime
    :ivar failed: If true, some exception was raised during processing. Check the 'error' field of
     the main return object.
    :vartype failed: bool
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar language: The document's language.
    :vartype language: str
    :ivar pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
     converted to pdf as part of the parsing process).
    :vartype pdf: str
    :ivar parent_document: If this document is part of a splitted document, this attribute points
     to the original document that this document is splitted from.
    :vartype parent_document: ~affinda.models.DocumentMetaParentDocument
    :ivar child_documents: If this document has been splitted into a number of child documents,
     this attribute points to those child documents.
    :vartype child_documents: list[~affinda.models.DocumentMetaChildDocumentsItem]
    :ivar pages: Required. The document's pages.
    :vartype pages: list[~affinda.models.PageMeta]
    :ivar is_ocrd:
    :vartype is_ocrd: bool
    :ivar ocr_confidence:
    :vartype ocr_confidence: float
    :ivar review_url:
    :vartype review_url: str
    :ivar collection:
    :vartype collection: ~affinda.models.DocumentMetaCollection
    :ivar workspace: Required.
    :vartype workspace: ~affinda.models.DocumentMetaWorkspace
    :ivar archived_dt:
    :vartype archived_dt: ~datetime.datetime
    :ivar is_archived:
    :vartype is_archived: bool
    :ivar confirmed_dt:
    :vartype confirmed_dt: ~datetime.datetime
    :ivar is_confirmed:
    :vartype is_confirmed: bool
    :ivar rejected_dt:
    :vartype rejected_dt: ~datetime.datetime
    :ivar is_rejected:
    :vartype is_rejected: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    :ivar error_code:
    :vartype error_code: str
    :ivar error_detail:
    :vartype error_detail: str
    :ivar file: URL to view the file.
    :vartype file: str
    :ivar tags: A set of tags.
    :vartype tags: list[~affinda.models.Tag]
    """

    _validation = {
        "identifier": {"required": True},
        "pages": {"required": True},
        "workspace": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "ready": {"key": "ready", "type": "bool"},
        "ready_dt": {"key": "readyDt", "type": "iso-8601"},
        "failed": {"key": "failed", "type": "bool"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "language": {"key": "language", "type": "str"},
        "pdf": {"key": "pdf", "type": "str"},
        "parent_document": {"key": "parentDocument", "type": "DocumentMetaParentDocument"},
        "child_documents": {"key": "childDocuments", "type": "[DocumentMetaChildDocumentsItem]"},
        "pages": {"key": "pages", "type": "[PageMeta]"},
        "is_ocrd": {"key": "isOcrd", "type": "bool"},
        "ocr_confidence": {"key": "ocrConfidence", "type": "float"},
        "review_url": {"key": "reviewUrl", "type": "str"},
        "collection": {"key": "collection", "type": "DocumentMetaCollection"},
        "workspace": {"key": "workspace", "type": "DocumentMetaWorkspace"},
        "archived_dt": {"key": "archivedDt", "type": "iso-8601"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "confirmed_dt": {"key": "confirmedDt", "type": "iso-8601"},
        "is_confirmed": {"key": "isConfirmed", "type": "bool"},
        "rejected_dt": {"key": "rejectedDt", "type": "iso-8601"},
        "is_rejected": {"key": "isRejected", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_detail": {"key": "errorDetail", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "tags": {"key": "tags", "type": "[Tag]"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        pages: List["_models.PageMeta"],
        workspace: "_models.DocumentMetaWorkspace",
        file_name: Optional[str] = None,
        ready: Optional[bool] = None,
        ready_dt: Optional[datetime.datetime] = None,
        failed: Optional[bool] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        pdf: Optional[str] = None,
        parent_document: Optional["_models.DocumentMetaParentDocument"] = None,
        child_documents: Optional[List["_models.DocumentMetaChildDocumentsItem"]] = None,
        is_ocrd: Optional[bool] = None,
        ocr_confidence: Optional[float] = None,
        review_url: Optional[str] = None,
        collection: Optional["_models.DocumentMetaCollection"] = None,
        archived_dt: Optional[datetime.datetime] = None,
        is_archived: Optional[bool] = None,
        confirmed_dt: Optional[datetime.datetime] = None,
        is_confirmed: Optional[bool] = None,
        rejected_dt: Optional[datetime.datetime] = None,
        is_rejected: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        error_code: Optional[str] = None,
        error_detail: Optional[str] = None,
        file: Optional[str] = None,
        tags: Optional[List["_models.Tag"]] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a document.
        :paramtype identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword ready: If true, the document has finished processing. Particularly useful if an
         endpoint request specified wait=False, when polling use this variable to determine when to stop
         polling.
        :paramtype ready: bool
        :keyword ready_dt: The datetime when the document was ready.
        :paramtype ready_dt: ~datetime.datetime
        :keyword failed: If true, some exception was raised during processing. Check the 'error' field
         of the main return object.
        :paramtype failed: bool
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword language: The document's language.
        :paramtype language: str
        :keyword pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
         converted to pdf as part of the parsing process).
        :paramtype pdf: str
        :keyword parent_document: If this document is part of a splitted document, this attribute
         points to the original document that this document is splitted from.
        :paramtype parent_document: ~affinda.models.DocumentMetaParentDocument
        :keyword child_documents: If this document has been splitted into a number of child documents,
         this attribute points to those child documents.
        :paramtype child_documents: list[~affinda.models.DocumentMetaChildDocumentsItem]
        :keyword pages: Required. The document's pages.
        :paramtype pages: list[~affinda.models.PageMeta]
        :keyword is_ocrd:
        :paramtype is_ocrd: bool
        :keyword ocr_confidence:
        :paramtype ocr_confidence: float
        :keyword review_url:
        :paramtype review_url: str
        :keyword collection:
        :paramtype collection: ~affinda.models.DocumentMetaCollection
        :keyword workspace: Required.
        :paramtype workspace: ~affinda.models.DocumentMetaWorkspace
        :keyword archived_dt:
        :paramtype archived_dt: ~datetime.datetime
        :keyword is_archived:
        :paramtype is_archived: bool
        :keyword confirmed_dt:
        :paramtype confirmed_dt: ~datetime.datetime
        :keyword is_confirmed:
        :paramtype is_confirmed: bool
        :keyword rejected_dt:
        :paramtype rejected_dt: ~datetime.datetime
        :keyword is_rejected:
        :paramtype is_rejected: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        :keyword error_code:
        :paramtype error_code: str
        :keyword error_detail:
        :paramtype error_detail: str
        :keyword file: URL to view the file.
        :paramtype file: str
        :keyword tags: A set of tags.
        :paramtype tags: list[~affinda.models.Tag]
        """
        super(DocumentMeta, self).__init__(**kwargs)
        self.identifier = identifier
        self.file_name = file_name
        self.ready = ready
        self.ready_dt = ready_dt
        self.failed = failed
        self.expiry_time = expiry_time
        self.language = language
        self.pdf = pdf
        self.parent_document = parent_document
        self.child_documents = child_documents
        self.pages = pages
        self.is_ocrd = is_ocrd
        self.ocr_confidence = ocr_confidence
        self.review_url = review_url
        self.collection = collection
        self.workspace = workspace
        self.archived_dt = archived_dt
        self.is_archived = is_archived
        self.confirmed_dt = confirmed_dt
        self.is_confirmed = is_confirmed
        self.rejected_dt = rejected_dt
        self.is_rejected = is_rejected
        self.created_dt = created_dt
        self.error_code = error_code
        self.error_detail = error_detail
        self.file = file
        self.tags = tags


class Document(DocumentMeta):
    """Document.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a document.
    :vartype identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar ready: If true, the document has finished processing. Particularly useful if an endpoint
     request specified wait=False, when polling use this variable to determine when to stop polling.
    :vartype ready: bool
    :ivar ready_dt: The datetime when the document was ready.
    :vartype ready_dt: ~datetime.datetime
    :ivar failed: If true, some exception was raised during processing. Check the 'error' field of
     the main return object.
    :vartype failed: bool
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar language: The document's language.
    :vartype language: str
    :ivar pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
     converted to pdf as part of the parsing process).
    :vartype pdf: str
    :ivar parent_document: If this document is part of a splitted document, this attribute points
     to the original document that this document is splitted from.
    :vartype parent_document: ~affinda.models.DocumentMetaParentDocument
    :ivar child_documents: If this document has been splitted into a number of child documents,
     this attribute points to those child documents.
    :vartype child_documents: list[~affinda.models.DocumentMetaChildDocumentsItem]
    :ivar pages: Required. The document's pages.
    :vartype pages: list[~affinda.models.PageMeta]
    :ivar is_ocrd:
    :vartype is_ocrd: bool
    :ivar ocr_confidence:
    :vartype ocr_confidence: float
    :ivar review_url:
    :vartype review_url: str
    :ivar collection:
    :vartype collection: ~affinda.models.DocumentMetaCollection
    :ivar workspace: Required.
    :vartype workspace: ~affinda.models.DocumentMetaWorkspace
    :ivar archived_dt:
    :vartype archived_dt: ~datetime.datetime
    :ivar is_archived:
    :vartype is_archived: bool
    :ivar confirmed_dt:
    :vartype confirmed_dt: ~datetime.datetime
    :ivar is_confirmed:
    :vartype is_confirmed: bool
    :ivar rejected_dt:
    :vartype rejected_dt: ~datetime.datetime
    :ivar is_rejected:
    :vartype is_rejected: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    :ivar error_code:
    :vartype error_code: str
    :ivar error_detail:
    :vartype error_detail: str
    :ivar file: URL to view the file.
    :vartype file: str
    :ivar tags: A set of tags.
    :vartype tags: list[~affinda.models.Tag]
    :ivar data: Dictionary of :code:`<any>`.
    :vartype data: dict[str, any]
    """

    _validation = {
        "identifier": {"required": True},
        "pages": {"required": True},
        "workspace": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "ready": {"key": "ready", "type": "bool"},
        "ready_dt": {"key": "readyDt", "type": "iso-8601"},
        "failed": {"key": "failed", "type": "bool"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "language": {"key": "language", "type": "str"},
        "pdf": {"key": "pdf", "type": "str"},
        "parent_document": {"key": "parentDocument", "type": "DocumentMetaParentDocument"},
        "child_documents": {"key": "childDocuments", "type": "[DocumentMetaChildDocumentsItem]"},
        "pages": {"key": "pages", "type": "[PageMeta]"},
        "is_ocrd": {"key": "isOcrd", "type": "bool"},
        "ocr_confidence": {"key": "ocrConfidence", "type": "float"},
        "review_url": {"key": "reviewUrl", "type": "str"},
        "collection": {"key": "collection", "type": "DocumentMetaCollection"},
        "workspace": {"key": "workspace", "type": "DocumentMetaWorkspace"},
        "archived_dt": {"key": "archivedDt", "type": "iso-8601"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "confirmed_dt": {"key": "confirmedDt", "type": "iso-8601"},
        "is_confirmed": {"key": "isConfirmed", "type": "bool"},
        "rejected_dt": {"key": "rejectedDt", "type": "iso-8601"},
        "is_rejected": {"key": "isRejected", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_detail": {"key": "errorDetail", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "tags": {"key": "tags", "type": "[Tag]"},
        "data": {"key": "data", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        pages: List["_models.PageMeta"],
        workspace: "_models.DocumentMetaWorkspace",
        file_name: Optional[str] = None,
        ready: Optional[bool] = None,
        ready_dt: Optional[datetime.datetime] = None,
        failed: Optional[bool] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        pdf: Optional[str] = None,
        parent_document: Optional["_models.DocumentMetaParentDocument"] = None,
        child_documents: Optional[List["_models.DocumentMetaChildDocumentsItem"]] = None,
        is_ocrd: Optional[bool] = None,
        ocr_confidence: Optional[float] = None,
        review_url: Optional[str] = None,
        collection: Optional["_models.DocumentMetaCollection"] = None,
        archived_dt: Optional[datetime.datetime] = None,
        is_archived: Optional[bool] = None,
        confirmed_dt: Optional[datetime.datetime] = None,
        is_confirmed: Optional[bool] = None,
        rejected_dt: Optional[datetime.datetime] = None,
        is_rejected: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        error_code: Optional[str] = None,
        error_detail: Optional[str] = None,
        file: Optional[str] = None,
        tags: Optional[List["_models.Tag"]] = None,
        data: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a document.
        :paramtype identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword ready: If true, the document has finished processing. Particularly useful if an
         endpoint request specified wait=False, when polling use this variable to determine when to stop
         polling.
        :paramtype ready: bool
        :keyword ready_dt: The datetime when the document was ready.
        :paramtype ready_dt: ~datetime.datetime
        :keyword failed: If true, some exception was raised during processing. Check the 'error' field
         of the main return object.
        :paramtype failed: bool
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword language: The document's language.
        :paramtype language: str
        :keyword pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
         converted to pdf as part of the parsing process).
        :paramtype pdf: str
        :keyword parent_document: If this document is part of a splitted document, this attribute
         points to the original document that this document is splitted from.
        :paramtype parent_document: ~affinda.models.DocumentMetaParentDocument
        :keyword child_documents: If this document has been splitted into a number of child documents,
         this attribute points to those child documents.
        :paramtype child_documents: list[~affinda.models.DocumentMetaChildDocumentsItem]
        :keyword pages: Required. The document's pages.
        :paramtype pages: list[~affinda.models.PageMeta]
        :keyword is_ocrd:
        :paramtype is_ocrd: bool
        :keyword ocr_confidence:
        :paramtype ocr_confidence: float
        :keyword review_url:
        :paramtype review_url: str
        :keyword collection:
        :paramtype collection: ~affinda.models.DocumentMetaCollection
        :keyword workspace: Required.
        :paramtype workspace: ~affinda.models.DocumentMetaWorkspace
        :keyword archived_dt:
        :paramtype archived_dt: ~datetime.datetime
        :keyword is_archived:
        :paramtype is_archived: bool
        :keyword confirmed_dt:
        :paramtype confirmed_dt: ~datetime.datetime
        :keyword is_confirmed:
        :paramtype is_confirmed: bool
        :keyword rejected_dt:
        :paramtype rejected_dt: ~datetime.datetime
        :keyword is_rejected:
        :paramtype is_rejected: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        :keyword error_code:
        :paramtype error_code: str
        :keyword error_detail:
        :paramtype error_detail: str
        :keyword file: URL to view the file.
        :paramtype file: str
        :keyword tags: A set of tags.
        :paramtype tags: list[~affinda.models.Tag]
        :keyword data: Dictionary of :code:`<any>`.
        :paramtype data: dict[str, any]
        """
        super(Document, self).__init__(
            identifier=identifier,
            file_name=file_name,
            ready=ready,
            ready_dt=ready_dt,
            failed=failed,
            expiry_time=expiry_time,
            language=language,
            pdf=pdf,
            parent_document=parent_document,
            child_documents=child_documents,
            pages=pages,
            is_ocrd=is_ocrd,
            ocr_confidence=ocr_confidence,
            review_url=review_url,
            collection=collection,
            workspace=workspace,
            archived_dt=archived_dt,
            is_archived=is_archived,
            confirmed_dt=confirmed_dt,
            is_confirmed=is_confirmed,
            rejected_dt=rejected_dt,
            is_rejected=is_rejected,
            created_dt=created_dt,
            error_code=error_code,
            error_detail=error_detail,
            file=file,
            tags=tags,
            **kwargs,
        )
        self.data = data


class DocumentCreate(msrest.serialization.Model):
    """DocumentCreate.

    :ivar file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML, PNG,
     JPG.
    :vartype file: IO
    :ivar url: URL to a resume to download and process.
    :vartype url: str
    :ivar collection: Uniquely identify a collection.
    :vartype collection: str
    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    :ivar wait: If "true" (default), will return a response only after processing has completed. If
     "false", will return an empty data object which can be polled at the GET endpoint until
     processing is complete.
    :vartype wait: bool
    :ivar identifier: Specify a custom identifier for the document.
    :vartype identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
    :vartype language: str
    """

    _attribute_map = {
        "file": {"key": "file", "type": "IO"},
        "url": {"key": "url", "type": "str"},
        "collection": {"key": "collection", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "wait": {"key": "wait", "type": "bool"},
        "identifier": {"key": "identifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "language": {"key": "language", "type": "str"},
    }

    def __init__(
        self,
        *,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        collection: Optional[str] = None,
        workspace: Optional[str] = None,
        wait: Optional[bool] = True,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML,
         PNG, JPG.
        :paramtype file: IO
        :keyword url: URL to a resume to download and process.
        :paramtype url: str
        :keyword collection: Uniquely identify a collection.
        :paramtype collection: str
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword wait: If "true" (default), will return a response only after processing has completed.
         If "false", will return an empty data object which can be polled at the GET endpoint until
         processing is complete.
        :paramtype wait: bool
        :keyword identifier: Specify a custom identifier for the document.
        :paramtype identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
        :paramtype language: str
        """
        super(DocumentCreate, self).__init__(**kwargs)
        self.file = file
        self.url = url
        self.collection = collection
        self.workspace = workspace
        self.wait = wait
        self.identifier = identifier
        self.file_name = file_name
        self.expiry_time = expiry_time
        self.language = language


class DocumentMetaChildDocumentsItem(msrest.serialization.Model):
    """DocumentMetaChildDocumentsItem.

    :ivar identifier: Uniquely identify a document.
    :vartype identifier: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
    }

    def __init__(self, *, identifier: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Uniquely identify a document.
        :paramtype identifier: str
        """
        super(DocumentMetaChildDocumentsItem, self).__init__(**kwargs)
        self.identifier = identifier


class DocumentMetaCollection(msrest.serialization.Model):
    """DocumentMetaCollection.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a collection.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    :ivar extractor:
    :vartype extractor: ~affinda.models.DocumentMetaCollectionExtractor
    """

    _validation = {
        "identifier": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "extractor": {"key": "extractor", "type": "DocumentMetaCollectionExtractor"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: Optional[str] = None,
        extractor: Optional["_models.DocumentMetaCollectionExtractor"] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a collection.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        :keyword extractor:
        :paramtype extractor: ~affinda.models.DocumentMetaCollectionExtractor
        """
        super(DocumentMetaCollection, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.extractor = extractor


class DocumentMetaCollectionExtractor(msrest.serialization.Model):
    """DocumentMetaCollectionExtractor.

    :ivar id: Extractor's ID.
    :vartype id: int
    :ivar name:
    :vartype name: str
    :ivar base_extractor: Base extractor's ID.
    :vartype base_extractor: int
    :ivar validatable:
    :vartype validatable: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "int"},
        "validatable": {"key": "validatable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        base_extractor: Optional[int] = None,
        validatable: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword id: Extractor's ID.
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword base_extractor: Base extractor's ID.
        :paramtype base_extractor: int
        :keyword validatable:
        :paramtype validatable: bool
        """
        super(DocumentMetaCollectionExtractor, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.base_extractor = base_extractor
        self.validatable = validatable


class DocumentMetaParentDocument(msrest.serialization.Model):
    """If this document is part of a splitted document, this attribute points to the original document that this document is splitted from.

    :ivar identifier: Uniquely identify a document.
    :vartype identifier: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
    }

    def __init__(self, *, identifier: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Uniquely identify a document.
        :paramtype identifier: str
        """
        super(DocumentMetaParentDocument, self).__init__(**kwargs)
        self.identifier = identifier


class DocumentMetaWorkspace(msrest.serialization.Model):
    """DocumentMetaWorkspace.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a workspace.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    """

    _validation = {
        "identifier": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, identifier: str, name: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Required. Uniquely identify a workspace.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        """
        super(DocumentMetaWorkspace, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name


class DocumentUpdate(msrest.serialization.Model):
    """DocumentUpdate.

    :ivar collection: Uniquely identify a collection.
    :vartype collection: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar is_confirmed:
    :vartype is_confirmed: bool
    :ivar is_rejected:
    :vartype is_rejected: bool
    :ivar language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
    :vartype language: str
    """

    _attribute_map = {
        "collection": {"key": "collection", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "is_confirmed": {"key": "isConfirmed", "type": "bool"},
        "is_rejected": {"key": "isRejected", "type": "bool"},
        "language": {"key": "language", "type": "str"},
    }

    def __init__(
        self,
        *,
        collection: Optional[str] = None,
        file_name: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        is_confirmed: Optional[bool] = None,
        is_rejected: Optional[bool] = None,
        language: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword collection: Uniquely identify a collection.
        :paramtype collection: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword is_confirmed:
        :paramtype is_confirmed: bool
        :keyword is_rejected:
        :paramtype is_rejected: bool
        :keyword language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
        :paramtype language: str
        """
        super(DocumentUpdate, self).__init__(**kwargs)
        self.collection = collection
        self.file_name = file_name
        self.expiry_time = expiry_time
        self.is_confirmed = is_confirmed
        self.is_rejected = is_rejected
        self.language = language


class Education(msrest.serialization.Model):
    """Education.

    :ivar id:
    :vartype id: int
    :ivar organization:
    :vartype organization: str
    :ivar accreditation:
    :vartype accreditation: ~affinda.models.Accreditation
    :ivar grade:
    :vartype grade: ~affinda.models.EducationGrade
    :ivar location:
    :vartype location: ~affinda.models.Location
    :ivar dates:
    :vartype dates: ~affinda.models.EducationDates
    """

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "organization": {"key": "organization", "type": "str"},
        "accreditation": {"key": "accreditation", "type": "Accreditation"},
        "grade": {"key": "grade", "type": "EducationGrade"},
        "location": {"key": "location", "type": "Location"},
        "dates": {"key": "dates", "type": "EducationDates"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        organization: Optional[str] = None,
        accreditation: Optional["_models.Accreditation"] = None,
        grade: Optional["_models.EducationGrade"] = None,
        location: Optional["_models.Location"] = None,
        dates: Optional["_models.EducationDates"] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: int
        :keyword organization:
        :paramtype organization: str
        :keyword accreditation:
        :paramtype accreditation: ~affinda.models.Accreditation
        :keyword grade:
        :paramtype grade: ~affinda.models.EducationGrade
        :keyword location:
        :paramtype location: ~affinda.models.Location
        :keyword dates:
        :paramtype dates: ~affinda.models.EducationDates
        """
        super(Education, self).__init__(**kwargs)
        self.id = id
        self.organization = organization
        self.accreditation = accreditation
        self.grade = grade
        self.location = location
        self.dates = dates


class EducationDates(msrest.serialization.Model):
    """EducationDates.

    :ivar completion_date:
    :vartype completion_date: ~datetime.date
    :ivar is_current:
    :vartype is_current: bool
    :ivar start_date:
    :vartype start_date: ~datetime.date
    """

    _attribute_map = {
        "completion_date": {"key": "completionDate", "type": "date"},
        "is_current": {"key": "isCurrent", "type": "bool"},
        "start_date": {"key": "startDate", "type": "date"},
    }

    def __init__(
        self,
        *,
        completion_date: Optional[datetime.date] = None,
        is_current: Optional[bool] = None,
        start_date: Optional[datetime.date] = None,
        **kwargs,
    ):
        """
        :keyword completion_date:
        :paramtype completion_date: ~datetime.date
        :keyword is_current:
        :paramtype is_current: bool
        :keyword start_date:
        :paramtype start_date: ~datetime.date
        """
        super(EducationDates, self).__init__(**kwargs)
        self.completion_date = completion_date
        self.is_current = is_current
        self.start_date = start_date


class EducationGrade(msrest.serialization.Model):
    """EducationGrade.

    :ivar raw:
    :vartype raw: str
    :ivar metric:
    :vartype metric: str
    :ivar value:
    :vartype value: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "metric": {"key": "metric", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        raw: Optional[str] = None,
        metric: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword metric:
        :paramtype metric: str
        :keyword value:
        :paramtype value: str
        """
        super(EducationGrade, self).__init__(**kwargs)
        self.raw = raw
        self.metric = metric
        self.value = value


class EducationSearchScoreComponent(msrest.serialization.Model):
    """EducationSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(EducationSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class EnumAnnotationSerializer(Annotation):
    """EnumAnnotationSerializer.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(EnumAnnotationSerializer, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class Error(msrest.serialization.Model):
    """Error.

    :ivar error_code:
    :vartype error_code: str
    :ivar error_detail:
    :vartype error_detail: str
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_detail": {"key": "errorDetail", "type": "str"},
    }

    def __init__(
        self, *, error_code: Optional[str] = None, error_detail: Optional[str] = None, **kwargs
    ):
        """
        :keyword error_code:
        :paramtype error_code: str
        :keyword error_detail:
        :paramtype error_detail: str
        """
        super(Error, self).__init__(**kwargs)
        self.error_code = error_code
        self.error_detail = error_detail


class ExpectedRemunerationAnnotation(Annotation):
    """ExpectedRemunerationAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: ~affinda.models.ExpectedRemunerationAnnotationParsed
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "ExpectedRemunerationAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional["_models.ExpectedRemunerationAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: ~affinda.models.ExpectedRemunerationAnnotationParsed
        """
        super(ExpectedRemunerationAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class ExpectedRemunerationAnnotationParsed(msrest.serialization.Model):
    """ExpectedRemunerationAnnotationParsed.

    :ivar minimum:
    :vartype minimum: float
    :ivar maximum:
    :vartype maximum: float
    :ivar currency:
    :vartype currency: str
    :ivar unit:
    :vartype unit: str
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "currency": {"key": "currency", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        currency: Optional[str] = None,
        unit: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword minimum:
        :paramtype minimum: float
        :keyword maximum:
        :paramtype maximum: float
        :keyword currency:
        :paramtype currency: str
        :keyword unit:
        :paramtype unit: str
        """
        super(ExpectedRemunerationAnnotationParsed, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.currency = currency
        self.unit = unit


class ExperienceSearchScoreComponent(msrest.serialization.Model):
    """ExperienceSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(ExperienceSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class Extractor(msrest.serialization.Model):
    """Extractor.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Extractor's ID.
    :vartype id: int
    :ivar identifier: Required.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar name_plural: Required.
    :vartype name_plural: str
    :ivar base_extractor:
    :vartype base_extractor: ~affinda.models.ExtractorBaseExtractor
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar category:
    :vartype category: str
    :ivar validatable: Required.
    :vartype validatable: bool
    :ivar is_custom:
    :vartype is_custom: bool
    :ivar field_groups:
    :vartype field_groups: ~affinda.models.ExtractorFieldGroups
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "identifier": {"required": True},
        "name": {"required": True},
        "name_plural": {"required": True},
        "validatable": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "ExtractorBaseExtractor"},
        "organization": {"key": "organization", "type": "Organization"},
        "category": {"key": "category", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "is_custom": {"key": "isCustom", "type": "bool"},
        "field_groups": {"key": "fieldGroups", "type": "ExtractorFieldGroups"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: int,
        identifier: str,
        name: str,
        name_plural: str,
        validatable: bool,
        base_extractor: Optional["_models.ExtractorBaseExtractor"] = None,
        organization: Optional["_models.Organization"] = None,
        category: Optional[str] = None,
        is_custom: Optional[bool] = None,
        field_groups: Optional["_models.ExtractorFieldGroups"] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword id: Required. Extractor's ID.
        :paramtype id: int
        :keyword identifier: Required.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural: Required.
        :paramtype name_plural: str
        :keyword base_extractor:
        :paramtype base_extractor: ~affinda.models.ExtractorBaseExtractor
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword category:
        :paramtype category: str
        :keyword validatable: Required.
        :paramtype validatable: bool
        :keyword is_custom:
        :paramtype is_custom: bool
        :keyword field_groups:
        :paramtype field_groups: ~affinda.models.ExtractorFieldGroups
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(Extractor, self).__init__(**kwargs)
        self.id = id
        self.identifier = identifier
        self.name = name
        self.name_plural = name_plural
        self.base_extractor = base_extractor
        self.organization = organization
        self.category = category
        self.validatable = validatable
        self.is_custom = is_custom
        self.field_groups = field_groups
        self.created_dt = created_dt


class ExtractorBaseExtractor(msrest.serialization.Model):
    """ExtractorBaseExtractor.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: int
    :ivar identifier: Required.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar name_plural: Required.
    :vartype name_plural: str
    :ivar validatable: Required.
    :vartype validatable: bool
    :ivar is_custom:
    :vartype is_custom: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "identifier": {"required": True},
        "name": {"required": True},
        "name_plural": {"required": True},
        "validatable": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "is_custom": {"key": "isCustom", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: int,
        identifier: str,
        name: str,
        name_plural: str,
        validatable: bool,
        is_custom: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword id: Required.
        :paramtype id: int
        :keyword identifier: Required.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural: Required.
        :paramtype name_plural: str
        :keyword validatable: Required.
        :paramtype validatable: bool
        :keyword is_custom:
        :paramtype is_custom: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(ExtractorBaseExtractor, self).__init__(**kwargs)
        self.id = id
        self.identifier = identifier
        self.name = name
        self.name_plural = name_plural
        self.validatable = validatable
        self.is_custom = is_custom
        self.created_dt = created_dt


class ExtractorCreate(msrest.serialization.Model):
    """ExtractorCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar name_plural:
    :vartype name_plural: str
    :ivar base_extractor: The base extractor's ID.
    :vartype base_extractor: int
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar category:
    :vartype category: str
    :ivar validatable:
    :vartype validatable: bool
    :ivar field_groups:
    :vartype field_groups: ~affinda.models.FieldGroups
    """

    _validation = {
        "name": {"required": True},
        "organization": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "int"},
        "organization": {"key": "organization", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "field_groups": {"key": "fieldGroups", "type": "FieldGroups"},
    }

    def __init__(
        self,
        *,
        name: str,
        organization: str,
        name_plural: Optional[str] = None,
        base_extractor: Optional[int] = None,
        category: Optional[str] = None,
        validatable: Optional[bool] = None,
        field_groups: Optional["_models.FieldGroups"] = None,
        **kwargs,
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural:
        :paramtype name_plural: str
        :keyword base_extractor: The base extractor's ID.
        :paramtype base_extractor: int
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword category:
        :paramtype category: str
        :keyword validatable:
        :paramtype validatable: bool
        :keyword field_groups:
        :paramtype field_groups: ~affinda.models.FieldGroups
        """
        super(ExtractorCreate, self).__init__(**kwargs)
        self.name = name
        self.name_plural = name_plural
        self.base_extractor = base_extractor
        self.organization = organization
        self.category = category
        self.validatable = validatable
        self.field_groups = field_groups


class FieldGroup(msrest.serialization.Model):
    """FieldGroup.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar fields: Required.
    :vartype fields: list[~affinda.models.Field]
    """

    _validation = {
        "label": {"required": True},
        "fields": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "fields": {"key": "fields", "type": "[Field]"},
    }

    def __init__(self, *, label: str, fields: List["_models.Field"], **kwargs):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword fields: Required.
        :paramtype fields: list[~affinda.models.Field]
        """
        super(FieldGroup, self).__init__(**kwargs)
        self.label = label
        self.fields = fields


class ExtractorFieldGroups(FieldGroup):
    """ExtractorFieldGroups.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar fields: Required.
    :vartype fields: list[~affinda.models.Field]
    """

    _validation = {
        "label": {"required": True},
        "fields": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "fields": {"key": "fields", "type": "[Field]"},
    }

    def __init__(self, *, label: str, fields: List["_models.Field"], **kwargs):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword fields: Required.
        :paramtype fields: list[~affinda.models.Field]
        """
        super(ExtractorFieldGroups, self).__init__(label=label, fields=fields, **kwargs)


class ExtractorUpdate(msrest.serialization.Model):
    """ExtractorUpdate.

    :ivar name:
    :vartype name: str
    :ivar name_plural:
    :vartype name_plural: str
    :ivar base_extractor: The base extractor's ID.
    :vartype base_extractor: int
    :ivar category:
    :vartype category: str
    :ivar validatable:
    :vartype validatable: bool
    :ivar field_groups:
    :vartype field_groups: ~affinda.models.FieldGroups
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "int"},
        "category": {"key": "category", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "field_groups": {"key": "fieldGroups", "type": "FieldGroups"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        name_plural: Optional[str] = None,
        base_extractor: Optional[int] = None,
        category: Optional[str] = None,
        validatable: Optional[bool] = None,
        field_groups: Optional["_models.FieldGroups"] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword name_plural:
        :paramtype name_plural: str
        :keyword base_extractor: The base extractor's ID.
        :paramtype base_extractor: int
        :keyword category:
        :paramtype category: str
        :keyword validatable:
        :paramtype validatable: bool
        :keyword field_groups:
        :paramtype field_groups: ~affinda.models.FieldGroups
        """
        super(ExtractorUpdate, self).__init__(**kwargs)
        self.name = name
        self.name_plural = name_plural
        self.base_extractor = base_extractor
        self.category = category
        self.validatable = validatable
        self.field_groups = field_groups


class Field(msrest.serialization.Model):
    """Field.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar slug: Required.
    :vartype slug: str
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar mandatory:
    :vartype mandatory: bool
    :ivar disabled:
    :vartype disabled: bool
    :ivar auto_validation_threshold:
    :vartype auto_validation_threshold: float
    :ivar fields:
    :vartype fields: list[~affinda.models.Field]
    """

    _validation = {
        "label": {"required": True},
        "slug": {"required": True},
        "data_point": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "slug": {"key": "slug", "type": "str"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "mandatory": {"key": "mandatory", "type": "bool"},
        "disabled": {"key": "disabled", "type": "bool"},
        "auto_validation_threshold": {"key": "autoValidationThreshold", "type": "float"},
        "fields": {"key": "fields", "type": "[Field]"},
    }

    def __init__(
        self,
        *,
        label: str,
        slug: str,
        data_point: str,
        mandatory: Optional[bool] = None,
        disabled: Optional[bool] = None,
        auto_validation_threshold: Optional[float] = None,
        fields: Optional[List["_models.Field"]] = None,
        **kwargs,
    ):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword slug: Required.
        :paramtype slug: str
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword mandatory:
        :paramtype mandatory: bool
        :keyword disabled:
        :paramtype disabled: bool
        :keyword auto_validation_threshold:
        :paramtype auto_validation_threshold: float
        :keyword fields:
        :paramtype fields: list[~affinda.models.Field]
        """
        super(Field, self).__init__(**kwargs)
        self.label = label
        self.slug = slug
        self.data_point = data_point
        self.mandatory = mandatory
        self.disabled = disabled
        self.auto_validation_threshold = auto_validation_threshold
        self.fields = fields


class FieldGroups(FieldGroup):
    """FieldGroups.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar fields: Required.
    :vartype fields: list[~affinda.models.Field]
    """

    _validation = {
        "label": {"required": True},
        "fields": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "fields": {"key": "fields", "type": "[Field]"},
    }

    def __init__(self, *, label: str, fields: List["_models.Field"], **kwargs):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword fields: Required.
        :paramtype fields: list[~affinda.models.Field]
        """
        super(FieldGroups, self).__init__(label=label, fields=fields, **kwargs)


class Get200ApplicationJsonPropertiesItemsItem(msrest.serialization.Model):
    """Get200ApplicationJsonPropertiesItemsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar document_type: Known values are: "resumes", "job_descriptions".
    :vartype document_type: str or
     ~affinda.models.GetResponses200ContentApplicationJsonSchemaResultsItemDocumentType
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "document_type": {"key": "documentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        document_type: Optional[
            Union[
                str, "_models.GetResponses200ContentApplicationJsonSchemaResultsItemDocumentType"
            ]
        ] = None,
        **kwargs,
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword document_type: Known values are: "resumes", "job_descriptions".
        :paramtype document_type: str or
         ~affinda.models.GetResponses200ContentApplicationJsonSchemaResultsItemDocumentType
        """
        super(Get200ApplicationJsonPropertiesItemsItem, self).__init__(**kwargs)
        self.name = name
        self.document_type = document_type


class GetAllDocumentsResults(msrest.serialization.Model):
    """GetAllDocumentsResults.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. Number of documents in result.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar results: Required.
    :vartype results: list[~affinda.models.Document]
    """

    _validation = {
        "count": {"required": True},
        "results": {"required": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "results": {"key": "results", "type": "[Document]"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: List["_models.Document"],
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword count: Required. Number of documents in result.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword results: Required.
        :paramtype results: list[~affinda.models.Document]
        """
        super(GetAllDocumentsResults, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.results = results


class GetAllInvoicesResults(msrest.serialization.Model):
    """GetAllInvoicesResults.

    :ivar count: Number of documents in result.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar results:
    :vartype results: list[~affinda.models.Meta]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "results": {"key": "results", "type": "[Meta]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        results: Optional[List["_models.Meta"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Number of documents in result.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword results:
        :paramtype results: list[~affinda.models.Meta]
        """
        super(GetAllInvoicesResults, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.results = results


class GetAllJobDescriptionsResults(msrest.serialization.Model):
    """GetAllJobDescriptionsResults.

    :ivar count: Number of documents in result.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar results:
    :vartype results: list[~affinda.models.Meta]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "results": {"key": "results", "type": "[Meta]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        results: Optional[List["_models.Meta"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Number of documents in result.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword results:
        :paramtype results: list[~affinda.models.Meta]
        """
        super(GetAllJobDescriptionsResults, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.results = results


class IndexRequestBody(msrest.serialization.Model):
    """IndexRequestBody.

    :ivar name:
    :vartype name: str
    :ivar document_type: Known values are: "resumes", "job_descriptions".
    :vartype document_type: str or ~affinda.models.PostContentSchemaDocumentType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "document_type": {"key": "documentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        document_type: Optional[Union[str, "_models.PostContentSchemaDocumentType"]] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword document_type: Known values are: "resumes", "job_descriptions".
        :paramtype document_type: str or ~affinda.models.PostContentSchemaDocumentType
        """
        super(IndexRequestBody, self).__init__(**kwargs)
        self.name = name
        self.document_type = document_type


class Invitation(msrest.serialization.Model):
    """Invitation.

    :ivar identifier: Uniquely identify an invitation.
    :vartype identifier: str
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar email: The email which the invitation is sent to.
    :vartype email: str
    :ivar role: Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    :ivar status: Known values are: "pending", "accepted", "declined".
    :vartype status: str or ~affinda.models.InvitationStatus
    :ivar expiry_date: The date after which the invitation expires. Default is 10 days from now.
    :vartype expiry_date: ~datetime.date
    :ivar invited_by:
    :vartype invited_by: ~affinda.models.User
    :ivar responded_by:
    :vartype responded_by: ~affinda.models.InvitationRespondedBy
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "email": {"key": "email", "type": "str"},
        "role": {"key": "role", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "expiry_date": {"key": "expiryDate", "type": "date"},
        "invited_by": {"key": "invitedBy", "type": "User"},
        "responded_by": {"key": "respondedBy", "type": "InvitationRespondedBy"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        organization: Optional["_models.Organization"] = None,
        email: Optional[str] = None,
        role: Optional[Union[str, "_models.OrganizationRole"]] = None,
        status: Optional[Union[str, "_models.InvitationStatus"]] = None,
        expiry_date: Optional[datetime.date] = None,
        invited_by: Optional["_models.User"] = None,
        responded_by: Optional["_models.InvitationRespondedBy"] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify an invitation.
        :paramtype identifier: str
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword email: The email which the invitation is sent to.
        :paramtype email: str
        :keyword role: Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        :keyword status: Known values are: "pending", "accepted", "declined".
        :paramtype status: str or ~affinda.models.InvitationStatus
        :keyword expiry_date: The date after which the invitation expires. Default is 10 days from now.
        :paramtype expiry_date: ~datetime.date
        :keyword invited_by:
        :paramtype invited_by: ~affinda.models.User
        :keyword responded_by:
        :paramtype responded_by: ~affinda.models.InvitationRespondedBy
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(Invitation, self).__init__(**kwargs)
        self.identifier = identifier
        self.organization = organization
        self.email = email
        self.role = role
        self.status = status
        self.expiry_date = expiry_date
        self.invited_by = invited_by
        self.responded_by = responded_by
        self.created_dt = created_dt


class InvitationCreate(msrest.serialization.Model):
    """InvitationCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar email: Required. The email which the invitation is sent to.
    :vartype email: str
    :ivar role: Required. Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    """

    _validation = {
        "organization": {"required": True},
        "email": {"required": True},
        "role": {"required": True},
    }

    _attribute_map = {
        "organization": {"key": "organization", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization: str,
        email: str,
        role: Union[str, "_models.OrganizationRole"],
        **kwargs,
    ):
        """
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword email: Required. The email which the invitation is sent to.
        :paramtype email: str
        :keyword role: Required. Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        """
        super(InvitationCreate, self).__init__(**kwargs)
        self.organization = organization
        self.email = email
        self.role = role


class User(msrest.serialization.Model):
    """User.

    :ivar id: Uniquely identify a user.
    :vartype id: int
    :ivar name:
    :vartype name: str
    :ivar username:
    :vartype username: str
    :ivar email:
    :vartype email: str
    :ivar avatar: URL of the user's avatar.
    :vartype avatar: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        username: Optional[str] = None,
        email: Optional[str] = None,
        avatar: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Uniquely identify a user.
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword username:
        :paramtype username: str
        :keyword email:
        :paramtype email: str
        :keyword avatar: URL of the user's avatar.
        :paramtype avatar: str
        """
        super(User, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.username = username
        self.email = email
        self.avatar = avatar


class InvitationRespondedBy(User):
    """InvitationRespondedBy.

    :ivar id: Uniquely identify a user.
    :vartype id: int
    :ivar name:
    :vartype name: str
    :ivar username:
    :vartype username: str
    :ivar email:
    :vartype email: str
    :ivar avatar: URL of the user's avatar.
    :vartype avatar: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        username: Optional[str] = None,
        email: Optional[str] = None,
        avatar: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Uniquely identify a user.
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword username:
        :paramtype username: str
        :keyword email:
        :paramtype email: str
        :keyword avatar: URL of the user's avatar.
        :paramtype avatar: str
        """
        super(InvitationRespondedBy, self).__init__(
            id=id, name=name, username=username, email=email, avatar=avatar, **kwargs
        )


class InvitationUpdate(msrest.serialization.Model):
    """InvitationUpdate.

    :ivar role: Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    """

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
    }

    def __init__(self, *, role: Optional[Union[str, "_models.OrganizationRole"]] = None, **kwargs):
        """
        :keyword role: Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        """
        super(InvitationUpdate, self).__init__(**kwargs)
        self.role = role


class Invoice(msrest.serialization.Model):
    """Invoice.

    All required parameters must be populated in order to send to Azure.

    :ivar client_verified_dt: Required.
    :vartype client_verified_dt: str
    :ivar data: Required.
    :vartype data: ~affinda.models.InvoiceData
    :ivar meta: Required.
    :vartype meta: ~affinda.models.Meta
    :ivar error: Required.
    :vartype error: ~affinda.models.Error
    """

    _validation = {
        "client_verified_dt": {"required": True},
        "data": {"required": True},
        "meta": {"required": True},
        "error": {"required": True},
    }

    _attribute_map = {
        "client_verified_dt": {"key": "clientVerifiedDt", "type": "str"},
        "data": {"key": "data", "type": "InvoiceData"},
        "meta": {"key": "meta", "type": "Meta"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        client_verified_dt: str,
        data: "_models.InvoiceData",
        meta: "_models.Meta",
        error: "_models.Error",
        **kwargs,
    ):
        """
        :keyword client_verified_dt: Required.
        :paramtype client_verified_dt: str
        :keyword data: Required.
        :paramtype data: ~affinda.models.InvoiceData
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.Meta
        :keyword error: Required.
        :paramtype error: ~affinda.models.Error
        """
        super(Invoice, self).__init__(**kwargs)
        self.client_verified_dt = client_verified_dt
        self.data = data
        self.meta = meta
        self.error = error


class InvoiceData(msrest.serialization.Model):
    """InvoiceData.

    :ivar tables:
    :vartype tables: list[~affinda.models.InvoiceDataTablesItem]
    :ivar invoice_date:
    :vartype invoice_date: ~affinda.models.DateAnnotation
    :ivar invoice_order_date:
    :vartype invoice_order_date: ~affinda.models.DateAnnotation
    :ivar payment_date_due:
    :vartype payment_date_due: ~affinda.models.DateAnnotation
    :ivar payment_amount_base:
    :vartype payment_amount_base: ~affinda.models.InvoiceDataPaymentAmountBase
    :ivar payment_amount_tax:
    :vartype payment_amount_tax: ~affinda.models.InvoiceDataPaymentAmountTax
    :ivar payment_amount_total:
    :vartype payment_amount_total: ~affinda.models.InvoiceDataPaymentAmountTotal
    :ivar payment_amount_paid:
    :vartype payment_amount_paid: ~affinda.models.InvoiceDataPaymentAmountPaid
    :ivar payment_amount_due:
    :vartype payment_amount_due: ~affinda.models.InvoiceDataPaymentAmountDue
    :ivar invoice_number:
    :vartype invoice_number: ~affinda.models.InvoiceDataInvoiceNumber
    :ivar invoice_purchase_order_number:
    :vartype invoice_purchase_order_number: ~affinda.models.InvoiceDataInvoicePurchaseOrderNumber
    :ivar supplier_business_number:
    :vartype supplier_business_number: ~affinda.models.InvoiceDataSupplierBusinessNumber
    :ivar customer_number:
    :vartype customer_number: ~affinda.models.InvoiceDataCustomerNumber
    :ivar customer_business_number:
    :vartype customer_business_number: ~affinda.models.InvoiceDataCustomerBusinessNumber
    :ivar payment_reference:
    :vartype payment_reference: ~affinda.models.InvoiceDataPaymentReference
    :ivar bank_account_number:
    :vartype bank_account_number: ~affinda.models.InvoiceDataBankAccountNumber
    :ivar supplier_vat:
    :vartype supplier_vat: ~affinda.models.InvoiceDataSupplierVat
    :ivar customer_vat:
    :vartype customer_vat: ~affinda.models.InvoiceDataCustomerVat
    :ivar bpay_biller_code:
    :vartype bpay_biller_code: ~affinda.models.InvoiceDataBpayBillerCode
    :ivar bpay_reference:
    :vartype bpay_reference: ~affinda.models.InvoiceDataBpayReference
    :ivar bank_sort_code:
    :vartype bank_sort_code: ~affinda.models.InvoiceDataBankSortCode
    :ivar bank_iban:
    :vartype bank_iban: ~affinda.models.InvoiceDataBankIban
    :ivar bank_swift:
    :vartype bank_swift: ~affinda.models.InvoiceDataBankSwift
    :ivar bank_bsb:
    :vartype bank_bsb: ~affinda.models.InvoiceDataBankBsb
    :ivar customer_contact_name:
    :vartype customer_contact_name: ~affinda.models.InvoiceDataCustomerContactName
    :ivar customer_company_name:
    :vartype customer_company_name: ~affinda.models.InvoiceDataCustomerCompanyName
    :ivar supplier_company_name:
    :vartype supplier_company_name: ~affinda.models.InvoiceDataSupplierCompanyName
    :ivar customer_billing_address:
    :vartype customer_billing_address: ~affinda.models.LocationAnnotation
    :ivar customer_delivery_address:
    :vartype customer_delivery_address: ~affinda.models.LocationAnnotation
    :ivar supplier_address:
    :vartype supplier_address: ~affinda.models.LocationAnnotation
    :ivar customer_phone_number:
    :vartype customer_phone_number: ~affinda.models.InvoiceDataCustomerPhoneNumber
    :ivar supplier_phone_number:
    :vartype supplier_phone_number: ~affinda.models.InvoiceDataSupplierPhoneNumber
    :ivar supplier_fax:
    :vartype supplier_fax: ~affinda.models.InvoiceDataSupplierFax
    :ivar customer_email:
    :vartype customer_email: ~affinda.models.InvoiceDataCustomerEmail
    :ivar supplier_email:
    :vartype supplier_email: ~affinda.models.InvoiceDataSupplierEmail
    :ivar supplier_website:
    :vartype supplier_website: ~affinda.models.InvoiceDataSupplierWebsite
    :ivar currency_code:
    :vartype currency_code: ~affinda.models.EnumAnnotationSerializer
    :ivar custom_fields: Dictionary of :code:`<any>`.
    :vartype custom_fields: dict[str, any]
    """

    _attribute_map = {
        "tables": {"key": "tables", "type": "[InvoiceDataTablesItem]"},
        "invoice_date": {"key": "invoiceDate", "type": "DateAnnotation"},
        "invoice_order_date": {"key": "invoiceOrderDate", "type": "DateAnnotation"},
        "payment_date_due": {"key": "paymentDateDue", "type": "DateAnnotation"},
        "payment_amount_base": {
            "key": "paymentAmountBase",
            "type": "InvoiceDataPaymentAmountBase",
        },
        "payment_amount_tax": {"key": "paymentAmountTax", "type": "InvoiceDataPaymentAmountTax"},
        "payment_amount_total": {
            "key": "paymentAmountTotal",
            "type": "InvoiceDataPaymentAmountTotal",
        },
        "payment_amount_paid": {
            "key": "paymentAmountPaid",
            "type": "InvoiceDataPaymentAmountPaid",
        },
        "payment_amount_due": {"key": "paymentAmountDue", "type": "InvoiceDataPaymentAmountDue"},
        "invoice_number": {"key": "invoiceNumber", "type": "InvoiceDataInvoiceNumber"},
        "invoice_purchase_order_number": {
            "key": "invoicePurchaseOrderNumber",
            "type": "InvoiceDataInvoicePurchaseOrderNumber",
        },
        "supplier_business_number": {
            "key": "supplierBusinessNumber",
            "type": "InvoiceDataSupplierBusinessNumber",
        },
        "customer_number": {"key": "customerNumber", "type": "InvoiceDataCustomerNumber"},
        "customer_business_number": {
            "key": "customerBusinessNumber",
            "type": "InvoiceDataCustomerBusinessNumber",
        },
        "payment_reference": {"key": "paymentReference", "type": "InvoiceDataPaymentReference"},
        "bank_account_number": {
            "key": "bankAccountNumber",
            "type": "InvoiceDataBankAccountNumber",
        },
        "supplier_vat": {"key": "supplierVat", "type": "InvoiceDataSupplierVat"},
        "customer_vat": {"key": "customerVat", "type": "InvoiceDataCustomerVat"},
        "bpay_biller_code": {"key": "bpayBillerCode", "type": "InvoiceDataBpayBillerCode"},
        "bpay_reference": {"key": "bpayReference", "type": "InvoiceDataBpayReference"},
        "bank_sort_code": {"key": "bankSortCode", "type": "InvoiceDataBankSortCode"},
        "bank_iban": {"key": "bankIban", "type": "InvoiceDataBankIban"},
        "bank_swift": {"key": "bankSwift", "type": "InvoiceDataBankSwift"},
        "bank_bsb": {"key": "bankBsb", "type": "InvoiceDataBankBsb"},
        "customer_contact_name": {
            "key": "customerContactName",
            "type": "InvoiceDataCustomerContactName",
        },
        "customer_company_name": {
            "key": "customerCompanyName",
            "type": "InvoiceDataCustomerCompanyName",
        },
        "supplier_company_name": {
            "key": "supplierCompanyName",
            "type": "InvoiceDataSupplierCompanyName",
        },
        "customer_billing_address": {
            "key": "customerBillingAddress",
            "type": "LocationAnnotation",
        },
        "customer_delivery_address": {
            "key": "customerDeliveryAddress",
            "type": "LocationAnnotation",
        },
        "supplier_address": {"key": "supplierAddress", "type": "LocationAnnotation"},
        "customer_phone_number": {
            "key": "customerPhoneNumber",
            "type": "InvoiceDataCustomerPhoneNumber",
        },
        "supplier_phone_number": {
            "key": "supplierPhoneNumber",
            "type": "InvoiceDataSupplierPhoneNumber",
        },
        "supplier_fax": {"key": "supplierFax", "type": "InvoiceDataSupplierFax"},
        "customer_email": {"key": "customerEmail", "type": "InvoiceDataCustomerEmail"},
        "supplier_email": {"key": "supplierEmail", "type": "InvoiceDataSupplierEmail"},
        "supplier_website": {"key": "supplierWebsite", "type": "InvoiceDataSupplierWebsite"},
        "currency_code": {"key": "currencyCode", "type": "EnumAnnotationSerializer"},
        "custom_fields": {"key": "customFields", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        tables: Optional[List["_models.InvoiceDataTablesItem"]] = None,
        invoice_date: Optional["_models.DateAnnotation"] = None,
        invoice_order_date: Optional["_models.DateAnnotation"] = None,
        payment_date_due: Optional["_models.DateAnnotation"] = None,
        payment_amount_base: Optional["_models.InvoiceDataPaymentAmountBase"] = None,
        payment_amount_tax: Optional["_models.InvoiceDataPaymentAmountTax"] = None,
        payment_amount_total: Optional["_models.InvoiceDataPaymentAmountTotal"] = None,
        payment_amount_paid: Optional["_models.InvoiceDataPaymentAmountPaid"] = None,
        payment_amount_due: Optional["_models.InvoiceDataPaymentAmountDue"] = None,
        invoice_number: Optional["_models.InvoiceDataInvoiceNumber"] = None,
        invoice_purchase_order_number: Optional[
            "_models.InvoiceDataInvoicePurchaseOrderNumber"
        ] = None,
        supplier_business_number: Optional["_models.InvoiceDataSupplierBusinessNumber"] = None,
        customer_number: Optional["_models.InvoiceDataCustomerNumber"] = None,
        customer_business_number: Optional["_models.InvoiceDataCustomerBusinessNumber"] = None,
        payment_reference: Optional["_models.InvoiceDataPaymentReference"] = None,
        bank_account_number: Optional["_models.InvoiceDataBankAccountNumber"] = None,
        supplier_vat: Optional["_models.InvoiceDataSupplierVat"] = None,
        customer_vat: Optional["_models.InvoiceDataCustomerVat"] = None,
        bpay_biller_code: Optional["_models.InvoiceDataBpayBillerCode"] = None,
        bpay_reference: Optional["_models.InvoiceDataBpayReference"] = None,
        bank_sort_code: Optional["_models.InvoiceDataBankSortCode"] = None,
        bank_iban: Optional["_models.InvoiceDataBankIban"] = None,
        bank_swift: Optional["_models.InvoiceDataBankSwift"] = None,
        bank_bsb: Optional["_models.InvoiceDataBankBsb"] = None,
        customer_contact_name: Optional["_models.InvoiceDataCustomerContactName"] = None,
        customer_company_name: Optional["_models.InvoiceDataCustomerCompanyName"] = None,
        supplier_company_name: Optional["_models.InvoiceDataSupplierCompanyName"] = None,
        customer_billing_address: Optional["_models.LocationAnnotation"] = None,
        customer_delivery_address: Optional["_models.LocationAnnotation"] = None,
        supplier_address: Optional["_models.LocationAnnotation"] = None,
        customer_phone_number: Optional["_models.InvoiceDataCustomerPhoneNumber"] = None,
        supplier_phone_number: Optional["_models.InvoiceDataSupplierPhoneNumber"] = None,
        supplier_fax: Optional["_models.InvoiceDataSupplierFax"] = None,
        customer_email: Optional["_models.InvoiceDataCustomerEmail"] = None,
        supplier_email: Optional["_models.InvoiceDataSupplierEmail"] = None,
        supplier_website: Optional["_models.InvoiceDataSupplierWebsite"] = None,
        currency_code: Optional["_models.EnumAnnotationSerializer"] = None,
        custom_fields: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        """
        :keyword tables:
        :paramtype tables: list[~affinda.models.InvoiceDataTablesItem]
        :keyword invoice_date:
        :paramtype invoice_date: ~affinda.models.DateAnnotation
        :keyword invoice_order_date:
        :paramtype invoice_order_date: ~affinda.models.DateAnnotation
        :keyword payment_date_due:
        :paramtype payment_date_due: ~affinda.models.DateAnnotation
        :keyword payment_amount_base:
        :paramtype payment_amount_base: ~affinda.models.InvoiceDataPaymentAmountBase
        :keyword payment_amount_tax:
        :paramtype payment_amount_tax: ~affinda.models.InvoiceDataPaymentAmountTax
        :keyword payment_amount_total:
        :paramtype payment_amount_total: ~affinda.models.InvoiceDataPaymentAmountTotal
        :keyword payment_amount_paid:
        :paramtype payment_amount_paid: ~affinda.models.InvoiceDataPaymentAmountPaid
        :keyword payment_amount_due:
        :paramtype payment_amount_due: ~affinda.models.InvoiceDataPaymentAmountDue
        :keyword invoice_number:
        :paramtype invoice_number: ~affinda.models.InvoiceDataInvoiceNumber
        :keyword invoice_purchase_order_number:
        :paramtype invoice_purchase_order_number: ~affinda.models.InvoiceDataInvoicePurchaseOrderNumber
        :keyword supplier_business_number:
        :paramtype supplier_business_number: ~affinda.models.InvoiceDataSupplierBusinessNumber
        :keyword customer_number:
        :paramtype customer_number: ~affinda.models.InvoiceDataCustomerNumber
        :keyword customer_business_number:
        :paramtype customer_business_number: ~affinda.models.InvoiceDataCustomerBusinessNumber
        :keyword payment_reference:
        :paramtype payment_reference: ~affinda.models.InvoiceDataPaymentReference
        :keyword bank_account_number:
        :paramtype bank_account_number: ~affinda.models.InvoiceDataBankAccountNumber
        :keyword supplier_vat:
        :paramtype supplier_vat: ~affinda.models.InvoiceDataSupplierVat
        :keyword customer_vat:
        :paramtype customer_vat: ~affinda.models.InvoiceDataCustomerVat
        :keyword bpay_biller_code:
        :paramtype bpay_biller_code: ~affinda.models.InvoiceDataBpayBillerCode
        :keyword bpay_reference:
        :paramtype bpay_reference: ~affinda.models.InvoiceDataBpayReference
        :keyword bank_sort_code:
        :paramtype bank_sort_code: ~affinda.models.InvoiceDataBankSortCode
        :keyword bank_iban:
        :paramtype bank_iban: ~affinda.models.InvoiceDataBankIban
        :keyword bank_swift:
        :paramtype bank_swift: ~affinda.models.InvoiceDataBankSwift
        :keyword bank_bsb:
        :paramtype bank_bsb: ~affinda.models.InvoiceDataBankBsb
        :keyword customer_contact_name:
        :paramtype customer_contact_name: ~affinda.models.InvoiceDataCustomerContactName
        :keyword customer_company_name:
        :paramtype customer_company_name: ~affinda.models.InvoiceDataCustomerCompanyName
        :keyword supplier_company_name:
        :paramtype supplier_company_name: ~affinda.models.InvoiceDataSupplierCompanyName
        :keyword customer_billing_address:
        :paramtype customer_billing_address: ~affinda.models.LocationAnnotation
        :keyword customer_delivery_address:
        :paramtype customer_delivery_address: ~affinda.models.LocationAnnotation
        :keyword supplier_address:
        :paramtype supplier_address: ~affinda.models.LocationAnnotation
        :keyword customer_phone_number:
        :paramtype customer_phone_number: ~affinda.models.InvoiceDataCustomerPhoneNumber
        :keyword supplier_phone_number:
        :paramtype supplier_phone_number: ~affinda.models.InvoiceDataSupplierPhoneNumber
        :keyword supplier_fax:
        :paramtype supplier_fax: ~affinda.models.InvoiceDataSupplierFax
        :keyword customer_email:
        :paramtype customer_email: ~affinda.models.InvoiceDataCustomerEmail
        :keyword supplier_email:
        :paramtype supplier_email: ~affinda.models.InvoiceDataSupplierEmail
        :keyword supplier_website:
        :paramtype supplier_website: ~affinda.models.InvoiceDataSupplierWebsite
        :keyword currency_code:
        :paramtype currency_code: ~affinda.models.EnumAnnotationSerializer
        :keyword custom_fields: Dictionary of :code:`<any>`.
        :paramtype custom_fields: dict[str, any]
        """
        super(InvoiceData, self).__init__(**kwargs)
        self.tables = tables
        self.invoice_date = invoice_date
        self.invoice_order_date = invoice_order_date
        self.payment_date_due = payment_date_due
        self.payment_amount_base = payment_amount_base
        self.payment_amount_tax = payment_amount_tax
        self.payment_amount_total = payment_amount_total
        self.payment_amount_paid = payment_amount_paid
        self.payment_amount_due = payment_amount_due
        self.invoice_number = invoice_number
        self.invoice_purchase_order_number = invoice_purchase_order_number
        self.supplier_business_number = supplier_business_number
        self.customer_number = customer_number
        self.customer_business_number = customer_business_number
        self.payment_reference = payment_reference
        self.bank_account_number = bank_account_number
        self.supplier_vat = supplier_vat
        self.customer_vat = customer_vat
        self.bpay_biller_code = bpay_biller_code
        self.bpay_reference = bpay_reference
        self.bank_sort_code = bank_sort_code
        self.bank_iban = bank_iban
        self.bank_swift = bank_swift
        self.bank_bsb = bank_bsb
        self.customer_contact_name = customer_contact_name
        self.customer_company_name = customer_company_name
        self.supplier_company_name = supplier_company_name
        self.customer_billing_address = customer_billing_address
        self.customer_delivery_address = customer_delivery_address
        self.supplier_address = supplier_address
        self.customer_phone_number = customer_phone_number
        self.supplier_phone_number = supplier_phone_number
        self.supplier_fax = supplier_fax
        self.customer_email = customer_email
        self.supplier_email = supplier_email
        self.supplier_website = supplier_website
        self.currency_code = currency_code
        self.custom_fields = custom_fields


class TextAnnotation(Annotation):
    """TextAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(TextAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class InvoiceDataBankAccountNumber(
    TextAnnotation, Components74A7C1SchemasInvoicedataPropertiesBankaccountnumberAllof1
):
    """InvoiceDataBankAccountNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataBankAccountNumber, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataBankBsb(
    TextAnnotation, Components1RrxgkvSchemasInvoicedataPropertiesBankbsbAllof1
):
    """InvoiceDataBankBsb.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataBankBsb, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataBankIban(
    TextAnnotation, Components1127QwqSchemasInvoicedataPropertiesBankibanAllof1
):
    """InvoiceDataBankIban.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataBankIban, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataBankSortCode(
    TextAnnotation, Components1QdassaSchemasInvoicedataPropertiesBanksortcodeAllof1
):
    """InvoiceDataBankSortCode.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataBankSortCode, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataBankSwift(
    TextAnnotation, Components1Roa72HSchemasInvoicedataPropertiesBankswiftAllof1
):
    """InvoiceDataBankSwift.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataBankSwift, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataBpayBillerCode(
    TextAnnotation, ComponentsA69Bd0SchemasInvoicedataPropertiesBpaybillercodeAllof1
):
    """InvoiceDataBpayBillerCode.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataBpayBillerCode, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataBpayReference(
    TextAnnotation, ComponentsW32SuaSchemasInvoicedataPropertiesBpayreferenceAllof1
):
    """InvoiceDataBpayReference.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataBpayReference, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataCustomerBusinessNumber(
    TextAnnotation, Components158Lya5SchemasInvoicedataPropertiesCustomerbusinessnumberAllof1
):
    """InvoiceDataCustomerBusinessNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataCustomerBusinessNumber, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataCustomerCompanyName(
    TextAnnotation, Components1O8OpknSchemasInvoicedataPropertiesCustomercompanynameAllof1
):
    """InvoiceDataCustomerCompanyName.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataCustomerCompanyName, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataCustomerContactName(
    TextAnnotation, ComponentsWv2QrxSchemasInvoicedataPropertiesCustomercontactnameAllof1
):
    """InvoiceDataCustomerContactName.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataCustomerContactName, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataCustomerEmail(
    TextAnnotation, Components1Y7HcurSchemasInvoicedataPropertiesCustomeremailAllof1
):
    """InvoiceDataCustomerEmail.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataCustomerEmail, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataCustomerNumber(
    TextAnnotation, Components105Abr3SchemasInvoicedataPropertiesCustomernumberAllof1
):
    """InvoiceDataCustomerNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataCustomerNumber, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataCustomerPhoneNumber(
    TextAnnotation, Components1YsiqwnSchemasInvoicedataPropertiesCustomerphonenumberAllof1
):
    """InvoiceDataCustomerPhoneNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataCustomerPhoneNumber, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataCustomerVat(
    TextAnnotation, ComponentsBeazccSchemasInvoicedataPropertiesCustomervatAllof1
):
    """InvoiceDataCustomerVat.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataCustomerVat, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataInvoiceNumber(
    TextAnnotation, Components5Rnu7ESchemasInvoicedataPropertiesInvoicenumberAllof1
):
    """InvoiceDataInvoiceNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataInvoiceNumber, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataInvoicePurchaseOrderNumber(
    TextAnnotation, ComponentsAq75Z8SchemasInvoicedataPropertiesInvoicepurchaseordernumberAllof1
):
    """InvoiceDataInvoicePurchaseOrderNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataInvoicePurchaseOrderNumber, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataPaymentAmountBase(
    TextAnnotation, Components1W3SqeuSchemasInvoicedataPropertiesPaymentamountbaseAllof1
):
    """InvoiceDataPaymentAmountBase.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataPaymentAmountBase, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataPaymentAmountDue(
    TextAnnotation, ComponentsEtsq6MSchemasInvoicedataPropertiesPaymentamountdueAllof1
):
    """InvoiceDataPaymentAmountDue.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataPaymentAmountDue, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataPaymentAmountPaid(
    TextAnnotation, Components1Vvtu5NSchemasInvoicedataPropertiesPaymentamountpaidAllof1
):
    """InvoiceDataPaymentAmountPaid.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataPaymentAmountPaid, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataPaymentAmountTax(
    TextAnnotation, Components6Zm20BSchemasInvoicedataPropertiesPaymentamounttaxAllof1
):
    """InvoiceDataPaymentAmountTax.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataPaymentAmountTax, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataPaymentAmountTotal(
    TextAnnotation, Components4A2PzvSchemasInvoicedataPropertiesPaymentamounttotalAllof1
):
    """InvoiceDataPaymentAmountTotal.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataPaymentAmountTotal, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataPaymentReference(
    TextAnnotation, Components2XnshtSchemasInvoicedataPropertiesPaymentreferenceAllof1
):
    """InvoiceDataPaymentReference.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataPaymentReference, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataSupplierBusinessNumber(
    TextAnnotation, Components5D6NjySchemasInvoicedataPropertiesSupplierbusinessnumberAllof1
):
    """InvoiceDataSupplierBusinessNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataSupplierBusinessNumber, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataSupplierCompanyName(
    TextAnnotation, Components1P4Fl61SchemasInvoicedataPropertiesSuppliercompanynameAllof1
):
    """InvoiceDataSupplierCompanyName.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataSupplierCompanyName, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataSupplierEmail(
    TextAnnotation, Components10Thcs2SchemasInvoicedataPropertiesSupplieremailAllof1
):
    """InvoiceDataSupplierEmail.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataSupplierEmail, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataSupplierFax(
    TextAnnotation, Components1Fe3VqtSchemasInvoicedataPropertiesSupplierfaxAllof1
):
    """InvoiceDataSupplierFax.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataSupplierFax, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataSupplierPhoneNumber(
    TextAnnotation, Components1Hr2XldSchemasInvoicedataPropertiesSupplierphonenumberAllof1
):
    """InvoiceDataSupplierPhoneNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataSupplierPhoneNumber, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataSupplierVat(
    TextAnnotation, ComponentsB3U7OaSchemasInvoicedataPropertiesSuppliervatAllof1
):
    """InvoiceDataSupplierVat.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataSupplierVat, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataSupplierWebsite(
    TextAnnotation, Components17JmwpjSchemasInvoicedataPropertiesSupplierwebsiteAllof1
):
    """InvoiceDataSupplierWebsite.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(InvoiceDataSupplierWebsite, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            parsed=parsed,
            **kwargs,
        )
        self.additional_properties = additional_properties
        self.id = id
        self.rectangle = rectangle
        self.rectangles = rectangles
        self.page_index = page_index
        self.raw = raw
        self.confidence = confidence
        self.classification_confidence = classification_confidence
        self.text_extraction_confidence = text_extraction_confidence
        self.is_verified = is_verified
        self.is_client_verified = is_client_verified
        self.is_auto_verified = is_auto_verified
        self.data_point = data_point
        self.content_type = content_type
        self.parsed = parsed


class InvoiceDataTablesItem(msrest.serialization.Model):
    """InvoiceDataTablesItem.

    :ivar rows:
    :vartype rows: list[~affinda.models.RowAnnotation]
    """

    _attribute_map = {
        "rows": {"key": "rows", "type": "[RowAnnotation]"},
    }

    def __init__(self, *, rows: Optional[List["_models.RowAnnotation"]] = None, **kwargs):
        """
        :keyword rows:
        :paramtype rows: list[~affinda.models.RowAnnotation]
        """
        super(InvoiceDataTablesItem, self).__init__(**kwargs)
        self.rows = rows


class InvoiceRequestBody(msrest.serialization.Model):
    """InvoiceRequestBody.

    :ivar file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML, PNG,
     JPG.
    :vartype file: IO
    :ivar url: URL to an invoice to download and process.
    :vartype url: str
    :ivar identifier: A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar wait: If "true" (default), will return a response only after processing has completed. If
     "false", will return an empty data object which can be polled at the GET endpoint until
     processing is complete.
    :vartype wait: bool
    :ivar reject_duplicates: If "true", parsing will fail when the uploaded document is duplicate
     of an existing document. If "false" (default), will parse the document normally whether its a
     duplicate or not.
    :vartype reject_duplicates: bool
    :ivar language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
    :vartype language: str
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    """

    _attribute_map = {
        "file": {"key": "file", "type": "IO"},
        "url": {"key": "url", "type": "str"},
        "identifier": {"key": "identifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "wait": {"key": "wait", "type": "bool"},
        "reject_duplicates": {"key": "rejectDuplicates", "type": "bool"},
        "language": {"key": "language", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML,
         PNG, JPG.
        :paramtype file: IO
        :keyword url: URL to an invoice to download and process.
        :paramtype url: str
        :keyword identifier: A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword wait: If "true" (default), will return a response only after processing has completed.
         If "false", will return an empty data object which can be polled at the GET endpoint until
         processing is complete.
        :paramtype wait: bool
        :keyword reject_duplicates: If "true", parsing will fail when the uploaded document is
         duplicate of an existing document. If "false" (default), will parse the document normally
         whether its a duplicate or not.
        :paramtype reject_duplicates: bool
        :keyword language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
        :paramtype language: str
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        """
        super(InvoiceRequestBody, self).__init__(**kwargs)
        self.file = file
        self.url = url
        self.identifier = identifier
        self.file_name = file_name
        self.wait = wait
        self.reject_duplicates = reject_duplicates
        self.language = language
        self.expiry_time = expiry_time


class JobDescription(msrest.serialization.Model):
    """JobDescription.

    All required parameters must be populated in order to send to Azure.

    :ivar data: Required.
    :vartype data: ~affinda.models.JobDescriptionData
    :ivar meta: Required.
    :vartype meta: ~affinda.models.Meta
    :ivar error: Required.
    :vartype error: ~affinda.models.Error
    """

    _validation = {
        "data": {"required": True},
        "meta": {"required": True},
        "error": {"required": True},
    }

    _attribute_map = {
        "data": {"key": "data", "type": "JobDescriptionData"},
        "meta": {"key": "meta", "type": "Meta"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        data: "_models.JobDescriptionData",
        meta: "_models.Meta",
        error: "_models.Error",
        **kwargs,
    ):
        """
        :keyword data: Required.
        :paramtype data: ~affinda.models.JobDescriptionData
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.Meta
        :keyword error: Required.
        :paramtype error: ~affinda.models.Error
        """
        super(JobDescription, self).__init__(**kwargs)
        self.data = data
        self.meta = meta
        self.error = error


class JobDescriptionData(msrest.serialization.Model):
    """JobDescriptionData.

    :ivar job_title:
    :vartype job_title: ~affinda.models.JobTitleAnnotation
    :ivar contact_email:
    :vartype contact_email: ~affinda.models.TextAnnotation
    :ivar contact_name:
    :vartype contact_name: ~affinda.models.TextAnnotation
    :ivar contact_phone:
    :vartype contact_phone: ~affinda.models.TextAnnotation
    :ivar start_date:
    :vartype start_date: ~affinda.models.DateAnnotation
    :ivar end_date:
    :vartype end_date: ~affinda.models.DateAnnotation
    :ivar job_type:
    :vartype job_type: ~affinda.models.TextAnnotation
    :ivar languages:
    :vartype languages: list[~affinda.models.LanguageAnnotation]
    :ivar skills:
    :vartype skills: list[~affinda.models.SkillAnnotation]
    :ivar organization_name:
    :vartype organization_name: ~affinda.models.TextAnnotation
    :ivar organization_website:
    :vartype organization_website: ~affinda.models.TextAnnotation
    :ivar education_level:
    :vartype education_level: ~affinda.models.TextAnnotation
    :ivar education_accreditation:
    :vartype education_accreditation: ~affinda.models.TextAnnotation
    :ivar expected_remuneration:
    :vartype expected_remuneration: ~affinda.models.ExpectedRemunerationAnnotation
    :ivar location:
    :vartype location: ~affinda.models.LocationAnnotation
    :ivar certifications:
    :vartype certifications: list[~affinda.models.TextAnnotation]
    :ivar years_experience:
    :vartype years_experience: ~affinda.models.YearsExperienceAnnotation
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "JobTitleAnnotation"},
        "contact_email": {"key": "contactEmail", "type": "TextAnnotation"},
        "contact_name": {"key": "contactName", "type": "TextAnnotation"},
        "contact_phone": {"key": "contactPhone", "type": "TextAnnotation"},
        "start_date": {"key": "startDate", "type": "DateAnnotation"},
        "end_date": {"key": "endDate", "type": "DateAnnotation"},
        "job_type": {"key": "jobType", "type": "TextAnnotation"},
        "languages": {"key": "languages", "type": "[LanguageAnnotation]"},
        "skills": {"key": "skills", "type": "[SkillAnnotation]"},
        "organization_name": {"key": "organizationName", "type": "TextAnnotation"},
        "organization_website": {"key": "organizationWebsite", "type": "TextAnnotation"},
        "education_level": {"key": "educationLevel", "type": "TextAnnotation"},
        "education_accreditation": {"key": "educationAccreditation", "type": "TextAnnotation"},
        "expected_remuneration": {
            "key": "expectedRemuneration",
            "type": "ExpectedRemunerationAnnotation",
        },
        "location": {"key": "location", "type": "LocationAnnotation"},
        "certifications": {"key": "certifications", "type": "[TextAnnotation]"},
        "years_experience": {"key": "yearsExperience", "type": "YearsExperienceAnnotation"},
    }

    def __init__(
        self,
        *,
        job_title: Optional["_models.JobTitleAnnotation"] = None,
        contact_email: Optional["_models.TextAnnotation"] = None,
        contact_name: Optional["_models.TextAnnotation"] = None,
        contact_phone: Optional["_models.TextAnnotation"] = None,
        start_date: Optional["_models.DateAnnotation"] = None,
        end_date: Optional["_models.DateAnnotation"] = None,
        job_type: Optional["_models.TextAnnotation"] = None,
        languages: Optional[List["_models.LanguageAnnotation"]] = None,
        skills: Optional[List["_models.SkillAnnotation"]] = None,
        organization_name: Optional["_models.TextAnnotation"] = None,
        organization_website: Optional["_models.TextAnnotation"] = None,
        education_level: Optional["_models.TextAnnotation"] = None,
        education_accreditation: Optional["_models.TextAnnotation"] = None,
        expected_remuneration: Optional["_models.ExpectedRemunerationAnnotation"] = None,
        location: Optional["_models.LocationAnnotation"] = None,
        certifications: Optional[List["_models.TextAnnotation"]] = None,
        years_experience: Optional["_models.YearsExperienceAnnotation"] = None,
        **kwargs,
    ):
        """
        :keyword job_title:
        :paramtype job_title: ~affinda.models.JobTitleAnnotation
        :keyword contact_email:
        :paramtype contact_email: ~affinda.models.TextAnnotation
        :keyword contact_name:
        :paramtype contact_name: ~affinda.models.TextAnnotation
        :keyword contact_phone:
        :paramtype contact_phone: ~affinda.models.TextAnnotation
        :keyword start_date:
        :paramtype start_date: ~affinda.models.DateAnnotation
        :keyword end_date:
        :paramtype end_date: ~affinda.models.DateAnnotation
        :keyword job_type:
        :paramtype job_type: ~affinda.models.TextAnnotation
        :keyword languages:
        :paramtype languages: list[~affinda.models.LanguageAnnotation]
        :keyword skills:
        :paramtype skills: list[~affinda.models.SkillAnnotation]
        :keyword organization_name:
        :paramtype organization_name: ~affinda.models.TextAnnotation
        :keyword organization_website:
        :paramtype organization_website: ~affinda.models.TextAnnotation
        :keyword education_level:
        :paramtype education_level: ~affinda.models.TextAnnotation
        :keyword education_accreditation:
        :paramtype education_accreditation: ~affinda.models.TextAnnotation
        :keyword expected_remuneration:
        :paramtype expected_remuneration: ~affinda.models.ExpectedRemunerationAnnotation
        :keyword location:
        :paramtype location: ~affinda.models.LocationAnnotation
        :keyword certifications:
        :paramtype certifications: list[~affinda.models.TextAnnotation]
        :keyword years_experience:
        :paramtype years_experience: ~affinda.models.YearsExperienceAnnotation
        """
        super(JobDescriptionData, self).__init__(**kwargs)
        self.job_title = job_title
        self.contact_email = contact_email
        self.contact_name = contact_name
        self.contact_phone = contact_phone
        self.start_date = start_date
        self.end_date = end_date
        self.job_type = job_type
        self.languages = languages
        self.skills = skills
        self.organization_name = organization_name
        self.organization_website = organization_website
        self.education_level = education_level
        self.education_accreditation = education_accreditation
        self.expected_remuneration = expected_remuneration
        self.location = location
        self.certifications = certifications
        self.years_experience = years_experience


class JobDescriptionRequestBody(msrest.serialization.Model):
    """JobDescriptionRequestBody.

    :ivar file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML, PNG,
     JPG.
    :vartype file: IO
    :ivar url: URL to a job description to download and process.
    :vartype url: str
    :ivar identifier: A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar wait: If "true" (default), will return a response only after processing has completed. If
     "false", will return an empty data object which can be polled at the GET endpoint until
     processing is complete.
    :vartype wait: bool
    :ivar reject_duplicates: If "true", parsing will fail when the uploaded document is duplicate
     of an existing document. If "false" (default), will parse the document normally whether its a
     duplicate or not.
    :vartype reject_duplicates: bool
    :ivar language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
    :vartype language: str
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    """

    _attribute_map = {
        "file": {"key": "file", "type": "IO"},
        "url": {"key": "url", "type": "str"},
        "identifier": {"key": "identifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "wait": {"key": "wait", "type": "bool"},
        "reject_duplicates": {"key": "rejectDuplicates", "type": "bool"},
        "language": {"key": "language", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML,
         PNG, JPG.
        :paramtype file: IO
        :keyword url: URL to a job description to download and process.
        :paramtype url: str
        :keyword identifier: A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword wait: If "true" (default), will return a response only after processing has completed.
         If "false", will return an empty data object which can be polled at the GET endpoint until
         processing is complete.
        :paramtype wait: bool
        :keyword reject_duplicates: If "true", parsing will fail when the uploaded document is
         duplicate of an existing document. If "false" (default), will parse the document normally
         whether its a duplicate or not.
        :paramtype reject_duplicates: bool
        :keyword language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
        :paramtype language: str
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        """
        super(JobDescriptionRequestBody, self).__init__(**kwargs)
        self.file = file
        self.url = url
        self.identifier = identifier
        self.file_name = file_name
        self.wait = wait
        self.reject_duplicates = reject_duplicates
        self.language = language
        self.expiry_time = expiry_time


class JobDescriptionSearch(msrest.serialization.Model):
    """JobDescriptionSearch.

    :ivar count: Total number of results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar parameters:
    :vartype parameters: ~affinda.models.JobDescriptionSearchParameters
    :ivar results:
    :vartype results: list[~affinda.models.JobDescriptionSearchResult]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "parameters": {"key": "parameters", "type": "JobDescriptionSearchParameters"},
        "results": {"key": "results", "type": "[JobDescriptionSearchResult]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        parameters: Optional["_models.JobDescriptionSearchParameters"] = None,
        results: Optional[List["_models.JobDescriptionSearchResult"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Total number of results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword parameters:
        :paramtype parameters: ~affinda.models.JobDescriptionSearchParameters
        :keyword results:
        :paramtype results: list[~affinda.models.JobDescriptionSearchResult]
        """
        super(JobDescriptionSearch, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.parameters = parameters
        self.results = results


class JobDescriptionSearchConfig(msrest.serialization.Model):
    """JobDescriptionSearchConfig.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allow_pdf_download:
    :vartype allow_pdf_download: bool
    :ivar max_results: Maximum number of results that can be returned. Setting to "null" means no
     limitation.
    :vartype max_results: int
    :ivar display_job_title:
    :vartype display_job_title: bool
    :ivar display_location:
    :vartype display_location: bool
    :ivar display_years_experience:
    :vartype display_years_experience: bool
    :ivar display_occupation_group:
    :vartype display_occupation_group: bool
    :ivar display_education:
    :vartype display_education: bool
    :ivar display_skills:
    :vartype display_skills: bool
    :ivar display_languages:
    :vartype display_languages: bool
    :ivar display_management_level:
    :vartype display_management_level: bool
    :ivar display_keywords:
    :vartype display_keywords: bool
    :ivar weight_job_title:
    :vartype weight_job_title: float
    :ivar weight_location:
    :vartype weight_location: float
    :ivar weight_years_experience:
    :vartype weight_years_experience: float
    :ivar weight_occupation_group:
    :vartype weight_occupation_group: float
    :ivar weight_education:
    :vartype weight_education: float
    :ivar weight_skills:
    :vartype weight_skills: float
    :ivar weight_languages:
    :vartype weight_languages: float
    :ivar weight_management_level:
    :vartype weight_management_level: float
    :ivar weight_keywords:
    :vartype weight_keywords: float
    :ivar indices: List of index names.
    :vartype indices: list[str]
    :ivar search_tool_theme: Customize the theme of the embeded search tool.
    :vartype search_tool_theme: dict[str, any]
    :ivar user_id: ID of the logged in user.
    :vartype user_id: int
    :ivar username: Username of the logged in user.
    :vartype username: str
    :ivar actions: A list of actions to show in the dropdown in the embedded search tool.
    :vartype actions: list[~affinda.models.JobDescriptionSearchConfigActionsItem]
    """

    _validation = {
        "user_id": {"readonly": True},
        "username": {"readonly": True},
    }

    _attribute_map = {
        "allow_pdf_download": {"key": "allowPdfDownload", "type": "bool"},
        "max_results": {"key": "maxResults", "type": "int"},
        "display_job_title": {"key": "displayJobTitle", "type": "bool"},
        "display_location": {"key": "displayLocation", "type": "bool"},
        "display_years_experience": {"key": "displayYearsExperience", "type": "bool"},
        "display_occupation_group": {"key": "displayOccupationGroup", "type": "bool"},
        "display_education": {"key": "displayEducation", "type": "bool"},
        "display_skills": {"key": "displaySkills", "type": "bool"},
        "display_languages": {"key": "displayLanguages", "type": "bool"},
        "display_management_level": {"key": "displayManagementLevel", "type": "bool"},
        "display_keywords": {"key": "displayKeywords", "type": "bool"},
        "weight_job_title": {"key": "weightJobTitle", "type": "float"},
        "weight_location": {"key": "weightLocation", "type": "float"},
        "weight_years_experience": {"key": "weightYearsExperience", "type": "float"},
        "weight_occupation_group": {"key": "weightOccupationGroup", "type": "float"},
        "weight_education": {"key": "weightEducation", "type": "float"},
        "weight_skills": {"key": "weightSkills", "type": "float"},
        "weight_languages": {"key": "weightLanguages", "type": "float"},
        "weight_management_level": {"key": "weightManagementLevel", "type": "float"},
        "weight_keywords": {"key": "weightKeywords", "type": "float"},
        "indices": {"key": "indices", "type": "[str]"},
        "search_tool_theme": {"key": "searchToolTheme", "type": "{object}"},
        "user_id": {"key": "userId", "type": "int"},
        "username": {"key": "username", "type": "str"},
        "actions": {"key": "actions", "type": "[JobDescriptionSearchConfigActionsItem]"},
    }

    def __init__(
        self,
        *,
        allow_pdf_download: Optional[bool] = None,
        max_results: Optional[int] = None,
        display_job_title: Optional[bool] = None,
        display_location: Optional[bool] = None,
        display_years_experience: Optional[bool] = None,
        display_occupation_group: Optional[bool] = None,
        display_education: Optional[bool] = None,
        display_skills: Optional[bool] = None,
        display_languages: Optional[bool] = None,
        display_management_level: Optional[bool] = None,
        display_keywords: Optional[bool] = None,
        weight_job_title: Optional[float] = None,
        weight_location: Optional[float] = None,
        weight_years_experience: Optional[float] = None,
        weight_occupation_group: Optional[float] = None,
        weight_education: Optional[float] = None,
        weight_skills: Optional[float] = None,
        weight_languages: Optional[float] = None,
        weight_management_level: Optional[float] = None,
        weight_keywords: Optional[float] = None,
        indices: Optional[List[str]] = None,
        search_tool_theme: Optional[Dict[str, Any]] = None,
        actions: Optional[List["_models.JobDescriptionSearchConfigActionsItem"]] = None,
        **kwargs,
    ):
        """
        :keyword allow_pdf_download:
        :paramtype allow_pdf_download: bool
        :keyword max_results: Maximum number of results that can be returned. Setting to "null" means
         no limitation.
        :paramtype max_results: int
        :keyword display_job_title:
        :paramtype display_job_title: bool
        :keyword display_location:
        :paramtype display_location: bool
        :keyword display_years_experience:
        :paramtype display_years_experience: bool
        :keyword display_occupation_group:
        :paramtype display_occupation_group: bool
        :keyword display_education:
        :paramtype display_education: bool
        :keyword display_skills:
        :paramtype display_skills: bool
        :keyword display_languages:
        :paramtype display_languages: bool
        :keyword display_management_level:
        :paramtype display_management_level: bool
        :keyword display_keywords:
        :paramtype display_keywords: bool
        :keyword weight_job_title:
        :paramtype weight_job_title: float
        :keyword weight_location:
        :paramtype weight_location: float
        :keyword weight_years_experience:
        :paramtype weight_years_experience: float
        :keyword weight_occupation_group:
        :paramtype weight_occupation_group: float
        :keyword weight_education:
        :paramtype weight_education: float
        :keyword weight_skills:
        :paramtype weight_skills: float
        :keyword weight_languages:
        :paramtype weight_languages: float
        :keyword weight_management_level:
        :paramtype weight_management_level: float
        :keyword weight_keywords:
        :paramtype weight_keywords: float
        :keyword indices: List of index names.
        :paramtype indices: list[str]
        :keyword search_tool_theme: Customize the theme of the embeded search tool.
        :paramtype search_tool_theme: dict[str, any]
        :keyword actions: A list of actions to show in the dropdown in the embedded search tool.
        :paramtype actions: list[~affinda.models.JobDescriptionSearchConfigActionsItem]
        """
        super(JobDescriptionSearchConfig, self).__init__(**kwargs)
        self.allow_pdf_download = allow_pdf_download
        self.max_results = max_results
        self.display_job_title = display_job_title
        self.display_location = display_location
        self.display_years_experience = display_years_experience
        self.display_occupation_group = display_occupation_group
        self.display_education = display_education
        self.display_skills = display_skills
        self.display_languages = display_languages
        self.display_management_level = display_management_level
        self.display_keywords = display_keywords
        self.weight_job_title = weight_job_title
        self.weight_location = weight_location
        self.weight_years_experience = weight_years_experience
        self.weight_occupation_group = weight_occupation_group
        self.weight_education = weight_education
        self.weight_skills = weight_skills
        self.weight_languages = weight_languages
        self.weight_management_level = weight_management_level
        self.weight_keywords = weight_keywords
        self.indices = indices
        self.search_tool_theme = search_tool_theme
        self.user_id = None
        self.username = None
        self.actions = actions


class JobDescriptionSearchConfigActionsItem(msrest.serialization.Model):
    """JobDescriptionSearchConfigActionsItem.

    :ivar label: Human readable label to display in the UI.
    :vartype label: str
    :ivar event_name: Name of the event to be triggered.
    :vartype event_name: str
    """

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "event_name": {"key": "eventName", "type": "str"},
    }

    def __init__(self, *, label: Optional[str] = None, event_name: Optional[str] = None, **kwargs):
        """
        :keyword label: Human readable label to display in the UI.
        :paramtype label: str
        :keyword event_name: Name of the event to be triggered.
        :paramtype event_name: str
        """
        super(JobDescriptionSearchConfigActionsItem, self).__init__(**kwargs)
        self.label = label
        self.event_name = event_name


class JobDescriptionSearchDetail(msrest.serialization.Model):
    """JobDescriptionSearchDetail.

    :ivar job_title:
    :vartype job_title: ~affinda.models.JobDescriptionSearchDetailJobTitle
    :ivar location:
    :vartype location: ~affinda.models.JobDescriptionSearchDetailLocation
    :ivar education:
    :vartype education: ~affinda.models.JobDescriptionSearchDetailEducation
    :ivar skills:
    :vartype skills: ~affinda.models.JobDescriptionSearchDetailSkills
    :ivar experience:
    :vartype experience: ~affinda.models.JobDescriptionSearchDetailExperience
    :ivar occupation_group:
    :vartype occupation_group: ~affinda.models.JobDescriptionSearchDetailOccupationGroup
    :ivar languages:
    :vartype languages: ~affinda.models.JobDescriptionSearchDetailLanguages
    :ivar management_level:
    :vartype management_level: ~affinda.models.JobDescriptionSearchDetailManagementLevel
    :ivar search_expression:
    :vartype search_expression: ~affinda.models.JobDescriptionSearchDetailSearchExpression
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "JobDescriptionSearchDetailJobTitle"},
        "location": {"key": "location", "type": "JobDescriptionSearchDetailLocation"},
        "education": {"key": "education", "type": "JobDescriptionSearchDetailEducation"},
        "skills": {"key": "skills", "type": "JobDescriptionSearchDetailSkills"},
        "experience": {"key": "experience", "type": "JobDescriptionSearchDetailExperience"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "JobDescriptionSearchDetailOccupationGroup",
        },
        "languages": {"key": "languages", "type": "JobDescriptionSearchDetailLanguages"},
        "management_level": {
            "key": "managementLevel",
            "type": "JobDescriptionSearchDetailManagementLevel",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "JobDescriptionSearchDetailSearchExpression",
        },
    }

    def __init__(
        self,
        *,
        job_title: Optional["_models.JobDescriptionSearchDetailJobTitle"] = None,
        location: Optional["_models.JobDescriptionSearchDetailLocation"] = None,
        education: Optional["_models.JobDescriptionSearchDetailEducation"] = None,
        skills: Optional["_models.JobDescriptionSearchDetailSkills"] = None,
        experience: Optional["_models.JobDescriptionSearchDetailExperience"] = None,
        occupation_group: Optional["_models.JobDescriptionSearchDetailOccupationGroup"] = None,
        languages: Optional["_models.JobDescriptionSearchDetailLanguages"] = None,
        management_level: Optional["_models.JobDescriptionSearchDetailManagementLevel"] = None,
        search_expression: Optional["_models.JobDescriptionSearchDetailSearchExpression"] = None,
        **kwargs,
    ):
        """
        :keyword job_title:
        :paramtype job_title: ~affinda.models.JobDescriptionSearchDetailJobTitle
        :keyword location:
        :paramtype location: ~affinda.models.JobDescriptionSearchDetailLocation
        :keyword education:
        :paramtype education: ~affinda.models.JobDescriptionSearchDetailEducation
        :keyword skills:
        :paramtype skills: ~affinda.models.JobDescriptionSearchDetailSkills
        :keyword experience:
        :paramtype experience: ~affinda.models.JobDescriptionSearchDetailExperience
        :keyword occupation_group:
        :paramtype occupation_group: ~affinda.models.JobDescriptionSearchDetailOccupationGroup
        :keyword languages:
        :paramtype languages: ~affinda.models.JobDescriptionSearchDetailLanguages
        :keyword management_level:
        :paramtype management_level: ~affinda.models.JobDescriptionSearchDetailManagementLevel
        :keyword search_expression:
        :paramtype search_expression: ~affinda.models.JobDescriptionSearchDetailSearchExpression
        """
        super(JobDescriptionSearchDetail, self).__init__(**kwargs)
        self.job_title = job_title
        self.location = location
        self.education = education
        self.skills = skills
        self.experience = experience
        self.occupation_group = occupation_group
        self.languages = languages
        self.management_level = management_level
        self.search_expression = search_expression


class JobDescriptionSearchDetailEducation(msrest.serialization.Model):
    """JobDescriptionSearchDetailEducation.

    :ivar missing:
    :vartype missing: ~affinda.models.JobDescriptionSearchDetailEducationMissing
    :ivar value:
    :vartype value: ~affinda.models.JobDescriptionSearchDetailEducationValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "JobDescriptionSearchDetailEducationMissing"},
        "value": {"key": "value", "type": "JobDescriptionSearchDetailEducationValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional["_models.JobDescriptionSearchDetailEducationMissing"] = None,
        value: Optional["_models.JobDescriptionSearchDetailEducationValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: ~affinda.models.JobDescriptionSearchDetailEducationMissing
        :keyword value:
        :paramtype value: ~affinda.models.JobDescriptionSearchDetailEducationValue
        """
        super(JobDescriptionSearchDetailEducation, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailEducationMissing(msrest.serialization.Model):
    """JobDescriptionSearchDetailEducationMissing.

    :ivar degrees:
    :vartype degrees: list[str]
    :ivar degree_types:
    :vartype degree_types: list[str]
    """

    _attribute_map = {
        "degrees": {"key": "degrees", "type": "[str]"},
        "degree_types": {"key": "degreeTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        degrees: Optional[List[str]] = None,
        degree_types: Optional[List[str]] = None,
        **kwargs,
    ):
        """
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword degree_types:
        :paramtype degree_types: list[str]
        """
        super(JobDescriptionSearchDetailEducationMissing, self).__init__(**kwargs)
        self.degrees = degrees
        self.degree_types = degree_types


class JobDescriptionSearchDetailEducationValue(msrest.serialization.Model):
    """JobDescriptionSearchDetailEducationValue.

    :ivar degrees:
    :vartype degrees: list[str]
    :ivar degree_types:
    :vartype degree_types: list[str]
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "degrees": {"key": "degrees", "type": "[str]"},
        "degree_types": {"key": "degreeTypes", "type": "[str]"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        degrees: Optional[List[str]] = None,
        degree_types: Optional[List[str]] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword degree_types:
        :paramtype degree_types: list[str]
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailEducationValue, self).__init__(**kwargs)
        self.degrees = degrees
        self.degree_types = degree_types
        self.match = match


class JobDescriptionSearchDetailExperience(msrest.serialization.Model):
    """JobDescriptionSearchDetailExperience.

    :ivar minimum_experience:
    :vartype minimum_experience: int
    :ivar maximum_experience:
    :vartype maximum_experience: int
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "minimum_experience": {"key": "minimumExperience", "type": "int"},
        "maximum_experience": {"key": "maximumExperience", "type": "int"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        minimum_experience: Optional[int] = None,
        maximum_experience: Optional[int] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword minimum_experience:
        :paramtype minimum_experience: int
        :keyword maximum_experience:
        :paramtype maximum_experience: int
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailExperience, self).__init__(**kwargs)
        self.minimum_experience = minimum_experience
        self.maximum_experience = maximum_experience
        self.match = match


class JobDescriptionSearchDetailJobTitle(msrest.serialization.Model):
    """JobDescriptionSearchDetailJobTitle.

    :ivar missing:
    :vartype missing: list[str]
    :ivar value:
    :vartype value: ~affinda.models.JobDescriptionSearchDetailJobTitleValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[str]"},
        "value": {"key": "value", "type": "JobDescriptionSearchDetailJobTitleValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List[str]] = None,
        value: Optional["_models.JobDescriptionSearchDetailJobTitleValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[str]
        :keyword value:
        :paramtype value: ~affinda.models.JobDescriptionSearchDetailJobTitleValue
        """
        super(JobDescriptionSearchDetailJobTitle, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailJobTitleValue(msrest.serialization.Model):
    """JobDescriptionSearchDetailJobTitleValue.

    :ivar name:
    :vartype name: str
    :ivar company_name:
    :vartype company_name: str
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        company_name: Optional[str] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword company_name:
        :paramtype company_name: str
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailJobTitleValue, self).__init__(**kwargs)
        self.name = name
        self.company_name = company_name
        self.match = match


class JobDescriptionSearchDetailLanguages(msrest.serialization.Model):
    """JobDescriptionSearchDetailLanguages.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar value:
    :vartype value: list[~affinda.models.JobDescriptionSearchDetailLanguagesValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersSkill]"},
        "value": {"key": "value", "type": "[JobDescriptionSearchDetailLanguagesValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        value: Optional[List["_models.JobDescriptionSearchDetailLanguagesValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword value:
        :paramtype value: list[~affinda.models.JobDescriptionSearchDetailLanguagesValueItem]
        """
        super(JobDescriptionSearchDetailLanguages, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailLanguagesValueItem(msrest.serialization.Model):
    """JobDescriptionSearchDetailLanguagesValueItem.

    :ivar name:
    :vartype name: str
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, name: Optional[str] = None, match: Optional[bool] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailLanguagesValueItem, self).__init__(**kwargs)
        self.name = name
        self.match = match


class JobDescriptionSearchDetailLocation(msrest.serialization.Model):
    """JobDescriptionSearchDetailLocation.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersLocation]
    :ivar value:
    :vartype value: ~affinda.models.JobDescriptionSearchDetailLocationValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersLocation]"},
        "value": {"key": "value", "type": "JobDescriptionSearchDetailLocationValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersLocation"]] = None,
        value: Optional["_models.JobDescriptionSearchDetailLocationValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersLocation]
        :keyword value:
        :paramtype value: ~affinda.models.JobDescriptionSearchDetailLocationValue
        """
        super(JobDescriptionSearchDetailLocation, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class Location(msrest.serialization.Model):
    """Location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar formatted:
    :vartype formatted: str
    :ivar postal_code:
    :vartype postal_code: str
    :ivar state:
    :vartype state: str
    :ivar country:
    :vartype country: str
    :ivar country_code: Two letter country code (ISO 3166-1 alpha-2).
    :vartype country_code: str
    :ivar raw_input: Required.
    :vartype raw_input: str
    :ivar street_number:
    :vartype street_number: str
    :ivar street:
    :vartype street: str
    :ivar apartment_number:
    :vartype apartment_number: str
    :ivar city:
    :vartype city: str
    """

    _validation = {
        "formatted": {"readonly": True},
        "postal_code": {"readonly": True},
        "state": {"readonly": True},
        "country": {"readonly": True},
        "country_code": {"readonly": True},
        "raw_input": {"required": True},
        "street_number": {"readonly": True},
        "street": {"readonly": True},
        "apartment_number": {"readonly": True},
        "city": {"readonly": True},
    }

    _attribute_map = {
        "formatted": {"key": "formatted", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "raw_input": {"key": "rawInput", "type": "str"},
        "street_number": {"key": "streetNumber", "type": "str"},
        "street": {"key": "street", "type": "str"},
        "apartment_number": {"key": "apartmentNumber", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(self, *, raw_input: str, **kwargs):
        """
        :keyword raw_input: Required.
        :paramtype raw_input: str
        """
        super(Location, self).__init__(**kwargs)
        self.formatted = None
        self.postal_code = None
        self.state = None
        self.country = None
        self.country_code = None
        self.raw_input = raw_input
        self.street_number = None
        self.street = None
        self.apartment_number = None
        self.city = None


class JobDescriptionSearchDetailLocationValue(
    Location,
    Components1TlnsonSchemasJobdescriptionsearchdetailPropertiesLocationPropertiesValueAllof1,
):
    """JobDescriptionSearchDetailLocationValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar match:
    :vartype match: bool
    :ivar formatted:
    :vartype formatted: str
    :ivar postal_code:
    :vartype postal_code: str
    :ivar state:
    :vartype state: str
    :ivar country:
    :vartype country: str
    :ivar country_code: Two letter country code (ISO 3166-1 alpha-2).
    :vartype country_code: str
    :ivar raw_input: Required.
    :vartype raw_input: str
    :ivar street_number:
    :vartype street_number: str
    :ivar street:
    :vartype street: str
    :ivar apartment_number:
    :vartype apartment_number: str
    :ivar city:
    :vartype city: str
    """

    _validation = {
        "formatted": {"readonly": True},
        "postal_code": {"readonly": True},
        "state": {"readonly": True},
        "country": {"readonly": True},
        "country_code": {"readonly": True},
        "raw_input": {"required": True},
        "street_number": {"readonly": True},
        "street": {"readonly": True},
        "apartment_number": {"readonly": True},
        "city": {"readonly": True},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "formatted": {"key": "formatted", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "raw_input": {"key": "rawInput", "type": "str"},
        "street_number": {"key": "streetNumber", "type": "str"},
        "street": {"key": "street", "type": "str"},
        "apartment_number": {"key": "apartmentNumber", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(self, *, raw_input: str, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        :keyword raw_input: Required.
        :paramtype raw_input: str
        """
        super(JobDescriptionSearchDetailLocationValue, self).__init__(
            raw_input=raw_input, match=match, **kwargs
        )
        self.match = match
        self.formatted = None
        self.postal_code = None
        self.state = None
        self.country = None
        self.country_code = None
        self.raw_input = raw_input
        self.street_number = None
        self.street = None
        self.apartment_number = None
        self.city = None


class JobDescriptionSearchDetailManagementLevel(msrest.serialization.Model):
    """JobDescriptionSearchDetailManagementLevel.

    :ivar level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype level: str or ~affinda.models.ManagementLevel
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype level: str or ~affinda.models.ManagementLevel
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailManagementLevel, self).__init__(**kwargs)
        self.level = level
        self.match = match


class JobDescriptionSearchDetailOccupationGroup(msrest.serialization.Model):
    """JobDescriptionSearchDetailOccupationGroup.

    :ivar missing:
    :vartype missing: list[int]
    :ivar value:
    :vartype value: list[~affinda.models.JobDescriptionSearchDetailOccupationGroupValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[int]"},
        "value": {"key": "value", "type": "[JobDescriptionSearchDetailOccupationGroupValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List[int]] = None,
        value: Optional[List["_models.JobDescriptionSearchDetailOccupationGroupValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[int]
        :keyword value:
        :paramtype value: list[~affinda.models.JobDescriptionSearchDetailOccupationGroupValueItem]
        """
        super(JobDescriptionSearchDetailOccupationGroup, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class OccupationGroup(msrest.serialization.Model):
    """OccupationGroup.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required.
    :vartype code: int
    :ivar name: Required.
    :vartype name: str
    :ivar children: Required.
    :vartype children: list[~affinda.models.OccupationGroup]
    """

    _validation = {
        "code": {"required": True},
        "name": {"required": True},
        "children": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "children": {"key": "children", "type": "[OccupationGroup]"},
    }

    def __init__(
        self, *, code: int, name: str, children: List["_models.OccupationGroup"], **kwargs
    ):
        """
        :keyword code: Required.
        :paramtype code: int
        :keyword name: Required.
        :paramtype name: str
        :keyword children: Required.
        :paramtype children: list[~affinda.models.OccupationGroup]
        """
        super(OccupationGroup, self).__init__(**kwargs)
        self.code = code
        self.name = name
        self.children = children


class JobDescriptionSearchDetailOccupationGroupValueItem(
    OccupationGroup,
    Components1Bq3Q31SchemasJobdescriptionsearchdetailPropertiesOccupationgroupPropertiesValueItemsAllof1,
):
    """JobDescriptionSearchDetailOccupationGroupValueItem.

    All required parameters must be populated in order to send to Azure.

    :ivar match:
    :vartype match: bool
    :ivar code: Required.
    :vartype code: int
    :ivar name: Required.
    :vartype name: str
    :ivar children: Required.
    :vartype children: list[~affinda.models.OccupationGroup]
    """

    _validation = {
        "code": {"required": True},
        "name": {"required": True},
        "children": {"required": True},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "code": {"key": "code", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "children": {"key": "children", "type": "[OccupationGroup]"},
    }

    def __init__(
        self,
        *,
        code: int,
        name: str,
        children: List["_models.OccupationGroup"],
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword code: Required.
        :paramtype code: int
        :keyword name: Required.
        :paramtype name: str
        :keyword children: Required.
        :paramtype children: list[~affinda.models.OccupationGroup]
        """
        super(JobDescriptionSearchDetailOccupationGroupValueItem, self).__init__(
            code=code, name=name, children=children, match=match, **kwargs
        )
        self.match = match
        self.code = code
        self.name = name
        self.children = children


class JobDescriptionSearchDetailSearchExpression(msrest.serialization.Model):
    """JobDescriptionSearchDetailSearchExpression.

    :ivar missing:
    :vartype missing: list[str]
    :ivar value:
    :vartype value: list[str]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[str]"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(
        self, *, missing: Optional[List[str]] = None, value: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword missing:
        :paramtype missing: list[str]
        :keyword value:
        :paramtype value: list[str]
        """
        super(JobDescriptionSearchDetailSearchExpression, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailSkills(msrest.serialization.Model):
    """JobDescriptionSearchDetailSkills.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar value:
    :vartype value: list[~affinda.models.JobDescriptionSearchDetailSkillsValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersSkill]"},
        "value": {"key": "value", "type": "[JobDescriptionSearchDetailSkillsValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        value: Optional[List["_models.JobDescriptionSearchDetailSkillsValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword value:
        :paramtype value: list[~affinda.models.JobDescriptionSearchDetailSkillsValueItem]
        """
        super(JobDescriptionSearchDetailSkills, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class JobDescriptionSearchDetailSkillsValueItem(msrest.serialization.Model):
    """JobDescriptionSearchDetailSkillsValueItem.

    :ivar name:
    :vartype name: str
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, name: Optional[str] = None, match: Optional[bool] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword match:
        :paramtype match: bool
        """
        super(JobDescriptionSearchDetailSkillsValueItem, self).__init__(**kwargs)
        self.name = name
        self.match = match


class JobDescriptionSearchEmbed(msrest.serialization.Model):
    """JobDescriptionSearchEmbed.

    :ivar url: The signed URL for the embedable search tool.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs):
        """
        :keyword url: The signed URL for the embedable search tool.
        :paramtype url: str
        """
        super(JobDescriptionSearchEmbed, self).__init__(**kwargs)
        self.url = url


class JobDescriptionSearchParameters(msrest.serialization.Model):
    """JobDescriptionSearchParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar indices: Required.
    :vartype indices: list[str]
    :ivar resume: A random string that uniquely identify the resource.
    :vartype resume: str
    :ivar job_titles:
    :vartype job_titles: list[str]
    :ivar job_titles_required:
    :vartype job_titles_required: bool
    :ivar job_titles_weight:
    :vartype job_titles_weight: float
    :ivar total_years_experience:
    :vartype total_years_experience: float
    :ivar years_experience_required:
    :vartype years_experience_required: bool
    :ivar years_experience_weight:
    :vartype years_experience_weight: float
    :ivar locations:
    :vartype locations: list[~affinda.models.ResumeSearchParametersLocation]
    :ivar locations_weight:
    :vartype locations_weight: float
    :ivar locations_required:
    :vartype locations_required: bool
    :ivar skills:
    :vartype skills: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar skills_weight:
    :vartype skills_weight: float
    :ivar languages:
    :vartype languages: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar languages_weight:
    :vartype languages_weight: float
    :ivar degrees:
    :vartype degrees: list[str]
    :ivar degrees_required:
    :vartype degrees_required: bool
    :ivar degree_types:
    :vartype degree_types: list[str or ~affinda.models.EducationLevel]
    :ivar degree_types_required:
    :vartype degree_types_required: bool
    :ivar education_weight:
    :vartype education_weight: float
    :ivar search_expression:
    :vartype search_expression: str
    :ivar search_expression_required:
    :vartype search_expression_required: bool
    :ivar search_expression_weight:
    :vartype search_expression_weight: float
    :ivar soc_codes:
    :vartype soc_codes: list[int]
    :ivar soc_codes_weight:
    :vartype soc_codes_weight: float
    :ivar soc_codes_required:
    :vartype soc_codes_required: bool
    :ivar management_level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype management_level: str or ~affinda.models.ManagementLevel
    :ivar management_level_required:
    :vartype management_level_required: bool
    :ivar management_level_weight:
    :vartype management_level_weight: float
    """

    _validation = {
        "indices": {"required": True},
        "job_titles_weight": {"maximum": 1, "minimum": 0},
        "years_experience_weight": {"maximum": 1, "minimum": 0},
        "locations_weight": {"maximum": 1, "minimum": 0},
        "skills_weight": {"maximum": 1, "minimum": 0},
        "languages_weight": {"maximum": 1, "minimum": 0},
        "degree_types": {"unique": True},
        "education_weight": {"maximum": 1, "minimum": 0},
        "search_expression_weight": {"maximum": 1, "minimum": 0},
        "soc_codes_weight": {"maximum": 1, "minimum": 0},
        "management_level_weight": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "indices": {"key": "indices", "type": "[str]"},
        "resume": {"key": "resume", "type": "str"},
        "job_titles": {"key": "jobTitles", "type": "[str]"},
        "job_titles_required": {"key": "jobTitlesRequired", "type": "bool"},
        "job_titles_weight": {"key": "jobTitlesWeight", "type": "float"},
        "total_years_experience": {"key": "totalYearsExperience", "type": "float"},
        "years_experience_required": {"key": "yearsExperienceRequired", "type": "bool"},
        "years_experience_weight": {"key": "yearsExperienceWeight", "type": "float"},
        "locations": {"key": "locations", "type": "[ResumeSearchParametersLocation]"},
        "locations_weight": {"key": "locationsWeight", "type": "float"},
        "locations_required": {"key": "locationsRequired", "type": "bool"},
        "skills": {"key": "skills", "type": "[ResumeSearchParametersSkill]"},
        "skills_weight": {"key": "skillsWeight", "type": "float"},
        "languages": {"key": "languages", "type": "[ResumeSearchParametersSkill]"},
        "languages_weight": {"key": "languagesWeight", "type": "float"},
        "degrees": {"key": "degrees", "type": "[str]"},
        "degrees_required": {"key": "degreesRequired", "type": "bool"},
        "degree_types": {"key": "degreeTypes", "type": "[str]"},
        "degree_types_required": {"key": "degreeTypesRequired", "type": "bool"},
        "education_weight": {"key": "educationWeight", "type": "float"},
        "search_expression": {"key": "searchExpression", "type": "str"},
        "search_expression_required": {"key": "searchExpressionRequired", "type": "bool"},
        "search_expression_weight": {"key": "searchExpressionWeight", "type": "float"},
        "soc_codes": {"key": "socCodes", "type": "[int]"},
        "soc_codes_weight": {"key": "socCodesWeight", "type": "float"},
        "soc_codes_required": {"key": "socCodesRequired", "type": "bool"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "management_level_required": {"key": "managementLevelRequired", "type": "bool"},
        "management_level_weight": {"key": "managementLevelWeight", "type": "float"},
    }

    def __init__(
        self,
        *,
        indices: List[str],
        resume: Optional[str] = None,
        job_titles: Optional[List[str]] = None,
        job_titles_required: Optional[bool] = None,
        job_titles_weight: Optional[float] = None,
        total_years_experience: Optional[float] = None,
        years_experience_required: Optional[bool] = None,
        years_experience_weight: Optional[float] = None,
        locations: Optional[List["_models.ResumeSearchParametersLocation"]] = None,
        locations_weight: Optional[float] = None,
        locations_required: Optional[bool] = None,
        skills: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        skills_weight: Optional[float] = None,
        languages: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        languages_weight: Optional[float] = None,
        degrees: Optional[List[str]] = None,
        degrees_required: Optional[bool] = None,
        degree_types: Optional[List[Union[str, "_models.EducationLevel"]]] = None,
        degree_types_required: Optional[bool] = None,
        education_weight: Optional[float] = None,
        search_expression: Optional[str] = None,
        search_expression_required: Optional[bool] = None,
        search_expression_weight: Optional[float] = None,
        soc_codes: Optional[List[int]] = None,
        soc_codes_weight: Optional[float] = None,
        soc_codes_required: Optional[bool] = None,
        management_level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        management_level_required: Optional[bool] = None,
        management_level_weight: Optional[float] = None,
        **kwargs,
    ):
        """
        :keyword indices: Required.
        :paramtype indices: list[str]
        :keyword resume: A random string that uniquely identify the resource.
        :paramtype resume: str
        :keyword job_titles:
        :paramtype job_titles: list[str]
        :keyword job_titles_required:
        :paramtype job_titles_required: bool
        :keyword job_titles_weight:
        :paramtype job_titles_weight: float
        :keyword total_years_experience:
        :paramtype total_years_experience: float
        :keyword years_experience_required:
        :paramtype years_experience_required: bool
        :keyword years_experience_weight:
        :paramtype years_experience_weight: float
        :keyword locations:
        :paramtype locations: list[~affinda.models.ResumeSearchParametersLocation]
        :keyword locations_weight:
        :paramtype locations_weight: float
        :keyword locations_required:
        :paramtype locations_required: bool
        :keyword skills:
        :paramtype skills: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword skills_weight:
        :paramtype skills_weight: float
        :keyword languages:
        :paramtype languages: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword languages_weight:
        :paramtype languages_weight: float
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword degrees_required:
        :paramtype degrees_required: bool
        :keyword degree_types:
        :paramtype degree_types: list[str or ~affinda.models.EducationLevel]
        :keyword degree_types_required:
        :paramtype degree_types_required: bool
        :keyword education_weight:
        :paramtype education_weight: float
        :keyword search_expression:
        :paramtype search_expression: str
        :keyword search_expression_required:
        :paramtype search_expression_required: bool
        :keyword search_expression_weight:
        :paramtype search_expression_weight: float
        :keyword soc_codes:
        :paramtype soc_codes: list[int]
        :keyword soc_codes_weight:
        :paramtype soc_codes_weight: float
        :keyword soc_codes_required:
        :paramtype soc_codes_required: bool
        :keyword management_level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype management_level: str or ~affinda.models.ManagementLevel
        :keyword management_level_required:
        :paramtype management_level_required: bool
        :keyword management_level_weight:
        :paramtype management_level_weight: float
        """
        super(JobDescriptionSearchParameters, self).__init__(**kwargs)
        self.indices = indices
        self.resume = resume
        self.job_titles = job_titles
        self.job_titles_required = job_titles_required
        self.job_titles_weight = job_titles_weight
        self.total_years_experience = total_years_experience
        self.years_experience_required = years_experience_required
        self.years_experience_weight = years_experience_weight
        self.locations = locations
        self.locations_weight = locations_weight
        self.locations_required = locations_required
        self.skills = skills
        self.skills_weight = skills_weight
        self.languages = languages
        self.languages_weight = languages_weight
        self.degrees = degrees
        self.degrees_required = degrees_required
        self.degree_types = degree_types
        self.degree_types_required = degree_types_required
        self.education_weight = education_weight
        self.search_expression = search_expression
        self.search_expression_required = search_expression_required
        self.search_expression_weight = search_expression_weight
        self.soc_codes = soc_codes
        self.soc_codes_weight = soc_codes_weight
        self.soc_codes_required = soc_codes_required
        self.management_level = management_level
        self.management_level_required = management_level_required
        self.management_level_weight = management_level_weight


class JobDescriptionSearchResult(msrest.serialization.Model):
    """JobDescriptionSearchResult.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar score: Required.
    :vartype score: float
    :ivar pdf: Required.
    :vartype pdf: str
    :ivar job_title: Required.
    :vartype job_title: ~affinda.models.JobTitleSearchScoreComponent
    :ivar management_level: Required.
    :vartype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
    :ivar experience: Required.
    :vartype experience: ~affinda.models.ExperienceSearchScoreComponent
    :ivar skills: Required.
    :vartype skills: ~affinda.models.SkillsSearchScoreComponent
    :ivar languages: Required.
    :vartype languages: ~affinda.models.LanguagesSearchScoreComponent
    :ivar location: Required.
    :vartype location: ~affinda.models.LocationSearchScoreComponent
    :ivar education: Required.
    :vartype education: ~affinda.models.EducationSearchScoreComponent
    :ivar occupation_group:
    :vartype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
    :ivar search_expression: Required.
    :vartype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
    :ivar organization_name: Required.
    :vartype organization_name: str
    """

    _validation = {
        "identifier": {"required": True},
        "score": {"required": True},
        "pdf": {"required": True},
        "job_title": {"required": True},
        "management_level": {"required": True},
        "experience": {"required": True},
        "skills": {"required": True},
        "languages": {"required": True},
        "location": {"required": True},
        "education": {"required": True},
        "search_expression": {"required": True},
        "organization_name": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "score": {"key": "score", "type": "float"},
        "pdf": {"key": "pdf", "type": "str"},
        "job_title": {"key": "jobTitle", "type": "JobTitleSearchScoreComponent"},
        "management_level": {
            "key": "managementLevel",
            "type": "ManagementLevelSearchScoreComponent",
        },
        "experience": {"key": "experience", "type": "ExperienceSearchScoreComponent"},
        "skills": {"key": "skills", "type": "SkillsSearchScoreComponent"},
        "languages": {"key": "languages", "type": "LanguagesSearchScoreComponent"},
        "location": {"key": "location", "type": "LocationSearchScoreComponent"},
        "education": {"key": "education", "type": "EducationSearchScoreComponent"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "OccupationGroupSearchScoreComponent",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "SearchExpressionSearchScoreComponent",
        },
        "organization_name": {"key": "organizationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        score: float,
        pdf: str,
        job_title: "_models.JobTitleSearchScoreComponent",
        management_level: "_models.ManagementLevelSearchScoreComponent",
        experience: "_models.ExperienceSearchScoreComponent",
        skills: "_models.SkillsSearchScoreComponent",
        languages: "_models.LanguagesSearchScoreComponent",
        location: "_models.LocationSearchScoreComponent",
        education: "_models.EducationSearchScoreComponent",
        search_expression: "_models.SearchExpressionSearchScoreComponent",
        organization_name: str,
        occupation_group: Optional["_models.OccupationGroupSearchScoreComponent"] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword score: Required.
        :paramtype score: float
        :keyword pdf: Required.
        :paramtype pdf: str
        :keyword job_title: Required.
        :paramtype job_title: ~affinda.models.JobTitleSearchScoreComponent
        :keyword management_level: Required.
        :paramtype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
        :keyword experience: Required.
        :paramtype experience: ~affinda.models.ExperienceSearchScoreComponent
        :keyword skills: Required.
        :paramtype skills: ~affinda.models.SkillsSearchScoreComponent
        :keyword languages: Required.
        :paramtype languages: ~affinda.models.LanguagesSearchScoreComponent
        :keyword location: Required.
        :paramtype location: ~affinda.models.LocationSearchScoreComponent
        :keyword education: Required.
        :paramtype education: ~affinda.models.EducationSearchScoreComponent
        :keyword occupation_group:
        :paramtype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
        :keyword search_expression: Required.
        :paramtype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
        :keyword organization_name: Required.
        :paramtype organization_name: str
        """
        super(JobDescriptionSearchResult, self).__init__(**kwargs)
        self.identifier = identifier
        self.score = score
        self.pdf = pdf
        self.job_title = job_title
        self.management_level = management_level
        self.experience = experience
        self.skills = skills
        self.languages = languages
        self.location = location
        self.education = education
        self.occupation_group = occupation_group
        self.search_expression = search_expression
        self.organization_name = organization_name


class JobTitleAnnotation(Annotation):
    """JobTitleAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed: Years of experience range.
    :vartype parsed: ~affinda.models.JobTitleAnnotationParsed
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "JobTitleAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional["_models.JobTitleAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed: Years of experience range.
        :paramtype parsed: ~affinda.models.JobTitleAnnotationParsed
        """
        super(JobTitleAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class JobTitleAnnotationParsed(msrest.serialization.Model):
    """Years of experience range.

    :ivar name:
    :vartype name: str
    :ivar management_level:
    :vartype management_level: str
    :ivar classification:
    :vartype classification: ~affinda.models.JobTitleAnnotationParsedClassification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "classification": {
            "key": "classification",
            "type": "JobTitleAnnotationParsedClassification",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        management_level: Optional[str] = None,
        classification: Optional["_models.JobTitleAnnotationParsedClassification"] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword management_level:
        :paramtype management_level: str
        :keyword classification:
        :paramtype classification: ~affinda.models.JobTitleAnnotationParsedClassification
        """
        super(JobTitleAnnotationParsed, self).__init__(**kwargs)
        self.name = name
        self.management_level = management_level
        self.classification = classification


class JobTitleAnnotationParsedClassification(msrest.serialization.Model):
    """JobTitleAnnotationParsedClassification.

    :ivar soc_code:
    :vartype soc_code: float
    :ivar title:
    :vartype title: str
    :ivar minor_group:
    :vartype minor_group: str
    :ivar sub_major_group:
    :vartype sub_major_group: str
    :ivar major_group:
    :vartype major_group: str
    """

    _attribute_map = {
        "soc_code": {"key": "socCode", "type": "float"},
        "title": {"key": "title", "type": "str"},
        "minor_group": {"key": "minorGroup", "type": "str"},
        "sub_major_group": {"key": "subMajorGroup", "type": "str"},
        "major_group": {"key": "majorGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        soc_code: Optional[float] = None,
        title: Optional[str] = None,
        minor_group: Optional[str] = None,
        sub_major_group: Optional[str] = None,
        major_group: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword soc_code:
        :paramtype soc_code: float
        :keyword title:
        :paramtype title: str
        :keyword minor_group:
        :paramtype minor_group: str
        :keyword sub_major_group:
        :paramtype sub_major_group: str
        :keyword major_group:
        :paramtype major_group: str
        """
        super(JobTitleAnnotationParsedClassification, self).__init__(**kwargs)
        self.soc_code = soc_code
        self.title = title
        self.minor_group = minor_group
        self.sub_major_group = sub_major_group
        self.major_group = major_group


class JobTitleSearchScoreComponent(msrest.serialization.Model):
    """JobTitleSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(JobTitleSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class LanguageAnnotation(Annotation):
    """LanguageAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(LanguageAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class LanguagesSearchScoreComponent(msrest.serialization.Model):
    """LanguagesSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(LanguagesSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class ListResult(msrest.serialization.Model):
    """ListResult.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self, *, count: int, next: Optional[str] = None, previous: Optional[str] = None, **kwargs
    ):
        """
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(ListResult, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous


class LocationAnnotation(Annotation):
    """LocationAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: ~affinda.models.Location
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "Location"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional["_models.Location"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: ~affinda.models.Location
        """
        super(LocationAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class LocationSearchScoreComponent(msrest.serialization.Model):
    """LocationSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(LocationSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class ManagementLevelSearchScoreComponent(msrest.serialization.Model):
    """ManagementLevelSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(ManagementLevelSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class Meta(msrest.serialization.Model):
    """Meta.

    :ivar identifier: Uniquely identify a document.
    :vartype identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar ready: If true, the document has finished processing. Particularly useful if an endpoint
     request specified wait=False, when polling use this variable to determine when to stop polling.
    :vartype ready: bool
    :ivar ready_dt: The datetime when the document was ready.
    :vartype ready_dt: ~datetime.datetime
    :ivar failed: If true, some exception was raised during processing. Check the 'error' field of
     the main return object.
    :vartype failed: bool
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    :ivar language: The document's language.
    :vartype language: str
    :ivar pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
     converted to pdf as part of the parsing process).
    :vartype pdf: str
    :ivar parent_document: If this document is part of a splitted document, this attribute points
     to the original document that this document is splitted from.
    :vartype parent_document: ~affinda.models.MetaParentDocument
    :ivar child_documents: If this document has been splitted into a number of child documents,
     this attribute points to those child documents.
    :vartype child_documents: list[~affinda.models.MetaChildDocumentsItem]
    :ivar pages: The document's pages.
    :vartype pages: list[~affinda.models.PageMeta]
    :ivar is_verified: This is true if the "confirm" button has been clicked in the Affinda
     validation tool.
    :vartype is_verified: bool
    :ivar review_url: Signed URL (valid for 60 minutes) to access the validation tool.  Not
     applicable for documents types such a resumes.
    :vartype review_url: str
    :ivar ocr_confidence: The overall confidence in the conversion of image to text.  (only
     applicable for images or PDF documents without a text layer).
    :vartype ocr_confidence: float
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "ready": {"key": "ready", "type": "bool"},
        "ready_dt": {"key": "readyDt", "type": "iso-8601"},
        "failed": {"key": "failed", "type": "bool"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "language": {"key": "language", "type": "str"},
        "pdf": {"key": "pdf", "type": "str"},
        "parent_document": {"key": "parentDocument", "type": "MetaParentDocument"},
        "child_documents": {"key": "childDocuments", "type": "[MetaChildDocumentsItem]"},
        "pages": {"key": "pages", "type": "[PageMeta]"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "review_url": {"key": "reviewUrl", "type": "str"},
        "ocr_confidence": {"key": "ocrConfidence", "type": "float"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        ready: Optional[bool] = None,
        ready_dt: Optional[datetime.datetime] = None,
        failed: Optional[bool] = None,
        expiry_time: Optional[datetime.datetime] = None,
        language: Optional[str] = None,
        pdf: Optional[str] = None,
        parent_document: Optional["_models.MetaParentDocument"] = None,
        child_documents: Optional[List["_models.MetaChildDocumentsItem"]] = None,
        pages: Optional[List["_models.PageMeta"]] = None,
        is_verified: Optional[bool] = None,
        review_url: Optional[str] = None,
        ocr_confidence: Optional[float] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify a document.
        :paramtype identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword ready: If true, the document has finished processing. Particularly useful if an
         endpoint request specified wait=False, when polling use this variable to determine when to stop
         polling.
        :paramtype ready: bool
        :keyword ready_dt: The datetime when the document was ready.
        :paramtype ready_dt: ~datetime.datetime
        :keyword failed: If true, some exception was raised during processing. Check the 'error' field
         of the main return object.
        :paramtype failed: bool
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        :keyword language: The document's language.
        :paramtype language: str
        :keyword pdf: The URL to the document's pdf (if the uploaded document is not already pdf, it's
         converted to pdf as part of the parsing process).
        :paramtype pdf: str
        :keyword parent_document: If this document is part of a splitted document, this attribute
         points to the original document that this document is splitted from.
        :paramtype parent_document: ~affinda.models.MetaParentDocument
        :keyword child_documents: If this document has been splitted into a number of child documents,
         this attribute points to those child documents.
        :paramtype child_documents: list[~affinda.models.MetaChildDocumentsItem]
        :keyword pages: The document's pages.
        :paramtype pages: list[~affinda.models.PageMeta]
        :keyword is_verified: This is true if the "confirm" button has been clicked in the Affinda
         validation tool.
        :paramtype is_verified: bool
        :keyword review_url: Signed URL (valid for 60 minutes) to access the validation tool.  Not
         applicable for documents types such a resumes.
        :paramtype review_url: str
        :keyword ocr_confidence: The overall confidence in the conversion of image to text.  (only
         applicable for images or PDF documents without a text layer).
        :paramtype ocr_confidence: float
        """
        super(Meta, self).__init__(**kwargs)
        self.identifier = identifier
        self.file_name = file_name
        self.ready = ready
        self.ready_dt = ready_dt
        self.failed = failed
        self.expiry_time = expiry_time
        self.language = language
        self.pdf = pdf
        self.parent_document = parent_document
        self.child_documents = child_documents
        self.pages = pages
        self.is_verified = is_verified
        self.review_url = review_url
        self.ocr_confidence = ocr_confidence


class MetaChildDocumentsItem(msrest.serialization.Model):
    """MetaChildDocumentsItem.

    :ivar identifier: Uniquely identify a document.
    :vartype identifier: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
    }

    def __init__(self, *, identifier: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Uniquely identify a document.
        :paramtype identifier: str
        """
        super(MetaChildDocumentsItem, self).__init__(**kwargs)
        self.identifier = identifier


class MetaParentDocument(msrest.serialization.Model):
    """If this document is part of a splitted document, this attribute points to the original document that this document is splitted from.

    :ivar identifier: Uniquely identify a document.
    :vartype identifier: str
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
    }

    def __init__(self, *, identifier: Optional[str] = None, **kwargs):
        """
        :keyword identifier: Uniquely identify a document.
        :paramtype identifier: str
        """
        super(MetaParentDocument, self).__init__(**kwargs)
        self.identifier = identifier


class OccupationGroupSearchScoreComponent(msrest.serialization.Model):
    """OccupationGroupSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(OccupationGroupSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class Organization(msrest.serialization.Model):
    """Organization.

    :ivar identifier: Uniquely identify an organization.
    :vartype identifier: str
    :ivar name:
    :vartype name: str
    :ivar user_role: The role of the logged in user within the organization. Known values are:
     "admin", "member".
    :vartype user_role: str or ~affinda.models.OrganizationUserRole
    :ivar avatar: URL of the organization's avatar.
    :vartype avatar: str
    :ivar resthook_signature_key: Used to sign webhook payloads so you can verify their integrity.
    :vartype resthook_signature_key: str
    :ivar is_trial:
    :vartype is_trial: bool
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "user_role": {"key": "userRole", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
        "resthook_signature_key": {"key": "resthookSignatureKey", "type": "str"},
        "is_trial": {"key": "isTrial", "type": "bool"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        name: Optional[str] = None,
        user_role: Optional[Union[str, "_models.OrganizationUserRole"]] = None,
        avatar: Optional[str] = None,
        resthook_signature_key: Optional[str] = None,
        is_trial: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify an organization.
        :paramtype identifier: str
        :keyword name:
        :paramtype name: str
        :keyword user_role: The role of the logged in user within the organization. Known values are:
         "admin", "member".
        :paramtype user_role: str or ~affinda.models.OrganizationUserRole
        :keyword avatar: URL of the organization's avatar.
        :paramtype avatar: str
        :keyword resthook_signature_key: Used to sign webhook payloads so you can verify their
         integrity.
        :paramtype resthook_signature_key: str
        :keyword is_trial:
        :paramtype is_trial: bool
        """
        super(Organization, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.user_role = user_role
        self.avatar = avatar
        self.resthook_signature_key = resthook_signature_key
        self.is_trial = is_trial


class OrganizationCreate(msrest.serialization.Model):
    """OrganizationCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar avatar: Upload avatar for the organization.
    :vartype avatar: IO
    :ivar resthook_signature_key: Used to sign webhook payloads so you can verify their integrity.
    :vartype resthook_signature_key: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "avatar": {"key": "avatar", "type": "IO"},
        "resthook_signature_key": {"key": "resthookSignatureKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        avatar: Optional[IO] = None,
        resthook_signature_key: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword avatar: Upload avatar for the organization.
        :paramtype avatar: IO
        :keyword resthook_signature_key: Used to sign webhook payloads so you can verify their
         integrity.
        :paramtype resthook_signature_key: str
        """
        super(OrganizationCreate, self).__init__(**kwargs)
        self.name = name
        self.avatar = avatar
        self.resthook_signature_key = resthook_signature_key


class OrganizationMembership(msrest.serialization.Model):
    """OrganizationMembership.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar user: Required.
    :vartype user: ~affinda.models.User
    :ivar role: Required. Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    """

    _validation = {
        "identifier": {"required": True},
        "organization": {"required": True},
        "user": {"required": True},
        "role": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "user": {"key": "user", "type": "User"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        organization: str,
        user: "_models.User",
        role: Union[str, "_models.OrganizationRole"],
        **kwargs,
    ):
        """
        :keyword identifier: Required. A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword user: Required.
        :paramtype user: ~affinda.models.User
        :keyword role: Required. Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        """
        super(OrganizationMembership, self).__init__(**kwargs)
        self.identifier = identifier
        self.organization = organization
        self.user = user
        self.role = role


class OrganizationMembershipUpdate(msrest.serialization.Model):
    """OrganizationMembershipUpdate.

    :ivar role: Known values are: "admin", "member".
    :vartype role: str or ~affinda.models.OrganizationRole
    """

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
    }

    def __init__(self, *, role: Optional[Union[str, "_models.OrganizationRole"]] = None, **kwargs):
        """
        :keyword role: Known values are: "admin", "member".
        :paramtype role: str or ~affinda.models.OrganizationRole
        """
        super(OrganizationMembershipUpdate, self).__init__(**kwargs)
        self.role = role


class OrganizationUpdate(msrest.serialization.Model):
    """OrganizationUpdate.

    :ivar name:
    :vartype name: str
    :ivar avatar: Upload avatar for the organization.
    :vartype avatar: IO
    :ivar resthook_signature_key: Used to sign webhook payloads so you can verify their integrity.
    :vartype resthook_signature_key: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "avatar": {"key": "avatar", "type": "IO"},
        "resthook_signature_key": {"key": "resthookSignatureKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        avatar: Optional[IO] = None,
        resthook_signature_key: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword avatar: Upload avatar for the organization.
        :paramtype avatar: IO
        :keyword resthook_signature_key: Used to sign webhook payloads so you can verify their
         integrity.
        :paramtype resthook_signature_key: str
        """
        super(OrganizationUpdate, self).__init__(**kwargs)
        self.name = name
        self.avatar = avatar
        self.resthook_signature_key = resthook_signature_key


class PageMeta(msrest.serialization.Model):
    """PageMeta.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: int
    :ivar page_index: Required. Page number within the document, starts from 0.
    :vartype page_index: int
    :ivar image: Required. The URL to the image of the page.
    :vartype image: str
    :ivar height: Required. Height of the page's image in px.
    :vartype height: float
    :ivar width: Required. Width of the page's image in px.
    :vartype width: float
    :ivar rotation: Required. The degree of rotation applied to the page. Greater than 0 indicates
     clockwise rotation. Less than 0 indicates counter-clockwise rotation.
    :vartype rotation: int
    """

    _validation = {
        "id": {"required": True},
        "page_index": {"required": True},
        "image": {"required": True},
        "height": {"required": True},
        "width": {"required": True},
        "rotation": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "image": {"key": "image", "type": "str"},
        "height": {"key": "height", "type": "float"},
        "width": {"key": "width", "type": "float"},
        "rotation": {"key": "rotation", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,
        page_index: int,
        image: str,
        height: float,
        width: float,
        rotation: int,
        **kwargs,
    ):
        """
        :keyword id: Required.
        :paramtype id: int
        :keyword page_index: Required. Page number within the document, starts from 0.
        :paramtype page_index: int
        :keyword image: Required. The URL to the image of the page.
        :paramtype image: str
        :keyword height: Required. Height of the page's image in px.
        :paramtype height: float
        :keyword width: Required. Width of the page's image in px.
        :paramtype width: float
        :keyword rotation: Required. The degree of rotation applied to the page. Greater than 0
         indicates clockwise rotation. Less than 0 indicates counter-clockwise rotation.
        :paramtype rotation: int
        """
        super(PageMeta, self).__init__(**kwargs)
        self.id = id
        self.page_index = page_index
        self.image = image
        self.height = height
        self.width = width
        self.rotation = rotation


class PaginatedResponse(msrest.serialization.Model):
    """PaginatedResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self, *, count: int, next: Optional[str] = None, previous: Optional[str] = None, **kwargs
    ):
        """
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(PaginatedResponse, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous


class Paths171Dpm5OrganizationMembershipsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths171Dpm5OrganizationMembershipsGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.OrganizationMembership]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[OrganizationMembership]"},
    }

    def __init__(
        self, *, results: Optional[List["_models.OrganizationMembership"]] = None, **kwargs
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.OrganizationMembership]
        """
        super(
            Paths171Dpm5OrganizationMembershipsGetResponses200ContentApplicationJsonSchemaAllof1,
            self,
        ).__init__(**kwargs)
        self.results = results


class Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema(msrest.serialization.Model):
    """Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema.

    :ivar name:
    :vartype name: str
    :ivar document_type: Known values are: "resumes", "job_descriptions".
    :vartype document_type: str or ~affinda.models.Enum5
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "document_type": {"key": "documentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        document_type: Optional[Union[str, "_models.Enum5"]] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword document_type: Known values are: "resumes", "job_descriptions".
        :paramtype document_type: str or ~affinda.models.Enum5
        """
        super(Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema, self).__init__(
            **kwargs
        )
        self.name = name
        self.document_type = document_type


class Paths1Vlpqy9WorkspaceMembershipsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """Paths1Vlpqy9WorkspaceMembershipsGetResponses200ContentApplicationJsonSchemaAllof1.

    All required parameters must be populated in order to send to Azure.

    :ivar results: Required.
    :vartype results: list[~affinda.models.WorkspaceMembership]
    """

    _validation = {
        "results": {"required": True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[WorkspaceMembership]"},
    }

    def __init__(self, *, results: List["_models.WorkspaceMembership"], **kwargs):
        """
        :keyword results: Required.
        :paramtype results: list[~affinda.models.WorkspaceMembership]
        """
        super(
            Paths1Vlpqy9WorkspaceMembershipsGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema.

    :ivar config_override:
    :vartype config_override: ~affinda.models.ResumeSearchConfig
    """

    _attribute_map = {
        "config_override": {"key": "configOverride", "type": "ResumeSearchConfig"},
    }

    def __init__(
        self, *, config_override: Optional["_models.ResumeSearchConfig"] = None, **kwargs
    ):
        """
        :keyword config_override:
        :paramtype config_override: ~affinda.models.ResumeSearchConfig
        """
        super(
            Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.config_override = config_override


class Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema(msrest.serialization.Model):
    """Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema.

    :ivar count: Number of indexes in result.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar results:
    :vartype results: list[~affinda.models.Get200ApplicationJsonPropertiesItemsItem]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "results": {"key": "results", "type": "[Get200ApplicationJsonPropertiesItemsItem]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        results: Optional[List["_models.Get200ApplicationJsonPropertiesItemsItem"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Number of indexes in result.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword results:
        :paramtype results: list[~affinda.models.Get200ApplicationJsonPropertiesItemsItem]
        """
        super(Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.results = results


class PathsAdr1YhWorkspaceMembershipsGetResponses200ContentApplicationJsonSchema(
    ListResult, Paths1Vlpqy9WorkspaceMembershipsGetResponses200ContentApplicationJsonSchemaAllof1
):
    """PathsAdr1YhWorkspaceMembershipsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results: Required.
    :vartype results: list[~affinda.models.WorkspaceMembership]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "results": {"required": True},
        "count": {"required": True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[WorkspaceMembership]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        results: List["_models.WorkspaceMembership"],
        count: int,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results: Required.
        :paramtype results: list[~affinda.models.WorkspaceMembership]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(
            PathsAdr1YhWorkspaceMembershipsGetResponses200ContentApplicationJsonSchema, self
        ).__init__(count=count, next=next, previous=previous, results=results, **kwargs)
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsCkdzu3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse,
    Paths171Dpm5OrganizationMembershipsGetResponses200ContentApplicationJsonSchemaAllof1,
):
    """PathsCkdzu3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.OrganizationMembership]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[OrganizationMembership]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.OrganizationMembership"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.OrganizationMembership]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(
            PathsCkdzu3OrganizationMembershipsGetResponses200ContentApplicationJsonSchema, self
        ).__init__(count=count, next=next, previous=previous, results=results, **kwargs)
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema.

    :ivar document: Unique identifier for the document.
    :vartype document: str
    """

    _attribute_map = {
        "document": {"key": "document", "type": "str"},
    }

    def __init__(self, *, document: Optional[str] = None, **kwargs):
        """
        :keyword document: Unique identifier for the document.
        :paramtype document: str
        """
        super(
            PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.document = document


class PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema.

    :ivar config_override:
    :vartype config_override: ~affinda.models.JobDescriptionSearchConfig
    """

    _attribute_map = {
        "config_override": {"key": "configOverride", "type": "JobDescriptionSearchConfig"},
    }

    def __init__(
        self, *, config_override: Optional["_models.JobDescriptionSearchConfig"] = None, **kwargs
    ):
        """
        :keyword config_override:
        :paramtype config_override: ~affinda.models.JobDescriptionSearchConfig
        """
        super(
            PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.config_override = config_override


class PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema.

    :ivar document:
    :vartype document: str
    """

    _attribute_map = {
        "document": {"key": "document", "type": "str"},
    }

    def __init__(self, *, document: Optional[str] = None, **kwargs):
        """
        :keyword document:
        :paramtype document: str
        """
        super(
            PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.document = document


class PathsHryo8IndexNameDocumentsGetResponses200ContentApplicationJsonSchemaPropertiesResultsItems(
    msrest.serialization.Model
):
    """PathsHryo8IndexNameDocumentsGetResponses200ContentApplicationJsonSchemaPropertiesResultsItems.

    :ivar document:
    :vartype document: str
    """

    _attribute_map = {
        "document": {"key": "document", "type": "str"},
    }

    def __init__(self, *, document: Optional[str] = None, **kwargs):
        """
        :keyword document:
        :paramtype document: str
        """
        super(
            PathsHryo8IndexNameDocumentsGetResponses200ContentApplicationJsonSchemaPropertiesResultsItems,
            self,
        ).__init__(**kwargs)
        self.document = document


class PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema.

    :ivar count: Number of indexed documents in result.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar results:
    :vartype results:
     list[~affinda.models.PathsHryo8IndexNameDocumentsGetResponses200ContentApplicationJsonSchemaPropertiesResultsItems]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "results": {
            "key": "results",
            "type": "[PathsHryo8IndexNameDocumentsGetResponses200ContentApplicationJsonSchemaPropertiesResultsItems]",
        },
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        results: Optional[
            List[
                "_models.PathsHryo8IndexNameDocumentsGetResponses200ContentApplicationJsonSchemaPropertiesResultsItems"
            ]
        ] = None,
        **kwargs,
    ):
        """
        :keyword count: Number of indexed documents in result.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword results:
        :paramtype results:
         list[~affinda.models.PathsHryo8IndexNameDocumentsGetResponses200ContentApplicationJsonSchemaPropertiesResultsItems]
        """
        super(
            PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.results = results


class PathsSnpek6InvitationsGetResponses200ContentApplicationJsonSchemaAllof1(
    msrest.serialization.Model
):
    """PathsSnpek6InvitationsGetResponses200ContentApplicationJsonSchemaAllof1.

    :ivar results:
    :vartype results: list[~affinda.models.Invitation]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[Invitation]"},
    }

    def __init__(self, *, results: Optional[List["_models.Invitation"]] = None, **kwargs):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Invitation]
        """
        super(
            PathsSnpek6InvitationsGetResponses200ContentApplicationJsonSchemaAllof1, self
        ).__init__(**kwargs)
        self.results = results


class PathsW51LnrInvitationsTokenPatchRequestbodyContentApplicationJsonSchema(
    msrest.serialization.Model
):
    """PathsW51LnrInvitationsTokenPatchRequestbodyContentApplicationJsonSchema.

    :ivar status: Known values are: "accepted", "declined".
    :vartype status: str or ~affinda.models.PatchContentSchemaStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self, *, status: Optional[Union[str, "_models.PatchContentSchemaStatus"]] = None, **kwargs
    ):
        """
        :keyword status: Known values are: "accepted", "declined".
        :paramtype status: str or ~affinda.models.PatchContentSchemaStatus
        """
        super(
            PathsW51LnrInvitationsTokenPatchRequestbodyContentApplicationJsonSchema, self
        ).__init__(**kwargs)
        self.status = status


class PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema(msrest.serialization.Model):
    """PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema.

    :ivar count: Number of indexes in result.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar results:
    :vartype results: list[~affinda.models.User]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "results": {"key": "results", "type": "[User]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        results: Optional[List["_models.User"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Number of indexes in result.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword results:
        :paramtype results: list[~affinda.models.User]
        """
        super(PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.results = results


class PathsZt2JhiInvitationsGetResponses200ContentApplicationJsonSchema(
    PaginatedResponse, PathsSnpek6InvitationsGetResponses200ContentApplicationJsonSchemaAllof1
):
    """PathsZt2JhiInvitationsGetResponses200ContentApplicationJsonSchema.

    All required parameters must be populated in order to send to Azure.

    :ivar results:
    :vartype results: list[~affinda.models.Invitation]
    :ivar count: Required. Number of items in results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    """

    _validation = {
        "count": {"required": True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[Invitation]"},
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: int,
        results: Optional[List["_models.Invitation"]] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword results:
        :paramtype results: list[~affinda.models.Invitation]
        :keyword count: Required. Number of items in results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        """
        super(PathsZt2JhiInvitationsGetResponses200ContentApplicationJsonSchema, self).__init__(
            count=count, next=next, previous=previous, results=results, **kwargs
        )
        self.results = results
        self.count = count
        self.next = next
        self.previous = previous


class Rectangle(msrest.serialization.Model):
    """Rectangle.

    All required parameters must be populated in order to send to Azure.

    :ivar x0: Required.
    :vartype x0: float
    :ivar y0: Required.
    :vartype y0: float
    :ivar x1: Required.
    :vartype x1: float
    :ivar y1: Required.
    :vartype y1: float
    """

    _validation = {
        "x0": {"required": True},
        "y0": {"required": True},
        "x1": {"required": True},
        "y1": {"required": True},
    }

    _attribute_map = {
        "x0": {"key": "x0", "type": "float"},
        "y0": {"key": "y0", "type": "float"},
        "x1": {"key": "x1", "type": "float"},
        "y1": {"key": "y1", "type": "float"},
    }

    def __init__(self, *, x0: float, y0: float, x1: float, y1: float, **kwargs):
        """
        :keyword x0: Required.
        :paramtype x0: float
        :keyword y0: Required.
        :paramtype y0: float
        :keyword x1: Required.
        :paramtype x1: float
        :keyword y1: Required.
        :paramtype y1: float
        """
        super(Rectangle, self).__init__(**kwargs)
        self.x0 = x0
        self.y0 = y0
        self.x1 = x1
        self.y1 = y1


class RedactedResume(msrest.serialization.Model):
    """RedactedResume.

    All required parameters must be populated in order to send to Azure.

    :ivar data: Required.
    :vartype data: ~affinda.models.RedactedResumeData
    :ivar meta: Required.
    :vartype meta: ~affinda.models.Meta
    :ivar error: Required.
    :vartype error: ~affinda.models.Error
    """

    _validation = {
        "data": {"required": True},
        "meta": {"required": True},
        "error": {"required": True},
    }

    _attribute_map = {
        "data": {"key": "data", "type": "RedactedResumeData"},
        "meta": {"key": "meta", "type": "Meta"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        data: "_models.RedactedResumeData",
        meta: "_models.Meta",
        error: "_models.Error",
        **kwargs,
    ):
        """
        :keyword data: Required.
        :paramtype data: ~affinda.models.RedactedResumeData
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.Meta
        :keyword error: Required.
        :paramtype error: ~affinda.models.Error
        """
        super(RedactedResume, self).__init__(**kwargs)
        self.data = data
        self.meta = meta
        self.error = error


class RedactedResumeData(msrest.serialization.Model):
    """RedactedResumeData.

    :ivar redacted_pdf: URL to redacted PDF.
    :vartype redacted_pdf: str
    """

    _attribute_map = {
        "redacted_pdf": {"key": "redactedPdf", "type": "str"},
    }

    def __init__(self, *, redacted_pdf: Optional[str] = None, **kwargs):
        """
        :keyword redacted_pdf: URL to redacted PDF.
        :paramtype redacted_pdf: str
        """
        super(RedactedResumeData, self).__init__(**kwargs)
        self.redacted_pdf = redacted_pdf


class RedactedResumeRequestBody(msrest.serialization.Model):
    """RedactedResumeRequestBody.

    :ivar file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML, PNG,
     JPG.
    :vartype file: IO
    :ivar identifier: A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar url: URL to a resume to download and process.
    :vartype url: str
    :ivar language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
    :vartype language: str
    :ivar wait: If "true" (default), will return a response only after processing has completed. If
     "false", will return an empty data object which can be polled at the GET endpoint until
     processing is complete.
    :vartype wait: bool
    :ivar redact_headshot: Whether to redact headshot.
    :vartype redact_headshot: bool
    :ivar redact_personal_details: Whether to redact personal details (e.g. name, address).
    :vartype redact_personal_details: bool
    :ivar redact_work_details: Whether to redact work details (e.g. company names).
    :vartype redact_work_details: bool
    :ivar redact_education_details: Whether to redact education details (e.g. university names).
    :vartype redact_education_details: bool
    :ivar redact_referees: Whether to redact referee details.
    :vartype redact_referees: bool
    :ivar redact_locations: Whether to redact location names.
    :vartype redact_locations: bool
    :ivar redact_dates: Whether to redact dates.
    :vartype redact_dates: bool
    :ivar redact_gender: Whether to redact gender.
    :vartype redact_gender: str
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    """

    _attribute_map = {
        "file": {"key": "file", "type": "IO"},
        "identifier": {"key": "identifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "language": {"key": "language", "type": "str"},
        "wait": {"key": "wait", "type": "bool"},
        "redact_headshot": {"key": "redactHeadshot", "type": "bool"},
        "redact_personal_details": {"key": "redactPersonalDetails", "type": "bool"},
        "redact_work_details": {"key": "redactWorkDetails", "type": "bool"},
        "redact_education_details": {"key": "redactEducationDetails", "type": "bool"},
        "redact_referees": {"key": "redactReferees", "type": "bool"},
        "redact_locations": {"key": "redactLocations", "type": "bool"},
        "redact_dates": {"key": "redactDates", "type": "bool"},
        "redact_gender": {"key": "redactGender", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        file: Optional[IO] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        url: Optional[str] = None,
        language: Optional[str] = None,
        wait: Optional[bool] = True,
        redact_headshot: Optional[bool] = True,
        redact_personal_details: Optional[bool] = True,
        redact_work_details: Optional[bool] = True,
        redact_education_details: Optional[bool] = True,
        redact_referees: Optional[bool] = True,
        redact_locations: Optional[bool] = True,
        redact_dates: Optional[bool] = True,
        redact_gender: Optional[str] = "true",
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML,
         PNG, JPG.
        :paramtype file: IO
        :keyword identifier: A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword url: URL to a resume to download and process.
        :paramtype url: str
        :keyword language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
        :paramtype language: str
        :keyword wait: If "true" (default), will return a response only after processing has completed.
         If "false", will return an empty data object which can be polled at the GET endpoint until
         processing is complete.
        :paramtype wait: bool
        :keyword redact_headshot: Whether to redact headshot.
        :paramtype redact_headshot: bool
        :keyword redact_personal_details: Whether to redact personal details (e.g. name, address).
        :paramtype redact_personal_details: bool
        :keyword redact_work_details: Whether to redact work details (e.g. company names).
        :paramtype redact_work_details: bool
        :keyword redact_education_details: Whether to redact education details (e.g. university names).
        :paramtype redact_education_details: bool
        :keyword redact_referees: Whether to redact referee details.
        :paramtype redact_referees: bool
        :keyword redact_locations: Whether to redact location names.
        :paramtype redact_locations: bool
        :keyword redact_dates: Whether to redact dates.
        :paramtype redact_dates: bool
        :keyword redact_gender: Whether to redact gender.
        :paramtype redact_gender: str
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        """
        super(RedactedResumeRequestBody, self).__init__(**kwargs)
        self.file = file
        self.identifier = identifier
        self.file_name = file_name
        self.url = url
        self.language = language
        self.wait = wait
        self.redact_headshot = redact_headshot
        self.redact_personal_details = redact_personal_details
        self.redact_work_details = redact_work_details
        self.redact_education_details = redact_education_details
        self.redact_referees = redact_referees
        self.redact_locations = redact_locations
        self.redact_dates = redact_dates
        self.redact_gender = redact_gender
        self.expiry_time = expiry_time


class RequestError(msrest.serialization.Model):
    """RequestError.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required.
    :vartype type: str
    :ivar errors: Required.
    :vartype errors: list[~affinda.models.RequestErrorErrorsItem]
    """

    _validation = {
        "type": {"required": True},
        "errors": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "errors": {"key": "errors", "type": "[RequestErrorErrorsItem]"},
    }

    def __init__(self, *, type: str, errors: List["_models.RequestErrorErrorsItem"], **kwargs):
        """
        :keyword type: Required.
        :paramtype type: str
        :keyword errors: Required.
        :paramtype errors: list[~affinda.models.RequestErrorErrorsItem]
        """
        super(RequestError, self).__init__(**kwargs)
        self.type = type
        self.errors = errors


class RequestErrorErrorsItem(msrest.serialization.Model):
    """RequestErrorErrorsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar attr: Required.
    :vartype attr: str
    :ivar code: Required.
    :vartype code: str
    :ivar detail: Required.
    :vartype detail: str
    """

    _validation = {
        "attr": {"required": True},
        "code": {"required": True},
        "detail": {"required": True},
    }

    _attribute_map = {
        "attr": {"key": "attr", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "detail": {"key": "detail", "type": "str"},
    }

    def __init__(self, *, attr: str, code: str, detail: str, **kwargs):
        """
        :keyword attr: Required.
        :paramtype attr: str
        :keyword code: Required.
        :paramtype code: str
        :keyword detail: Required.
        :paramtype detail: str
        """
        super(RequestErrorErrorsItem, self).__init__(**kwargs)
        self.attr = attr
        self.code = code
        self.detail = detail


class Resume(msrest.serialization.Model):
    """Resume.

    All required parameters must be populated in order to send to Azure.

    :ivar data: Required. A JSON-encoded string of the ``ResumeData`` object.
    :vartype data: ~affinda.models.ResumeData
    :ivar meta: Required.
    :vartype meta: ~affinda.models.Meta
    :ivar error: Required.
    :vartype error: ~affinda.models.Error
    """

    _validation = {
        "data": {"required": True},
        "meta": {"required": True},
        "error": {"required": True},
    }

    _attribute_map = {
        "data": {"key": "data", "type": "ResumeData"},
        "meta": {"key": "meta", "type": "Meta"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self, *, data: "_models.ResumeData", meta: "_models.Meta", error: "_models.Error", **kwargs
    ):
        """
        :keyword data: Required. A JSON-encoded string of the ``ResumeData`` object.
        :paramtype data: ~affinda.models.ResumeData
        :keyword meta: Required.
        :paramtype meta: ~affinda.models.Meta
        :keyword error: Required.
        :paramtype error: ~affinda.models.Error
        """
        super(Resume, self).__init__(**kwargs)
        self.data = data
        self.meta = meta
        self.error = error


class ResumeData(msrest.serialization.Model):
    """A JSON-encoded string of the ``ResumeData`` object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name:
    :vartype name: ~affinda.models.ResumeDataName
    :ivar phone_numbers:
    :vartype phone_numbers: list[str]
    :ivar websites:
    :vartype websites: list[str]
    :ivar emails:
    :vartype emails: list[str]
    :ivar date_of_birth:
    :vartype date_of_birth: str
    :ivar location:
    :vartype location: ~affinda.models.Location
    :ivar objective:
    :vartype objective: str
    :ivar languages:
    :vartype languages: list[str]
    :ivar language_codes:
    :vartype language_codes: list[str]
    :ivar summary:
    :vartype summary: str
    :ivar total_years_experience:
    :vartype total_years_experience: int
    :ivar head_shot: base64 encoded string.
    :vartype head_shot: bytearray
    :ivar education:
    :vartype education: list[~affinda.models.Education]
    :ivar profession: Prediction of the candidate's profession based on recent work experience.
    :vartype profession: str
    :ivar linkedin: Linkedin account associated with the candidate.
    :vartype linkedin: str
    :ivar work_experience:
    :vartype work_experience: list[~affinda.models.ResumeDataWorkExperienceItem]
    :ivar skills:
    :vartype skills: list[~affinda.models.ResumeDataSkillsItem]
    :ivar certifications:
    :vartype certifications: list[str]
    :ivar publications:
    :vartype publications: list[str]
    :ivar referees:
    :vartype referees: list[~affinda.models.ResumeDataRefereesItem]
    :ivar sections:
    :vartype sections: list[~affinda.models.ResumeDataSectionsItem]
    :ivar is_resume_probability: Probability that the given document is a resume. Values below 30
     suggest that the document is not a resume.
    :vartype is_resume_probability: int
    :ivar raw_text: All of the raw text of the parsed resume, example is shortened for readability.
    :vartype raw_text: str
    """

    _validation = {
        "languages": {"readonly": True},
        "language_codes": {"readonly": True},
        "head_shot": {"readonly": True},
        "profession": {"readonly": True},
        "linkedin": {"readonly": True},
        "sections": {"readonly": True},
        "is_resume_probability": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "ResumeDataName"},
        "phone_numbers": {"key": "phoneNumbers", "type": "[str]"},
        "websites": {"key": "websites", "type": "[str]"},
        "emails": {"key": "emails", "type": "[str]"},
        "date_of_birth": {"key": "dateOfBirth", "type": "str"},
        "location": {"key": "location", "type": "Location"},
        "objective": {"key": "objective", "type": "str"},
        "languages": {"key": "languages", "type": "[str]"},
        "language_codes": {"key": "languageCodes", "type": "[str]"},
        "summary": {"key": "summary", "type": "str"},
        "total_years_experience": {"key": "totalYearsExperience", "type": "int"},
        "head_shot": {"key": "headShot", "type": "bytearray"},
        "education": {"key": "education", "type": "[Education]"},
        "profession": {"key": "profession", "type": "str"},
        "linkedin": {"key": "linkedin", "type": "str"},
        "work_experience": {"key": "workExperience", "type": "[ResumeDataWorkExperienceItem]"},
        "skills": {"key": "skills", "type": "[ResumeDataSkillsItem]"},
        "certifications": {"key": "certifications", "type": "[str]"},
        "publications": {"key": "publications", "type": "[str]"},
        "referees": {"key": "referees", "type": "[ResumeDataRefereesItem]"},
        "sections": {"key": "sections", "type": "[ResumeDataSectionsItem]"},
        "is_resume_probability": {"key": "isResumeProbability", "type": "int"},
        "raw_text": {"key": "rawText", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        name: Optional["_models.ResumeDataName"] = None,
        phone_numbers: Optional[List[str]] = None,
        websites: Optional[List[str]] = None,
        emails: Optional[List[str]] = None,
        date_of_birth: Optional[str] = None,
        location: Optional["_models.Location"] = None,
        objective: Optional[str] = None,
        summary: Optional[str] = None,
        total_years_experience: Optional[int] = None,
        education: Optional[List["_models.Education"]] = None,
        work_experience: Optional[List["_models.ResumeDataWorkExperienceItem"]] = None,
        skills: Optional[List["_models.ResumeDataSkillsItem"]] = None,
        certifications: Optional[List[str]] = None,
        publications: Optional[List[str]] = None,
        referees: Optional[List["_models.ResumeDataRefereesItem"]] = None,
        raw_text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword name:
        :paramtype name: ~affinda.models.ResumeDataName
        :keyword phone_numbers:
        :paramtype phone_numbers: list[str]
        :keyword websites:
        :paramtype websites: list[str]
        :keyword emails:
        :paramtype emails: list[str]
        :keyword date_of_birth:
        :paramtype date_of_birth: str
        :keyword location:
        :paramtype location: ~affinda.models.Location
        :keyword objective:
        :paramtype objective: str
        :keyword summary:
        :paramtype summary: str
        :keyword total_years_experience:
        :paramtype total_years_experience: int
        :keyword education:
        :paramtype education: list[~affinda.models.Education]
        :keyword work_experience:
        :paramtype work_experience: list[~affinda.models.ResumeDataWorkExperienceItem]
        :keyword skills:
        :paramtype skills: list[~affinda.models.ResumeDataSkillsItem]
        :keyword certifications:
        :paramtype certifications: list[str]
        :keyword publications:
        :paramtype publications: list[str]
        :keyword referees:
        :paramtype referees: list[~affinda.models.ResumeDataRefereesItem]
        :keyword raw_text: All of the raw text of the parsed resume, example is shortened for
         readability.
        :paramtype raw_text: str
        """
        super(ResumeData, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.phone_numbers = phone_numbers
        self.websites = websites
        self.emails = emails
        self.date_of_birth = date_of_birth
        self.location = location
        self.objective = objective
        self.languages = None
        self.language_codes = None
        self.summary = summary
        self.total_years_experience = total_years_experience
        self.head_shot = None
        self.education = education
        self.profession = None
        self.linkedin = None
        self.work_experience = work_experience
        self.skills = skills
        self.certifications = certifications
        self.publications = publications
        self.referees = referees
        self.sections = None
        self.is_resume_probability = None
        self.raw_text = raw_text


class ResumeDataName(msrest.serialization.Model):
    """ResumeDataName.

    :ivar raw:
    :vartype raw: str
    :ivar first:
    :vartype first: str
    :ivar last:
    :vartype last: str
    :ivar middle:
    :vartype middle: str
    :ivar title:
    :vartype title: str
    """

    _attribute_map = {
        "raw": {"key": "raw", "type": "str"},
        "first": {"key": "first", "type": "str"},
        "last": {"key": "last", "type": "str"},
        "middle": {"key": "middle", "type": "str"},
        "title": {"key": "title", "type": "str"},
    }

    def __init__(
        self,
        *,
        raw: Optional[str] = None,
        first: Optional[str] = None,
        last: Optional[str] = None,
        middle: Optional[str] = None,
        title: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword raw:
        :paramtype raw: str
        :keyword first:
        :paramtype first: str
        :keyword last:
        :paramtype last: str
        :keyword middle:
        :paramtype middle: str
        :keyword title:
        :paramtype title: str
        """
        super(ResumeDataName, self).__init__(**kwargs)
        self.raw = raw
        self.first = first
        self.last = last
        self.middle = middle
        self.title = title


class ResumeDataRefereesItem(msrest.serialization.Model):
    """ResumeDataRefereesItem.

    :ivar name:
    :vartype name: str
    :ivar text:
    :vartype text: str
    :ivar email:
    :vartype email: str
    :ivar number:
    :vartype number: str
    :ivar position:
    :vartype position: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "text": {"key": "text", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "number": {"key": "number", "type": "str"},
        "position": {"key": "position", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        text: Optional[str] = None,
        email: Optional[str] = None,
        number: Optional[str] = None,
        position: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword text:
        :paramtype text: str
        :keyword email:
        :paramtype email: str
        :keyword number:
        :paramtype number: str
        :keyword position:
        :paramtype position: str
        """
        super(ResumeDataRefereesItem, self).__init__(**kwargs)
        self.name = name
        self.text = text
        self.email = email
        self.number = number
        self.position = position


class ResumeDataSectionsItem(msrest.serialization.Model):
    """ResumeDataSectionsItem.

    :ivar section_type:
    :vartype section_type: str
    :ivar bbox:
    :vartype bbox: list[float]
    :ivar page_index:
    :vartype page_index: int
    :ivar text:
    :vartype text: str
    """

    _validation = {
        "bbox": {"max_items": 4, "min_items": 4},
    }

    _attribute_map = {
        "section_type": {"key": "sectionType", "type": "str"},
        "bbox": {"key": "bbox", "type": "[float]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(
        self,
        *,
        section_type: Optional[str] = None,
        bbox: Optional[List[float]] = None,
        page_index: Optional[int] = None,
        text: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword section_type:
        :paramtype section_type: str
        :keyword bbox:
        :paramtype bbox: list[float]
        :keyword page_index:
        :paramtype page_index: int
        :keyword text:
        :paramtype text: str
        """
        super(ResumeDataSectionsItem, self).__init__(**kwargs)
        self.section_type = section_type
        self.bbox = bbox
        self.page_index = page_index
        self.text = text


class ResumeDataSkillsItem(msrest.serialization.Model):
    """ResumeDataSkillsItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: int
    :ivar emsi_id: EMSI id of this skill.
    :vartype emsi_id: str
    :ivar name:
    :vartype name: str
    :ivar last_used:
    :vartype last_used: str
    :ivar number_of_months:
    :vartype number_of_months: int
    :ivar type:
    :vartype type: str
    :ivar count:
    :vartype count: int
    :ivar weighting:
    :vartype weighting: float
    :ivar sources:
    :vartype sources: list[~affinda.models.ResumeDataSkillsPropertiesItemsItem]
    """

    _validation = {
        "emsi_id": {"readonly": True},
        "type": {"readonly": True},
        "count": {"readonly": True},
        "weighting": {"readonly": True},
        "sources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "emsi_id": {"key": "emsiId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "last_used": {"key": "lastUsed", "type": "str"},
        "number_of_months": {"key": "numberOfMonths", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "weighting": {"key": "weighting", "type": "float"},
        "sources": {"key": "sources", "type": "[ResumeDataSkillsPropertiesItemsItem]"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        last_used: Optional[str] = None,
        number_of_months: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword last_used:
        :paramtype last_used: str
        :keyword number_of_months:
        :paramtype number_of_months: int
        """
        super(ResumeDataSkillsItem, self).__init__(**kwargs)
        self.id = id
        self.emsi_id = None
        self.name = name
        self.last_used = last_used
        self.number_of_months = number_of_months
        self.type = None
        self.count = None
        self.weighting = None
        self.sources = None


class ResumeDataSkillsPropertiesItemsItem(msrest.serialization.Model):
    """ResumeDataSkillsPropertiesItemsItem.

    :ivar section:
    :vartype section: str
    :ivar position: If this skill is extracted from a "workExperience" section, the "position" is
     the index of the work experience where this skill is found, with 0 being the first work
     experience, 1 being the second work experience, and so on.
    :vartype position: int
    :ivar work_experience_id: If this skill is extracted from a "workExperience" section, the
     "workExperienceId" is the id of the work experience where this skill is found.
    :vartype work_experience_id: int
    """

    _attribute_map = {
        "section": {"key": "section", "type": "str"},
        "position": {"key": "position", "type": "int"},
        "work_experience_id": {"key": "workExperienceId", "type": "int"},
    }

    def __init__(
        self,
        *,
        section: Optional[str] = None,
        position: Optional[int] = None,
        work_experience_id: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword section:
        :paramtype section: str
        :keyword position: If this skill is extracted from a "workExperience" section, the "position"
         is the index of the work experience where this skill is found, with 0 being the first work
         experience, 1 being the second work experience, and so on.
        :paramtype position: int
        :keyword work_experience_id: If this skill is extracted from a "workExperience" section, the
         "workExperienceId" is the id of the work experience where this skill is found.
        :paramtype work_experience_id: int
        """
        super(ResumeDataSkillsPropertiesItemsItem, self).__init__(**kwargs)
        self.section = section
        self.position = position
        self.work_experience_id = work_experience_id


class ResumeDataWorkExperienceItem(msrest.serialization.Model):
    """ResumeDataWorkExperienceItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: int
    :ivar job_title:
    :vartype job_title: str
    :ivar soc_code:
    :vartype soc_code: str
    :ivar soc_name:
    :vartype soc_name: str
    :ivar organization:
    :vartype organization: str
    :ivar industry:
    :vartype industry: str
    :ivar location:
    :vartype location: ~affinda.models.Location
    :ivar job_description:
    :vartype job_description: str
    :ivar dates:
    :vartype dates: ~affinda.models.ResumeDataWorkExperienceItemDates
    :ivar occupation:
    :vartype occupation: ~affinda.models.ResumeDataWorkExperienceItemOccupation
    """

    _validation = {
        "soc_code": {"readonly": True},
        "soc_name": {"readonly": True},
        "industry": {"readonly": True},
        "occupation": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "job_title": {"key": "jobTitle", "type": "str"},
        "soc_code": {"key": "socCode", "type": "str"},
        "soc_name": {"key": "socName", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "industry": {"key": "industry", "type": "str"},
        "location": {"key": "location", "type": "Location"},
        "job_description": {"key": "jobDescription", "type": "str"},
        "dates": {"key": "dates", "type": "ResumeDataWorkExperienceItemDates"},
        "occupation": {"key": "occupation", "type": "ResumeDataWorkExperienceItemOccupation"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        job_title: Optional[str] = None,
        organization: Optional[str] = None,
        location: Optional["_models.Location"] = None,
        job_description: Optional[str] = None,
        dates: Optional["_models.ResumeDataWorkExperienceItemDates"] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: int
        :keyword job_title:
        :paramtype job_title: str
        :keyword organization:
        :paramtype organization: str
        :keyword location:
        :paramtype location: ~affinda.models.Location
        :keyword job_description:
        :paramtype job_description: str
        :keyword dates:
        :paramtype dates: ~affinda.models.ResumeDataWorkExperienceItemDates
        """
        super(ResumeDataWorkExperienceItem, self).__init__(**kwargs)
        self.id = id
        self.job_title = job_title
        self.soc_code = None
        self.soc_name = None
        self.organization = organization
        self.industry = None
        self.location = location
        self.job_description = job_description
        self.dates = dates
        self.occupation = None


class ResumeDataWorkExperienceItemDates(msrest.serialization.Model):
    """ResumeDataWorkExperienceItemDates.

    :ivar start_date:
    :vartype start_date: ~datetime.date
    :ivar end_date:
    :vartype end_date: ~datetime.date
    :ivar months_in_position:
    :vartype months_in_position: int
    :ivar is_current:
    :vartype is_current: bool
    """

    _attribute_map = {
        "start_date": {"key": "startDate", "type": "date"},
        "end_date": {"key": "endDate", "type": "date"},
        "months_in_position": {"key": "monthsInPosition", "type": "int"},
        "is_current": {"key": "isCurrent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        start_date: Optional[datetime.date] = None,
        end_date: Optional[datetime.date] = None,
        months_in_position: Optional[int] = None,
        is_current: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword start_date:
        :paramtype start_date: ~datetime.date
        :keyword end_date:
        :paramtype end_date: ~datetime.date
        :keyword months_in_position:
        :paramtype months_in_position: int
        :keyword is_current:
        :paramtype is_current: bool
        """
        super(ResumeDataWorkExperienceItemDates, self).__init__(**kwargs)
        self.start_date = start_date
        self.end_date = end_date
        self.months_in_position = months_in_position
        self.is_current = is_current


class ResumeDataWorkExperienceItemOccupation(msrest.serialization.Model):
    """ResumeDataWorkExperienceItemOccupation.

    :ivar job_title: The raw (not normalized) job title pulled from the work experience entry.
    :vartype job_title: str
    :ivar job_title_normalized: Mapped onto the EMSI job title taxonomy if a sufficiently close
     match exists.
    :vartype job_title_normalized: str
    :ivar management_level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype management_level: str or ~affinda.models.ManagementLevel
    :ivar classification:
    :vartype classification:
     ~affinda.models.Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "str"},
        "job_title_normalized": {"key": "jobTitleNormalized", "type": "str"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "classification": {
            "key": "classification",
            "type": "Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification",
        },
    }

    def __init__(
        self,
        *,
        job_title: Optional[str] = None,
        job_title_normalized: Optional[str] = None,
        management_level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        classification: Optional[
            "_models.Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification"
        ] = None,
        **kwargs,
    ):
        """
        :keyword job_title: The raw (not normalized) job title pulled from the work experience entry.
        :paramtype job_title: str
        :keyword job_title_normalized: Mapped onto the EMSI job title taxonomy if a sufficiently close
         match exists.
        :paramtype job_title_normalized: str
        :keyword management_level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype management_level: str or ~affinda.models.ManagementLevel
        :keyword classification:
        :paramtype classification:
         ~affinda.models.Components1TryetgSchemasResumedataPropertiesWorkexperienceItemsPropertiesOccupationPropertiesClassification
        """
        super(ResumeDataWorkExperienceItemOccupation, self).__init__(**kwargs)
        self.job_title = job_title
        self.job_title_normalized = job_title_normalized
        self.management_level = management_level
        self.classification = classification


class ResumeRequestBody(msrest.serialization.Model):
    """ResumeRequestBody.

    :ivar file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML, PNG,
     JPG.
    :vartype file: IO
    :ivar url: URL to a resume to download and process.
    :vartype url: str
    :ivar data: A JSON-encoded string of the ``ResumeData`` object.
    :vartype data: ~affinda.models.ResumeData
    :ivar identifier: A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar file_name: Optional filename of the file.
    :vartype file_name: str
    :ivar wait: If "true" (default), will return a response only after processing has completed. If
     "false", will return an empty data object which can be polled at the GET endpoint until
     processing is complete.
    :vartype wait: bool
    :ivar reject_duplicates: If "true", parsing will fail when the uploaded document is duplicate
     of an existing document. If "false" (default), will parse the document normally whether its a
     duplicate or not.
    :vartype reject_duplicates: bool
    :ivar language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
    :vartype language: str
    :ivar expiry_time: The date/time in ISO-8601 format when the document will be automatically
     deleted.  Defaults to no expiry.
    :vartype expiry_time: ~datetime.datetime
    """

    _attribute_map = {
        "file": {"key": "file", "type": "IO"},
        "url": {"key": "url", "type": "str"},
        "data": {"key": "data", "type": "ResumeData"},
        "identifier": {"key": "identifier", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "wait": {"key": "wait", "type": "bool"},
        "reject_duplicates": {"key": "rejectDuplicates", "type": "bool"},
        "language": {"key": "language", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        data: Optional["_models.ResumeData"] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword file: File as binary data blob. Supported formats: PDF, DOC, DOCX, TXT, RTF, HTML,
         PNG, JPG.
        :paramtype file: IO
        :keyword url: URL to a resume to download and process.
        :paramtype url: str
        :keyword data: A JSON-encoded string of the ``ResumeData`` object.
        :paramtype data: ~affinda.models.ResumeData
        :keyword identifier: A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword file_name: Optional filename of the file.
        :paramtype file_name: str
        :keyword wait: If "true" (default), will return a response only after processing has completed.
         If "false", will return an empty data object which can be polled at the GET endpoint until
         processing is complete.
        :paramtype wait: bool
        :keyword reject_duplicates: If "true", parsing will fail when the uploaded document is
         duplicate of an existing document. If "false" (default), will parse the document normally
         whether its a duplicate or not.
        :paramtype reject_duplicates: bool
        :keyword language: Language code in ISO 639-1 format. Must specify zh-cn or zh-tw for Chinese.
        :paramtype language: str
        :keyword expiry_time: The date/time in ISO-8601 format when the document will be automatically
         deleted.  Defaults to no expiry.
        :paramtype expiry_time: ~datetime.datetime
        """
        super(ResumeRequestBody, self).__init__(**kwargs)
        self.file = file
        self.url = url
        self.data = data
        self.identifier = identifier
        self.file_name = file_name
        self.wait = wait
        self.reject_duplicates = reject_duplicates
        self.language = language
        self.expiry_time = expiry_time


class ResumeSearch(msrest.serialization.Model):
    """ResumeSearch.

    :ivar count: Total number of results.
    :vartype count: int
    :ivar next: URL to request next page of results.
    :vartype next: str
    :ivar previous: URL to request previous page of results.
    :vartype previous: str
    :ivar parameters:
    :vartype parameters: ~affinda.models.ResumeSearchParameters
    :ivar results:
    :vartype results: list[~affinda.models.ResumeSearchResult]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "next": {"key": "next", "type": "str"},
        "previous": {"key": "previous", "type": "str"},
        "parameters": {"key": "parameters", "type": "ResumeSearchParameters"},
        "results": {"key": "results", "type": "[ResumeSearchResult]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        next: Optional[str] = None,
        previous: Optional[str] = None,
        parameters: Optional["_models.ResumeSearchParameters"] = None,
        results: Optional[List["_models.ResumeSearchResult"]] = None,
        **kwargs,
    ):
        """
        :keyword count: Total number of results.
        :paramtype count: int
        :keyword next: URL to request next page of results.
        :paramtype next: str
        :keyword previous: URL to request previous page of results.
        :paramtype previous: str
        :keyword parameters:
        :paramtype parameters: ~affinda.models.ResumeSearchParameters
        :keyword results:
        :paramtype results: list[~affinda.models.ResumeSearchResult]
        """
        super(ResumeSearch, self).__init__(**kwargs)
        self.count = count
        self.next = next
        self.previous = previous
        self.parameters = parameters
        self.results = results


class ResumeSearchConfig(msrest.serialization.Model):
    """ResumeSearchConfig.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allow_pdf_download:
    :vartype allow_pdf_download: bool
    :ivar max_results: Maximum number of results that can be returned. Setting to "null" means no
     limitation.
    :vartype max_results: int
    :ivar display_job_title:
    :vartype display_job_title: bool
    :ivar display_location:
    :vartype display_location: bool
    :ivar display_years_experience:
    :vartype display_years_experience: bool
    :ivar display_occupation_group:
    :vartype display_occupation_group: bool
    :ivar display_education:
    :vartype display_education: bool
    :ivar display_skills:
    :vartype display_skills: bool
    :ivar display_languages:
    :vartype display_languages: bool
    :ivar display_management_level:
    :vartype display_management_level: bool
    :ivar display_keywords:
    :vartype display_keywords: bool
    :ivar weight_job_title:
    :vartype weight_job_title: float
    :ivar weight_location:
    :vartype weight_location: float
    :ivar weight_years_experience:
    :vartype weight_years_experience: float
    :ivar weight_occupation_group:
    :vartype weight_occupation_group: float
    :ivar weight_education:
    :vartype weight_education: float
    :ivar weight_skills:
    :vartype weight_skills: float
    :ivar weight_languages:
    :vartype weight_languages: float
    :ivar weight_management_level:
    :vartype weight_management_level: float
    :ivar weight_keywords:
    :vartype weight_keywords: float
    :ivar indices: List of index names.
    :vartype indices: list[str]
    :ivar search_tool_theme: Customize the theme of the embeded search tool.
    :vartype search_tool_theme: dict[str, any]
    :ivar user_id: ID of the logged in user.
    :vartype user_id: int
    :ivar username: Username of the logged in user.
    :vartype username: str
    """

    _validation = {
        "user_id": {"readonly": True},
        "username": {"readonly": True},
    }

    _attribute_map = {
        "allow_pdf_download": {"key": "allowPdfDownload", "type": "bool"},
        "max_results": {"key": "maxResults", "type": "int"},
        "display_job_title": {"key": "displayJobTitle", "type": "bool"},
        "display_location": {"key": "displayLocation", "type": "bool"},
        "display_years_experience": {"key": "displayYearsExperience", "type": "bool"},
        "display_occupation_group": {"key": "displayOccupationGroup", "type": "bool"},
        "display_education": {"key": "displayEducation", "type": "bool"},
        "display_skills": {"key": "displaySkills", "type": "bool"},
        "display_languages": {"key": "displayLanguages", "type": "bool"},
        "display_management_level": {"key": "displayManagementLevel", "type": "bool"},
        "display_keywords": {"key": "displayKeywords", "type": "bool"},
        "weight_job_title": {"key": "weightJobTitle", "type": "float"},
        "weight_location": {"key": "weightLocation", "type": "float"},
        "weight_years_experience": {"key": "weightYearsExperience", "type": "float"},
        "weight_occupation_group": {"key": "weightOccupationGroup", "type": "float"},
        "weight_education": {"key": "weightEducation", "type": "float"},
        "weight_skills": {"key": "weightSkills", "type": "float"},
        "weight_languages": {"key": "weightLanguages", "type": "float"},
        "weight_management_level": {"key": "weightManagementLevel", "type": "float"},
        "weight_keywords": {"key": "weightKeywords", "type": "float"},
        "indices": {"key": "indices", "type": "[str]"},
        "search_tool_theme": {"key": "searchToolTheme", "type": "{object}"},
        "user_id": {"key": "userId", "type": "int"},
        "username": {"key": "username", "type": "str"},
    }

    def __init__(
        self,
        *,
        allow_pdf_download: Optional[bool] = None,
        max_results: Optional[int] = None,
        display_job_title: Optional[bool] = None,
        display_location: Optional[bool] = None,
        display_years_experience: Optional[bool] = None,
        display_occupation_group: Optional[bool] = None,
        display_education: Optional[bool] = None,
        display_skills: Optional[bool] = None,
        display_languages: Optional[bool] = None,
        display_management_level: Optional[bool] = None,
        display_keywords: Optional[bool] = None,
        weight_job_title: Optional[float] = None,
        weight_location: Optional[float] = None,
        weight_years_experience: Optional[float] = None,
        weight_occupation_group: Optional[float] = None,
        weight_education: Optional[float] = None,
        weight_skills: Optional[float] = None,
        weight_languages: Optional[float] = None,
        weight_management_level: Optional[float] = None,
        weight_keywords: Optional[float] = None,
        indices: Optional[List[str]] = None,
        search_tool_theme: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        """
        :keyword allow_pdf_download:
        :paramtype allow_pdf_download: bool
        :keyword max_results: Maximum number of results that can be returned. Setting to "null" means
         no limitation.
        :paramtype max_results: int
        :keyword display_job_title:
        :paramtype display_job_title: bool
        :keyword display_location:
        :paramtype display_location: bool
        :keyword display_years_experience:
        :paramtype display_years_experience: bool
        :keyword display_occupation_group:
        :paramtype display_occupation_group: bool
        :keyword display_education:
        :paramtype display_education: bool
        :keyword display_skills:
        :paramtype display_skills: bool
        :keyword display_languages:
        :paramtype display_languages: bool
        :keyword display_management_level:
        :paramtype display_management_level: bool
        :keyword display_keywords:
        :paramtype display_keywords: bool
        :keyword weight_job_title:
        :paramtype weight_job_title: float
        :keyword weight_location:
        :paramtype weight_location: float
        :keyword weight_years_experience:
        :paramtype weight_years_experience: float
        :keyword weight_occupation_group:
        :paramtype weight_occupation_group: float
        :keyword weight_education:
        :paramtype weight_education: float
        :keyword weight_skills:
        :paramtype weight_skills: float
        :keyword weight_languages:
        :paramtype weight_languages: float
        :keyword weight_management_level:
        :paramtype weight_management_level: float
        :keyword weight_keywords:
        :paramtype weight_keywords: float
        :keyword indices: List of index names.
        :paramtype indices: list[str]
        :keyword search_tool_theme: Customize the theme of the embeded search tool.
        :paramtype search_tool_theme: dict[str, any]
        """
        super(ResumeSearchConfig, self).__init__(**kwargs)
        self.allow_pdf_download = allow_pdf_download
        self.max_results = max_results
        self.display_job_title = display_job_title
        self.display_location = display_location
        self.display_years_experience = display_years_experience
        self.display_occupation_group = display_occupation_group
        self.display_education = display_education
        self.display_skills = display_skills
        self.display_languages = display_languages
        self.display_management_level = display_management_level
        self.display_keywords = display_keywords
        self.weight_job_title = weight_job_title
        self.weight_location = weight_location
        self.weight_years_experience = weight_years_experience
        self.weight_occupation_group = weight_occupation_group
        self.weight_education = weight_education
        self.weight_skills = weight_skills
        self.weight_languages = weight_languages
        self.weight_management_level = weight_management_level
        self.weight_keywords = weight_keywords
        self.indices = indices
        self.search_tool_theme = search_tool_theme
        self.user_id = None
        self.username = None


class ResumeSearchDetail(msrest.serialization.Model):
    """ResumeSearchDetail.

    :ivar job_title:
    :vartype job_title: ~affinda.models.ResumeSearchDetailJobTitle
    :ivar location:
    :vartype location: ~affinda.models.ResumeSearchDetailLocation
    :ivar education:
    :vartype education: ~affinda.models.ResumeSearchDetailEducation
    :ivar skills:
    :vartype skills: ~affinda.models.ResumeSearchDetailSkills
    :ivar experience:
    :vartype experience: ~affinda.models.ResumeSearchDetailExperience
    :ivar occupation_group:
    :vartype occupation_group: ~affinda.models.ResumeSearchDetailOccupationGroup
    :ivar languages:
    :vartype languages: ~affinda.models.ResumeSearchDetailLanguages
    :ivar management_level:
    :vartype management_level: ~affinda.models.ResumeSearchDetailManagementLevel
    :ivar search_expression:
    :vartype search_expression: ~affinda.models.ResumeSearchDetailSearchExpression
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "ResumeSearchDetailJobTitle"},
        "location": {"key": "location", "type": "ResumeSearchDetailLocation"},
        "education": {"key": "education", "type": "ResumeSearchDetailEducation"},
        "skills": {"key": "skills", "type": "ResumeSearchDetailSkills"},
        "experience": {"key": "experience", "type": "ResumeSearchDetailExperience"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "ResumeSearchDetailOccupationGroup",
        },
        "languages": {"key": "languages", "type": "ResumeSearchDetailLanguages"},
        "management_level": {
            "key": "managementLevel",
            "type": "ResumeSearchDetailManagementLevel",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "ResumeSearchDetailSearchExpression",
        },
    }

    def __init__(
        self,
        *,
        job_title: Optional["_models.ResumeSearchDetailJobTitle"] = None,
        location: Optional["_models.ResumeSearchDetailLocation"] = None,
        education: Optional["_models.ResumeSearchDetailEducation"] = None,
        skills: Optional["_models.ResumeSearchDetailSkills"] = None,
        experience: Optional["_models.ResumeSearchDetailExperience"] = None,
        occupation_group: Optional["_models.ResumeSearchDetailOccupationGroup"] = None,
        languages: Optional["_models.ResumeSearchDetailLanguages"] = None,
        management_level: Optional["_models.ResumeSearchDetailManagementLevel"] = None,
        search_expression: Optional["_models.ResumeSearchDetailSearchExpression"] = None,
        **kwargs,
    ):
        """
        :keyword job_title:
        :paramtype job_title: ~affinda.models.ResumeSearchDetailJobTitle
        :keyword location:
        :paramtype location: ~affinda.models.ResumeSearchDetailLocation
        :keyword education:
        :paramtype education: ~affinda.models.ResumeSearchDetailEducation
        :keyword skills:
        :paramtype skills: ~affinda.models.ResumeSearchDetailSkills
        :keyword experience:
        :paramtype experience: ~affinda.models.ResumeSearchDetailExperience
        :keyword occupation_group:
        :paramtype occupation_group: ~affinda.models.ResumeSearchDetailOccupationGroup
        :keyword languages:
        :paramtype languages: ~affinda.models.ResumeSearchDetailLanguages
        :keyword management_level:
        :paramtype management_level: ~affinda.models.ResumeSearchDetailManagementLevel
        :keyword search_expression:
        :paramtype search_expression: ~affinda.models.ResumeSearchDetailSearchExpression
        """
        super(ResumeSearchDetail, self).__init__(**kwargs)
        self.job_title = job_title
        self.location = location
        self.education = education
        self.skills = skills
        self.experience = experience
        self.occupation_group = occupation_group
        self.languages = languages
        self.management_level = management_level
        self.search_expression = search_expression


class ResumeSearchDetailEducation(msrest.serialization.Model):
    """ResumeSearchDetailEducation.

    :ivar missing:
    :vartype missing: ~affinda.models.ResumeSearchDetailEducationMissing
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailEducationValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "ResumeSearchDetailEducationMissing"},
        "value": {"key": "value", "type": "[ResumeSearchDetailEducationValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional["_models.ResumeSearchDetailEducationMissing"] = None,
        value: Optional[List["_models.ResumeSearchDetailEducationValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: ~affinda.models.ResumeSearchDetailEducationMissing
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailEducationValueItem]
        """
        super(ResumeSearchDetailEducation, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailEducationMissing(msrest.serialization.Model):
    """ResumeSearchDetailEducationMissing.

    :ivar degrees:
    :vartype degrees: list[str]
    :ivar highest_degree_types:
    :vartype highest_degree_types: list[str]
    :ivar institutions:
    :vartype institutions: list[str]
    :ivar current_student:
    :vartype current_student: bool
    :ivar recent_graduate:
    :vartype recent_graduate: bool
    """

    _attribute_map = {
        "degrees": {"key": "degrees", "type": "[str]"},
        "highest_degree_types": {"key": "highestDegreeTypes", "type": "[str]"},
        "institutions": {"key": "institutions", "type": "[str]"},
        "current_student": {"key": "currentStudent", "type": "bool"},
        "recent_graduate": {"key": "recentGraduate", "type": "bool"},
    }

    def __init__(
        self,
        *,
        degrees: Optional[List[str]] = None,
        highest_degree_types: Optional[List[str]] = None,
        institutions: Optional[List[str]] = None,
        current_student: Optional[bool] = None,
        recent_graduate: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword highest_degree_types:
        :paramtype highest_degree_types: list[str]
        :keyword institutions:
        :paramtype institutions: list[str]
        :keyword current_student:
        :paramtype current_student: bool
        :keyword recent_graduate:
        :paramtype recent_graduate: bool
        """
        super(ResumeSearchDetailEducationMissing, self).__init__(**kwargs)
        self.degrees = degrees
        self.highest_degree_types = highest_degree_types
        self.institutions = institutions
        self.current_student = current_student
        self.recent_graduate = recent_graduate


class ResumeSearchDetailEducationValueItem(
    Education,
    ComponentsSxu0N3SchemasResumesearchdetailPropertiesEducationPropertiesValueItemsAllof1,
):
    """ResumeSearchDetailEducationValueItem.

    :ivar match:
    :vartype match: bool
    :ivar id:
    :vartype id: int
    :ivar organization:
    :vartype organization: str
    :ivar accreditation:
    :vartype accreditation: ~affinda.models.Accreditation
    :ivar grade:
    :vartype grade: ~affinda.models.EducationGrade
    :ivar location:
    :vartype location: ~affinda.models.Location
    :ivar dates:
    :vartype dates: ~affinda.models.EducationDates
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "id": {"key": "id", "type": "int"},
        "organization": {"key": "organization", "type": "str"},
        "accreditation": {"key": "accreditation", "type": "Accreditation"},
        "grade": {"key": "grade", "type": "EducationGrade"},
        "location": {"key": "location", "type": "Location"},
        "dates": {"key": "dates", "type": "EducationDates"},
    }

    def __init__(
        self,
        *,
        match: Optional[bool] = None,
        id: Optional[int] = None,
        organization: Optional[str] = None,
        accreditation: Optional["_models.Accreditation"] = None,
        grade: Optional["_models.EducationGrade"] = None,
        location: Optional["_models.Location"] = None,
        dates: Optional["_models.EducationDates"] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword id:
        :paramtype id: int
        :keyword organization:
        :paramtype organization: str
        :keyword accreditation:
        :paramtype accreditation: ~affinda.models.Accreditation
        :keyword grade:
        :paramtype grade: ~affinda.models.EducationGrade
        :keyword location:
        :paramtype location: ~affinda.models.Location
        :keyword dates:
        :paramtype dates: ~affinda.models.EducationDates
        """
        super(ResumeSearchDetailEducationValueItem, self).__init__(
            id=id,
            organization=organization,
            accreditation=accreditation,
            grade=grade,
            location=location,
            dates=dates,
            match=match,
            **kwargs,
        )
        self.match = match
        self.id = id
        self.organization = organization
        self.accreditation = accreditation
        self.grade = grade
        self.location = location
        self.dates = dates


class ResumeSearchDetailExperience(msrest.serialization.Model):
    """ResumeSearchDetailExperience.

    :ivar years:
    :vartype years: int
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "years": {"key": "years", "type": "int"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(self, *, years: Optional[int] = None, match: Optional[bool] = None, **kwargs):
        """
        :keyword years:
        :paramtype years: int
        :keyword match:
        :paramtype match: bool
        """
        super(ResumeSearchDetailExperience, self).__init__(**kwargs)
        self.years = years
        self.match = match


class ResumeSearchDetailJobTitle(msrest.serialization.Model):
    """ResumeSearchDetailJobTitle.

    :ivar missing:
    :vartype missing: list[str]
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailJobTitleValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[str]"},
        "value": {"key": "value", "type": "[ResumeSearchDetailJobTitleValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List[str]] = None,
        value: Optional[List["_models.ResumeSearchDetailJobTitleValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[str]
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailJobTitleValueItem]
        """
        super(ResumeSearchDetailJobTitle, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailJobTitleValueItem(msrest.serialization.Model):
    """ResumeSearchDetailJobTitleValueItem.

    :ivar name:
    :vartype name: str
    :ivar start_date:
    :vartype start_date: str
    :ivar end_date:
    :vartype end_date: str
    :ivar company_name:
    :vartype company_name: str
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "start_date": {"key": "startDate", "type": "str"},
        "end_date": {"key": "endDate", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_date: Optional[str] = None,
        end_date: Optional[str] = None,
        company_name: Optional[str] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword start_date:
        :paramtype start_date: str
        :keyword end_date:
        :paramtype end_date: str
        :keyword company_name:
        :paramtype company_name: str
        :keyword match:
        :paramtype match: bool
        """
        super(ResumeSearchDetailJobTitleValueItem, self).__init__(**kwargs)
        self.name = name
        self.start_date = start_date
        self.end_date = end_date
        self.company_name = company_name
        self.match = match


class ResumeSearchDetailLanguages(msrest.serialization.Model):
    """ResumeSearchDetailLanguages.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailLanguagesValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersSkill]"},
        "value": {"key": "value", "type": "[ResumeSearchDetailLanguagesValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        value: Optional[List["_models.ResumeSearchDetailLanguagesValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailLanguagesValueItem]
        """
        super(ResumeSearchDetailLanguages, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSkill(msrest.serialization.Model):
    """ResumeSkill.

    :ivar name:
    :vartype name: str
    :ivar last_used:
    :vartype last_used: str
    :ivar number_of_months:
    :vartype number_of_months: int
    :ivar type:
    :vartype type: str
    :ivar sources:
    :vartype sources: list[~affinda.models.ResumeSkillSourcesItem]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "last_used": {"key": "lastUsed", "type": "str"},
        "number_of_months": {"key": "numberOfMonths", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "sources": {"key": "sources", "type": "[ResumeSkillSourcesItem]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        last_used: Optional[str] = None,
        number_of_months: Optional[int] = None,
        type: Optional[str] = None,
        sources: Optional[List["_models.ResumeSkillSourcesItem"]] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword last_used:
        :paramtype last_used: str
        :keyword number_of_months:
        :paramtype number_of_months: int
        :keyword type:
        :paramtype type: str
        :keyword sources:
        :paramtype sources: list[~affinda.models.ResumeSkillSourcesItem]
        """
        super(ResumeSkill, self).__init__(**kwargs)
        self.name = name
        self.last_used = last_used
        self.number_of_months = number_of_months
        self.type = type
        self.sources = sources


class ResumeSearchDetailLanguagesValueItem(
    ResumeSkill,
    Components159Ji55SchemasResumesearchdetailPropertiesLanguagesPropertiesValueItemsAllof1,
):
    """ResumeSearchDetailLanguagesValueItem.

    :ivar match:
    :vartype match: bool
    :ivar name:
    :vartype name: str
    :ivar last_used:
    :vartype last_used: str
    :ivar number_of_months:
    :vartype number_of_months: int
    :ivar type:
    :vartype type: str
    :ivar sources:
    :vartype sources: list[~affinda.models.ResumeSkillSourcesItem]
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "last_used": {"key": "lastUsed", "type": "str"},
        "number_of_months": {"key": "numberOfMonths", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "sources": {"key": "sources", "type": "[ResumeSkillSourcesItem]"},
    }

    def __init__(
        self,
        *,
        match: Optional[bool] = None,
        name: Optional[str] = None,
        last_used: Optional[str] = None,
        number_of_months: Optional[int] = None,
        type: Optional[str] = None,
        sources: Optional[List["_models.ResumeSkillSourcesItem"]] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword name:
        :paramtype name: str
        :keyword last_used:
        :paramtype last_used: str
        :keyword number_of_months:
        :paramtype number_of_months: int
        :keyword type:
        :paramtype type: str
        :keyword sources:
        :paramtype sources: list[~affinda.models.ResumeSkillSourcesItem]
        """
        super(ResumeSearchDetailLanguagesValueItem, self).__init__(
            name=name,
            last_used=last_used,
            number_of_months=number_of_months,
            type=type,
            sources=sources,
            match=match,
            **kwargs,
        )
        self.match = match
        self.name = name
        self.last_used = last_used
        self.number_of_months = number_of_months
        self.type = type
        self.sources = sources


class ResumeSearchDetailLocation(msrest.serialization.Model):
    """ResumeSearchDetailLocation.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersLocation]
    :ivar value:
    :vartype value: ~affinda.models.ResumeSearchDetailLocationValue
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersLocation]"},
        "value": {"key": "value", "type": "ResumeSearchDetailLocationValue"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersLocation"]] = None,
        value: Optional["_models.ResumeSearchDetailLocationValue"] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersLocation]
        :keyword value:
        :paramtype value: ~affinda.models.ResumeSearchDetailLocationValue
        """
        super(ResumeSearchDetailLocation, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailLocationValue(
    Location, ComponentsN9ShogSchemasResumesearchdetailPropertiesLocationPropertiesValueAllof1
):
    """ResumeSearchDetailLocationValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar match:
    :vartype match: bool
    :ivar formatted:
    :vartype formatted: str
    :ivar postal_code:
    :vartype postal_code: str
    :ivar state:
    :vartype state: str
    :ivar country:
    :vartype country: str
    :ivar country_code: Two letter country code (ISO 3166-1 alpha-2).
    :vartype country_code: str
    :ivar raw_input: Required.
    :vartype raw_input: str
    :ivar street_number:
    :vartype street_number: str
    :ivar street:
    :vartype street: str
    :ivar apartment_number:
    :vartype apartment_number: str
    :ivar city:
    :vartype city: str
    """

    _validation = {
        "formatted": {"readonly": True},
        "postal_code": {"readonly": True},
        "state": {"readonly": True},
        "country": {"readonly": True},
        "country_code": {"readonly": True},
        "raw_input": {"required": True},
        "street_number": {"readonly": True},
        "street": {"readonly": True},
        "apartment_number": {"readonly": True},
        "city": {"readonly": True},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "formatted": {"key": "formatted", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "raw_input": {"key": "rawInput", "type": "str"},
        "street_number": {"key": "streetNumber", "type": "str"},
        "street": {"key": "street", "type": "str"},
        "apartment_number": {"key": "apartmentNumber", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(self, *, raw_input: str, match: Optional[bool] = None, **kwargs):
        """
        :keyword match:
        :paramtype match: bool
        :keyword raw_input: Required.
        :paramtype raw_input: str
        """
        super(ResumeSearchDetailLocationValue, self).__init__(
            raw_input=raw_input, match=match, **kwargs
        )
        self.match = match
        self.formatted = None
        self.postal_code = None
        self.state = None
        self.country = None
        self.country_code = None
        self.raw_input = raw_input
        self.street_number = None
        self.street = None
        self.apartment_number = None
        self.city = None


class ResumeSearchDetailManagementLevel(msrest.serialization.Model):
    """ResumeSearchDetailManagementLevel.

    :ivar level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype level: str or ~affinda.models.ManagementLevel
    :ivar match:
    :vartype match: bool
    """

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "match": {"key": "match", "type": "bool"},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype level: str or ~affinda.models.ManagementLevel
        :keyword match:
        :paramtype match: bool
        """
        super(ResumeSearchDetailManagementLevel, self).__init__(**kwargs)
        self.level = level
        self.match = match


class ResumeSearchDetailOccupationGroup(msrest.serialization.Model):
    """ResumeSearchDetailOccupationGroup.

    :ivar missing:
    :vartype missing: list[int]
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailOccupationGroupValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[int]"},
        "value": {"key": "value", "type": "[ResumeSearchDetailOccupationGroupValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List[int]] = None,
        value: Optional[List["_models.ResumeSearchDetailOccupationGroupValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[int]
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailOccupationGroupValueItem]
        """
        super(ResumeSearchDetailOccupationGroup, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailOccupationGroupValueItem(
    OccupationGroup,
    ComponentsK7P1F5SchemasResumesearchdetailPropertiesOccupationgroupPropertiesValueItemsAllof1,
):
    """ResumeSearchDetailOccupationGroupValueItem.

    All required parameters must be populated in order to send to Azure.

    :ivar match:
    :vartype match: bool
    :ivar code: Required.
    :vartype code: int
    :ivar name: Required.
    :vartype name: str
    :ivar children: Required.
    :vartype children: list[~affinda.models.OccupationGroup]
    """

    _validation = {
        "code": {"required": True},
        "name": {"required": True},
        "children": {"required": True},
    }

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "code": {"key": "code", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "children": {"key": "children", "type": "[OccupationGroup]"},
    }

    def __init__(
        self,
        *,
        code: int,
        name: str,
        children: List["_models.OccupationGroup"],
        match: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword code: Required.
        :paramtype code: int
        :keyword name: Required.
        :paramtype name: str
        :keyword children: Required.
        :paramtype children: list[~affinda.models.OccupationGroup]
        """
        super(ResumeSearchDetailOccupationGroupValueItem, self).__init__(
            code=code, name=name, children=children, match=match, **kwargs
        )
        self.match = match
        self.code = code
        self.name = name
        self.children = children


class ResumeSearchDetailSearchExpression(msrest.serialization.Model):
    """ResumeSearchDetailSearchExpression.

    :ivar missing:
    :vartype missing: list[str]
    :ivar value:
    :vartype value: list[str]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[str]"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(
        self, *, missing: Optional[List[str]] = None, value: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword missing:
        :paramtype missing: list[str]
        :keyword value:
        :paramtype value: list[str]
        """
        super(ResumeSearchDetailSearchExpression, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailSkills(msrest.serialization.Model):
    """ResumeSearchDetailSkills.

    :ivar missing:
    :vartype missing: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar value:
    :vartype value: list[~affinda.models.ResumeSearchDetailSkillsValueItem]
    """

    _attribute_map = {
        "missing": {"key": "missing", "type": "[ResumeSearchParametersSkill]"},
        "value": {"key": "value", "type": "[ResumeSearchDetailSkillsValueItem]"},
    }

    def __init__(
        self,
        *,
        missing: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        value: Optional[List["_models.ResumeSearchDetailSkillsValueItem"]] = None,
        **kwargs,
    ):
        """
        :keyword missing:
        :paramtype missing: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword value:
        :paramtype value: list[~affinda.models.ResumeSearchDetailSkillsValueItem]
        """
        super(ResumeSearchDetailSkills, self).__init__(**kwargs)
        self.missing = missing
        self.value = value


class ResumeSearchDetailSkillsValueItem(
    ResumeSkill,
    ComponentsH65QjbSchemasResumesearchdetailPropertiesSkillsPropertiesValueItemsAllof1,
):
    """ResumeSearchDetailSkillsValueItem.

    :ivar match:
    :vartype match: bool
    :ivar name:
    :vartype name: str
    :ivar last_used:
    :vartype last_used: str
    :ivar number_of_months:
    :vartype number_of_months: int
    :ivar type:
    :vartype type: str
    :ivar sources:
    :vartype sources: list[~affinda.models.ResumeSkillSourcesItem]
    """

    _attribute_map = {
        "match": {"key": "match", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "last_used": {"key": "lastUsed", "type": "str"},
        "number_of_months": {"key": "numberOfMonths", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "sources": {"key": "sources", "type": "[ResumeSkillSourcesItem]"},
    }

    def __init__(
        self,
        *,
        match: Optional[bool] = None,
        name: Optional[str] = None,
        last_used: Optional[str] = None,
        number_of_months: Optional[int] = None,
        type: Optional[str] = None,
        sources: Optional[List["_models.ResumeSkillSourcesItem"]] = None,
        **kwargs,
    ):
        """
        :keyword match:
        :paramtype match: bool
        :keyword name:
        :paramtype name: str
        :keyword last_used:
        :paramtype last_used: str
        :keyword number_of_months:
        :paramtype number_of_months: int
        :keyword type:
        :paramtype type: str
        :keyword sources:
        :paramtype sources: list[~affinda.models.ResumeSkillSourcesItem]
        """
        super(ResumeSearchDetailSkillsValueItem, self).__init__(
            name=name,
            last_used=last_used,
            number_of_months=number_of_months,
            type=type,
            sources=sources,
            match=match,
            **kwargs,
        )
        self.match = match
        self.name = name
        self.last_used = last_used
        self.number_of_months = number_of_months
        self.type = type
        self.sources = sources


class ResumeSearchEmbed(msrest.serialization.Model):
    """ResumeSearchEmbed.

    :ivar url: The signed URL for the embedable search tool.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs):
        """
        :keyword url: The signed URL for the embedable search tool.
        :paramtype url: str
        """
        super(ResumeSearchEmbed, self).__init__(**kwargs)
        self.url = url


class ResumeSearchMatch(msrest.serialization.Model):
    """ResumeSearchMatch.

    :ivar score: The matching score between the provided resume and job description.
    :vartype score: float
    :ivar details:
    :vartype details: ~affinda.models.ResumeSearchMatchDetails
    """

    _validation = {
        "score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "score": {"key": "score", "type": "float"},
        "details": {"key": "details", "type": "ResumeSearchMatchDetails"},
    }

    def __init__(
        self,
        *,
        score: Optional[float] = None,
        details: Optional["_models.ResumeSearchMatchDetails"] = None,
        **kwargs,
    ):
        """
        :keyword score: The matching score between the provided resume and job description.
        :paramtype score: float
        :keyword details:
        :paramtype details: ~affinda.models.ResumeSearchMatchDetails
        """
        super(ResumeSearchMatch, self).__init__(**kwargs)
        self.score = score
        self.details = details


class ResumeSearchMatchDetails(msrest.serialization.Model):
    """ResumeSearchMatchDetails.

    :ivar job_title:
    :vartype job_title: ~affinda.models.JobTitleSearchScoreComponent
    :ivar management_level:
    :vartype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
    :ivar experience:
    :vartype experience: ~affinda.models.ExperienceSearchScoreComponent
    :ivar skills:
    :vartype skills: ~affinda.models.SkillsSearchScoreComponent
    :ivar languages:
    :vartype languages: ~affinda.models.LanguagesSearchScoreComponent
    :ivar location:
    :vartype location: ~affinda.models.LocationSearchScoreComponent
    :ivar education:
    :vartype education: ~affinda.models.EducationSearchScoreComponent
    :ivar occupation_group:
    :vartype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
    :ivar search_expression:
    :vartype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
    """

    _attribute_map = {
        "job_title": {"key": "jobTitle", "type": "JobTitleSearchScoreComponent"},
        "management_level": {
            "key": "managementLevel",
            "type": "ManagementLevelSearchScoreComponent",
        },
        "experience": {"key": "experience", "type": "ExperienceSearchScoreComponent"},
        "skills": {"key": "skills", "type": "SkillsSearchScoreComponent"},
        "languages": {"key": "languages", "type": "LanguagesSearchScoreComponent"},
        "location": {"key": "location", "type": "LocationSearchScoreComponent"},
        "education": {"key": "education", "type": "EducationSearchScoreComponent"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "OccupationGroupSearchScoreComponent",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "SearchExpressionSearchScoreComponent",
        },
    }

    def __init__(
        self,
        *,
        job_title: Optional["_models.JobTitleSearchScoreComponent"] = None,
        management_level: Optional["_models.ManagementLevelSearchScoreComponent"] = None,
        experience: Optional["_models.ExperienceSearchScoreComponent"] = None,
        skills: Optional["_models.SkillsSearchScoreComponent"] = None,
        languages: Optional["_models.LanguagesSearchScoreComponent"] = None,
        location: Optional["_models.LocationSearchScoreComponent"] = None,
        education: Optional["_models.EducationSearchScoreComponent"] = None,
        occupation_group: Optional["_models.OccupationGroupSearchScoreComponent"] = None,
        search_expression: Optional["_models.SearchExpressionSearchScoreComponent"] = None,
        **kwargs,
    ):
        """
        :keyword job_title:
        :paramtype job_title: ~affinda.models.JobTitleSearchScoreComponent
        :keyword management_level:
        :paramtype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
        :keyword experience:
        :paramtype experience: ~affinda.models.ExperienceSearchScoreComponent
        :keyword skills:
        :paramtype skills: ~affinda.models.SkillsSearchScoreComponent
        :keyword languages:
        :paramtype languages: ~affinda.models.LanguagesSearchScoreComponent
        :keyword location:
        :paramtype location: ~affinda.models.LocationSearchScoreComponent
        :keyword education:
        :paramtype education: ~affinda.models.EducationSearchScoreComponent
        :keyword occupation_group:
        :paramtype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
        :keyword search_expression:
        :paramtype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
        """
        super(ResumeSearchMatchDetails, self).__init__(**kwargs)
        self.job_title = job_title
        self.management_level = management_level
        self.experience = experience
        self.skills = skills
        self.languages = languages
        self.location = location
        self.education = education
        self.occupation_group = occupation_group
        self.search_expression = search_expression


class ResumeSearchParameters(msrest.serialization.Model):
    """ResumeSearchParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar indices: Required.
    :vartype indices: list[str]
    :ivar job_description: A random string that uniquely identify the resource.
    :vartype job_description: str
    :ivar resume: A random string that uniquely identify the resource.
    :vartype resume: str
    :ivar job_titles:
    :vartype job_titles: list[str]
    :ivar job_titles_current_only: Search only through the canditate's current job.
    :vartype job_titles_current_only: bool
    :ivar job_titles_required:
    :vartype job_titles_required: bool
    :ivar job_titles_weight:
    :vartype job_titles_weight: float
    :ivar years_experience_min: Minimum years of total work experience.
    :vartype years_experience_min: int
    :ivar years_experience_max: Maximum years of total work experience.
    :vartype years_experience_max: int
    :ivar years_experience_required:
    :vartype years_experience_required: bool
    :ivar years_experience_weight:
    :vartype years_experience_weight: float
    :ivar locations: Search by location name or by coordinates.
    :vartype locations: list[~affinda.models.ResumeSearchParametersLocation]
    :ivar locations_weight:
    :vartype locations_weight: float
    :ivar locations_required:
    :vartype locations_required: bool
    :ivar skills:
    :vartype skills: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar skills_weight:
    :vartype skills_weight: float
    :ivar languages:
    :vartype languages: list[~affinda.models.ResumeSearchParametersSkill]
    :ivar languages_weight:
    :vartype languages_weight: float
    :ivar institutions:
    :vartype institutions: list[str]
    :ivar institutions_required:
    :vartype institutions_required: bool
    :ivar degrees:
    :vartype degrees: list[str]
    :ivar degrees_required:
    :vartype degrees_required: bool
    :ivar highest_degree_types:
    :vartype highest_degree_types: list[str or ~affinda.models.EducationLevel]
    :ivar highest_degree_types_required:
    :vartype highest_degree_types_required: bool
    :ivar is_current_student: Search for student canditates.
    :vartype is_current_student: bool
    :ivar is_current_student_required:
    :vartype is_current_student_required: bool
    :ivar is_recent_graduate: Search for canditates that graduated less than a year ago.
    :vartype is_recent_graduate: bool
    :ivar is_recent_graduate_required:
    :vartype is_recent_graduate_required: bool
    :ivar education_weight:
    :vartype education_weight: float
    :ivar search_expression: Search through resumes' raw text.
    :vartype search_expression: str
    :ivar search_expression_required:
    :vartype search_expression_required: bool
    :ivar search_expression_weight:
    :vartype search_expression_weight: float
    :ivar soc_codes:
    :vartype soc_codes: list[int]
    :ivar soc_codes_weight:
    :vartype soc_codes_weight: float
    :ivar soc_codes_required:
    :vartype soc_codes_required: bool
    :ivar management_level: Known values are: "None", "Low", "Mid", "Upper".
    :vartype management_level: str or ~affinda.models.ManagementLevel
    :ivar management_level_required:
    :vartype management_level_required: bool
    :ivar management_level_weight:
    :vartype management_level_weight: float
    :ivar custom_data:
    :vartype custom_data: list[~affinda.models.ResumeSearchParametersCustomData]
    """

    _validation = {
        "indices": {"required": True},
        "job_titles_weight": {"maximum": 1, "minimum": 0},
        "years_experience_weight": {"maximum": 1, "minimum": 0},
        "locations_weight": {"maximum": 1, "minimum": 0},
        "skills_weight": {"maximum": 1, "minimum": 0},
        "languages_weight": {"maximum": 1, "minimum": 0},
        "highest_degree_types": {"unique": True},
        "education_weight": {"maximum": 1, "minimum": 0},
        "search_expression_weight": {"maximum": 1, "minimum": 0},
        "soc_codes_weight": {"maximum": 1, "minimum": 0},
        "management_level_weight": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "indices": {"key": "indices", "type": "[str]"},
        "job_description": {"key": "jobDescription", "type": "str"},
        "resume": {"key": "resume", "type": "str"},
        "job_titles": {"key": "jobTitles", "type": "[str]"},
        "job_titles_current_only": {"key": "jobTitlesCurrentOnly", "type": "bool"},
        "job_titles_required": {"key": "jobTitlesRequired", "type": "bool"},
        "job_titles_weight": {"key": "jobTitlesWeight", "type": "float"},
        "years_experience_min": {"key": "yearsExperienceMin", "type": "int"},
        "years_experience_max": {"key": "yearsExperienceMax", "type": "int"},
        "years_experience_required": {"key": "yearsExperienceRequired", "type": "bool"},
        "years_experience_weight": {"key": "yearsExperienceWeight", "type": "float"},
        "locations": {"key": "locations", "type": "[ResumeSearchParametersLocation]"},
        "locations_weight": {"key": "locationsWeight", "type": "float"},
        "locations_required": {"key": "locationsRequired", "type": "bool"},
        "skills": {"key": "skills", "type": "[ResumeSearchParametersSkill]"},
        "skills_weight": {"key": "skillsWeight", "type": "float"},
        "languages": {"key": "languages", "type": "[ResumeSearchParametersSkill]"},
        "languages_weight": {"key": "languagesWeight", "type": "float"},
        "institutions": {"key": "institutions", "type": "[str]"},
        "institutions_required": {"key": "institutionsRequired", "type": "bool"},
        "degrees": {"key": "degrees", "type": "[str]"},
        "degrees_required": {"key": "degreesRequired", "type": "bool"},
        "highest_degree_types": {"key": "highestDegreeTypes", "type": "[str]"},
        "highest_degree_types_required": {"key": "highestDegreeTypesRequired", "type": "bool"},
        "is_current_student": {"key": "isCurrentStudent", "type": "bool"},
        "is_current_student_required": {"key": "isCurrentStudentRequired", "type": "bool"},
        "is_recent_graduate": {"key": "isRecentGraduate", "type": "bool"},
        "is_recent_graduate_required": {"key": "isRecentGraduateRequired", "type": "bool"},
        "education_weight": {"key": "educationWeight", "type": "float"},
        "search_expression": {"key": "searchExpression", "type": "str"},
        "search_expression_required": {"key": "searchExpressionRequired", "type": "bool"},
        "search_expression_weight": {"key": "searchExpressionWeight", "type": "float"},
        "soc_codes": {"key": "socCodes", "type": "[int]"},
        "soc_codes_weight": {"key": "socCodesWeight", "type": "float"},
        "soc_codes_required": {"key": "socCodesRequired", "type": "bool"},
        "management_level": {"key": "managementLevel", "type": "str"},
        "management_level_required": {"key": "managementLevelRequired", "type": "bool"},
        "management_level_weight": {"key": "managementLevelWeight", "type": "float"},
        "custom_data": {"key": "customData", "type": "[ResumeSearchParametersCustomData]"},
    }

    def __init__(
        self,
        *,
        indices: List[str],
        job_description: Optional[str] = None,
        resume: Optional[str] = None,
        job_titles: Optional[List[str]] = None,
        job_titles_current_only: Optional[bool] = None,
        job_titles_required: Optional[bool] = None,
        job_titles_weight: Optional[float] = None,
        years_experience_min: Optional[int] = None,
        years_experience_max: Optional[int] = None,
        years_experience_required: Optional[bool] = None,
        years_experience_weight: Optional[float] = None,
        locations: Optional[List["_models.ResumeSearchParametersLocation"]] = None,
        locations_weight: Optional[float] = None,
        locations_required: Optional[bool] = None,
        skills: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        skills_weight: Optional[float] = None,
        languages: Optional[List["_models.ResumeSearchParametersSkill"]] = None,
        languages_weight: Optional[float] = None,
        institutions: Optional[List[str]] = None,
        institutions_required: Optional[bool] = None,
        degrees: Optional[List[str]] = None,
        degrees_required: Optional[bool] = None,
        highest_degree_types: Optional[List[Union[str, "_models.EducationLevel"]]] = None,
        highest_degree_types_required: Optional[bool] = None,
        is_current_student: Optional[bool] = None,
        is_current_student_required: Optional[bool] = None,
        is_recent_graduate: Optional[bool] = None,
        is_recent_graduate_required: Optional[bool] = None,
        education_weight: Optional[float] = None,
        search_expression: Optional[str] = None,
        search_expression_required: Optional[bool] = None,
        search_expression_weight: Optional[float] = None,
        soc_codes: Optional[List[int]] = None,
        soc_codes_weight: Optional[float] = None,
        soc_codes_required: Optional[bool] = None,
        management_level: Optional[Union[str, "_models.ManagementLevel"]] = None,
        management_level_required: Optional[bool] = None,
        management_level_weight: Optional[float] = None,
        custom_data: Optional[List["_models.ResumeSearchParametersCustomData"]] = None,
        **kwargs,
    ):
        """
        :keyword indices: Required.
        :paramtype indices: list[str]
        :keyword job_description: A random string that uniquely identify the resource.
        :paramtype job_description: str
        :keyword resume: A random string that uniquely identify the resource.
        :paramtype resume: str
        :keyword job_titles:
        :paramtype job_titles: list[str]
        :keyword job_titles_current_only: Search only through the canditate's current job.
        :paramtype job_titles_current_only: bool
        :keyword job_titles_required:
        :paramtype job_titles_required: bool
        :keyword job_titles_weight:
        :paramtype job_titles_weight: float
        :keyword years_experience_min: Minimum years of total work experience.
        :paramtype years_experience_min: int
        :keyword years_experience_max: Maximum years of total work experience.
        :paramtype years_experience_max: int
        :keyword years_experience_required:
        :paramtype years_experience_required: bool
        :keyword years_experience_weight:
        :paramtype years_experience_weight: float
        :keyword locations: Search by location name or by coordinates.
        :paramtype locations: list[~affinda.models.ResumeSearchParametersLocation]
        :keyword locations_weight:
        :paramtype locations_weight: float
        :keyword locations_required:
        :paramtype locations_required: bool
        :keyword skills:
        :paramtype skills: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword skills_weight:
        :paramtype skills_weight: float
        :keyword languages:
        :paramtype languages: list[~affinda.models.ResumeSearchParametersSkill]
        :keyword languages_weight:
        :paramtype languages_weight: float
        :keyword institutions:
        :paramtype institutions: list[str]
        :keyword institutions_required:
        :paramtype institutions_required: bool
        :keyword degrees:
        :paramtype degrees: list[str]
        :keyword degrees_required:
        :paramtype degrees_required: bool
        :keyword highest_degree_types:
        :paramtype highest_degree_types: list[str or ~affinda.models.EducationLevel]
        :keyword highest_degree_types_required:
        :paramtype highest_degree_types_required: bool
        :keyword is_current_student: Search for student canditates.
        :paramtype is_current_student: bool
        :keyword is_current_student_required:
        :paramtype is_current_student_required: bool
        :keyword is_recent_graduate: Search for canditates that graduated less than a year ago.
        :paramtype is_recent_graduate: bool
        :keyword is_recent_graduate_required:
        :paramtype is_recent_graduate_required: bool
        :keyword education_weight:
        :paramtype education_weight: float
        :keyword search_expression: Search through resumes' raw text.
        :paramtype search_expression: str
        :keyword search_expression_required:
        :paramtype search_expression_required: bool
        :keyword search_expression_weight:
        :paramtype search_expression_weight: float
        :keyword soc_codes:
        :paramtype soc_codes: list[int]
        :keyword soc_codes_weight:
        :paramtype soc_codes_weight: float
        :keyword soc_codes_required:
        :paramtype soc_codes_required: bool
        :keyword management_level: Known values are: "None", "Low", "Mid", "Upper".
        :paramtype management_level: str or ~affinda.models.ManagementLevel
        :keyword management_level_required:
        :paramtype management_level_required: bool
        :keyword management_level_weight:
        :paramtype management_level_weight: float
        :keyword custom_data:
        :paramtype custom_data: list[~affinda.models.ResumeSearchParametersCustomData]
        """
        super(ResumeSearchParameters, self).__init__(**kwargs)
        self.indices = indices
        self.job_description = job_description
        self.resume = resume
        self.job_titles = job_titles
        self.job_titles_current_only = job_titles_current_only
        self.job_titles_required = job_titles_required
        self.job_titles_weight = job_titles_weight
        self.years_experience_min = years_experience_min
        self.years_experience_max = years_experience_max
        self.years_experience_required = years_experience_required
        self.years_experience_weight = years_experience_weight
        self.locations = locations
        self.locations_weight = locations_weight
        self.locations_required = locations_required
        self.skills = skills
        self.skills_weight = skills_weight
        self.languages = languages
        self.languages_weight = languages_weight
        self.institutions = institutions
        self.institutions_required = institutions_required
        self.degrees = degrees
        self.degrees_required = degrees_required
        self.highest_degree_types = highest_degree_types
        self.highest_degree_types_required = highest_degree_types_required
        self.is_current_student = is_current_student
        self.is_current_student_required = is_current_student_required
        self.is_recent_graduate = is_recent_graduate
        self.is_recent_graduate_required = is_recent_graduate_required
        self.education_weight = education_weight
        self.search_expression = search_expression
        self.search_expression_required = search_expression_required
        self.search_expression_weight = search_expression_weight
        self.soc_codes = soc_codes
        self.soc_codes_weight = soc_codes_weight
        self.soc_codes_required = soc_codes_required
        self.management_level = management_level
        self.management_level_required = management_level_required
        self.management_level_weight = management_level_weight
        self.custom_data = custom_data


class ResumeSearchParametersCustomData(msrest.serialization.Model):
    """ResumeSearchParametersCustomData.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: Required. Known values are: "equals", "range".
    :vartype filter_type: str or ~affinda.models.ResumeSearchParametersCustomDataFilterType
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar query: Required. "equals" searches require the "value" key inside the query, and "range"
     searches require at least one of "gte" (greater than or equal) and "lte" (less than or equal).
    :vartype query: any
    :ivar required:
    :vartype required: bool
    :ivar weight:
    :vartype weight: float
    """

    _validation = {
        "filter_type": {"required": True},
        "data_point": {"required": True},
        "query": {"required": True},
        "weight": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "filter_type": {"key": "filterType", "type": "str"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "query": {"key": "query", "type": "object"},
        "required": {"key": "required", "type": "bool"},
        "weight": {"key": "weight", "type": "float"},
    }

    def __init__(
        self,
        *,
        filter_type: Union[str, "_models.ResumeSearchParametersCustomDataFilterType"],
        data_point: str,
        query: Any,
        required: Optional[bool] = None,
        weight: Optional[float] = None,
        **kwargs,
    ):
        """
        :keyword filter_type: Required. Known values are: "equals", "range".
        :paramtype filter_type: str or ~affinda.models.ResumeSearchParametersCustomDataFilterType
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword query: Required. "equals" searches require the "value" key inside the query, and
         "range" searches require at least one of "gte" (greater than or equal) and "lte" (less than or
         equal).
        :paramtype query: any
        :keyword required:
        :paramtype required: bool
        :keyword weight:
        :paramtype weight: float
        """
        super(ResumeSearchParametersCustomData, self).__init__(**kwargs)
        self.filter_type = filter_type
        self.data_point = data_point
        self.query = query
        self.required = required
        self.weight = weight


class ResumeSearchParametersLocation(msrest.serialization.Model):
    """ResumeSearchParametersLocation.

    :ivar name:
    :vartype name: str
    :ivar coordinates:
    :vartype coordinates: ~affinda.models.ResumeSearchParametersLocationCoordinates
    :ivar distance:
    :vartype distance: int
    :ivar unit: Known values are: "km", "mi". Default value: "km".
    :vartype unit: str or ~affinda.models.SearchLocationUnit
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "coordinates": {"key": "coordinates", "type": "ResumeSearchParametersLocationCoordinates"},
        "distance": {"key": "distance", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = "",
        coordinates: Optional["_models.ResumeSearchParametersLocationCoordinates"] = None,
        distance: Optional[int] = 100,
        unit: Optional[Union[str, "_models.SearchLocationUnit"]] = "km",
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword coordinates:
        :paramtype coordinates: ~affinda.models.ResumeSearchParametersLocationCoordinates
        :keyword distance:
        :paramtype distance: int
        :keyword unit: Known values are: "km", "mi". Default value: "km".
        :paramtype unit: str or ~affinda.models.SearchLocationUnit
        """
        super(ResumeSearchParametersLocation, self).__init__(**kwargs)
        self.name = name
        self.coordinates = coordinates
        self.distance = distance
        self.unit = unit


class ResumeSearchParametersLocationCoordinates(msrest.serialization.Model):
    """ResumeSearchParametersLocationCoordinates.

    :ivar latitude:
    :vartype latitude: float
    :ivar longitude:
    :vartype longitude: float
    """

    _attribute_map = {
        "latitude": {"key": "latitude", "type": "float"},
        "longitude": {"key": "longitude", "type": "float"},
    }

    def __init__(
        self, *, latitude: Optional[float] = None, longitude: Optional[float] = None, **kwargs
    ):
        """
        :keyword latitude:
        :paramtype latitude: float
        :keyword longitude:
        :paramtype longitude: float
        """
        super(ResumeSearchParametersLocationCoordinates, self).__init__(**kwargs)
        self.latitude = latitude
        self.longitude = longitude


class ResumeSearchParametersSkill(msrest.serialization.Model):
    """ResumeSearchParametersSkill.

    :ivar name:
    :vartype name: str
    :ivar required:
    :vartype required: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "required": {"key": "required", "type": "bool"},
    }

    def __init__(self, *, name: Optional[str] = None, required: Optional[bool] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword required:
        :paramtype required: bool
        """
        super(ResumeSearchParametersSkill, self).__init__(**kwargs)
        self.name = name
        self.required = required


class ResumeSearchResult(msrest.serialization.Model):
    """ResumeSearchResult.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. A random string that uniquely identify the resource.
    :vartype identifier: str
    :ivar score: Required.
    :vartype score: float
    :ivar pdf: Required.
    :vartype pdf: str
    :ivar name:
    :vartype name: str
    :ivar job_title: Required.
    :vartype job_title: ~affinda.models.JobTitleSearchScoreComponent
    :ivar management_level: Required.
    :vartype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
    :ivar experience: Required.
    :vartype experience: ~affinda.models.ExperienceSearchScoreComponent
    :ivar skills: Required.
    :vartype skills: ~affinda.models.SkillsSearchScoreComponent
    :ivar languages: Required.
    :vartype languages: ~affinda.models.LanguagesSearchScoreComponent
    :ivar location: Required.
    :vartype location: ~affinda.models.LocationSearchScoreComponent
    :ivar education: Required.
    :vartype education: ~affinda.models.EducationSearchScoreComponent
    :ivar occupation_group: Required.
    :vartype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
    :ivar search_expression: Required.
    :vartype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
    :ivar custom_data: Required. Dictionary of
     <components·nqbw24·schemas·customdatasearchscorecomponent·additionalproperties>.
    :vartype custom_data: dict[str,
     ~affinda.models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties]
    """

    _validation = {
        "identifier": {"required": True},
        "score": {"required": True},
        "pdf": {"required": True},
        "job_title": {"required": True},
        "management_level": {"required": True},
        "experience": {"required": True},
        "skills": {"required": True},
        "languages": {"required": True},
        "location": {"required": True},
        "education": {"required": True},
        "occupation_group": {"required": True},
        "search_expression": {"required": True},
        "custom_data": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "score": {"key": "score", "type": "float"},
        "pdf": {"key": "pdf", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "job_title": {"key": "jobTitle", "type": "JobTitleSearchScoreComponent"},
        "management_level": {
            "key": "managementLevel",
            "type": "ManagementLevelSearchScoreComponent",
        },
        "experience": {"key": "experience", "type": "ExperienceSearchScoreComponent"},
        "skills": {"key": "skills", "type": "SkillsSearchScoreComponent"},
        "languages": {"key": "languages", "type": "LanguagesSearchScoreComponent"},
        "location": {"key": "location", "type": "LocationSearchScoreComponent"},
        "education": {"key": "education", "type": "EducationSearchScoreComponent"},
        "occupation_group": {
            "key": "occupationGroup",
            "type": "OccupationGroupSearchScoreComponent",
        },
        "search_expression": {
            "key": "searchExpression",
            "type": "SearchExpressionSearchScoreComponent",
        },
        "custom_data": {
            "key": "customData",
            "type": "{ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties}",
        },
    }

    def __init__(
        self,
        *,
        identifier: str,
        score: float,
        pdf: str,
        job_title: "_models.JobTitleSearchScoreComponent",
        management_level: "_models.ManagementLevelSearchScoreComponent",
        experience: "_models.ExperienceSearchScoreComponent",
        skills: "_models.SkillsSearchScoreComponent",
        languages: "_models.LanguagesSearchScoreComponent",
        location: "_models.LocationSearchScoreComponent",
        education: "_models.EducationSearchScoreComponent",
        occupation_group: "_models.OccupationGroupSearchScoreComponent",
        search_expression: "_models.SearchExpressionSearchScoreComponent",
        custom_data: Dict[
            str,
            "_models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties",
        ],
        name: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. A random string that uniquely identify the resource.
        :paramtype identifier: str
        :keyword score: Required.
        :paramtype score: float
        :keyword pdf: Required.
        :paramtype pdf: str
        :keyword name:
        :paramtype name: str
        :keyword job_title: Required.
        :paramtype job_title: ~affinda.models.JobTitleSearchScoreComponent
        :keyword management_level: Required.
        :paramtype management_level: ~affinda.models.ManagementLevelSearchScoreComponent
        :keyword experience: Required.
        :paramtype experience: ~affinda.models.ExperienceSearchScoreComponent
        :keyword skills: Required.
        :paramtype skills: ~affinda.models.SkillsSearchScoreComponent
        :keyword languages: Required.
        :paramtype languages: ~affinda.models.LanguagesSearchScoreComponent
        :keyword location: Required.
        :paramtype location: ~affinda.models.LocationSearchScoreComponent
        :keyword education: Required.
        :paramtype education: ~affinda.models.EducationSearchScoreComponent
        :keyword occupation_group: Required.
        :paramtype occupation_group: ~affinda.models.OccupationGroupSearchScoreComponent
        :keyword search_expression: Required.
        :paramtype search_expression: ~affinda.models.SearchExpressionSearchScoreComponent
        :keyword custom_data: Required. Dictionary of
         <components·nqbw24·schemas·customdatasearchscorecomponent·additionalproperties>.
        :paramtype custom_data: dict[str,
         ~affinda.models.ComponentsNqbw24SchemasCustomdatasearchscorecomponentAdditionalproperties]
        """
        super(ResumeSearchResult, self).__init__(**kwargs)
        self.identifier = identifier
        self.score = score
        self.pdf = pdf
        self.name = name
        self.job_title = job_title
        self.management_level = management_level
        self.experience = experience
        self.skills = skills
        self.languages = languages
        self.location = location
        self.education = education
        self.occupation_group = occupation_group
        self.search_expression = search_expression
        self.custom_data = custom_data


class ResumeSkillSourcesItem(msrest.serialization.Model):
    """ResumeSkillSourcesItem.

    :ivar section: Known values are: "Achievements", "AdditionalInformation", "Education",
     "Extracurriculars", "Organisations", "Other", "PersonalDetails", "Projects", "Publications",
     "Referees", "Skills", "Summary", "Training", "WorkExperience", "NotPopulated", "Header",
     "Footer".
    :vartype section: str or ~affinda.models.ResumeSkillSourcesItemSection
    :ivar position:
    :vartype position: int
    """

    _attribute_map = {
        "section": {"key": "section", "type": "str"},
        "position": {"key": "position", "type": "int"},
    }

    def __init__(
        self,
        *,
        section: Optional[Union[str, "_models.ResumeSkillSourcesItemSection"]] = None,
        position: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword section: Known values are: "Achievements", "AdditionalInformation", "Education",
         "Extracurriculars", "Organisations", "Other", "PersonalDetails", "Projects", "Publications",
         "Referees", "Skills", "Summary", "Training", "WorkExperience", "NotPopulated", "Header",
         "Footer".
        :paramtype section: str or ~affinda.models.ResumeSkillSourcesItemSection
        :keyword position:
        :paramtype position: int
        """
        super(ResumeSkillSourcesItem, self).__init__(**kwargs)
        self.section = section
        self.position = position


class RowAnnotation(msrest.serialization.Model):
    """RowAnnotation.

    :ivar code:
    :vartype code: str
    :ivar date:
    :vartype date: str
    :ivar description:
    :vartype description: str
    :ivar unit:
    :vartype unit: str
    :ivar unit_price:
    :vartype unit_price: float
    :ivar quantity:
    :vartype quantity: float
    :ivar discount:
    :vartype discount: str
    :ivar base_total:
    :vartype base_total: float
    :ivar tax_rate:
    :vartype tax_rate: str
    :ivar tax_total:
    :vartype tax_total: float
    :ivar total:
    :vartype total: float
    :ivar other:
    :vartype other: str
    :ivar custom_fields: Dictionary of :code:`<any>`.
    :vartype custom_fields: dict[str, any]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "date": {"key": "date", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "unit_price": {"key": "unitPrice", "type": "float"},
        "quantity": {"key": "quantity", "type": "float"},
        "discount": {"key": "discount", "type": "str"},
        "base_total": {"key": "baseTotal", "type": "float"},
        "tax_rate": {"key": "taxRate", "type": "str"},
        "tax_total": {"key": "taxTotal", "type": "float"},
        "total": {"key": "total", "type": "float"},
        "other": {"key": "other", "type": "str"},
        "custom_fields": {"key": "customFields", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        date: Optional[str] = None,
        description: Optional[str] = None,
        unit: Optional[str] = None,
        unit_price: Optional[float] = None,
        quantity: Optional[float] = None,
        discount: Optional[str] = None,
        base_total: Optional[float] = None,
        tax_rate: Optional[str] = None,
        tax_total: Optional[float] = None,
        total: Optional[float] = None,
        other: Optional[str] = None,
        custom_fields: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        """
        :keyword code:
        :paramtype code: str
        :keyword date:
        :paramtype date: str
        :keyword description:
        :paramtype description: str
        :keyword unit:
        :paramtype unit: str
        :keyword unit_price:
        :paramtype unit_price: float
        :keyword quantity:
        :paramtype quantity: float
        :keyword discount:
        :paramtype discount: str
        :keyword base_total:
        :paramtype base_total: float
        :keyword tax_rate:
        :paramtype tax_rate: str
        :keyword tax_total:
        :paramtype tax_total: float
        :keyword total:
        :paramtype total: float
        :keyword other:
        :paramtype other: str
        :keyword custom_fields: Dictionary of :code:`<any>`.
        :paramtype custom_fields: dict[str, any]
        """
        super(RowAnnotation, self).__init__(**kwargs)
        self.code = code
        self.date = date
        self.description = description
        self.unit = unit
        self.unit_price = unit_price
        self.quantity = quantity
        self.discount = discount
        self.base_total = base_total
        self.tax_rate = tax_rate
        self.tax_total = tax_total
        self.total = total
        self.other = other
        self.custom_fields = custom_fields


class SearchExpressionSearchScoreComponent(msrest.serialization.Model):
    """SearchExpressionSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar label: Required.
    :vartype label: str
    :ivar value:
    :vartype value: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword label: Required.
        :paramtype label: str
        :keyword value:
        :paramtype value: str
        :keyword score:
        :paramtype score: float
        """
        super(SearchExpressionSearchScoreComponent, self).__init__(**kwargs)
        self.label = label
        self.value = value
        self.score = score


class SkillAnnotation(Annotation):
    """SkillAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed:
    :vartype parsed: str
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed:
        :paramtype parsed: str
        """
        super(SkillAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class SkillsSearchScoreComponent(msrest.serialization.Model):
    """SkillsSearchScoreComponent.

    All required parameters must be populated in order to send to Azure.

    :ivar value:
    :vartype value: str
    :ivar label: Required.
    :vartype label: str
    :ivar score:
    :vartype score: float
    """

    _validation = {
        "label": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self, *, label: str, value: Optional[str] = None, score: Optional[float] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: str
        :keyword label: Required.
        :paramtype label: str
        :keyword score:
        :paramtype score: float
        """
        super(SkillsSearchScoreComponent, self).__init__(**kwargs)
        self.value = value
        self.label = label
        self.score = score


class Tag(msrest.serialization.Model):
    """Tag.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Uniquely identify a tag.
    :vartype id: int
    :ivar name: Required.
    :vartype name: str
    :ivar workspace: Required. Uniquely identify a workspace.
    :vartype workspace: str
    :ivar document_count: Required. Number of documents tagged with this.
    :vartype document_count: int
    """

    _validation = {
        "id": {"required": True},
        "name": {"required": True},
        "workspace": {"required": True},
        "document_count": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "document_count": {"key": "documentCount", "type": "int"},
    }

    def __init__(self, *, id: int, name: str, workspace: str, document_count: int, **kwargs):
        """
        :keyword id: Required. Uniquely identify a tag.
        :paramtype id: int
        :keyword name: Required.
        :paramtype name: str
        :keyword workspace: Required. Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword document_count: Required. Number of documents tagged with this.
        :paramtype document_count: int
        """
        super(Tag, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.workspace = workspace
        self.document_count = document_count


class TagCreate(msrest.serialization.Model):
    """TagCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar workspace: Required. Uniquely identify a workspace.
    :vartype workspace: str
    """

    _validation = {
        "name": {"required": True},
        "workspace": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
    }

    def __init__(self, *, name: str, workspace: str, **kwargs):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword workspace: Required. Uniquely identify a workspace.
        :paramtype workspace: str
        """
        super(TagCreate, self).__init__(**kwargs)
        self.name = name
        self.workspace = workspace


class TagUpdate(msrest.serialization.Model):
    """TagUpdate.

    :ivar name:
    :vartype name: str
    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, workspace: Optional[str] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        """
        super(TagUpdate, self).__init__(**kwargs)
        self.name = name
        self.workspace = workspace


class UserCreateRequest(msrest.serialization.Model):
    """UserCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar name:
    :vartype name: str
    :ivar username: Required.
    :vartype username: str
    :ivar email: Required.
    :vartype email: str
    :ivar avatar: Upload avatar for the user.
    :vartype avatar: IO
    """

    _validation = {
        "username": {"required": True},
        "email": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "IO"},
    }

    def __init__(
        self,
        *,
        username: str,
        email: str,
        name: Optional[str] = None,
        avatar: Optional[IO] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword username: Required.
        :paramtype username: str
        :keyword email: Required.
        :paramtype email: str
        :keyword avatar: Upload avatar for the user.
        :paramtype avatar: IO
        """
        super(UserCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.username = username
        self.email = email
        self.avatar = avatar


class UserCreateResponse(User):
    """UserCreateResponse.

    :ivar id: Uniquely identify a user.
    :vartype id: int
    :ivar name:
    :vartype name: str
    :ivar username:
    :vartype username: str
    :ivar email:
    :vartype email: str
    :ivar avatar: URL of the user's avatar.
    :vartype avatar: str
    :ivar api_key: API key used to authenticate for future requests. This key is only retrievable
     at the initial creation of the user.
    :vartype api_key: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "avatar": {"key": "avatar", "type": "str"},
        "api_key": {"key": "apiKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        username: Optional[str] = None,
        email: Optional[str] = None,
        avatar: Optional[str] = None,
        api_key: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Uniquely identify a user.
        :paramtype id: int
        :keyword name:
        :paramtype name: str
        :keyword username:
        :paramtype username: str
        :keyword email:
        :paramtype email: str
        :keyword avatar: URL of the user's avatar.
        :paramtype avatar: str
        :keyword api_key: API key used to authenticate for future requests. This key is only
         retrievable at the initial creation of the user.
        :paramtype api_key: str
        """
        super(UserCreateResponse, self).__init__(
            id=id, name=name, username=username, email=email, avatar=avatar, **kwargs
        )
        self.api_key = api_key


class Workspace(msrest.serialization.Model):
    """Workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a workspace.
    :vartype identifier: str
    :ivar organization:
    :vartype organization: ~affinda.models.Organization
    :ivar name:
    :vartype name: str
    :ivar visibility: Visibility "organization" means everyone in the organization can access the
     workspace. Visibility "private" means only people explicitly added can access the workspace.
     Known values are: "organization", "private".
    :vartype visibility: str or ~affinda.models.WorkspaceVisibility
    :ivar collections:
    :vartype collections: list[~affinda.models.WorkspaceCollectionsItem]
    :ivar reject_invalid_documents: If true, the uploaded document will be rejected if it's of the
     wrong document type, or if its document type cannot be determined. No credits will be consumed.
    :vartype reject_invalid_documents: bool
    :ivar members:
    :vartype members: list[~affinda.models.User]
    :ivar unvalidated_docs_count: Number of unvalidated documents in the workspace.
    :vartype unvalidated_docs_count: int
    :ivar confirmed_docs_count: Number of validated documents in the workspace.
    :vartype confirmed_docs_count: int
    """

    _validation = {
        "identifier": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "organization": {"key": "organization", "type": "Organization"},
        "name": {"key": "name", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "collections": {"key": "collections", "type": "[WorkspaceCollectionsItem]"},
        "reject_invalid_documents": {"key": "rejectInvalidDocuments", "type": "bool"},
        "members": {"key": "members", "type": "[User]"},
        "unvalidated_docs_count": {"key": "unvalidatedDocsCount", "type": "int"},
        "confirmed_docs_count": {"key": "confirmedDocsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        organization: Optional["_models.Organization"] = None,
        name: Optional[str] = None,
        visibility: Optional[Union[str, "_models.WorkspaceVisibility"]] = None,
        collections: Optional[List["_models.WorkspaceCollectionsItem"]] = None,
        reject_invalid_documents: Optional[bool] = None,
        members: Optional[List["_models.User"]] = None,
        unvalidated_docs_count: Optional[int] = None,
        confirmed_docs_count: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a workspace.
        :paramtype identifier: str
        :keyword organization:
        :paramtype organization: ~affinda.models.Organization
        :keyword name:
        :paramtype name: str
        :keyword visibility: Visibility "organization" means everyone in the organization can access
         the workspace. Visibility "private" means only people explicitly added can access the
         workspace. Known values are: "organization", "private".
        :paramtype visibility: str or ~affinda.models.WorkspaceVisibility
        :keyword collections:
        :paramtype collections: list[~affinda.models.WorkspaceCollectionsItem]
        :keyword reject_invalid_documents: If true, the uploaded document will be rejected if it's of
         the wrong document type, or if its document type cannot be determined. No credits will be
         consumed.
        :paramtype reject_invalid_documents: bool
        :keyword members:
        :paramtype members: list[~affinda.models.User]
        :keyword unvalidated_docs_count: Number of unvalidated documents in the workspace.
        :paramtype unvalidated_docs_count: int
        :keyword confirmed_docs_count: Number of validated documents in the workspace.
        :paramtype confirmed_docs_count: int
        """
        super(Workspace, self).__init__(**kwargs)
        self.identifier = identifier
        self.organization = organization
        self.name = name
        self.visibility = visibility
        self.collections = collections
        self.reject_invalid_documents = reject_invalid_documents
        self.members = members
        self.unvalidated_docs_count = unvalidated_docs_count
        self.confirmed_docs_count = confirmed_docs_count


class WorkspaceCollectionsItem(msrest.serialization.Model):
    """WorkspaceCollectionsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar identifier: Required. Uniquely identify a collection.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar extractor: Required.
    :vartype extractor: ~affinda.models.WorkspaceCollectionsItemExtractor
    :ivar unvalidated_docs_count: Number of unvalidated documents in the collection.
    :vartype unvalidated_docs_count: int
    :ivar confirmed_docs_count: Number of validated documents in the collection.
    :vartype confirmed_docs_count: int
    """

    _validation = {
        "identifier": {"required": True},
        "name": {"required": True},
        "extractor": {"required": True},
    }

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "extractor": {"key": "extractor", "type": "WorkspaceCollectionsItemExtractor"},
        "unvalidated_docs_count": {"key": "unvalidatedDocsCount", "type": "int"},
        "confirmed_docs_count": {"key": "confirmedDocsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        identifier: str,
        name: str,
        extractor: "_models.WorkspaceCollectionsItemExtractor",
        unvalidated_docs_count: Optional[int] = None,
        confirmed_docs_count: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Required. Uniquely identify a collection.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword extractor: Required.
        :paramtype extractor: ~affinda.models.WorkspaceCollectionsItemExtractor
        :keyword unvalidated_docs_count: Number of unvalidated documents in the collection.
        :paramtype unvalidated_docs_count: int
        :keyword confirmed_docs_count: Number of validated documents in the collection.
        :paramtype confirmed_docs_count: int
        """
        super(WorkspaceCollectionsItem, self).__init__(**kwargs)
        self.identifier = identifier
        self.name = name
        self.extractor = extractor
        self.unvalidated_docs_count = unvalidated_docs_count
        self.confirmed_docs_count = confirmed_docs_count


class WorkspaceCollectionsItemExtractor(msrest.serialization.Model):
    """WorkspaceCollectionsItemExtractor.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Extractor's ID.
    :vartype id: int
    :ivar identifier: Required.
    :vartype identifier: str
    :ivar name: Required.
    :vartype name: str
    :ivar name_plural: Required.
    :vartype name_plural: str
    :ivar base_extractor:
    :vartype base_extractor: ~affinda.models.BaseExtractor
    :ivar category:
    :vartype category: str
    :ivar validatable: Required.
    :vartype validatable: bool
    :ivar is_custom:
    :vartype is_custom: bool
    :ivar created_dt:
    :vartype created_dt: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "identifier": {"required": True},
        "name": {"required": True},
        "name_plural": {"required": True},
        "validatable": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "identifier": {"key": "identifier", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_plural": {"key": "namePlural", "type": "str"},
        "base_extractor": {"key": "baseExtractor", "type": "BaseExtractor"},
        "category": {"key": "category", "type": "str"},
        "validatable": {"key": "validatable", "type": "bool"},
        "is_custom": {"key": "isCustom", "type": "bool"},
        "created_dt": {"key": "createdDt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: int,
        identifier: str,
        name: str,
        name_plural: str,
        validatable: bool,
        base_extractor: Optional["_models.BaseExtractor"] = None,
        category: Optional[str] = None,
        is_custom: Optional[bool] = None,
        created_dt: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword id: Required. Extractor's ID.
        :paramtype id: int
        :keyword identifier: Required.
        :paramtype identifier: str
        :keyword name: Required.
        :paramtype name: str
        :keyword name_plural: Required.
        :paramtype name_plural: str
        :keyword base_extractor:
        :paramtype base_extractor: ~affinda.models.BaseExtractor
        :keyword category:
        :paramtype category: str
        :keyword validatable: Required.
        :paramtype validatable: bool
        :keyword is_custom:
        :paramtype is_custom: bool
        :keyword created_dt:
        :paramtype created_dt: ~datetime.datetime
        """
        super(WorkspaceCollectionsItemExtractor, self).__init__(**kwargs)
        self.id = id
        self.identifier = identifier
        self.name = name
        self.name_plural = name_plural
        self.base_extractor = base_extractor
        self.category = category
        self.validatable = validatable
        self.is_custom = is_custom
        self.created_dt = created_dt


class WorkspaceCreate(msrest.serialization.Model):
    """WorkspaceCreate.

    All required parameters must be populated in order to send to Azure.

    :ivar organization: Required. Uniquely identify an organization.
    :vartype organization: str
    :ivar name: Required.
    :vartype name: str
    :ivar visibility: Visibility "organization" means everyone in the organization can access the
     workspace. Visibility "private" means only people explicitly added can access the workspace.
     Known values are: "organization", "private".
    :vartype visibility: str or ~affinda.models.WorkspaceVisibility
    :ivar reject_invalid_documents: If true, the uploaded document will be rejected if it's of the
     wrong document type, or if its document type cannot be determined. No credits will be consumed.
    :vartype reject_invalid_documents: bool
    """

    _validation = {
        "organization": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "organization": {"key": "organization", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "reject_invalid_documents": {"key": "rejectInvalidDocuments", "type": "bool"},
    }

    def __init__(
        self,
        *,
        organization: str,
        name: str,
        visibility: Optional[Union[str, "_models.WorkspaceVisibility"]] = None,
        reject_invalid_documents: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword organization: Required. Uniquely identify an organization.
        :paramtype organization: str
        :keyword name: Required.
        :paramtype name: str
        :keyword visibility: Visibility "organization" means everyone in the organization can access
         the workspace. Visibility "private" means only people explicitly added can access the
         workspace. Known values are: "organization", "private".
        :paramtype visibility: str or ~affinda.models.WorkspaceVisibility
        :keyword reject_invalid_documents: If true, the uploaded document will be rejected if it's of
         the wrong document type, or if its document type cannot be determined. No credits will be
         consumed.
        :paramtype reject_invalid_documents: bool
        """
        super(WorkspaceCreate, self).__init__(**kwargs)
        self.organization = organization
        self.name = name
        self.visibility = visibility
        self.reject_invalid_documents = reject_invalid_documents


class WorkspaceMembership(msrest.serialization.Model):
    """WorkspaceMembership.

    :ivar identifier: Uniquely identify a membership.
    :vartype identifier: str
    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    :ivar user:
    :vartype user: ~affinda.models.User
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "user": {"key": "user", "type": "User"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        workspace: Optional[str] = None,
        user: Optional["_models.User"] = None,
        **kwargs,
    ):
        """
        :keyword identifier: Uniquely identify a membership.
        :paramtype identifier: str
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword user:
        :paramtype user: ~affinda.models.User
        """
        super(WorkspaceMembership, self).__init__(**kwargs)
        self.identifier = identifier
        self.workspace = workspace
        self.user = user


class WorkspaceMembershipCreate(msrest.serialization.Model):
    """WorkspaceMembershipCreate.

    :ivar workspace: Uniquely identify a workspace.
    :vartype workspace: str
    :ivar user: Uniquely identify a user.
    :vartype user: int
    """

    _attribute_map = {
        "workspace": {"key": "workspace", "type": "str"},
        "user": {"key": "user", "type": "int"},
    }

    def __init__(self, *, workspace: Optional[str] = None, user: Optional[int] = None, **kwargs):
        """
        :keyword workspace: Uniquely identify a workspace.
        :paramtype workspace: str
        :keyword user: Uniquely identify a user.
        :paramtype user: int
        """
        super(WorkspaceMembershipCreate, self).__init__(**kwargs)
        self.workspace = workspace
        self.user = user


class WorkspaceUpdate(msrest.serialization.Model):
    """WorkspaceUpdate.

    :ivar name:
    :vartype name: str
    :ivar visibility: Visibility "organization" means everyone in the organization can access the
     workspace. Visibility "private" means only people explicitly added can access the workspace.
     Known values are: "organization", "private".
    :vartype visibility: str or ~affinda.models.WorkspaceVisibility
    :ivar reject_invalid_documents: If true, the uploaded document will be rejected if it's of the
     wrong document type, or if its document type cannot be determined. No credits will be consumed.
    :vartype reject_invalid_documents: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "reject_invalid_documents": {"key": "rejectInvalidDocuments", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        visibility: Optional[Union[str, "_models.WorkspaceVisibility"]] = None,
        reject_invalid_documents: Optional[bool] = None,
        **kwargs,
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword visibility: Visibility "organization" means everyone in the organization can access
         the workspace. Visibility "private" means only people explicitly added can access the
         workspace. Known values are: "organization", "private".
        :paramtype visibility: str or ~affinda.models.WorkspaceVisibility
        :keyword reject_invalid_documents: If true, the uploaded document will be rejected if it's of
         the wrong document type, or if its document type cannot be determined. No credits will be
         consumed.
        :paramtype reject_invalid_documents: bool
        """
        super(WorkspaceUpdate, self).__init__(**kwargs)
        self.name = name
        self.visibility = visibility
        self.reject_invalid_documents = reject_invalid_documents


class YearsExperienceAnnotation(Annotation):
    """YearsExperienceAnnotation.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Required.
    :vartype id: int
    :ivar rectangle: Required.
    :vartype rectangle: ~affinda.models.Rectangle
    :ivar rectangles: Required.
    :vartype rectangles: list[~affinda.models.Rectangle]
    :ivar page_index: Required.
    :vartype page_index: int
    :ivar raw: Required.
    :vartype raw: str
    :ivar confidence: Required. The overall confidence that the model's prediction is correct.
    :vartype confidence: float
    :ivar classification_confidence: Required. The model's confidence that the text has been
     classified correctly.
    :vartype classification_confidence: float
    :ivar text_extraction_confidence: Required. If the document was submitted as an image, this is
     the confidence that the text in the image has been correctly read by the model.
    :vartype text_extraction_confidence: float
    :ivar is_verified: Required.
    :vartype is_verified: bool
    :ivar is_client_verified: Required.
    :vartype is_client_verified: bool
    :ivar is_auto_verified: Required.
    :vartype is_auto_verified: bool
    :ivar data_point: Required.
    :vartype data_point: str
    :ivar content_type: Required.
    :vartype content_type: str
    :ivar parsed: Years of experience range.
    :vartype parsed: ~affinda.models.YearsExperienceAnnotationParsed
    """

    _validation = {
        "id": {"required": True},
        "rectangle": {"required": True},
        "rectangles": {"required": True},
        "page_index": {"required": True},
        "raw": {"required": True},
        "confidence": {"required": True},
        "classification_confidence": {"required": True},
        "text_extraction_confidence": {"required": True},
        "is_verified": {"required": True},
        "is_client_verified": {"required": True},
        "is_auto_verified": {"required": True},
        "data_point": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "int"},
        "rectangle": {"key": "rectangle", "type": "Rectangle"},
        "rectangles": {"key": "rectangles", "type": "[Rectangle]"},
        "page_index": {"key": "pageIndex", "type": "int"},
        "raw": {"key": "raw", "type": "str"},
        "confidence": {"key": "confidence", "type": "float"},
        "classification_confidence": {"key": "classificationConfidence", "type": "float"},
        "text_extraction_confidence": {"key": "textExtractionConfidence", "type": "float"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "is_client_verified": {"key": "isClientVerified", "type": "bool"},
        "is_auto_verified": {"key": "isAutoVerified", "type": "bool"},
        "data_point": {"key": "dataPoint", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "parsed": {"key": "parsed", "type": "YearsExperienceAnnotationParsed"},
    }

    def __init__(
        self,
        *,
        id: int,
        rectangle: "_models.Rectangle",
        rectangles: List["_models.Rectangle"],
        page_index: int,
        raw: str,
        confidence: float,
        classification_confidence: float,
        text_extraction_confidence: float,
        is_verified: bool,
        is_client_verified: bool,
        is_auto_verified: bool,
        data_point: str,
        content_type: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        parsed: Optional["_models.YearsExperienceAnnotationParsed"] = None,
        **kwargs,
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Required.
        :paramtype id: int
        :keyword rectangle: Required.
        :paramtype rectangle: ~affinda.models.Rectangle
        :keyword rectangles: Required.
        :paramtype rectangles: list[~affinda.models.Rectangle]
        :keyword page_index: Required.
        :paramtype page_index: int
        :keyword raw: Required.
        :paramtype raw: str
        :keyword confidence: Required. The overall confidence that the model's prediction is correct.
        :paramtype confidence: float
        :keyword classification_confidence: Required. The model's confidence that the text has been
         classified correctly.
        :paramtype classification_confidence: float
        :keyword text_extraction_confidence: Required. If the document was submitted as an image, this
         is the confidence that the text in the image has been correctly read by the model.
        :paramtype text_extraction_confidence: float
        :keyword is_verified: Required.
        :paramtype is_verified: bool
        :keyword is_client_verified: Required.
        :paramtype is_client_verified: bool
        :keyword is_auto_verified: Required.
        :paramtype is_auto_verified: bool
        :keyword data_point: Required.
        :paramtype data_point: str
        :keyword content_type: Required.
        :paramtype content_type: str
        :keyword parsed: Years of experience range.
        :paramtype parsed: ~affinda.models.YearsExperienceAnnotationParsed
        """
        super(YearsExperienceAnnotation, self).__init__(
            additional_properties=additional_properties,
            id=id,
            rectangle=rectangle,
            rectangles=rectangles,
            page_index=page_index,
            raw=raw,
            confidence=confidence,
            classification_confidence=classification_confidence,
            text_extraction_confidence=text_extraction_confidence,
            is_verified=is_verified,
            is_client_verified=is_client_verified,
            is_auto_verified=is_auto_verified,
            data_point=data_point,
            content_type=content_type,
            **kwargs,
        )
        self.parsed = parsed


class YearsExperienceAnnotationParsed(msrest.serialization.Model):
    """Years of experience range.

    :ivar minimum: Minimum years of experience.
    :vartype minimum: float
    :ivar maximum: Maximum years of experience.
    :vartype maximum: float
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
    }

    def __init__(
        self, *, minimum: Optional[float] = None, maximum: Optional[float] = None, **kwargs
    ):
        """
        :keyword minimum: Minimum years of experience.
        :paramtype minimum: float
        :keyword maximum: Maximum years of experience.
        :paramtype maximum: float
        """
        super(YearsExperienceAnnotationParsed, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
