import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeBackendBucketSignedUrlKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The backend bucket this signed URL key belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key#backend_bucket ComputeBackendBucketSignedUrlKey#backend_bucket}
    */
    readonly backendBucket: string;
    /**
    * 128-bit key value used for signing the URL. The key value must be a
  valid RFC 4648 Section 5 base64url encoded string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key#key_value ComputeBackendBucketSignedUrlKey#key_value}
    */
    readonly keyValue: string;
    /**
    * Name of the signed URL key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key#name ComputeBackendBucketSignedUrlKey#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key#project ComputeBackendBucketSignedUrlKey#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key#timeouts ComputeBackendBucketSignedUrlKey#timeouts}
    */
    readonly timeouts?: ComputeBackendBucketSignedUrlKeyTimeouts;
}
export interface ComputeBackendBucketSignedUrlKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key#create ComputeBackendBucketSignedUrlKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key#delete ComputeBackendBucketSignedUrlKey#delete}
    */
    readonly delete?: string;
}
export declare function computeBackendBucketSignedUrlKeyTimeoutsToTerraform(struct?: ComputeBackendBucketSignedUrlKeyTimeoutsOutputReference | ComputeBackendBucketSignedUrlKeyTimeouts | cdktf.IResolvable): any;
export declare class ComputeBackendBucketSignedUrlKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendBucketSignedUrlKeyTimeouts | undefined;
    set internalValue(value: ComputeBackendBucketSignedUrlKeyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key google_compute_backend_bucket_signed_url_key}
*/
export declare class ComputeBackendBucketSignedUrlKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_backend_bucket_signed_url_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket_signed_url_key google_compute_backend_bucket_signed_url_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeBackendBucketSignedUrlKeyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeBackendBucketSignedUrlKeyConfig);
    private _backendBucket?;
    get backendBucket(): string;
    set backendBucket(value: string);
    get backendBucketInput(): string | undefined;
    get id(): string;
    private _keyValue?;
    get keyValue(): string;
    set keyValue(value: string);
    get keyValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeBackendBucketSignedUrlKeyTimeoutsOutputReference;
    putTimeouts(value: ComputeBackendBucketSignedUrlKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeBackendBucketSignedUrlKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
