import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeReservationConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#description ComputeReservation#description}
    */
    readonly description?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#name ComputeReservation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#project ComputeReservation#project}
    */
    readonly project?: string;
    /**
    * When set to true, only VMs that target this reservation by name can
  consume this reservation. Otherwise, it can be consumed by VMs with
  affinity for any reservation. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#specific_reservation_required ComputeReservation#specific_reservation_required}
    */
    readonly specificReservationRequired?: boolean | cdktf.IResolvable;
    /**
    * The zone where the reservation is made.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#zone ComputeReservation#zone}
    */
    readonly zone: string;
    /**
    * share_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#share_settings ComputeReservation#share_settings}
    */
    readonly shareSettings?: ComputeReservationShareSettings;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#specific_reservation ComputeReservation#specific_reservation}
    */
    readonly specificReservation: ComputeReservationSpecificReservation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#timeouts ComputeReservation#timeouts}
    */
    readonly timeouts?: ComputeReservationTimeouts;
}
export interface ComputeReservationShareSettingsProjectMap {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#id ComputeReservation#id}
    */
    readonly id: string;
    /**
    * The project id/number, should be same as the key of this project config in the project map.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#project_id ComputeReservation#project_id}
    */
    readonly projectId?: string;
}
export declare function computeReservationShareSettingsProjectMapToTerraform(struct?: ComputeReservationShareSettingsProjectMap | cdktf.IResolvable): any;
export interface ComputeReservationShareSettings {
    /**
    * Type of sharing for this shared-reservation Possible values: ["LOCAL", "SPECIFIC_PROJECTS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#share_type ComputeReservation#share_type}
    */
    readonly shareType?: string;
    /**
    * project_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#project_map ComputeReservation#project_map}
    */
    readonly projectMap?: ComputeReservationShareSettingsProjectMap[] | cdktf.IResolvable;
}
export declare function computeReservationShareSettingsToTerraform(struct?: ComputeReservationShareSettingsOutputReference | ComputeReservationShareSettings): any;
export declare class ComputeReservationShareSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeReservationShareSettings | undefined;
    set internalValue(value: ComputeReservationShareSettings | undefined);
    private _shareType?;
    get shareType(): string;
    set shareType(value: string);
    resetShareType(): void;
    get shareTypeInput(): string | undefined;
    private _projectMap?;
    get projectMap(): ComputeReservationShareSettingsProjectMap[] | cdktf.IResolvable;
    set projectMap(value: ComputeReservationShareSettingsProjectMap[] | cdktf.IResolvable);
    resetProjectMap(): void;
    get projectMapInput(): cdktf.IResolvable | ComputeReservationShareSettingsProjectMap[] | undefined;
}
export interface ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators {
    /**
    * The number of the guest accelerator cards exposed to
  this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#accelerator_count ComputeReservation#accelerator_count}
    */
    readonly acceleratorCount: number;
    /**
    * The full or partial URL of the accelerator type to
  attach to this instance. For example:
  'projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100'
  
  If you are creating an instance template, specify only the accelerator name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#accelerator_type ComputeReservation#accelerator_type}
    */
    readonly acceleratorType: string;
}
export declare function computeReservationSpecificReservationInstancePropertiesGuestAcceleratorsToTerraform(struct?: ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators | cdktf.IResolvable): any;
export interface ComputeReservationSpecificReservationInstancePropertiesLocalSsds {
    /**
    * The size of the disk in base-2 GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#disk_size_gb ComputeReservation#disk_size_gb}
    */
    readonly diskSizeGb: number;
    /**
    * The disk interface to use for attaching this disk. Default value: "SCSI" Possible values: ["SCSI", "NVME"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#interface ComputeReservation#interface}
    */
    readonly interface?: string;
}
export declare function computeReservationSpecificReservationInstancePropertiesLocalSsdsToTerraform(struct?: ComputeReservationSpecificReservationInstancePropertiesLocalSsds | cdktf.IResolvable): any;
export interface ComputeReservationSpecificReservationInstanceProperties {
    /**
    * The name of the machine type to reserve.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#machine_type ComputeReservation#machine_type}
    */
    readonly machineType: string;
    /**
    * The minimum CPU platform for the reservation. For example,
  '"Intel Skylake"'. See
  the CPU platform availability reference](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform#availablezones)
  for information on available CPU platforms.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#min_cpu_platform ComputeReservation#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * guest_accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#guest_accelerators ComputeReservation#guest_accelerators}
    */
    readonly guestAccelerators?: ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | cdktf.IResolvable;
    /**
    * local_ssds block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#local_ssds ComputeReservation#local_ssds}
    */
    readonly localSsds?: ComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | cdktf.IResolvable;
}
export declare function computeReservationSpecificReservationInstancePropertiesToTerraform(struct?: ComputeReservationSpecificReservationInstancePropertiesOutputReference | ComputeReservationSpecificReservationInstanceProperties): any;
export declare class ComputeReservationSpecificReservationInstancePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeReservationSpecificReservationInstanceProperties | undefined;
    set internalValue(value: ComputeReservationSpecificReservationInstanceProperties | undefined);
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _guestAccelerators?;
    get guestAccelerators(): ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | cdktf.IResolvable;
    set guestAccelerators(value: ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | cdktf.IResolvable);
    resetGuestAccelerators(): void;
    get guestAcceleratorsInput(): cdktf.IResolvable | ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | undefined;
    private _localSsds?;
    get localSsds(): ComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | cdktf.IResolvable;
    set localSsds(value: ComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | cdktf.IResolvable);
    resetLocalSsds(): void;
    get localSsdsInput(): cdktf.IResolvable | ComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | undefined;
}
export interface ComputeReservationSpecificReservation {
    /**
    * The number of resources that are allocated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#count ComputeReservation#count}
    */
    readonly count: number;
    /**
    * instance_properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#instance_properties ComputeReservation#instance_properties}
    */
    readonly instanceProperties: ComputeReservationSpecificReservationInstanceProperties;
}
export declare function computeReservationSpecificReservationToTerraform(struct?: ComputeReservationSpecificReservationOutputReference | ComputeReservationSpecificReservation): any;
export declare class ComputeReservationSpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeReservationSpecificReservation | undefined;
    set internalValue(value: ComputeReservationSpecificReservation | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    get inUseCount(): number;
    private _instanceProperties;
    get instanceProperties(): ComputeReservationSpecificReservationInstancePropertiesOutputReference;
    putInstanceProperties(value: ComputeReservationSpecificReservationInstanceProperties): void;
    get instancePropertiesInput(): ComputeReservationSpecificReservationInstanceProperties | undefined;
}
export interface ComputeReservationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#create ComputeReservation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#delete ComputeReservation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation#update ComputeReservation#update}
    */
    readonly update?: string;
}
export declare function computeReservationTimeoutsToTerraform(struct?: ComputeReservationTimeoutsOutputReference | ComputeReservationTimeouts | cdktf.IResolvable): any;
export declare class ComputeReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeReservationTimeouts | undefined;
    set internalValue(value: ComputeReservationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_reservation google_compute_reservation}
*/
export declare class ComputeReservation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_reservation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_reservation google_compute_reservation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeReservationConfig
    */
    constructor(scope: Construct, id: string, config: ComputeReservationConfig);
    get commitment(): string;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _specificReservationRequired?;
    get specificReservationRequired(): boolean | cdktf.IResolvable;
    set specificReservationRequired(value: boolean | cdktf.IResolvable);
    resetSpecificReservationRequired(): void;
    get specificReservationRequiredInput(): boolean | cdktf.IResolvable | undefined;
    get status(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _shareSettings;
    get shareSettings(): ComputeReservationShareSettingsOutputReference;
    putShareSettings(value: ComputeReservationShareSettings): void;
    resetShareSettings(): void;
    get shareSettingsInput(): ComputeReservationShareSettings | undefined;
    private _specificReservation;
    get specificReservation(): ComputeReservationSpecificReservationOutputReference;
    putSpecificReservation(value: ComputeReservationSpecificReservation): void;
    get specificReservationInput(): ComputeReservationSpecificReservation | undefined;
    private _timeouts;
    get timeouts(): ComputeReservationTimeoutsOutputReference;
    putTimeouts(value: ComputeReservationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
