import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAwsClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#annotations ContainerAwsCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#aws_region ContainerAwsCluster#aws_region}
    */
    readonly awsRegion: string;
    /**
    * Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#description ContainerAwsCluster#description}
    */
    readonly description?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#location ContainerAwsCluster#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#name ContainerAwsCluster#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#project ContainerAwsCluster#project}
    */
    readonly project?: string;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#authorization ContainerAwsCluster#authorization}
    */
    readonly authorization: ContainerAwsClusterAuthorization;
    /**
    * control_plane block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#control_plane ContainerAwsCluster#control_plane}
    */
    readonly controlPlane: ContainerAwsClusterControlPlane;
    /**
    * fleet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#fleet ContainerAwsCluster#fleet}
    */
    readonly fleet: ContainerAwsClusterFleet;
    /**
    * networking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#networking ContainerAwsCluster#networking}
    */
    readonly networking: ContainerAwsClusterNetworking;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#timeouts ContainerAwsCluster#timeouts}
    */
    readonly timeouts?: ContainerAwsClusterTimeouts;
}
export interface ContainerAwsClusterWorkloadIdentityConfig {
}
export declare function containerAwsClusterWorkloadIdentityConfigToTerraform(struct?: ContainerAwsClusterWorkloadIdentityConfig): any;
export declare class ContainerAwsClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAwsClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: ContainerAwsClusterWorkloadIdentityConfig | undefined);
    get identityProvider(): string;
    get issuerUri(): string;
    get workloadPool(): string;
}
export declare class ContainerAwsClusterWorkloadIdentityConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAwsClusterWorkloadIdentityConfigOutputReference;
}
export interface ContainerAwsClusterAuthorizationAdminUsers {
    /**
    * The name of the user, e.g. `my-gcp-id@gmail.com`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#username ContainerAwsCluster#username}
    */
    readonly username: string;
}
export declare function containerAwsClusterAuthorizationAdminUsersToTerraform(struct?: ContainerAwsClusterAuthorizationAdminUsers | cdktf.IResolvable): any;
export interface ContainerAwsClusterAuthorization {
    /**
    * admin_users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#admin_users ContainerAwsCluster#admin_users}
    */
    readonly adminUsers: ContainerAwsClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
}
export declare function containerAwsClusterAuthorizationToTerraform(struct?: ContainerAwsClusterAuthorizationOutputReference | ContainerAwsClusterAuthorization): any;
export declare class ContainerAwsClusterAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterAuthorization | undefined;
    set internalValue(value: ContainerAwsClusterAuthorization | undefined);
    private _adminUsers?;
    get adminUsers(): ContainerAwsClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
    set adminUsers(value: ContainerAwsClusterAuthorizationAdminUsers[] | cdktf.IResolvable);
    get adminUsersInput(): cdktf.IResolvable | ContainerAwsClusterAuthorizationAdminUsers[] | undefined;
}
export interface ContainerAwsClusterControlPlaneAwsServicesAuthentication {
    /**
    * The Amazon Resource Name (ARN) of the role that the Anthos Multi-Cloud API will assume when managing AWS resources on your account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#role_arn ContainerAwsCluster#role_arn}
    */
    readonly roleArn: string;
    /**
    * Optional. An identifier for the assumed role session. When unspecified, it defaults to `multicloud-service-agent`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#role_session_name ContainerAwsCluster#role_session_name}
    */
    readonly roleSessionName?: string;
}
export declare function containerAwsClusterControlPlaneAwsServicesAuthenticationToTerraform(struct?: ContainerAwsClusterControlPlaneAwsServicesAuthenticationOutputReference | ContainerAwsClusterControlPlaneAwsServicesAuthentication): any;
export declare class ContainerAwsClusterControlPlaneAwsServicesAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterControlPlaneAwsServicesAuthentication | undefined;
    set internalValue(value: ContainerAwsClusterControlPlaneAwsServicesAuthentication | undefined);
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _roleSessionName?;
    get roleSessionName(): string;
    set roleSessionName(value: string);
    resetRoleSessionName(): void;
    get roleSessionNameInput(): string | undefined;
}
export interface ContainerAwsClusterControlPlaneConfigEncryption {
    /**
    * The ARN of the AWS KMS key used to encrypt cluster configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#kms_key_arn ContainerAwsCluster#kms_key_arn}
    */
    readonly kmsKeyArn: string;
}
export declare function containerAwsClusterControlPlaneConfigEncryptionToTerraform(struct?: ContainerAwsClusterControlPlaneConfigEncryptionOutputReference | ContainerAwsClusterControlPlaneConfigEncryption): any;
export declare class ContainerAwsClusterControlPlaneConfigEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterControlPlaneConfigEncryption | undefined;
    set internalValue(value: ContainerAwsClusterControlPlaneConfigEncryption | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    get kmsKeyArnInput(): string | undefined;
}
export interface ContainerAwsClusterControlPlaneDatabaseEncryption {
    /**
    * The ARN of the AWS KMS key used to encrypt cluster secrets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#kms_key_arn ContainerAwsCluster#kms_key_arn}
    */
    readonly kmsKeyArn: string;
}
export declare function containerAwsClusterControlPlaneDatabaseEncryptionToTerraform(struct?: ContainerAwsClusterControlPlaneDatabaseEncryptionOutputReference | ContainerAwsClusterControlPlaneDatabaseEncryption): any;
export declare class ContainerAwsClusterControlPlaneDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterControlPlaneDatabaseEncryption | undefined;
    set internalValue(value: ContainerAwsClusterControlPlaneDatabaseEncryption | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    get kmsKeyArnInput(): string | undefined;
}
export interface ContainerAwsClusterControlPlaneMainVolume {
    /**
    * Optional. The number of I/O operations per second (IOPS) to provision for GP3 volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#iops ContainerAwsCluster#iops}
    */
    readonly iops?: number;
    /**
    * Optional. The Amazon Resource Name (ARN) of the Customer Managed Key (CMK) used to encrypt AWS EBS volumes. If not specified, the default Amazon managed key associated to the AWS region where this cluster runs will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#kms_key_arn ContainerAwsCluster#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
    /**
    * Optional. The size of the volume, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#size_gib ContainerAwsCluster#size_gib}
    */
    readonly sizeGib?: number;
    /**
    * Optional. Type of the EBS volume. When unspecified, it defaults to GP2 volume. Possible values: VOLUME_TYPE_UNSPECIFIED, GP2, GP3
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#volume_type ContainerAwsCluster#volume_type}
    */
    readonly volumeType?: string;
}
export declare function containerAwsClusterControlPlaneMainVolumeToTerraform(struct?: ContainerAwsClusterControlPlaneMainVolumeOutputReference | ContainerAwsClusterControlPlaneMainVolume): any;
export declare class ContainerAwsClusterControlPlaneMainVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterControlPlaneMainVolume | undefined;
    set internalValue(value: ContainerAwsClusterControlPlaneMainVolume | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    resetKmsKeyArn(): void;
    get kmsKeyArnInput(): string | undefined;
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
}
export interface ContainerAwsClusterControlPlaneProxyConfig {
    /**
    * The ARN of the AWS Secret Manager secret that contains the HTTP(S) proxy configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#secret_arn ContainerAwsCluster#secret_arn}
    */
    readonly secretArn: string;
    /**
    * The version string of the AWS Secret Manager secret that contains the HTTP(S) proxy configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#secret_version ContainerAwsCluster#secret_version}
    */
    readonly secretVersion: string;
}
export declare function containerAwsClusterControlPlaneProxyConfigToTerraform(struct?: ContainerAwsClusterControlPlaneProxyConfigOutputReference | ContainerAwsClusterControlPlaneProxyConfig): any;
export declare class ContainerAwsClusterControlPlaneProxyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterControlPlaneProxyConfig | undefined;
    set internalValue(value: ContainerAwsClusterControlPlaneProxyConfig | undefined);
    private _secretArn?;
    get secretArn(): string;
    set secretArn(value: string);
    get secretArnInput(): string | undefined;
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface ContainerAwsClusterControlPlaneRootVolume {
    /**
    * Optional. The number of I/O operations per second (IOPS) to provision for GP3 volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#iops ContainerAwsCluster#iops}
    */
    readonly iops?: number;
    /**
    * Optional. The Amazon Resource Name (ARN) of the Customer Managed Key (CMK) used to encrypt AWS EBS volumes. If not specified, the default Amazon managed key associated to the AWS region where this cluster runs will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#kms_key_arn ContainerAwsCluster#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
    /**
    * Optional. The size of the volume, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#size_gib ContainerAwsCluster#size_gib}
    */
    readonly sizeGib?: number;
    /**
    * Optional. Type of the EBS volume. When unspecified, it defaults to GP2 volume. Possible values: VOLUME_TYPE_UNSPECIFIED, GP2, GP3
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#volume_type ContainerAwsCluster#volume_type}
    */
    readonly volumeType?: string;
}
export declare function containerAwsClusterControlPlaneRootVolumeToTerraform(struct?: ContainerAwsClusterControlPlaneRootVolumeOutputReference | ContainerAwsClusterControlPlaneRootVolume): any;
export declare class ContainerAwsClusterControlPlaneRootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterControlPlaneRootVolume | undefined;
    set internalValue(value: ContainerAwsClusterControlPlaneRootVolume | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    resetKmsKeyArn(): void;
    get kmsKeyArnInput(): string | undefined;
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
}
export interface ContainerAwsClusterControlPlaneSshConfig {
    /**
    * The name of the EC2 key pair used to login into cluster machines.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#ec2_key_pair ContainerAwsCluster#ec2_key_pair}
    */
    readonly ec2KeyPair: string;
}
export declare function containerAwsClusterControlPlaneSshConfigToTerraform(struct?: ContainerAwsClusterControlPlaneSshConfigOutputReference | ContainerAwsClusterControlPlaneSshConfig): any;
export declare class ContainerAwsClusterControlPlaneSshConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterControlPlaneSshConfig | undefined;
    set internalValue(value: ContainerAwsClusterControlPlaneSshConfig | undefined);
    private _ec2KeyPair?;
    get ec2KeyPair(): string;
    set ec2KeyPair(value: string);
    get ec2KeyPairInput(): string | undefined;
}
export interface ContainerAwsClusterControlPlane {
    /**
    * The name of the AWS IAM instance pofile to assign to each control plane replica.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#iam_instance_profile ContainerAwsCluster#iam_instance_profile}
    */
    readonly iamInstanceProfile: string;
    /**
    * Optional. The AWS instance type. When unspecified, it defaults to `m5.large`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#instance_type ContainerAwsCluster#instance_type}
    */
    readonly instanceType?: string;
    /**
    * Optional. The IDs of additional security groups to add to control plane replicas. The Anthos Multi-Cloud API will automatically create and manage security groups with the minimum rules needed for a functioning cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#security_group_ids ContainerAwsCluster#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * The list of subnets where control plane replicas will run. A replica will be provisioned on each subnet and up to three values can be provided. Each subnet must be in a different AWS Availability Zone (AZ).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#subnet_ids ContainerAwsCluster#subnet_ids}
    */
    readonly subnetIds: string[];
    /**
    * Optional. A set of AWS resource tags to propagate to all underlying managed AWS resources. Specify at most 50 pairs containing alphanumerics, spaces, and symbols (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to 255 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#tags ContainerAwsCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * The Kubernetes version to run on control plane replicas (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling .
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#version ContainerAwsCluster#version}
    */
    readonly version: string;
    /**
    * aws_services_authentication block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#aws_services_authentication ContainerAwsCluster#aws_services_authentication}
    */
    readonly awsServicesAuthentication: ContainerAwsClusterControlPlaneAwsServicesAuthentication;
    /**
    * config_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#config_encryption ContainerAwsCluster#config_encryption}
    */
    readonly configEncryption: ContainerAwsClusterControlPlaneConfigEncryption;
    /**
    * database_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#database_encryption ContainerAwsCluster#database_encryption}
    */
    readonly databaseEncryption: ContainerAwsClusterControlPlaneDatabaseEncryption;
    /**
    * main_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#main_volume ContainerAwsCluster#main_volume}
    */
    readonly mainVolume?: ContainerAwsClusterControlPlaneMainVolume;
    /**
    * proxy_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#proxy_config ContainerAwsCluster#proxy_config}
    */
    readonly proxyConfig?: ContainerAwsClusterControlPlaneProxyConfig;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#root_volume ContainerAwsCluster#root_volume}
    */
    readonly rootVolume?: ContainerAwsClusterControlPlaneRootVolume;
    /**
    * ssh_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#ssh_config ContainerAwsCluster#ssh_config}
    */
    readonly sshConfig?: ContainerAwsClusterControlPlaneSshConfig;
}
export declare function containerAwsClusterControlPlaneToTerraform(struct?: ContainerAwsClusterControlPlaneOutputReference | ContainerAwsClusterControlPlane): any;
export declare class ContainerAwsClusterControlPlaneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterControlPlane | undefined;
    set internalValue(value: ContainerAwsClusterControlPlane | undefined);
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    get iamInstanceProfileInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    resetInstanceType(): void;
    get instanceTypeInput(): string | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    get subnetIdsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _awsServicesAuthentication;
    get awsServicesAuthentication(): ContainerAwsClusterControlPlaneAwsServicesAuthenticationOutputReference;
    putAwsServicesAuthentication(value: ContainerAwsClusterControlPlaneAwsServicesAuthentication): void;
    get awsServicesAuthenticationInput(): ContainerAwsClusterControlPlaneAwsServicesAuthentication | undefined;
    private _configEncryption;
    get configEncryption(): ContainerAwsClusterControlPlaneConfigEncryptionOutputReference;
    putConfigEncryption(value: ContainerAwsClusterControlPlaneConfigEncryption): void;
    get configEncryptionInput(): ContainerAwsClusterControlPlaneConfigEncryption | undefined;
    private _databaseEncryption;
    get databaseEncryption(): ContainerAwsClusterControlPlaneDatabaseEncryptionOutputReference;
    putDatabaseEncryption(value: ContainerAwsClusterControlPlaneDatabaseEncryption): void;
    get databaseEncryptionInput(): ContainerAwsClusterControlPlaneDatabaseEncryption | undefined;
    private _mainVolume;
    get mainVolume(): ContainerAwsClusterControlPlaneMainVolumeOutputReference;
    putMainVolume(value: ContainerAwsClusterControlPlaneMainVolume): void;
    resetMainVolume(): void;
    get mainVolumeInput(): ContainerAwsClusterControlPlaneMainVolume | undefined;
    private _proxyConfig;
    get proxyConfig(): ContainerAwsClusterControlPlaneProxyConfigOutputReference;
    putProxyConfig(value: ContainerAwsClusterControlPlaneProxyConfig): void;
    resetProxyConfig(): void;
    get proxyConfigInput(): ContainerAwsClusterControlPlaneProxyConfig | undefined;
    private _rootVolume;
    get rootVolume(): ContainerAwsClusterControlPlaneRootVolumeOutputReference;
    putRootVolume(value: ContainerAwsClusterControlPlaneRootVolume): void;
    resetRootVolume(): void;
    get rootVolumeInput(): ContainerAwsClusterControlPlaneRootVolume | undefined;
    private _sshConfig;
    get sshConfig(): ContainerAwsClusterControlPlaneSshConfigOutputReference;
    putSshConfig(value: ContainerAwsClusterControlPlaneSshConfig): void;
    resetSshConfig(): void;
    get sshConfigInput(): ContainerAwsClusterControlPlaneSshConfig | undefined;
}
export interface ContainerAwsClusterFleet {
    /**
    * The number of the Fleet host project where this cluster will be registered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#project ContainerAwsCluster#project}
    */
    readonly project?: string;
}
export declare function containerAwsClusterFleetToTerraform(struct?: ContainerAwsClusterFleetOutputReference | ContainerAwsClusterFleet): any;
export declare class ContainerAwsClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterFleet | undefined;
    set internalValue(value: ContainerAwsClusterFleet | undefined);
    get membership(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
}
export interface ContainerAwsClusterNetworking {
    /**
    * All pods in the cluster are assigned an RFC1918 IPv4 address from these ranges. Only a single range is supported. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#pod_address_cidr_blocks ContainerAwsCluster#pod_address_cidr_blocks}
    */
    readonly podAddressCidrBlocks: string[];
    /**
    * All services in the cluster are assigned an RFC1918 IPv4 address from these ranges. Only a single range is supported. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#service_address_cidr_blocks ContainerAwsCluster#service_address_cidr_blocks}
    */
    readonly serviceAddressCidrBlocks: string[];
    /**
    * The VPC associated with the cluster. All component clusters (i.e. control plane and node pools) run on a single VPC. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#vpc_id ContainerAwsCluster#vpc_id}
    */
    readonly vpcId: string;
}
export declare function containerAwsClusterNetworkingToTerraform(struct?: ContainerAwsClusterNetworkingOutputReference | ContainerAwsClusterNetworking): any;
export declare class ContainerAwsClusterNetworkingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterNetworking | undefined;
    set internalValue(value: ContainerAwsClusterNetworking | undefined);
    private _podAddressCidrBlocks?;
    get podAddressCidrBlocks(): string[];
    set podAddressCidrBlocks(value: string[]);
    get podAddressCidrBlocksInput(): string[] | undefined;
    private _serviceAddressCidrBlocks?;
    get serviceAddressCidrBlocks(): string[];
    set serviceAddressCidrBlocks(value: string[]);
    get serviceAddressCidrBlocksInput(): string[] | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
}
export interface ContainerAwsClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#create ContainerAwsCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#delete ContainerAwsCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster#update ContainerAwsCluster#update}
    */
    readonly update?: string;
}
export declare function containerAwsClusterTimeoutsToTerraform(struct?: ContainerAwsClusterTimeoutsOutputReference | ContainerAwsClusterTimeouts | cdktf.IResolvable): any;
export declare class ContainerAwsClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsClusterTimeouts | undefined;
    set internalValue(value: ContainerAwsClusterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster google_container_aws_cluster}
*/
export declare class ContainerAwsCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_aws_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_aws_cluster google_container_aws_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAwsClusterConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAwsClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _awsRegion?;
    get awsRegion(): string;
    set awsRegion(value: string);
    get awsRegionInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get endpoint(): string;
    get etag(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): ContainerAwsClusterWorkloadIdentityConfigList;
    private _authorization;
    get authorization(): ContainerAwsClusterAuthorizationOutputReference;
    putAuthorization(value: ContainerAwsClusterAuthorization): void;
    get authorizationInput(): ContainerAwsClusterAuthorization | undefined;
    private _controlPlane;
    get controlPlane(): ContainerAwsClusterControlPlaneOutputReference;
    putControlPlane(value: ContainerAwsClusterControlPlane): void;
    get controlPlaneInput(): ContainerAwsClusterControlPlane | undefined;
    private _fleet;
    get fleet(): ContainerAwsClusterFleetOutputReference;
    putFleet(value: ContainerAwsClusterFleet): void;
    get fleetInput(): ContainerAwsClusterFleet | undefined;
    private _networking;
    get networking(): ContainerAwsClusterNetworkingOutputReference;
    putNetworking(value: ContainerAwsClusterNetworking): void;
    get networkingInput(): ContainerAwsClusterNetworking | undefined;
    private _timeouts;
    get timeouts(): ContainerAwsClusterTimeoutsOutputReference;
    putTimeouts(value: ContainerAwsClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerAwsClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
