import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EndpointsServiceConsumersIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member#consumer_project EndpointsServiceConsumersIamMember#consumer_project}
    */
    readonly consumerProject: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member#member EndpointsServiceConsumersIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member#role EndpointsServiceConsumersIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member#service_name EndpointsServiceConsumersIamMember#service_name}
    */
    readonly serviceName: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member#condition EndpointsServiceConsumersIamMember#condition}
    */
    readonly condition?: EndpointsServiceConsumersIamMemberCondition;
}
export interface EndpointsServiceConsumersIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member#description EndpointsServiceConsumersIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member#expression EndpointsServiceConsumersIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member#title EndpointsServiceConsumersIamMember#title}
    */
    readonly title: string;
}
export declare function endpointsServiceConsumersIamMemberConditionToTerraform(struct?: EndpointsServiceConsumersIamMemberConditionOutputReference | EndpointsServiceConsumersIamMemberCondition): any;
export declare class EndpointsServiceConsumersIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EndpointsServiceConsumersIamMemberCondition | undefined;
    set internalValue(value: EndpointsServiceConsumersIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member google_endpoints_service_consumers_iam_member}
*/
export declare class EndpointsServiceConsumersIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_endpoints_service_consumers_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_member google_endpoints_service_consumers_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EndpointsServiceConsumersIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: EndpointsServiceConsumersIamMemberConfig);
    private _consumerProject?;
    get consumerProject(): string;
    set consumerProject(value: string);
    get consumerProjectInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _condition;
    get condition(): EndpointsServiceConsumersIamMemberConditionOutputReference;
    putCondition(value: EndpointsServiceConsumersIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): EndpointsServiceConsumersIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
