import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirebaserulesReleaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Format: `projects/{project_id}/releases/{release_id}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release#name FirebaserulesRelease#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release#project FirebaserulesRelease#project}
    */
    readonly project?: string;
    /**
    * Name of the `Ruleset` referred to by this `Release`. The `Ruleset` must exist the `Release` to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release#ruleset_name FirebaserulesRelease#ruleset_name}
    */
    readonly rulesetName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release#timeouts FirebaserulesRelease#timeouts}
    */
    readonly timeouts?: FirebaserulesReleaseTimeouts;
}
export interface FirebaserulesReleaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release#create FirebaserulesRelease#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release#delete FirebaserulesRelease#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release#update FirebaserulesRelease#update}
    */
    readonly update?: string;
}
export declare function firebaserulesReleaseTimeoutsToTerraform(struct?: FirebaserulesReleaseTimeoutsOutputReference | FirebaserulesReleaseTimeouts | cdktf.IResolvable): any;
export declare class FirebaserulesReleaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirebaserulesReleaseTimeouts | undefined;
    set internalValue(value: FirebaserulesReleaseTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release google_firebaserules_release}
*/
export declare class FirebaserulesRelease extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebaserules_release";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/firebaserules_release google_firebaserules_release} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirebaserulesReleaseConfig
    */
    constructor(scope: Construct, id: string, config: FirebaserulesReleaseConfig);
    get createTime(): string;
    get disabled(): cdktf.IResolvable;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _rulesetName?;
    get rulesetName(): string;
    set rulesetName(value: string);
    get rulesetNameInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): FirebaserulesReleaseTimeoutsOutputReference;
    putTimeouts(value: FirebaserulesReleaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FirebaserulesReleaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
