import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirestoreDocumentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The collection ID, relative to database. For example: chatrooms or chatrooms/my-document/private-messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#collection FirestoreDocument#collection}
    */
    readonly collection: string;
    /**
    * The Firestore database id. Defaults to '"(default)"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#database FirestoreDocument#database}
    */
    readonly database?: string;
    /**
    * The client-assigned document ID to use for this document during creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#document_id FirestoreDocument#document_id}
    */
    readonly documentId: string;
    /**
    * The document's [fields](https://cloud.google.com/firestore/docs/reference/rest/v1/projects.databases.documents) formated as a json string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#fields FirestoreDocument#fields}
    */
    readonly fields: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#project FirestoreDocument#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#timeouts FirestoreDocument#timeouts}
    */
    readonly timeouts?: FirestoreDocumentTimeouts;
}
export interface FirestoreDocumentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#create FirestoreDocument#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#delete FirestoreDocument#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_document#update FirestoreDocument#update}
    */
    readonly update?: string;
}
export declare function firestoreDocumentTimeoutsToTerraform(struct?: FirestoreDocumentTimeoutsOutputReference | FirestoreDocumentTimeouts | cdktf.IResolvable): any;
export declare class FirestoreDocumentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirestoreDocumentTimeouts | undefined;
    set internalValue(value: FirestoreDocumentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/firestore_document google_firestore_document}
*/
export declare class FirestoreDocument extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firestore_document";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/firestore_document google_firestore_document} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirestoreDocumentConfig
    */
    constructor(scope: Construct, id: string, config: FirestoreDocumentConfig);
    private _collection?;
    get collection(): string;
    set collection(value: string);
    get collectionInput(): string | undefined;
    get createTime(): string;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _documentId?;
    get documentId(): string;
    set documentId(value: string);
    get documentIdInput(): string | undefined;
    private _fields?;
    get fields(): string;
    set fields(value: string);
    get fieldsInput(): string | undefined;
    get id(): string;
    get name(): string;
    get path(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): FirestoreDocumentTimeoutsOutputReference;
    putTimeouts(value: FirestoreDocumentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FirestoreDocumentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
