"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HealthcareDicomStoreIamPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_policy google_healthcare_dicom_store_iam_policy}
*/
class HealthcareDicomStoreIamPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_policy google_healthcare_dicom_store_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareDicomStoreIamPolicyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_healthcare_dicom_store_iam_policy',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.20.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._dicomStoreId = config.dicomStoreId;
        this._policyData = config.policyData;
    }
    get dicomStoreId() {
        return this.getStringAttribute('dicom_store_id');
    }
    set dicomStoreId(value) {
        this._dicomStoreId = value;
    }
    // Temporarily expose input value. Use with caution.
    get dicomStoreIdInput() {
        return this._dicomStoreId;
    }
    // etag - computed: true, optional: false, required: false
    get etag() {
        return this.getStringAttribute('etag');
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get policyData() {
        return this.getStringAttribute('policy_data');
    }
    set policyData(value) {
        this._policyData = value;
    }
    // Temporarily expose input value. Use with caution.
    get policyDataInput() {
        return this._policyData;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            dicom_store_id: cdktf.stringToTerraform(this._dicomStoreId),
            policy_data: cdktf.stringToTerraform(this._policyData),
        };
    }
}
exports.HealthcareDicomStoreIamPolicy = HealthcareDicomStoreIamPolicy;
_a = JSII_RTTI_SYMBOL_1;
HealthcareDicomStoreIamPolicy[_a] = { fqn: "@cdktf/provider-google.HealthcareDicomStoreIamPolicy", version: "0.8.29" };
// =================
// STATIC PROPERTIES
// =================
HealthcareDicomStoreIamPolicy.tfResourceType = "google_healthcare_dicom_store_iam_policy";
//# sourceMappingURL=data:application/json;base64,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