import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsKeyRingIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_policy#key_ring_id KmsKeyRingIamPolicy#key_ring_id}
    */
    readonly keyRingId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_policy#policy_data KmsKeyRingIamPolicy#policy_data}
    */
    readonly policyData: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_policy google_kms_key_ring_iam_policy}
*/
export declare class KmsKeyRingIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_key_ring_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_iam_policy google_kms_key_ring_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsKeyRingIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: KmsKeyRingIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _keyRingId?;
    get keyRingId(): string;
    set keyRingId(value: string);
    get keyRingIdInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
