import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubSubscriptionIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member#member PubsubSubscriptionIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member#project PubsubSubscriptionIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member#role PubsubSubscriptionIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member#subscription PubsubSubscriptionIamMember#subscription}
    */
    readonly subscription: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member#condition PubsubSubscriptionIamMember#condition}
    */
    readonly condition?: PubsubSubscriptionIamMemberCondition;
}
export interface PubsubSubscriptionIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member#description PubsubSubscriptionIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member#expression PubsubSubscriptionIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member#title PubsubSubscriptionIamMember#title}
    */
    readonly title: string;
}
export declare function pubsubSubscriptionIamMemberConditionToTerraform(struct?: PubsubSubscriptionIamMemberConditionOutputReference | PubsubSubscriptionIamMemberCondition): any;
export declare class PubsubSubscriptionIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubSubscriptionIamMemberCondition | undefined;
    set internalValue(value: PubsubSubscriptionIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member google_pubsub_subscription_iam_member}
*/
export declare class PubsubSubscriptionIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_subscription_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription_iam_member google_pubsub_subscription_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PubsubSubscriptionIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: PubsubSubscriptionIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _subscription?;
    get subscription(): string;
    set subscription(value: string);
    get subscriptionInput(): string | undefined;
    private _condition;
    get condition(): PubsubSubscriptionIamMemberConditionOutputReference;
    putCondition(value: PubsubSubscriptionIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): PubsubSubscriptionIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
