import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RedisInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Only applicable to STANDARD_HA tier which protects the instance
  against zonal failures by provisioning it across two zones.
  If provided, it must be a different zone from the one provided in
  [locationId].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#alternative_location_id RedisInstance#alternative_location_id}
    */
    readonly alternativeLocationId?: string;
    /**
    * Optional. Indicates whether OSS Redis AUTH is enabled for the
  instance. If set to "true" AUTH is enabled on the instance.
  Default value is "false" meaning AUTH is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#auth_enabled RedisInstance#auth_enabled}
    */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
    * The full name of the Google Compute Engine network to which the
  instance is connected. If left unspecified, the default network
  will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#authorized_network RedisInstance#authorized_network}
    */
    readonly authorizedNetwork?: string;
    /**
    * The connection mode of the Redis instance. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#connect_mode RedisInstance#connect_mode}
    */
    readonly connectMode?: string;
    /**
    * An arbitrary and optional user-provided name for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#display_name RedisInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#labels RedisInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The zone where the instance will be provisioned. If not provided,
  the service will choose a zone for the instance. For STANDARD_HA tier,
  instances will be created across two zones for protection against
  zonal failures. If [alternativeLocationId] is also provided, it must
  be different from [locationId].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#location_id RedisInstance#location_id}
    */
    readonly locationId?: string;
    /**
    * Redis memory size in GiB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#memory_size_gb RedisInstance#memory_size_gb}
    */
    readonly memorySizeGb: number;
    /**
    * The ID of the instance or a fully qualified identifier for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#name RedisInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#project RedisInstance#project}
    */
    readonly project?: string;
    /**
    * Optional. Read replica mode. Can only be specified when trying to create the instance.
  If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
  - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
  instance cannot scale up or down the number of replicas.
  - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
  can scale up and down the number of replicas. Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#read_replicas_mode RedisInstance#read_replicas_mode}
    */
    readonly readReplicasMode?: string;
    /**
    * Redis configuration parameters, according to http://redis.io/topics/config.
  Please check Memorystore documentation for the list of supported parameters:
  https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#redis_configs RedisInstance#redis_configs}
    */
    readonly redisConfigs?: {
        [key: string]: string;
    };
    /**
    * The version of Redis software. If not provided, latest supported
  version will be used. Please check the API documentation linked
  at the top for the latest valid values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#redis_version RedisInstance#redis_version}
    */
    readonly redisVersion?: string;
    /**
    * The name of the Redis region of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#region RedisInstance#region}
    */
    readonly region?: string;
    /**
    * Optional. The number of replica nodes. The valid range for the Standard Tier with
  read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
  for a Standard Tier instance, the only valid value is 1 and the default is 1.
  The valid value for basic tier is 0 and the default is also 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#replica_count RedisInstance#replica_count}
    */
    readonly replicaCount?: number;
    /**
    * The CIDR range of internal addresses that are reserved for this
  instance. If not provided, the service will choose an unused /29
  block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
  unique and non-overlapping with existing subnets in an authorized
  network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#reserved_ip_range RedisInstance#reserved_ip_range}
    */
    readonly reservedIpRange?: string;
    /**
    * Optional. Additional IP range for node placement. Required when enabling read replicas on
  an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
  "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
  range associated with the private service access connection, or "auto".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#secondary_ip_range RedisInstance#secondary_ip_range}
    */
    readonly secondaryIpRange?: string;
    /**
    * The service tier of the instance. Must be one of these values:
  
  - BASIC: standalone instance
  - STANDARD_HA: highly available primary/replica instances Default value: "BASIC" Possible values: ["BASIC", "STANDARD_HA"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#tier RedisInstance#tier}
    */
    readonly tier?: string;
    /**
    * The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
  
  - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication Default value: "DISABLED" Possible values: ["SERVER_AUTHENTICATION", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#transit_encryption_mode RedisInstance#transit_encryption_mode}
    */
    readonly transitEncryptionMode?: string;
    /**
    * maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#maintenance_policy RedisInstance#maintenance_policy}
    */
    readonly maintenancePolicy?: RedisInstanceMaintenancePolicy;
    /**
    * maintenance_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#maintenance_schedule RedisInstance#maintenance_schedule}
    */
    readonly maintenanceSchedule?: RedisInstanceMaintenanceSchedule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#timeouts RedisInstance#timeouts}
    */
    readonly timeouts?: RedisInstanceTimeouts;
}
export interface RedisInstanceNodes {
}
export declare function redisInstanceNodesToTerraform(struct?: RedisInstanceNodes): any;
export declare class RedisInstanceNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RedisInstanceNodes | undefined;
    set internalValue(value: RedisInstanceNodes | undefined);
    get id(): string;
    get zone(): string;
}
export declare class RedisInstanceNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RedisInstanceNodesOutputReference;
}
export interface RedisInstanceServerCaCerts {
}
export declare function redisInstanceServerCaCertsToTerraform(struct?: RedisInstanceServerCaCerts): any;
export declare class RedisInstanceServerCaCertsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RedisInstanceServerCaCerts | undefined;
    set internalValue(value: RedisInstanceServerCaCerts | undefined);
    get cert(): string;
    get createTime(): string;
    get expireTime(): string;
    get serialNumber(): string;
    get sha1Fingerprint(): string;
}
export declare class RedisInstanceServerCaCertsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RedisInstanceServerCaCertsOutputReference;
}
export interface RedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
  An API may choose to allow the value "24:00:00" for scenarios like business closing time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#hours RedisInstance#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#minutes RedisInstance#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#nanos RedisInstance#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59.
  An API may allow the value 60 if it allows leap-seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#seconds RedisInstance#seconds}
    */
    readonly seconds?: number;
}
export declare function redisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeToTerraform(struct?: RedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference | RedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime): any;
export declare class RedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined;
    set internalValue(value: RedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export interface RedisInstanceMaintenancePolicyWeeklyMaintenanceWindow {
    /**
    * Required. The day of week that maintenance updates occur.
  
  - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
  - MONDAY: Monday
  - TUESDAY: Tuesday
  - WEDNESDAY: Wednesday
  - THURSDAY: Thursday
  - FRIDAY: Friday
  - SATURDAY: Saturday
  - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#day RedisInstance#day}
    */
    readonly day: string;
    /**
    * start_time block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#start_time RedisInstance#start_time}
    */
    readonly startTime: RedisInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime;
}
export declare function redisInstanceMaintenancePolicyWeeklyMaintenanceWindowToTerraform(struct?: RedisInstanceMaintenancePolicyWeeklyMaintenanceWindow | cdktf.IResolvable): any;
export interface RedisInstanceMaintenancePolicy {
    /**
    * Optional. Description of what this policy is for.
  Create/Update methods return INVALID_ARGUMENT if the
  length is greater than 512.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#description RedisInstance#description}
    */
    readonly description?: string;
    /**
    * weekly_maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#weekly_maintenance_window RedisInstance#weekly_maintenance_window}
    */
    readonly weeklyMaintenanceWindow?: RedisInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable;
}
export declare function redisInstanceMaintenancePolicyToTerraform(struct?: RedisInstanceMaintenancePolicyOutputReference | RedisInstanceMaintenancePolicy): any;
export declare class RedisInstanceMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisInstanceMaintenancePolicy | undefined;
    set internalValue(value: RedisInstanceMaintenancePolicy | undefined);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get updateTime(): string;
    private _weeklyMaintenanceWindow?;
    get weeklyMaintenanceWindow(): RedisInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable;
    set weeklyMaintenanceWindow(value: RedisInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable);
    resetWeeklyMaintenanceWindow(): void;
    get weeklyMaintenanceWindowInput(): cdktf.IResolvable | RedisInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | undefined;
}
export interface RedisInstanceMaintenanceSchedule {
}
export declare function redisInstanceMaintenanceScheduleToTerraform(struct?: RedisInstanceMaintenanceScheduleOutputReference | RedisInstanceMaintenanceSchedule): any;
export declare class RedisInstanceMaintenanceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisInstanceMaintenanceSchedule | undefined;
    set internalValue(value: RedisInstanceMaintenanceSchedule | undefined);
    get endTime(): string;
    get scheduleDeadlineTime(): string;
    get startTime(): string;
}
export interface RedisInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#create RedisInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#delete RedisInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance#update RedisInstance#update}
    */
    readonly update?: string;
}
export declare function redisInstanceTimeoutsToTerraform(struct?: RedisInstanceTimeoutsOutputReference | RedisInstanceTimeouts | cdktf.IResolvable): any;
export declare class RedisInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedisInstanceTimeouts | undefined;
    set internalValue(value: RedisInstanceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/redis_instance google_redis_instance}
*/
export declare class RedisInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_redis_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/redis_instance google_redis_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RedisInstanceConfig
    */
    constructor(scope: Construct, id: string, config: RedisInstanceConfig);
    private _alternativeLocationId?;
    get alternativeLocationId(): string;
    set alternativeLocationId(value: string);
    resetAlternativeLocationId(): void;
    get alternativeLocationIdInput(): string | undefined;
    private _authEnabled?;
    get authEnabled(): boolean | cdktf.IResolvable;
    set authEnabled(value: boolean | cdktf.IResolvable);
    resetAuthEnabled(): void;
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get authString(): string;
    private _authorizedNetwork?;
    get authorizedNetwork(): string;
    set authorizedNetwork(value: string);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    private _connectMode?;
    get connectMode(): string;
    set connectMode(value: string);
    resetConnectMode(): void;
    get connectModeInput(): string | undefined;
    get createTime(): string;
    get currentLocationId(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get host(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _locationId?;
    get locationId(): string;
    set locationId(value: string);
    resetLocationId(): void;
    get locationIdInput(): string | undefined;
    private _memorySizeGb?;
    get memorySizeGb(): number;
    set memorySizeGb(value: number);
    get memorySizeGbInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodes;
    get nodes(): RedisInstanceNodesList;
    get persistenceIamIdentity(): string;
    get port(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get readEndpoint(): string;
    get readEndpointPort(): number;
    private _readReplicasMode?;
    get readReplicasMode(): string;
    set readReplicasMode(value: string);
    resetReadReplicasMode(): void;
    get readReplicasModeInput(): string | undefined;
    private _redisConfigs?;
    get redisConfigs(): {
        [key: string]: string;
    };
    set redisConfigs(value: {
        [key: string]: string;
    });
    resetRedisConfigs(): void;
    get redisConfigsInput(): {
        [key: string]: string;
    } | undefined;
    private _redisVersion?;
    get redisVersion(): string;
    set redisVersion(value: string);
    resetRedisVersion(): void;
    get redisVersionInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _replicaCount?;
    get replicaCount(): number;
    set replicaCount(value: number);
    resetReplicaCount(): void;
    get replicaCountInput(): number | undefined;
    private _reservedIpRange?;
    get reservedIpRange(): string;
    set reservedIpRange(value: string);
    resetReservedIpRange(): void;
    get reservedIpRangeInput(): string | undefined;
    private _secondaryIpRange?;
    get secondaryIpRange(): string;
    set secondaryIpRange(value: string);
    resetSecondaryIpRange(): void;
    get secondaryIpRangeInput(): string | undefined;
    private _serverCaCerts;
    get serverCaCerts(): RedisInstanceServerCaCertsList;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _transitEncryptionMode?;
    get transitEncryptionMode(): string;
    set transitEncryptionMode(value: string);
    resetTransitEncryptionMode(): void;
    get transitEncryptionModeInput(): string | undefined;
    private _maintenancePolicy;
    get maintenancePolicy(): RedisInstanceMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: RedisInstanceMaintenancePolicy): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): RedisInstanceMaintenancePolicy | undefined;
    private _maintenanceSchedule;
    get maintenanceSchedule(): RedisInstanceMaintenanceScheduleOutputReference;
    putMaintenanceSchedule(value: RedisInstanceMaintenanceSchedule): void;
    resetMaintenanceSchedule(): void;
    get maintenanceScheduleInput(): RedisInstanceMaintenanceSchedule | undefined;
    private _timeouts;
    get timeouts(): RedisInstanceTimeoutsOutputReference;
    putTimeouts(value: RedisInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): RedisInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
