# Generated by Django 2.2.13 on 2020-06-20 20:00

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_currentuser.db.models.fields
import django_currentuser.middleware
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('schema', '0064_auto_20200610_2131'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalCameraModel',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('model', models.CharField(help_text='The model name of the camera', max_length=45)),
                ('disambiguation', models.CharField(blank=True, help_text='Distinguishing notes for camera models with the same name', max_length=45, null=True)),
                ('focus_type', models.CharField(blank=True, choices=[('Autofocus', 'Autofocus'), ('Fixed focus', 'Fixed focus'), ('Zone focus', 'Zone focus'), ('Rangefinder', 'Rangefinder'), ('SLR', 'SLR'), ('TLR', 'TLR'), ('View camera', 'View camera')], help_text='Focus type used on this camera model', max_length=25, null=True)),
                ('metering', models.BooleanField(blank=True, help_text='Whether the camera has built-in metering', null=True)),
                ('metering_type', models.CharField(blank=True, choices=[('Cadmium sulphide CdS', 'Cadmium sulphide CdS'), ('Selenium', 'Selenium'), ('Silicon', 'Silicon')], help_text='Metering type used on this camera model', max_length=25, null=True)),
                ('introduced', models.PositiveIntegerField(blank=True, help_text='Year in which the camera model was introduced', null=True)),
                ('discontinued', models.PositiveIntegerField(blank=True, help_text='Year in which the camera model was discontinued', null=True)),
                ('body_type', models.CharField(blank=True, choices=[('Box camera', 'Box camera'), ('Folding camera', 'Folding camera'), ('Compact camera', 'Compact camera'), ('SLR', 'SLR'), ('TLR', 'TLR'), ('Bridge camera', 'Bridge camera'), ('View camera', 'View camera'), ('Pistol grip camera', 'Pistol grip camera'), ('Miniature camera', 'Miniature camera')], help_text='Body type of this camera model', max_length=25, null=True)),
                ('weight', models.PositiveIntegerField(blank=True, help_text='Weight of the camera body (without lens or batteries) in grammes (g)', null=True)),
                ('shutter_type', models.CharField(blank=True, choices=[('Focal plane cloth', 'Focal plane cloth'), ('Focal plane metal', 'Focal plane metal'), ('Leaf', 'Leaf'), ('Rotary', 'Rotary'), ('Sliding', 'Sliding'), ('Electronic', 'Electronic')], help_text='Type of shutter used on this camera model', max_length=25, null=True)),
                ('shutter_model', models.CharField(blank=True, help_text='Model of shutter', max_length=45, null=True)),
                ('cable_release', models.BooleanField(blank=True, help_text='Whether the camera has the facility for a remote cable release', null=True)),
                ('viewfinder_coverage', models.PositiveIntegerField(blank=True, help_text='Percentage coverage of the viewfinder. Mostly applicable to SLRs.', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('power_drive', models.BooleanField(blank=True, help_text='Whether the camera has integrated motor drive', null=True)),
                ('continuous_fps', models.DecimalField(blank=True, decimal_places=1, help_text='The maximum rate at which the camera can shoot, in frames per second', max_digits=4, null=True)),
                ('battery_qty', models.PositiveIntegerField(blank=True, help_text='Quantity of batteries needed', null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform text field for extra notes', max_length=100, null=True)),
                ('bulb', models.BooleanField(blank=True, help_text='Whether the camera supports bulb (B) exposure', null=True)),
                ('time', models.BooleanField(blank=True, help_text='Whether the camera supports time (T) exposure', null=True)),
                ('min_iso', models.PositiveIntegerField(blank=True, help_text='Minimum ISO the camera will accept for metering', null=True, verbose_name='Min ISO')),
                ('max_iso', models.PositiveIntegerField(blank=True, help_text='Maximum ISO the camera will accept for metering', null=True, verbose_name='Max ISO')),
                ('af_points', models.PositiveIntegerField(blank=True, help_text='Number of autofocus points', null=True, verbose_name='Autofocus points')),
                ('int_flash', models.BooleanField(blank=True, help_text='Whether the camera has an integrated flash', null=True, verbose_name='Internal flash')),
                ('int_flash_gn', models.PositiveIntegerField(blank=True, help_text='Guide number of internal flash', null=True, verbose_name='Internal flash guide number')),
                ('ext_flash', models.BooleanField(blank=True, help_text='Whether the camera supports an external flash', null=True, verbose_name='External flash')),
                ('pc_sync', models.BooleanField(blank=True, help_text='Whether the camera has a PC sync socket for flash', null=True, verbose_name='PC sync')),
                ('shoe', models.CharField(blank=True, choices=[('No shoe', 'No shoe'), ('Hot shoe', 'Hot shoe'), ('Cold shoe', 'Cold shoe')], help_text='Type of flash/accessory shoe used on this camera model', max_length=9, null=True)),
                ('meter_min_ev', models.IntegerField(blank=True, help_text='Lowest EV/LV the built-in meter supports', null=True, verbose_name='Min EV')),
                ('meter_max_ev', models.PositiveIntegerField(blank=True, help_text='Highest EV/LV the built-in meter supports', null=True, verbose_name='Max EV')),
                ('dof_preview', models.BooleanField(blank=True, help_text='Whether the camera has depth of field preview', null=True, verbose_name='DoF preview')),
                ('mirror_lockup', models.BooleanField(blank=True, help_text='Whether the camera has mirror lock-up', null=True, verbose_name='Mirror lock-up')),
                ('tripod', models.BooleanField(blank=True, help_text='Whether the camera has a tripod bush', null=True)),
                ('slug', models.SlugField(editable=False, null=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, editable=False, null=True)),
                ('url', models.URLField(blank=True, help_text='URL to more information about this camera model', null=True, verbose_name='URL')),
                ('lens_model_name', models.CharField(blank=True, help_text='Model name of this lens', max_length=45, null=True)),
                ('zoom', models.BooleanField(blank=True, help_text='Whether this is a zoom lens', null=True)),
                ('min_focal_length', models.PositiveIntegerField(blank=True, help_text='Shortest focal length of this lens, in mm', null=True)),
                ('max_focal_length', models.PositiveIntegerField(blank=True, help_text='Longest focal length of this lens, in mm', null=True)),
                ('zoom_ratio', models.DecimalField(blank=True, decimal_places=2, editable=False, help_text='Ratio between minimum and maximum focal lengths', max_digits=4, null=True)),
                ('closest_focus', models.DecimalField(blank=True, decimal_places=2, help_text='The closest focus possible with this lens, in m', max_digits=6, null=True)),
                ('max_aperture', models.DecimalField(blank=True, decimal_places=1, help_text='Maximum (widest) aperture available on this lens (numerical part only, e.g. 2.8)', max_digits=4, null=True)),
                ('min_aperture', models.DecimalField(blank=True, decimal_places=1, help_text='Minimum (narrowest) aperture available on this lens (numerical part only, e.g. 22)', max_digits=4, null=True)),
                ('elements', models.PositiveIntegerField(blank=True, help_text='Number of optical lens elements', null=True)),
                ('groups', models.PositiveIntegerField(blank=True, help_text='Number of optical groups', null=True)),
                ('nominal_min_angle_diag', models.PositiveIntegerField(blank=True, help_text='Nominal minimum diagonal field of view from manufacturer specs', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)], verbose_name='Min angle of view')),
                ('nominal_max_angle_diag', models.PositiveIntegerField(blank=True, help_text='Nominal maximum diagonal field of view from manufacturer specs', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)], verbose_name='Max angle of view')),
                ('aperture_blades', models.PositiveIntegerField(blank=True, help_text='Number of aperture blades', null=True)),
                ('filter_thread', models.DecimalField(blank=True, decimal_places=1, help_text='Diameter of lens filter thread, in mm', max_digits=4, null=True)),
                ('magnification', models.DecimalField(blank=True, decimal_places=3, help_text='Maximum magnification ratio of the lens, expressed like 0.765', max_digits=5, null=True)),
                ('coating', models.CharField(blank=True, choices=[('Uncoated', 'Uncoated'), ('Single coated', 'Single coated'), ('Multi coated', 'Multi coated')], help_text='Type of lens coating', max_length=15, null=True)),
                ('hood', models.CharField(blank=True, help_text='Model number of the compatible lens hood', max_length=45, null=True)),
                ('rectilinear', models.BooleanField(blank=True, default=1, help_text='Whether this is a rectilinear lens', null=True)),
                ('image_circle', models.PositiveIntegerField(blank=True, help_text='Diameter of image circle projected by lens, in mm', null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('battery_type', models.ForeignKey(blank=True, db_constraint=False, help_text='Battery type that this camera model needs', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Battery')),
                ('created_by', django_currentuser.db.models.fields.CurrentUserField(blank=True, db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('flash_metering', models.ForeignKey(blank=True, db_constraint=False, help_text='Whether this camera model supports flash metering', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.FlashProtocol')),
                ('format', models.ForeignKey(blank=True, db_constraint=False, help_text='Film format used by this camera model', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Format')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('lens_manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer of this lens model', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('manufacturer', models.ForeignKey(blank=True, db_constraint=False, help_text='Manufacturer of this camera model', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Manufacturer')),
                ('mount', models.ForeignKey(blank=True, db_constraint=False, help_text='Lens mount used by this camera model', limit_choices_to={'purpose': 'Camera'}, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.Mount')),
                ('negative_size', models.ForeignKey(blank=True, db_constraint=False, help_text='Size of negative created by this camera', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.NegativeSize')),
                ('updated_by', django_currentuser.db.models.fields.CurrentUserField(db_constraint=False, default=django_currentuser.middleware.get_current_authenticated_user, null=True, on_delete=django.db.models.deletion.DO_NOTHING, on_update=True, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('x_sync', models.ForeignKey(blank=True, db_constraint=False, help_text='Flash X-sync speed', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='schema.ShutterSpeed')),
            ],
            options={
                'verbose_name': 'historical camera model',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
