"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
class AwsCdkConstructLibrary extends projen_1.awscdk.AwsCdkConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        super({
            ...options,
            authorOrganization: true,
            license: "MIT",
            copyrightOwner: "Pepperize UG (haftungsbeschränkt)",
            autoApproveUpgrades: true,
            autoApproveOptions: {
                ...options.autoApproveOptions,
                allowedUsernames: ["pflorek", "acfo", "dependabot[bot]"],
                label: "auto-approve",
                secret: "GITHUB_TOKEN",
            },
            depsUpgradeOptions: {
                ...options.depsUpgradeOptions,
                workflowOptions: {
                    ...options.depsUpgradeOptions?.workflowOptions,
                    secret: "PROJEN_GITHUB_TOKEN",
                },
            },
            dependabot: true,
            dependabotOptions: {
                labels: ["auto-approve"],
            },
            eslint: true,
            prettier: true,
            prettierOptions: {
                ...options.prettierOptions,
                settings: {
                    ...options.prettierOptions?.settings,
                    printWidth: 120,
                },
            },
            defaultReleaseBranch: "main",
            npmAccess: projen_1.javascript.NpmAccess.PUBLIC,
            release: true,
            staleOptions: {
                pullRequest: {
                    daysBeforeStale: 90,
                    daysBeforeClose: 30,
                    ...options.staleOptions?.pullRequest,
                },
                issues: {
                    daysBeforeStale: 180,
                    daysBeforeClose: 30,
                    ...options.staleOptions?.pullRequest,
                },
                ...options.staleOptions,
            },
            gitignore: [...(options.gitignore || [])],
        });
        this.addDevDeps("ts-node@^10");
        this.gitignore.exclude(".idea/", "*.iml", ".vscode/");
        this.prettier?.addIgnorePattern("API.md");
        this.formatTask = this.addTask("format", {
            description: "Format with prettier",
            exec: "prettier --write src/**/*.ts test/**/*.ts .projenrc.[jt]s README.md",
        });
        // https://editorconfig.org/#file-format-details
        new projen_1.IniFile(this, ".editorconfig", {
            obj: {
                ["root"]: true,
                ["*"]: {
                    ["end_of_line"]: "lf",
                    ["charset"]: "utf-8",
                },
                ["*.{js,ts}"]: {
                    ["indent_style"]: "space",
                    ["indent_size"]: 2,
                    ["max_line_length"]: 120,
                },
            },
            marker: true,
        });
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "@pepperize/projen-awscdk-construct.AwsCdkConstructLibrary", version: "0.0.212" };
//# sourceMappingURL=data:application/json;base64,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