"use strict";
const core_1 = require("@aws-cdk/core");
const events = require("../lib");
module.exports = {
    'cron expressions day and dow are mutex: given weekday'(test) {
        // Run every 10 minutes Monday through Friday
        test.equal('cron(0/10 * ? * MON-FRI *)', events.Schedule.cron({
            minute: '0/10',
            weekDay: 'MON-FRI',
        }).expressionString);
        test.done();
    },
    'cron expressions day and dow are mutex: given month day'(test) {
        // Run at 8:00 am (UTC) every 1st day of the month
        test.equal('cron(0 8 1 * ? *)', events.Schedule.cron({
            minute: '0',
            hour: '8',
            day: '1',
        }).expressionString);
        test.done();
    },
    'cron expressions day and dow are mutex: given neither'(test) {
        // Run at 10:00 am (UTC) every day
        test.equal('cron(0 10 * * ? *)', events.Schedule.cron({
            minute: '0',
            hour: '10',
        }).expressionString);
        test.done();
    },
    'rate must be whole number of minutes'(test) {
        test.throws(() => {
            events.Schedule.rate(core_1.Duration.seconds(12345));
        }, /'12345 seconds' cannot be converted into a whole number of minutes/);
        test.done();
    },
    'rate cannot be 0'(test) {
        test.throws(() => {
            events.Schedule.rate(core_1.Duration.days(0));
        }, /Duration cannot be 0/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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